<?php


/**
 * Base static class for performing query and update operations on the 'objectives_objectiveLog' table.
 *
 * Objective Log
 *
 * @package propel.generator.objectives.classes.om
 */
abstract class BaseObjectiveLogPeer
{

    /** the default database name for this class */
    const DATABASE_NAME = 'application';

    /** the table name for this class */
    const TABLE_NAME = 'objectives_objectiveLog';

    /** the related Propel class for this table */
    const OM_CLASS = 'ObjectiveLog';

    /** the related TableMap class for this table */
    const TM_CLASS = 'ObjectiveLogTableMap';

    /** The total number of columns. */
    const NUM_COLUMNS = 19;

    /** The number of lazy-loaded columns. */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /** The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS) */
    const NUM_HYDRATE_COLUMNS = 19;

    /** the column name for the ID field */
    const ID = 'objectives_objectiveLog.ID';

    /** the column name for the OBJECTIVEID field */
    const OBJECTIVEID = 'objectives_objectiveLog.OBJECTIVEID';

    /** the column name for the NAME field */
    const NAME = 'objectives_objectiveLog.NAME';

    /** the column name for the POLICYGUIDELINEID field */
    const POLICYGUIDELINEID = 'objectives_objectiveLog.POLICYGUIDELINEID';

    /** the column name for the STRATEGICOBJECTIVEID field */
    const STRATEGICOBJECTIVEID = 'objectives_objectiveLog.STRATEGICOBJECTIVEID';

    /** the column name for the AFFILIATEID field */
    const AFFILIATEID = 'objectives_objectiveLog.AFFILIATEID';

    /** the column name for the DESCRIPTION field */
    const DESCRIPTION = 'objectives_objectiveLog.DESCRIPTION';

    /** the column name for the DATE field */
    const DATE = 'objectives_objectiveLog.DATE';

    /** the column name for the EXPIRATIONDATE field */
    const EXPIRATIONDATE = 'objectives_objectiveLog.EXPIRATIONDATE';

    /** the column name for the ACHIEVED field */
    const ACHIEVED = 'objectives_objectiveLog.ACHIEVED';

    /** the column name for the NOTES field */
    const NOTES = 'objectives_objectiveLog.NOTES';

    /** the column name for the RESPONSIBLECODE field */
    const RESPONSIBLECODE = 'objectives_objectiveLog.RESPONSIBLECODE';

    /** the column name for the USERID field */
    const USERID = 'objectives_objectiveLog.USERID';

    /** the column name for the USERBYAFFILIATESID field */
    const USERBYAFFILIATESID = 'objectives_objectiveLog.USERBYAFFILIATESID';

    /** the column name for the UPDATED field */
    const UPDATED = 'objectives_objectiveLog.UPDATED';

    /** the column name for the CHANGES field */
    const CHANGES = 'objectives_objectiveLog.CHANGES';

    /** the column name for the OLDID field */
    const OLDID = 'objectives_objectiveLog.OLDID';

    /** the column name for the STARTINGYEAR field */
    const STARTINGYEAR = 'objectives_objectiveLog.STARTINGYEAR';

    /** the column name for the ENDINGYEAR field */
    const ENDINGYEAR = 'objectives_objectiveLog.ENDINGYEAR';

    /** The default string format for model objects of the related table **/
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * An identiy map to hold any loaded instances of ObjectiveLog objects.
     * This must be public so that other peer classes can access this when hydrating from JOIN
     * queries.
     * @var        array ObjectiveLog[]
     */
    public static $instances = array();


    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. ObjectiveLogPeer::$fieldNames[ObjectiveLogPeer::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        BasePeer::TYPE_PHPNAME => array ('Id', 'Objectiveid', 'Name', 'Policyguidelineid', 'Strategicobjectiveid', 'Affiliateid', 'Description', 'Date', 'Expirationdate', 'Achieved', 'Notes', 'Responsiblecode', 'Userid', 'Userbyaffiliatesid', 'Updated', 'Changes', 'Oldid', 'Startingyear', 'Endingyear', ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id', 'objectiveid', 'name', 'policyguidelineid', 'strategicobjectiveid', 'affiliateid', 'description', 'date', 'expirationdate', 'achieved', 'notes', 'responsiblecode', 'userid', 'userbyaffiliatesid', 'updated', 'changes', 'oldid', 'startingyear', 'endingyear', ),
        BasePeer::TYPE_COLNAME => array (ObjectiveLogPeer::ID, ObjectiveLogPeer::OBJECTIVEID, ObjectiveLogPeer::NAME, ObjectiveLogPeer::POLICYGUIDELINEID, ObjectiveLogPeer::STRATEGICOBJECTIVEID, ObjectiveLogPeer::AFFILIATEID, ObjectiveLogPeer::DESCRIPTION, ObjectiveLogPeer::DATE, ObjectiveLogPeer::EXPIRATIONDATE, ObjectiveLogPeer::ACHIEVED, ObjectiveLogPeer::NOTES, ObjectiveLogPeer::RESPONSIBLECODE, ObjectiveLogPeer::USERID, ObjectiveLogPeer::USERBYAFFILIATESID, ObjectiveLogPeer::UPDATED, ObjectiveLogPeer::CHANGES, ObjectiveLogPeer::OLDID, ObjectiveLogPeer::STARTINGYEAR, ObjectiveLogPeer::ENDINGYEAR, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID', 'OBJECTIVEID', 'NAME', 'POLICYGUIDELINEID', 'STRATEGICOBJECTIVEID', 'AFFILIATEID', 'DESCRIPTION', 'DATE', 'EXPIRATIONDATE', 'ACHIEVED', 'NOTES', 'RESPONSIBLECODE', 'USERID', 'USERBYAFFILIATESID', 'UPDATED', 'CHANGES', 'OLDID', 'STARTINGYEAR', 'ENDINGYEAR', ),
        BasePeer::TYPE_FIELDNAME => array ('id', 'objectiveId', 'name', 'policyGuidelineId', 'strategicObjectiveId', 'affiliateId', 'description', 'date', 'expirationDate', 'achieved', 'notes', 'responsibleCode', 'userId', 'userByAffiliatesId', 'updated', 'changes', 'oldId', 'startingYear', 'endingYear', ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. ObjectiveLogPeer::$fieldNames[BasePeer::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        BasePeer::TYPE_PHPNAME => array ('Id' => 0, 'Objectiveid' => 1, 'Name' => 2, 'Policyguidelineid' => 3, 'Strategicobjectiveid' => 4, 'Affiliateid' => 5, 'Description' => 6, 'Date' => 7, 'Expirationdate' => 8, 'Achieved' => 9, 'Notes' => 10, 'Responsiblecode' => 11, 'Userid' => 12, 'Userbyaffiliatesid' => 13, 'Updated' => 14, 'Changes' => 15, 'Oldid' => 16, 'Startingyear' => 17, 'Endingyear' => 18, ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id' => 0, 'objectiveid' => 1, 'name' => 2, 'policyguidelineid' => 3, 'strategicobjectiveid' => 4, 'affiliateid' => 5, 'description' => 6, 'date' => 7, 'expirationdate' => 8, 'achieved' => 9, 'notes' => 10, 'responsiblecode' => 11, 'userid' => 12, 'userbyaffiliatesid' => 13, 'updated' => 14, 'changes' => 15, 'oldid' => 16, 'startingyear' => 17, 'endingyear' => 18, ),
        BasePeer::TYPE_COLNAME => array (ObjectiveLogPeer::ID => 0, ObjectiveLogPeer::OBJECTIVEID => 1, ObjectiveLogPeer::NAME => 2, ObjectiveLogPeer::POLICYGUIDELINEID => 3, ObjectiveLogPeer::STRATEGICOBJECTIVEID => 4, ObjectiveLogPeer::AFFILIATEID => 5, ObjectiveLogPeer::DESCRIPTION => 6, ObjectiveLogPeer::DATE => 7, ObjectiveLogPeer::EXPIRATIONDATE => 8, ObjectiveLogPeer::ACHIEVED => 9, ObjectiveLogPeer::NOTES => 10, ObjectiveLogPeer::RESPONSIBLECODE => 11, ObjectiveLogPeer::USERID => 12, ObjectiveLogPeer::USERBYAFFILIATESID => 13, ObjectiveLogPeer::UPDATED => 14, ObjectiveLogPeer::CHANGES => 15, ObjectiveLogPeer::OLDID => 16, ObjectiveLogPeer::STARTINGYEAR => 17, ObjectiveLogPeer::ENDINGYEAR => 18, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID' => 0, 'OBJECTIVEID' => 1, 'NAME' => 2, 'POLICYGUIDELINEID' => 3, 'STRATEGICOBJECTIVEID' => 4, 'AFFILIATEID' => 5, 'DESCRIPTION' => 6, 'DATE' => 7, 'EXPIRATIONDATE' => 8, 'ACHIEVED' => 9, 'NOTES' => 10, 'RESPONSIBLECODE' => 11, 'USERID' => 12, 'USERBYAFFILIATESID' => 13, 'UPDATED' => 14, 'CHANGES' => 15, 'OLDID' => 16, 'STARTINGYEAR' => 17, 'ENDINGYEAR' => 18, ),
        BasePeer::TYPE_FIELDNAME => array ('id' => 0, 'objectiveId' => 1, 'name' => 2, 'policyGuidelineId' => 3, 'strategicObjectiveId' => 4, 'affiliateId' => 5, 'description' => 6, 'date' => 7, 'expirationDate' => 8, 'achieved' => 9, 'notes' => 10, 'responsibleCode' => 11, 'userId' => 12, 'userByAffiliatesId' => 13, 'updated' => 14, 'changes' => 15, 'oldId' => 16, 'startingYear' => 17, 'endingYear' => 18, ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, )
    );

    /**
     * Translates a fieldname to another type
     *
     * @param      string $name field name
     * @param      string $fromType One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                         BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @param      string $toType   One of the class type constants
     * @return string          translated name of the field.
     * @throws PropelException - if the specified name could not be found in the fieldname mappings.
     */
    public static function translateFieldName($name, $fromType, $toType)
    {
        $toNames = ObjectiveLogPeer::getFieldNames($toType);
        $key = isset(ObjectiveLogPeer::$fieldKeys[$fromType][$name]) ? ObjectiveLogPeer::$fieldKeys[$fromType][$name] : null;
        if ($key === null) {
            throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(ObjectiveLogPeer::$fieldKeys[$fromType], true));
        }

        return $toNames[$key];
    }

    /**
     * Returns an array of field names.
     *
     * @param      string $type The type of fieldnames to return:
     *                      One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                      BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @return array           A list of field names
     * @throws PropelException - if the type is not valid.
     */
    public static function getFieldNames($type = BasePeer::TYPE_PHPNAME)
    {
        if (!array_key_exists($type, ObjectiveLogPeer::$fieldNames)) {
            throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME, BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. ' . $type . ' was given.');
        }

        return ObjectiveLogPeer::$fieldNames[$type];
    }

    /**
     * Convenience method which changes table.column to alias.column.
     *
     * Using this method you can maintain SQL abstraction while using column aliases.
     * <code>
     *		$c->addAlias("alias1", TablePeer::TABLE_NAME);
     *		$c->addJoin(TablePeer::alias("alias1", TablePeer::PRIMARY_KEY_COLUMN), TablePeer::PRIMARY_KEY_COLUMN);
     * </code>
     * @param      string $alias The alias for the current table.
     * @param      string $column The column name for current table. (i.e. ObjectiveLogPeer::COLUMN_NAME).
     * @return string
     */
    public static function alias($alias, $column)
    {
        return str_replace(ObjectiveLogPeer::TABLE_NAME.'.', $alias.'.', $column);
    }

    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param      Criteria $criteria object containing the columns to add.
     * @param      string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ObjectiveLogPeer::ID);
            $criteria->addSelectColumn(ObjectiveLogPeer::OBJECTIVEID);
            $criteria->addSelectColumn(ObjectiveLogPeer::NAME);
            $criteria->addSelectColumn(ObjectiveLogPeer::POLICYGUIDELINEID);
            $criteria->addSelectColumn(ObjectiveLogPeer::STRATEGICOBJECTIVEID);
            $criteria->addSelectColumn(ObjectiveLogPeer::AFFILIATEID);
            $criteria->addSelectColumn(ObjectiveLogPeer::DESCRIPTION);
            $criteria->addSelectColumn(ObjectiveLogPeer::DATE);
            $criteria->addSelectColumn(ObjectiveLogPeer::EXPIRATIONDATE);
            $criteria->addSelectColumn(ObjectiveLogPeer::ACHIEVED);
            $criteria->addSelectColumn(ObjectiveLogPeer::NOTES);
            $criteria->addSelectColumn(ObjectiveLogPeer::RESPONSIBLECODE);
            $criteria->addSelectColumn(ObjectiveLogPeer::USERID);
            $criteria->addSelectColumn(ObjectiveLogPeer::USERBYAFFILIATESID);
            $criteria->addSelectColumn(ObjectiveLogPeer::UPDATED);
            $criteria->addSelectColumn(ObjectiveLogPeer::CHANGES);
            $criteria->addSelectColumn(ObjectiveLogPeer::OLDID);
            $criteria->addSelectColumn(ObjectiveLogPeer::STARTINGYEAR);
            $criteria->addSelectColumn(ObjectiveLogPeer::ENDINGYEAR);
        } else {
            $criteria->addSelectColumn($alias . '.ID');
            $criteria->addSelectColumn($alias . '.OBJECTIVEID');
            $criteria->addSelectColumn($alias . '.NAME');
            $criteria->addSelectColumn($alias . '.POLICYGUIDELINEID');
            $criteria->addSelectColumn($alias . '.STRATEGICOBJECTIVEID');
            $criteria->addSelectColumn($alias . '.AFFILIATEID');
            $criteria->addSelectColumn($alias . '.DESCRIPTION');
            $criteria->addSelectColumn($alias . '.DATE');
            $criteria->addSelectColumn($alias . '.EXPIRATIONDATE');
            $criteria->addSelectColumn($alias . '.ACHIEVED');
            $criteria->addSelectColumn($alias . '.NOTES');
            $criteria->addSelectColumn($alias . '.RESPONSIBLECODE');
            $criteria->addSelectColumn($alias . '.USERID');
            $criteria->addSelectColumn($alias . '.USERBYAFFILIATESID');
            $criteria->addSelectColumn($alias . '.UPDATED');
            $criteria->addSelectColumn($alias . '.CHANGES');
            $criteria->addSelectColumn($alias . '.OLDID');
            $criteria->addSelectColumn($alias . '.STARTINGYEAR');
            $criteria->addSelectColumn($alias . '.ENDINGYEAR');
        }
    }

    /**
     * Returns the number of rows matching criteria.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @return int Number of matching rows.
     */
    public static function doCount(Criteria $criteria, $distinct = false, PropelPDO $con = null)
    {
        // we may modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectiveLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectiveLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
        $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME); // Set the correct dbName

        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        // BasePeer returns a PDOStatement
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }
    /**
     * Selects one object from the DB.
     *
     * @param      Criteria $criteria object used to create the SELECT statement.
     * @param      PropelPDO $con
     * @return                 ObjectiveLog
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectOne(Criteria $criteria, PropelPDO $con = null)
    {
        $critcopy = clone $criteria;
        $critcopy->setLimit(1);
        $objects = ObjectiveLogPeer::doSelect($critcopy, $con);
        if ($objects) {
            return $objects[0];
        }

        return null;
    }
    /**
     * Selects several row from the DB.
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con
     * @return array           Array of selected Objects
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelect(Criteria $criteria, PropelPDO $con = null)
    {
        return ObjectiveLogPeer::populateObjects(ObjectiveLogPeer::doSelectStmt($criteria, $con));
    }
    /**
     * Prepares the Criteria object and uses the parent doSelect() method to execute a PDOStatement.
     *
     * Use this method directly if you want to work with an executed statement durirectly (for example
     * to perform your own object hydration).
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con The connection to use
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return PDOStatement The executed PDOStatement object.
     * @see        BasePeer::doSelect()
     */
    public static function doSelectStmt(Criteria $criteria, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        if (!$criteria->hasSelectClause()) {
            $criteria = clone $criteria;
            ObjectiveLogPeer::addSelectColumns($criteria);
        }

        // Set the correct dbName
        $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);

        // BasePeer returns a PDOStatement
        return BasePeer::doSelect($criteria, $con);
    }
    /**
     * Adds an object to the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doSelect*()
     * methods in your stub classes -- you may need to explicitly add objects
     * to the cache in order to ensure that the same objects are always returned by doSelect*()
     * and retrieveByPK*() calls.
     *
     * @param      ObjectiveLog $obj A ObjectiveLog object.
     * @param      string $key (optional) key to use for instance map (for performance boost if key was already calculated externally).
     */
    public static function addInstanceToPool($obj, $key = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if ($key === null) {
                $key = (string) $obj->getId();
            } // if key === null
            ObjectiveLogPeer::$instances[$key] = $obj;
        }
    }

    /**
     * Removes an object from the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doDelete
     * methods in your stub classes -- you may need to explicitly remove objects
     * from the cache in order to prevent returning objects that no longer exist.
     *
     * @param      mixed $value A ObjectiveLog object or a primary key value.
     *
     * @return void
     * @throws PropelException - if the value is invalid.
     */
    public static function removeInstanceFromPool($value)
    {
        if (Propel::isInstancePoolingEnabled() && $value !== null) {
            if (is_object($value) && $value instanceof ObjectiveLog) {
                $key = (string) $value->getId();
            } elseif (is_scalar($value)) {
                // assume we've been passed a primary key
                $key = (string) $value;
            } else {
                $e = new PropelException("Invalid value passed to removeInstanceFromPool().  Expected primary key or ObjectiveLog object; got " . (is_object($value) ? get_class($value) . ' object.' : var_export($value,true)));
                throw $e;
            }

            unset(ObjectiveLogPeer::$instances[$key]);
        }
    } // removeInstanceFromPool()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      string $key The key (@see getPrimaryKeyHash()) for this instance.
     * @return   ObjectiveLog Found object or null if 1) no instance exists for specified key or 2) instance pooling has been disabled.
     * @see        getPrimaryKeyHash()
     */
    public static function getInstanceFromPool($key)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if (isset(ObjectiveLogPeer::$instances[$key])) {
                return ObjectiveLogPeer::$instances[$key];
            }
        }

        return null; // just to be explicit
    }

    /**
     * Clear the instance pool.
     *
     * @return void
     */
    public static function clearInstancePool()
    {
        ObjectiveLogPeer::$instances = array();
    }

    /**
     * Method to invalidate the instance pool of all tables related to objectives_objectiveLog
     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return string A string version of PK or null if the components of primary key in result array are all null.
     */
    public static function getPrimaryKeyHashFromRow($row, $startcol = 0)
    {
        // If the PK cannot be derived from the row, return null.
        if ($row[$startcol] === null) {
            return null;
        }

        return (string) $row[$startcol];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $startcol = 0)
    {

        return (int) $row[$startcol];
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function populateObjects(PDOStatement $stmt)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = ObjectiveLogPeer::getOMClass();
        // populate the object(s)
        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key = ObjectiveLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj = ObjectiveLogPeer::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ObjectiveLogPeer::addInstanceToPool($obj, $key);
            } // if key exists
        }
        $stmt->closeCursor();

        return $results;
    }
    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return array (ObjectiveLog object, last column rank)
     */
    public static function populateObject($row, $startcol = 0)
    {
        $key = ObjectiveLogPeer::getPrimaryKeyHashFromRow($row, $startcol);
        if (null !== ($obj = ObjectiveLogPeer::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $startcol, true); // rehydrate
            $col = $startcol + ObjectiveLogPeer::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ObjectiveLogPeer::OM_CLASS;
            $obj = new $cls();
            $col = $obj->hydrate($row, $startcol);
            ObjectiveLogPeer::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }


    /**
     * Returns the number of rows matching criteria, joining the related StrategicObjective table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinStrategicObjective(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectiveLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectiveLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectiveLogPeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Objective table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinObjective(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectiveLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectiveLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectiveLogPeer::OBJECTIVEID, ObjectivePeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related PolicyGuideline table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinPolicyGuideline(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectiveLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectiveLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectiveLogPeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related User table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinUser(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectiveLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectiveLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectiveLogPeer::USERID, UserPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Position table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinPosition(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectiveLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectiveLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectiveLogPeer::RESPONSIBLECODE, PositionPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of ObjectiveLog objects pre-filled with their StrategicObjective objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ObjectiveLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinStrategicObjective(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);
        }

        ObjectiveLogPeer::addSelectColumns($criteria);
        $startcol = ObjectiveLogPeer::NUM_HYDRATE_COLUMNS;
        StrategicObjectivePeer::addSelectColumns($criteria);

        $criteria->addJoin(ObjectiveLogPeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectiveLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectiveLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = ObjectiveLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectiveLogPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = StrategicObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = StrategicObjectivePeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = StrategicObjectivePeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    StrategicObjectivePeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (ObjectiveLog) to $obj2 (StrategicObjective)
                $obj2->addObjectiveLog($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of ObjectiveLog objects pre-filled with their Objective objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ObjectiveLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinObjective(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);
        }

        ObjectiveLogPeer::addSelectColumns($criteria);
        $startcol = ObjectiveLogPeer::NUM_HYDRATE_COLUMNS;
        ObjectivePeer::addSelectColumns($criteria);

        $criteria->addJoin(ObjectiveLogPeer::OBJECTIVEID, ObjectivePeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectiveLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectiveLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = ObjectiveLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectiveLogPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = ObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = ObjectivePeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = ObjectivePeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    ObjectivePeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (ObjectiveLog) to $obj2 (Objective)
                $obj2->addObjectiveLog($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of ObjectiveLog objects pre-filled with their PolicyGuideline objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ObjectiveLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinPolicyGuideline(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);
        }

        ObjectiveLogPeer::addSelectColumns($criteria);
        $startcol = ObjectiveLogPeer::NUM_HYDRATE_COLUMNS;
        PolicyGuidelinePeer::addSelectColumns($criteria);

        $criteria->addJoin(ObjectiveLogPeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectiveLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectiveLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = ObjectiveLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectiveLogPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = PolicyGuidelinePeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = PolicyGuidelinePeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = PolicyGuidelinePeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    PolicyGuidelinePeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (ObjectiveLog) to $obj2 (PolicyGuideline)
                $obj2->addObjectiveLog($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of ObjectiveLog objects pre-filled with their User objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ObjectiveLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinUser(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);
        }

        ObjectiveLogPeer::addSelectColumns($criteria);
        $startcol = ObjectiveLogPeer::NUM_HYDRATE_COLUMNS;
        UserPeer::addSelectColumns($criteria);

        $criteria->addJoin(ObjectiveLogPeer::USERID, UserPeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectiveLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectiveLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = ObjectiveLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectiveLogPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = UserPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = UserPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    UserPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (ObjectiveLog) to $obj2 (User)
                $obj2->addObjectiveLog($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of ObjectiveLog objects pre-filled with their Position objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ObjectiveLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinPosition(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);
        }

        ObjectiveLogPeer::addSelectColumns($criteria);
        $startcol = ObjectiveLogPeer::NUM_HYDRATE_COLUMNS;
        PositionPeer::addSelectColumns($criteria);

        $criteria->addJoin(ObjectiveLogPeer::RESPONSIBLECODE, PositionPeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectiveLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectiveLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = ObjectiveLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectiveLogPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = PositionPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = PositionPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    PositionPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (ObjectiveLog) to $obj2 (Position)
                $obj2->addObjectiveLog($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining all related tables
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAll(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectiveLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectiveLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectiveLogPeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::OBJECTIVEID, ObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::RESPONSIBLECODE, PositionPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }

    /**
     * Selects a collection of ObjectiveLog objects pre-filled with all related objects.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ObjectiveLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAll(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);
        }

        ObjectiveLogPeer::addSelectColumns($criteria);
        $startcol2 = ObjectiveLogPeer::NUM_HYDRATE_COLUMNS;

        StrategicObjectivePeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + StrategicObjectivePeer::NUM_HYDRATE_COLUMNS;

        ObjectivePeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + ObjectivePeer::NUM_HYDRATE_COLUMNS;

        PolicyGuidelinePeer::addSelectColumns($criteria);
        $startcol5 = $startcol4 + PolicyGuidelinePeer::NUM_HYDRATE_COLUMNS;

        UserPeer::addSelectColumns($criteria);
        $startcol6 = $startcol5 + UserPeer::NUM_HYDRATE_COLUMNS;

        PositionPeer::addSelectColumns($criteria);
        $startcol7 = $startcol6 + PositionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ObjectiveLogPeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::OBJECTIVEID, ObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::RESPONSIBLECODE, PositionPeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectiveLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectiveLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ObjectiveLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectiveLogPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

            // Add objects for joined StrategicObjective rows

            $key2 = StrategicObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol2);
            if ($key2 !== null) {
                $obj2 = StrategicObjectivePeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = StrategicObjectivePeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    StrategicObjectivePeer::addInstanceToPool($obj2, $key2);
                } // if obj2 loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj2 (StrategicObjective)
                $obj2->addObjectiveLog($obj1);
            } // if joined row not null

            // Add objects for joined Objective rows

            $key3 = ObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol3);
            if ($key3 !== null) {
                $obj3 = ObjectivePeer::getInstanceFromPool($key3);
                if (!$obj3) {

                    $cls = ObjectivePeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    ObjectivePeer::addInstanceToPool($obj3, $key3);
                } // if obj3 loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj3 (Objective)
                $obj3->addObjectiveLog($obj1);
            } // if joined row not null

            // Add objects for joined PolicyGuideline rows

            $key4 = PolicyGuidelinePeer::getPrimaryKeyHashFromRow($row, $startcol4);
            if ($key4 !== null) {
                $obj4 = PolicyGuidelinePeer::getInstanceFromPool($key4);
                if (!$obj4) {

                    $cls = PolicyGuidelinePeer::getOMClass();

                    $obj4 = new $cls();
                    $obj4->hydrate($row, $startcol4);
                    PolicyGuidelinePeer::addInstanceToPool($obj4, $key4);
                } // if obj4 loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj4 (PolicyGuideline)
                $obj4->addObjectiveLog($obj1);
            } // if joined row not null

            // Add objects for joined User rows

            $key5 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol5);
            if ($key5 !== null) {
                $obj5 = UserPeer::getInstanceFromPool($key5);
                if (!$obj5) {

                    $cls = UserPeer::getOMClass();

                    $obj5 = new $cls();
                    $obj5->hydrate($row, $startcol5);
                    UserPeer::addInstanceToPool($obj5, $key5);
                } // if obj5 loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj5 (User)
                $obj5->addObjectiveLog($obj1);
            } // if joined row not null

            // Add objects for joined Position rows

            $key6 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol6);
            if ($key6 !== null) {
                $obj6 = PositionPeer::getInstanceFromPool($key6);
                if (!$obj6) {

                    $cls = PositionPeer::getOMClass();

                    $obj6 = new $cls();
                    $obj6->hydrate($row, $startcol6);
                    PositionPeer::addInstanceToPool($obj6, $key6);
                } // if obj6 loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj6 (Position)
                $obj6->addObjectiveLog($obj1);
            } // if joined row not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining the related StrategicObjective table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptStrategicObjective(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectiveLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectiveLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectiveLogPeer::OBJECTIVEID, ObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::RESPONSIBLECODE, PositionPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Objective table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptObjective(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectiveLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectiveLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectiveLogPeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::RESPONSIBLECODE, PositionPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related PolicyGuideline table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptPolicyGuideline(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectiveLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectiveLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectiveLogPeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::OBJECTIVEID, ObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::RESPONSIBLECODE, PositionPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related User table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptUser(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectiveLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectiveLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectiveLogPeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::OBJECTIVEID, ObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::RESPONSIBLECODE, PositionPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Position table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptPosition(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectiveLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectiveLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectiveLogPeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::OBJECTIVEID, ObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::USERID, UserPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of ObjectiveLog objects pre-filled with all related objects except StrategicObjective.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ObjectiveLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptStrategicObjective(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);
        }

        ObjectiveLogPeer::addSelectColumns($criteria);
        $startcol2 = ObjectiveLogPeer::NUM_HYDRATE_COLUMNS;

        ObjectivePeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + ObjectivePeer::NUM_HYDRATE_COLUMNS;

        PolicyGuidelinePeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + PolicyGuidelinePeer::NUM_HYDRATE_COLUMNS;

        UserPeer::addSelectColumns($criteria);
        $startcol5 = $startcol4 + UserPeer::NUM_HYDRATE_COLUMNS;

        PositionPeer::addSelectColumns($criteria);
        $startcol6 = $startcol5 + PositionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ObjectiveLogPeer::OBJECTIVEID, ObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::RESPONSIBLECODE, PositionPeer::ID, $join_behavior);


        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectiveLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectiveLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ObjectiveLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectiveLogPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined Objective rows

                $key2 = ObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = ObjectivePeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = ObjectivePeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    ObjectivePeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj2 (Objective)
                $obj2->addObjectiveLog($obj1);

            } // if joined row is not null

                // Add objects for joined PolicyGuideline rows

                $key3 = PolicyGuidelinePeer::getPrimaryKeyHashFromRow($row, $startcol3);
                if ($key3 !== null) {
                    $obj3 = PolicyGuidelinePeer::getInstanceFromPool($key3);
                    if (!$obj3) {

                        $cls = PolicyGuidelinePeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    PolicyGuidelinePeer::addInstanceToPool($obj3, $key3);
                } // if $obj3 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj3 (PolicyGuideline)
                $obj3->addObjectiveLog($obj1);

            } // if joined row is not null

                // Add objects for joined User rows

                $key4 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol4);
                if ($key4 !== null) {
                    $obj4 = UserPeer::getInstanceFromPool($key4);
                    if (!$obj4) {

                        $cls = UserPeer::getOMClass();

                    $obj4 = new $cls();
                    $obj4->hydrate($row, $startcol4);
                    UserPeer::addInstanceToPool($obj4, $key4);
                } // if $obj4 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj4 (User)
                $obj4->addObjectiveLog($obj1);

            } // if joined row is not null

                // Add objects for joined Position rows

                $key5 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol5);
                if ($key5 !== null) {
                    $obj5 = PositionPeer::getInstanceFromPool($key5);
                    if (!$obj5) {

                        $cls = PositionPeer::getOMClass();

                    $obj5 = new $cls();
                    $obj5->hydrate($row, $startcol5);
                    PositionPeer::addInstanceToPool($obj5, $key5);
                } // if $obj5 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj5 (Position)
                $obj5->addObjectiveLog($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of ObjectiveLog objects pre-filled with all related objects except Objective.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ObjectiveLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptObjective(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);
        }

        ObjectiveLogPeer::addSelectColumns($criteria);
        $startcol2 = ObjectiveLogPeer::NUM_HYDRATE_COLUMNS;

        StrategicObjectivePeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + StrategicObjectivePeer::NUM_HYDRATE_COLUMNS;

        PolicyGuidelinePeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + PolicyGuidelinePeer::NUM_HYDRATE_COLUMNS;

        UserPeer::addSelectColumns($criteria);
        $startcol5 = $startcol4 + UserPeer::NUM_HYDRATE_COLUMNS;

        PositionPeer::addSelectColumns($criteria);
        $startcol6 = $startcol5 + PositionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ObjectiveLogPeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::RESPONSIBLECODE, PositionPeer::ID, $join_behavior);


        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectiveLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectiveLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ObjectiveLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectiveLogPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined StrategicObjective rows

                $key2 = StrategicObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = StrategicObjectivePeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = StrategicObjectivePeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    StrategicObjectivePeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj2 (StrategicObjective)
                $obj2->addObjectiveLog($obj1);

            } // if joined row is not null

                // Add objects for joined PolicyGuideline rows

                $key3 = PolicyGuidelinePeer::getPrimaryKeyHashFromRow($row, $startcol3);
                if ($key3 !== null) {
                    $obj3 = PolicyGuidelinePeer::getInstanceFromPool($key3);
                    if (!$obj3) {

                        $cls = PolicyGuidelinePeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    PolicyGuidelinePeer::addInstanceToPool($obj3, $key3);
                } // if $obj3 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj3 (PolicyGuideline)
                $obj3->addObjectiveLog($obj1);

            } // if joined row is not null

                // Add objects for joined User rows

                $key4 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol4);
                if ($key4 !== null) {
                    $obj4 = UserPeer::getInstanceFromPool($key4);
                    if (!$obj4) {

                        $cls = UserPeer::getOMClass();

                    $obj4 = new $cls();
                    $obj4->hydrate($row, $startcol4);
                    UserPeer::addInstanceToPool($obj4, $key4);
                } // if $obj4 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj4 (User)
                $obj4->addObjectiveLog($obj1);

            } // if joined row is not null

                // Add objects for joined Position rows

                $key5 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol5);
                if ($key5 !== null) {
                    $obj5 = PositionPeer::getInstanceFromPool($key5);
                    if (!$obj5) {

                        $cls = PositionPeer::getOMClass();

                    $obj5 = new $cls();
                    $obj5->hydrate($row, $startcol5);
                    PositionPeer::addInstanceToPool($obj5, $key5);
                } // if $obj5 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj5 (Position)
                $obj5->addObjectiveLog($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of ObjectiveLog objects pre-filled with all related objects except PolicyGuideline.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ObjectiveLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptPolicyGuideline(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);
        }

        ObjectiveLogPeer::addSelectColumns($criteria);
        $startcol2 = ObjectiveLogPeer::NUM_HYDRATE_COLUMNS;

        StrategicObjectivePeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + StrategicObjectivePeer::NUM_HYDRATE_COLUMNS;

        ObjectivePeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + ObjectivePeer::NUM_HYDRATE_COLUMNS;

        UserPeer::addSelectColumns($criteria);
        $startcol5 = $startcol4 + UserPeer::NUM_HYDRATE_COLUMNS;

        PositionPeer::addSelectColumns($criteria);
        $startcol6 = $startcol5 + PositionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ObjectiveLogPeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::OBJECTIVEID, ObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::RESPONSIBLECODE, PositionPeer::ID, $join_behavior);


        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectiveLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectiveLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ObjectiveLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectiveLogPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined StrategicObjective rows

                $key2 = StrategicObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = StrategicObjectivePeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = StrategicObjectivePeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    StrategicObjectivePeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj2 (StrategicObjective)
                $obj2->addObjectiveLog($obj1);

            } // if joined row is not null

                // Add objects for joined Objective rows

                $key3 = ObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol3);
                if ($key3 !== null) {
                    $obj3 = ObjectivePeer::getInstanceFromPool($key3);
                    if (!$obj3) {

                        $cls = ObjectivePeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    ObjectivePeer::addInstanceToPool($obj3, $key3);
                } // if $obj3 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj3 (Objective)
                $obj3->addObjectiveLog($obj1);

            } // if joined row is not null

                // Add objects for joined User rows

                $key4 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol4);
                if ($key4 !== null) {
                    $obj4 = UserPeer::getInstanceFromPool($key4);
                    if (!$obj4) {

                        $cls = UserPeer::getOMClass();

                    $obj4 = new $cls();
                    $obj4->hydrate($row, $startcol4);
                    UserPeer::addInstanceToPool($obj4, $key4);
                } // if $obj4 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj4 (User)
                $obj4->addObjectiveLog($obj1);

            } // if joined row is not null

                // Add objects for joined Position rows

                $key5 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol5);
                if ($key5 !== null) {
                    $obj5 = PositionPeer::getInstanceFromPool($key5);
                    if (!$obj5) {

                        $cls = PositionPeer::getOMClass();

                    $obj5 = new $cls();
                    $obj5->hydrate($row, $startcol5);
                    PositionPeer::addInstanceToPool($obj5, $key5);
                } // if $obj5 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj5 (Position)
                $obj5->addObjectiveLog($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of ObjectiveLog objects pre-filled with all related objects except User.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ObjectiveLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptUser(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);
        }

        ObjectiveLogPeer::addSelectColumns($criteria);
        $startcol2 = ObjectiveLogPeer::NUM_HYDRATE_COLUMNS;

        StrategicObjectivePeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + StrategicObjectivePeer::NUM_HYDRATE_COLUMNS;

        ObjectivePeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + ObjectivePeer::NUM_HYDRATE_COLUMNS;

        PolicyGuidelinePeer::addSelectColumns($criteria);
        $startcol5 = $startcol4 + PolicyGuidelinePeer::NUM_HYDRATE_COLUMNS;

        PositionPeer::addSelectColumns($criteria);
        $startcol6 = $startcol5 + PositionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ObjectiveLogPeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::OBJECTIVEID, ObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::RESPONSIBLECODE, PositionPeer::ID, $join_behavior);


        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectiveLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectiveLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ObjectiveLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectiveLogPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined StrategicObjective rows

                $key2 = StrategicObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = StrategicObjectivePeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = StrategicObjectivePeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    StrategicObjectivePeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj2 (StrategicObjective)
                $obj2->addObjectiveLog($obj1);

            } // if joined row is not null

                // Add objects for joined Objective rows

                $key3 = ObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol3);
                if ($key3 !== null) {
                    $obj3 = ObjectivePeer::getInstanceFromPool($key3);
                    if (!$obj3) {

                        $cls = ObjectivePeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    ObjectivePeer::addInstanceToPool($obj3, $key3);
                } // if $obj3 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj3 (Objective)
                $obj3->addObjectiveLog($obj1);

            } // if joined row is not null

                // Add objects for joined PolicyGuideline rows

                $key4 = PolicyGuidelinePeer::getPrimaryKeyHashFromRow($row, $startcol4);
                if ($key4 !== null) {
                    $obj4 = PolicyGuidelinePeer::getInstanceFromPool($key4);
                    if (!$obj4) {

                        $cls = PolicyGuidelinePeer::getOMClass();

                    $obj4 = new $cls();
                    $obj4->hydrate($row, $startcol4);
                    PolicyGuidelinePeer::addInstanceToPool($obj4, $key4);
                } // if $obj4 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj4 (PolicyGuideline)
                $obj4->addObjectiveLog($obj1);

            } // if joined row is not null

                // Add objects for joined Position rows

                $key5 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol5);
                if ($key5 !== null) {
                    $obj5 = PositionPeer::getInstanceFromPool($key5);
                    if (!$obj5) {

                        $cls = PositionPeer::getOMClass();

                    $obj5 = new $cls();
                    $obj5->hydrate($row, $startcol5);
                    PositionPeer::addInstanceToPool($obj5, $key5);
                } // if $obj5 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj5 (Position)
                $obj5->addObjectiveLog($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of ObjectiveLog objects pre-filled with all related objects except Position.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ObjectiveLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptPosition(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);
        }

        ObjectiveLogPeer::addSelectColumns($criteria);
        $startcol2 = ObjectiveLogPeer::NUM_HYDRATE_COLUMNS;

        StrategicObjectivePeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + StrategicObjectivePeer::NUM_HYDRATE_COLUMNS;

        ObjectivePeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + ObjectivePeer::NUM_HYDRATE_COLUMNS;

        PolicyGuidelinePeer::addSelectColumns($criteria);
        $startcol5 = $startcol4 + PolicyGuidelinePeer::NUM_HYDRATE_COLUMNS;

        UserPeer::addSelectColumns($criteria);
        $startcol6 = $startcol5 + UserPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ObjectiveLogPeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::OBJECTIVEID, ObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectiveLogPeer::USERID, UserPeer::ID, $join_behavior);


        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectiveLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectiveLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ObjectiveLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectiveLogPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined StrategicObjective rows

                $key2 = StrategicObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = StrategicObjectivePeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = StrategicObjectivePeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    StrategicObjectivePeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj2 (StrategicObjective)
                $obj2->addObjectiveLog($obj1);

            } // if joined row is not null

                // Add objects for joined Objective rows

                $key3 = ObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol3);
                if ($key3 !== null) {
                    $obj3 = ObjectivePeer::getInstanceFromPool($key3);
                    if (!$obj3) {

                        $cls = ObjectivePeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    ObjectivePeer::addInstanceToPool($obj3, $key3);
                } // if $obj3 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj3 (Objective)
                $obj3->addObjectiveLog($obj1);

            } // if joined row is not null

                // Add objects for joined PolicyGuideline rows

                $key4 = PolicyGuidelinePeer::getPrimaryKeyHashFromRow($row, $startcol4);
                if ($key4 !== null) {
                    $obj4 = PolicyGuidelinePeer::getInstanceFromPool($key4);
                    if (!$obj4) {

                        $cls = PolicyGuidelinePeer::getOMClass();

                    $obj4 = new $cls();
                    $obj4->hydrate($row, $startcol4);
                    PolicyGuidelinePeer::addInstanceToPool($obj4, $key4);
                } // if $obj4 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj4 (PolicyGuideline)
                $obj4->addObjectiveLog($obj1);

            } // if joined row is not null

                // Add objects for joined User rows

                $key5 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol5);
                if ($key5 !== null) {
                    $obj5 = UserPeer::getInstanceFromPool($key5);
                    if (!$obj5) {

                        $cls = UserPeer::getOMClass();

                    $obj5 = new $cls();
                    $obj5->hydrate($row, $startcol5);
                    UserPeer::addInstanceToPool($obj5, $key5);
                } // if $obj5 already loaded

                // Add the $obj1 (ObjectiveLog) to the collection in $obj5 (User)
                $obj5->addObjectiveLog($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }

    /**
     * Returns the TableMap related to this peer.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getDatabaseMap(ObjectiveLogPeer::DATABASE_NAME)->getTable(ObjectiveLogPeer::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this peer class.
     */
    public static function buildTableMap()
    {
      $dbMap = Propel::getDatabaseMap(BaseObjectiveLogPeer::DATABASE_NAME);
      if (!$dbMap->hasTable(BaseObjectiveLogPeer::TABLE_NAME)) {
        $dbMap->addTableObject(new ObjectiveLogTableMap());
      }
    }

    /**
     * The class that the Peer will make instances of.
     *
     *
     * @return string ClassName
     */
    public static function getOMClass()
    {
        return ObjectiveLogPeer::OM_CLASS;
    }

    /**
     * Performs an INSERT on the database, given a ObjectiveLog or Criteria object.
     *
     * @param      mixed $values Criteria or ObjectiveLog object containing data that is used to create the INSERT statement.
     * @param      PropelPDO $con the PropelPDO connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doInsert($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity
        } else {
            $criteria = $values->buildCriteria(); // build Criteria from ObjectiveLog object
        }

        if ($criteria->containsKey(ObjectiveLogPeer::ID) && $criteria->keyContainsValue(ObjectiveLogPeer::ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.ObjectiveLogPeer::ID.')');
        }


        // Set the correct dbName
        $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);

        try {
            // use transaction because $criteria could contain info
            // for more than one table (I guess, conceivably)
            $con->beginTransaction();
            $pk = BasePeer::doInsert($criteria, $con);
            $con->commit();
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }

        return $pk;
    }

    /**
     * Performs an UPDATE on the database, given a ObjectiveLog or Criteria object.
     *
     * @param      mixed $values Criteria or ObjectiveLog object containing data that is used to create the UPDATE statement.
     * @param      PropelPDO $con The connection to use (specify PropelPDO connection object to exert more control over transactions).
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doUpdate($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $selectCriteria = new Criteria(ObjectiveLogPeer::DATABASE_NAME);

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity

            $comparison = $criteria->getComparison(ObjectiveLogPeer::ID);
            $value = $criteria->remove(ObjectiveLogPeer::ID);
            if ($value) {
                $selectCriteria->add(ObjectiveLogPeer::ID, $value, $comparison);
            } else {
                $selectCriteria->setPrimaryTableName(ObjectiveLogPeer::TABLE_NAME);
            }

        } else { // $values is ObjectiveLog object
            $criteria = $values->buildCriteria(); // gets full criteria
            $selectCriteria = $values->buildPkeyCriteria(); // gets criteria w/ primary key(s)
        }

        // set the correct dbName
        $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);

        return BasePeer::doUpdate($selectCriteria, $criteria, $con);
    }

    /**
     * Deletes all rows from the objectives_objectiveLog table.
     *
     * @param      PropelPDO $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException
     */
    public static function doDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $affectedRows = 0; // initialize var to track total num of affected rows
        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();
            $affectedRows += BasePeer::doDeleteAll(ObjectiveLogPeer::TABLE_NAME, $con, ObjectiveLogPeer::DATABASE_NAME);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ObjectiveLogPeer::clearInstancePool();
            ObjectiveLogPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs a DELETE on the database, given a ObjectiveLog or Criteria object OR a primary key value.
     *
     * @param      mixed $values Criteria or ObjectiveLog object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param      PropelPDO $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *				if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, PropelPDO $con = null)
     {
        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            // invalidate the cache for all objects of this type, since we have no
            // way of knowing (without running a query) what objects should be invalidated
            // from the cache based on this Criteria.
            ObjectiveLogPeer::clearInstancePool();
            // rename for clarity
            $criteria = clone $values;
        } elseif ($values instanceof ObjectiveLog) { // it's a model object
            // invalidate the cache for this single object
            ObjectiveLogPeer::removeInstanceFromPool($values);
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ObjectiveLogPeer::DATABASE_NAME);
            $criteria->add(ObjectiveLogPeer::ID, (array) $values, Criteria::IN);
            // invalidate the cache for this object(s)
            foreach ((array) $values as $singleval) {
                ObjectiveLogPeer::removeInstanceFromPool($singleval);
            }
        }

        // Set the correct dbName
        $criteria->setDbName(ObjectiveLogPeer::DATABASE_NAME);

        $affectedRows = 0; // initialize var to track total num of affected rows

        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();

            $affectedRows += BasePeer::doDelete($criteria, $con);
            ObjectiveLogPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Validates all modified columns of given ObjectiveLog object.
     * If parameter $columns is either a single column name or an array of column names
     * than only those columns are validated.
     *
     * NOTICE: This does not apply to primary or foreign keys for now.
     *
     * @param      ObjectiveLog $obj The object to validate.
     * @param      mixed $cols Column name or array of column names.
     *
     * @return mixed TRUE if all columns are valid or the error message of the first invalid column.
     */
    public static function doValidate($obj, $cols = null)
    {
        $columns = array();

        if ($cols) {
            $dbMap = Propel::getDatabaseMap(ObjectiveLogPeer::DATABASE_NAME);
            $tableMap = $dbMap->getTable(ObjectiveLogPeer::TABLE_NAME);

            if (! is_array($cols)) {
                $cols = array($cols);
            }

            foreach ($cols as $colName) {
                if ($tableMap->hasColumn($colName)) {
                    $get = 'get' . $tableMap->getColumn($colName)->getPhpName();
                    $columns[$colName] = $obj->$get();
                }
            }
        } else {

        }

        return BasePeer::doValidate(ObjectiveLogPeer::DATABASE_NAME, ObjectiveLogPeer::TABLE_NAME, $columns);
    }

    /**
     * Retrieve a single object by pkey.
     *
     * @param      int $pk the primary key.
     * @param      PropelPDO $con the connection to use
     * @return ObjectiveLog
     */
    public static function retrieveByPK($pk, PropelPDO $con = null)
    {

        if (null !== ($obj = ObjectiveLogPeer::getInstanceFromPool((string) $pk))) {
            return $obj;
        }

        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria = new Criteria(ObjectiveLogPeer::DATABASE_NAME);
        $criteria->add(ObjectiveLogPeer::ID, $pk);

        $v = ObjectiveLogPeer::doSelect($criteria, $con);

        return !empty($v) > 0 ? $v[0] : null;
    }

    /**
     * Retrieve multiple objects by pkey.
     *
     * @param      array $pks List of primary keys
     * @param      PropelPDO $con the connection to use
     * @return ObjectiveLog[]
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function retrieveByPKs($pks, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $objs = null;
        if (empty($pks)) {
            $objs = array();
        } else {
            $criteria = new Criteria(ObjectiveLogPeer::DATABASE_NAME);
            $criteria->add(ObjectiveLogPeer::ID, $pks, Criteria::IN);
            $objs = ObjectiveLogPeer::doSelect($criteria, $con);
        }

        return $objs;
    }

} // BaseObjectiveLogPeer

// This is the static code needed to register the TableMap for this table with the main Propel class.
//
BaseObjectiveLogPeer::buildTableMap();

