<?php


/**
 * Base class that represents a row from the 'objectives_objective' table.
 *
 * Objective
 *
 * @package    propel.generator.objectives.classes.om
 */
abstract class BaseObjective extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'ObjectivePeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        ObjectivePeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the policyguidelineid field.
     * @var        int
     */
    protected $policyguidelineid;

    /**
     * The value for the strategicobjectiveid field.
     * @var        int
     */
    protected $strategicobjectiveid;

    /**
     * The value for the affiliateid field.
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $affiliateid;

    /**
     * The value for the description field.
     * @var        string
     */
    protected $description;

    /**
     * The value for the date field.
     * @var        string
     */
    protected $date;

    /**
     * The value for the expirationdate field.
     * @var        string
     */
    protected $expirationdate;

    /**
     * The value for the achieved field.
     * @var        boolean
     */
    protected $achieved;

    /**
     * The value for the notes field.
     * @var        string
     */
    protected $notes;

    /**
     * The value for the responsiblecode field.
     * @var        int
     */
    protected $responsiblecode;

    /**
     * The value for the userid field.
     * @var        int
     */
    protected $userid;

    /**
     * The value for the userbyaffiliatesid field.
     * @var        int
     */
    protected $userbyaffiliatesid;

    /**
     * The value for the updated field.
     * @var        string
     */
    protected $updated;

    /**
     * The value for the changes field.
     * @var        int
     */
    protected $changes;

    /**
     * The value for the oldid field.
     * @var        int
     */
    protected $oldid;

    /**
     * The value for the startingyear field.
     * @var        int
     */
    protected $startingyear;

    /**
     * The value for the endingyear field.
     * @var        int
     */
    protected $endingyear;

    /**
     * The value for the deleted_at field.
     * @var        string
     */
    protected $deleted_at;

    /**
     * @var        StrategicObjective
     */
    protected $aStrategicObjective;

    /**
     * @var        PolicyGuideline
     */
    protected $aPolicyGuideline;

    /**
     * @var        User
     */
    protected $aUser;

    /**
     * @var        Position
     */
    protected $aPosition;

    /**
     * @var        PropelObjectCollection|Indicator[] Collection to store aggregation of Indicator objects.
     */
    protected $collIndicators;
    protected $collIndicatorsPartial;

    /**
     * @var        PropelObjectCollection|ObjectiveRegion[] Collection to store aggregation of ObjectiveRegion objects.
     */
    protected $collObjectiveRegions;
    protected $collObjectiveRegionsPartial;

    /**
     * @var        PropelObjectCollection|ObjectivePosition[] Collection to store aggregation of ObjectivePosition objects.
     */
    protected $collObjectivePositions;
    protected $collObjectivePositionsPartial;

    /**
     * @var        PropelObjectCollection|ObjectiveLog[] Collection to store aggregation of ObjectiveLog objects.
     */
    protected $collObjectiveLogs;
    protected $collObjectiveLogsPartial;

    /**
     * @var        PropelObjectCollection|Project[] Collection to store aggregation of Project objects.
     */
    protected $collProjects;
    protected $collProjectsPartial;

    /**
     * @var        PropelObjectCollection|ProjectLog[] Collection to store aggregation of ProjectLog objects.
     */
    protected $collProjectLogs;
    protected $collProjectLogsPartial;

    /**
     * @var        PropelObjectCollection|Region[] Collection to store aggregation of Region objects.
     */
    protected $collRegions;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $regionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $indicatorsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $objectiveRegionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $objectivePositionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $objectiveLogsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectLogsScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see        __construct()
     */
    public function applyDefaultValues()
    {
        $this->affiliateid = 0;
    }

    /**
     * Initializes internal state of BaseObjective object.
     * @see        applyDefaults()
     */
    public function __construct()
    {
        parent::__construct();
        $this->applyDefaultValues();
    }

    /**
     * Get the [id] column value.
     * Objective Id
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     * Objective Name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [policyguidelineid] column value.
     * Strategic Objective Id
     * @return int
     */
    public function getPolicyguidelineid()
    {
        return $this->policyguidelineid;
    }

    /**
     * Get the [strategicobjectiveid] column value.
     * Strategic Objective Id
     * @return int
     */
    public function getStrategicobjectiveid()
    {
        return $this->strategicobjectiveid;
    }

    /**
     * Get the [affiliateid] column value.
     * Affiliate Id
     * @return int
     */
    public function getAffiliateid()
    {
        return $this->affiliateid;
    }

    /**
     * Get the [description] column value.
     * Objective Description
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the [optionally formatted] temporal [date] column value.
     * Objective Date
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDate($format = '%Y/%m/%d')
    {
        if ($this->date === null) {
            return null;
        }

        if ($this->date === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->date);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->date, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [expirationdate] column value.
     * Objective Expiration Date (Fecha Vencimiento)
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getExpirationdate($format = '%Y/%m/%d')
    {
        if ($this->expirationdate === null) {
            return null;
        }

        if ($this->expirationdate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->expirationdate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->expirationdate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [achieved] column value.
     * is Objective achieved?
     * @return boolean
     */
    public function getAchieved()
    {
        return $this->achieved;
    }

    /**
     * Get the [notes] column value.
     * Objective Notes
     * @return string
     */
    public function getNotes()
    {
        return $this->notes;
    }

    /**
     * Get the [responsiblecode] column value.
     * Position Code
     * @return int
     */
    public function getResponsiblecode()
    {
        return $this->responsiblecode;
    }

    /**
     * Get the [userid] column value.
     * User Id
     * @return int
     */
    public function getUserid()
    {
        return $this->userid;
    }

    /**
     * Get the [userbyaffiliatesid] column value.
     * UserByAffiliates Id
     * @return int
     */
    public function getUserbyaffiliatesid()
    {
        return $this->userbyaffiliatesid;
    }

    /**
     * Get the [optionally formatted] temporal [updated] column value.
     * Updated
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getUpdated($format = 'Y-m-d H:i:s')
    {
        if ($this->updated === null) {
            return null;
        }

        if ($this->updated === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->updated);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->updated, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [changes] column value.
     * Cantidad de modificaciones
     * @return int
     */
    public function getChanges()
    {
        return $this->changes;
    }

    /**
     * Get the [oldid] column value.
     * Old Id
     * @return int
     */
    public function getOldid()
    {
        return $this->oldid;
    }

    /**
     * Get the [startingyear] column value.
     * Starting year
     * @return int
     */
    public function getStartingyear()
    {
        return $this->startingyear;
    }

    /**
     * Get the [endingyear] column value.
     * Ending year
     * @return int
     */
    public function getEndingyear()
    {
        return $this->endingyear;
    }

    /**
     * Get the [optionally formatted] temporal [deleted_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDeletedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->deleted_at === null) {
            return null;
        }

        if ($this->deleted_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->deleted_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->deleted_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Set the value of [id] column.
     * Objective Id
     * @param int $v new value
     * @return Objective The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = ObjectivePeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [name] column.
     * Objective Name
     * @param string $v new value
     * @return Objective The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = ObjectivePeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [policyguidelineid] column.
     * Strategic Objective Id
     * @param int $v new value
     * @return Objective The current object (for fluent API support)
     */
    public function setPolicyguidelineid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->policyguidelineid !== $v) {
            $this->policyguidelineid = $v;
            $this->modifiedColumns[] = ObjectivePeer::POLICYGUIDELINEID;
        }

        if ($this->aPolicyGuideline !== null && $this->aPolicyGuideline->getId() !== $v) {
            $this->aPolicyGuideline = null;
        }


        return $this;
    } // setPolicyguidelineid()

    /**
     * Set the value of [strategicobjectiveid] column.
     * Strategic Objective Id
     * @param int $v new value
     * @return Objective The current object (for fluent API support)
     */
    public function setStrategicobjectiveid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->strategicobjectiveid !== $v) {
            $this->strategicobjectiveid = $v;
            $this->modifiedColumns[] = ObjectivePeer::STRATEGICOBJECTIVEID;
        }

        if ($this->aStrategicObjective !== null && $this->aStrategicObjective->getId() !== $v) {
            $this->aStrategicObjective = null;
        }


        return $this;
    } // setStrategicobjectiveid()

    /**
     * Set the value of [affiliateid] column.
     * Affiliate Id
     * @param int $v new value
     * @return Objective The current object (for fluent API support)
     */
    public function setAffiliateid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->affiliateid !== $v) {
            $this->affiliateid = $v;
            $this->modifiedColumns[] = ObjectivePeer::AFFILIATEID;
        }


        return $this;
    } // setAffiliateid()

    /**
     * Set the value of [description] column.
     * Objective Description
     * @param string $v new value
     * @return Objective The current object (for fluent API support)
     */
    public function setDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->description !== $v) {
            $this->description = $v;
            $this->modifiedColumns[] = ObjectivePeer::DESCRIPTION;
        }


        return $this;
    } // setDescription()

    /**
     * Sets the value of [date] column to a normalized version of the date/time value specified.
     * Objective Date
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Objective The current object (for fluent API support)
     */
    public function setDate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->date !== null || $dt !== null) {
            $currentDateAsString = ($this->date !== null && $tmpDt = new DateTime($this->date)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->date = $newDateAsString;
                $this->modifiedColumns[] = ObjectivePeer::DATE;
            }
        } // if either are not null


        return $this;
    } // setDate()

    /**
     * Sets the value of [expirationdate] column to a normalized version of the date/time value specified.
     * Objective Expiration Date (Fecha Vencimiento)
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Objective The current object (for fluent API support)
     */
    public function setExpirationdate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->expirationdate !== null || $dt !== null) {
            $currentDateAsString = ($this->expirationdate !== null && $tmpDt = new DateTime($this->expirationdate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->expirationdate = $newDateAsString;
                $this->modifiedColumns[] = ObjectivePeer::EXPIRATIONDATE;
            }
        } // if either are not null


        return $this;
    } // setExpirationdate()

    /**
     * Sets the value of the [achieved] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * is Objective achieved?
     * @param boolean|integer|string $v The new value
     * @return Objective The current object (for fluent API support)
     */
    public function setAchieved($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->achieved !== $v) {
            $this->achieved = $v;
            $this->modifiedColumns[] = ObjectivePeer::ACHIEVED;
        }


        return $this;
    } // setAchieved()

    /**
     * Set the value of [notes] column.
     * Objective Notes
     * @param string $v new value
     * @return Objective The current object (for fluent API support)
     */
    public function setNotes($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->notes !== $v) {
            $this->notes = $v;
            $this->modifiedColumns[] = ObjectivePeer::NOTES;
        }


        return $this;
    } // setNotes()

    /**
     * Set the value of [responsiblecode] column.
     * Position Code
     * @param int $v new value
     * @return Objective The current object (for fluent API support)
     */
    public function setResponsiblecode($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->responsiblecode !== $v) {
            $this->responsiblecode = $v;
            $this->modifiedColumns[] = ObjectivePeer::RESPONSIBLECODE;
        }

        if ($this->aPosition !== null && $this->aPosition->getCode() !== $v) {
            $this->aPosition = null;
        }


        return $this;
    } // setResponsiblecode()

    /**
     * Set the value of [userid] column.
     * User Id
     * @param int $v new value
     * @return Objective The current object (for fluent API support)
     */
    public function setUserid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->userid !== $v) {
            $this->userid = $v;
            $this->modifiedColumns[] = ObjectivePeer::USERID;
        }

        if ($this->aUser !== null && $this->aUser->getId() !== $v) {
            $this->aUser = null;
        }


        return $this;
    } // setUserid()

    /**
     * Set the value of [userbyaffiliatesid] column.
     * UserByAffiliates Id
     * @param int $v new value
     * @return Objective The current object (for fluent API support)
     */
    public function setUserbyaffiliatesid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->userbyaffiliatesid !== $v) {
            $this->userbyaffiliatesid = $v;
            $this->modifiedColumns[] = ObjectivePeer::USERBYAFFILIATESID;
        }


        return $this;
    } // setUserbyaffiliatesid()

    /**
     * Sets the value of [updated] column to a normalized version of the date/time value specified.
     * Updated
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Objective The current object (for fluent API support)
     */
    public function setUpdated($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->updated !== null || $dt !== null) {
            $currentDateAsString = ($this->updated !== null && $tmpDt = new DateTime($this->updated)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->updated = $newDateAsString;
                $this->modifiedColumns[] = ObjectivePeer::UPDATED;
            }
        } // if either are not null


        return $this;
    } // setUpdated()

    /**
     * Set the value of [changes] column.
     * Cantidad de modificaciones
     * @param int $v new value
     * @return Objective The current object (for fluent API support)
     */
    public function setChanges($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->changes !== $v) {
            $this->changes = $v;
            $this->modifiedColumns[] = ObjectivePeer::CHANGES;
        }


        return $this;
    } // setChanges()

    /**
     * Set the value of [oldid] column.
     * Old Id
     * @param int $v new value
     * @return Objective The current object (for fluent API support)
     */
    public function setOldid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->oldid !== $v) {
            $this->oldid = $v;
            $this->modifiedColumns[] = ObjectivePeer::OLDID;
        }


        return $this;
    } // setOldid()

    /**
     * Set the value of [startingyear] column.
     * Starting year
     * @param int $v new value
     * @return Objective The current object (for fluent API support)
     */
    public function setStartingyear($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->startingyear !== $v) {
            $this->startingyear = $v;
            $this->modifiedColumns[] = ObjectivePeer::STARTINGYEAR;
        }


        return $this;
    } // setStartingyear()

    /**
     * Set the value of [endingyear] column.
     * Ending year
     * @param int $v new value
     * @return Objective The current object (for fluent API support)
     */
    public function setEndingyear($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->endingyear !== $v) {
            $this->endingyear = $v;
            $this->modifiedColumns[] = ObjectivePeer::ENDINGYEAR;
        }


        return $this;
    } // setEndingyear()

    /**
     * Sets the value of [deleted_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Objective The current object (for fluent API support)
     */
    public function setDeletedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->deleted_at !== null || $dt !== null) {
            $currentDateAsString = ($this->deleted_at !== null && $tmpDt = new DateTime($this->deleted_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->deleted_at = $newDateAsString;
                $this->modifiedColumns[] = ObjectivePeer::DELETED_AT;
            }
        } // if either are not null


        return $this;
    } // setDeletedAt()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->affiliateid !== 0) {
                return false;
            }

        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->policyguidelineid = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
            $this->strategicobjectiveid = ($row[$startcol + 3] !== null) ? (int) $row[$startcol + 3] : null;
            $this->affiliateid = ($row[$startcol + 4] !== null) ? (int) $row[$startcol + 4] : null;
            $this->description = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->date = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->expirationdate = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
            $this->achieved = ($row[$startcol + 8] !== null) ? (boolean) $row[$startcol + 8] : null;
            $this->notes = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
            $this->responsiblecode = ($row[$startcol + 10] !== null) ? (int) $row[$startcol + 10] : null;
            $this->userid = ($row[$startcol + 11] !== null) ? (int) $row[$startcol + 11] : null;
            $this->userbyaffiliatesid = ($row[$startcol + 12] !== null) ? (int) $row[$startcol + 12] : null;
            $this->updated = ($row[$startcol + 13] !== null) ? (string) $row[$startcol + 13] : null;
            $this->changes = ($row[$startcol + 14] !== null) ? (int) $row[$startcol + 14] : null;
            $this->oldid = ($row[$startcol + 15] !== null) ? (int) $row[$startcol + 15] : null;
            $this->startingyear = ($row[$startcol + 16] !== null) ? (int) $row[$startcol + 16] : null;
            $this->endingyear = ($row[$startcol + 17] !== null) ? (int) $row[$startcol + 17] : null;
            $this->deleted_at = ($row[$startcol + 18] !== null) ? (string) $row[$startcol + 18] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 19; // 19 = ObjectivePeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Objective object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aPolicyGuideline !== null && $this->policyguidelineid !== $this->aPolicyGuideline->getId()) {
            $this->aPolicyGuideline = null;
        }
        if ($this->aStrategicObjective !== null && $this->strategicobjectiveid !== $this->aStrategicObjective->getId()) {
            $this->aStrategicObjective = null;
        }
        if ($this->aPosition !== null && $this->responsiblecode !== $this->aPosition->getCode()) {
            $this->aPosition = null;
        }
        if ($this->aUser !== null && $this->userid !== $this->aUser->getId()) {
            $this->aUser = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = ObjectivePeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aStrategicObjective = null;
            $this->aPolicyGuideline = null;
            $this->aUser = null;
            $this->aPosition = null;
            $this->collIndicators = null;

            $this->collObjectiveRegions = null;

            $this->collObjectivePositions = null;

            $this->collObjectiveLogs = null;

            $this->collProjects = null;

            $this->collProjectLogs = null;

            $this->collRegions = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = ObjectiveQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // soft_delete behavior
            if (!empty($ret) && ObjectiveQuery::isSoftDeleteEnabled()) {
                $this->setDeletedAt(time());
                $this->save($con);
                $this->postDelete($con);
                $con->commit();
                ObjectivePeer::removeInstanceFromPool($this);

                return;
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                ObjectivePeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aStrategicObjective !== null) {
                if ($this->aStrategicObjective->isModified() || $this->aStrategicObjective->isNew()) {
                    $affectedRows += $this->aStrategicObjective->save($con);
                }
                $this->setStrategicObjective($this->aStrategicObjective);
            }

            if ($this->aPolicyGuideline !== null) {
                if ($this->aPolicyGuideline->isModified() || $this->aPolicyGuideline->isNew()) {
                    $affectedRows += $this->aPolicyGuideline->save($con);
                }
                $this->setPolicyGuideline($this->aPolicyGuideline);
            }

            if ($this->aUser !== null) {
                if ($this->aUser->isModified() || $this->aUser->isNew()) {
                    $affectedRows += $this->aUser->save($con);
                }
                $this->setUser($this->aUser);
            }

            if ($this->aPosition !== null) {
                if ($this->aPosition->isModified() || $this->aPosition->isNew()) {
                    $affectedRows += $this->aPosition->save($con);
                }
                $this->setPosition($this->aPosition);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->regionsScheduledForDeletion !== null) {
                if (!$this->regionsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->regionsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    ObjectiveRegionQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->regionsScheduledForDeletion = null;
                }

                foreach ($this->getRegions() as $region) {
                    if ($region->isModified()) {
                        $region->save($con);
                    }
                }
            }

            if ($this->indicatorsScheduledForDeletion !== null) {
                if (!$this->indicatorsScheduledForDeletion->isEmpty()) {
                    foreach ($this->indicatorsScheduledForDeletion as $indicator) {
                        // need to save related object because we set the relation to null
                        $indicator->save($con);
                    }
                    $this->indicatorsScheduledForDeletion = null;
                }
            }

            if ($this->collIndicators !== null) {
                foreach ($this->collIndicators as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->objectiveRegionsScheduledForDeletion !== null) {
                if (!$this->objectiveRegionsScheduledForDeletion->isEmpty()) {
                    ObjectiveRegionQuery::create()
                        ->filterByPrimaryKeys($this->objectiveRegionsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->objectiveRegionsScheduledForDeletion = null;
                }
            }

            if ($this->collObjectiveRegions !== null) {
                foreach ($this->collObjectiveRegions as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->objectivePositionsScheduledForDeletion !== null) {
                if (!$this->objectivePositionsScheduledForDeletion->isEmpty()) {
                    ObjectivePositionQuery::create()
                        ->filterByPrimaryKeys($this->objectivePositionsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->objectivePositionsScheduledForDeletion = null;
                }
            }

            if ($this->collObjectivePositions !== null) {
                foreach ($this->collObjectivePositions as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->objectiveLogsScheduledForDeletion !== null) {
                if (!$this->objectiveLogsScheduledForDeletion->isEmpty()) {
                    ObjectiveLogQuery::create()
                        ->filterByPrimaryKeys($this->objectiveLogsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->objectiveLogsScheduledForDeletion = null;
                }
            }

            if ($this->collObjectiveLogs !== null) {
                foreach ($this->collObjectiveLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectsScheduledForDeletion !== null) {
                if (!$this->projectsScheduledForDeletion->isEmpty()) {
                    ProjectQuery::create()
                        ->filterByPrimaryKeys($this->projectsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->projectsScheduledForDeletion = null;
                }
            }

            if ($this->collProjects !== null) {
                foreach ($this->collProjects as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectLogsScheduledForDeletion !== null) {
                if (!$this->projectLogsScheduledForDeletion->isEmpty()) {
                    ProjectLogQuery::create()
                        ->filterByPrimaryKeys($this->projectLogsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->projectLogsScheduledForDeletion = null;
                }
            }

            if ($this->collProjectLogs !== null) {
                foreach ($this->collProjectLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = ObjectivePeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . ObjectivePeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(ObjectivePeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(ObjectivePeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(ObjectivePeer::POLICYGUIDELINEID)) {
            $modifiedColumns[':p' . $index++]  = '`POLICYGUIDELINEID`';
        }
        if ($this->isColumnModified(ObjectivePeer::STRATEGICOBJECTIVEID)) {
            $modifiedColumns[':p' . $index++]  = '`STRATEGICOBJECTIVEID`';
        }
        if ($this->isColumnModified(ObjectivePeer::AFFILIATEID)) {
            $modifiedColumns[':p' . $index++]  = '`AFFILIATEID`';
        }
        if ($this->isColumnModified(ObjectivePeer::DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`DESCRIPTION`';
        }
        if ($this->isColumnModified(ObjectivePeer::DATE)) {
            $modifiedColumns[':p' . $index++]  = '`DATE`';
        }
        if ($this->isColumnModified(ObjectivePeer::EXPIRATIONDATE)) {
            $modifiedColumns[':p' . $index++]  = '`EXPIRATIONDATE`';
        }
        if ($this->isColumnModified(ObjectivePeer::ACHIEVED)) {
            $modifiedColumns[':p' . $index++]  = '`ACHIEVED`';
        }
        if ($this->isColumnModified(ObjectivePeer::NOTES)) {
            $modifiedColumns[':p' . $index++]  = '`NOTES`';
        }
        if ($this->isColumnModified(ObjectivePeer::RESPONSIBLECODE)) {
            $modifiedColumns[':p' . $index++]  = '`RESPONSIBLECODE`';
        }
        if ($this->isColumnModified(ObjectivePeer::USERID)) {
            $modifiedColumns[':p' . $index++]  = '`USERID`';
        }
        if ($this->isColumnModified(ObjectivePeer::USERBYAFFILIATESID)) {
            $modifiedColumns[':p' . $index++]  = '`USERBYAFFILIATESID`';
        }
        if ($this->isColumnModified(ObjectivePeer::UPDATED)) {
            $modifiedColumns[':p' . $index++]  = '`UPDATED`';
        }
        if ($this->isColumnModified(ObjectivePeer::CHANGES)) {
            $modifiedColumns[':p' . $index++]  = '`CHANGES`';
        }
        if ($this->isColumnModified(ObjectivePeer::OLDID)) {
            $modifiedColumns[':p' . $index++]  = '`OLDID`';
        }
        if ($this->isColumnModified(ObjectivePeer::STARTINGYEAR)) {
            $modifiedColumns[':p' . $index++]  = '`STARTINGYEAR`';
        }
        if ($this->isColumnModified(ObjectivePeer::ENDINGYEAR)) {
            $modifiedColumns[':p' . $index++]  = '`ENDINGYEAR`';
        }
        if ($this->isColumnModified(ObjectivePeer::DELETED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`DELETED_AT`';
        }

        $sql = sprintf(
            'INSERT INTO `objectives_objective` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`POLICYGUIDELINEID`':
                        $stmt->bindValue($identifier, $this->policyguidelineid, PDO::PARAM_INT);
                        break;
                    case '`STRATEGICOBJECTIVEID`':
                        $stmt->bindValue($identifier, $this->strategicobjectiveid, PDO::PARAM_INT);
                        break;
                    case '`AFFILIATEID`':
                        $stmt->bindValue($identifier, $this->affiliateid, PDO::PARAM_INT);
                        break;
                    case '`DESCRIPTION`':
                        $stmt->bindValue($identifier, $this->description, PDO::PARAM_STR);
                        break;
                    case '`DATE`':
                        $stmt->bindValue($identifier, $this->date, PDO::PARAM_STR);
                        break;
                    case '`EXPIRATIONDATE`':
                        $stmt->bindValue($identifier, $this->expirationdate, PDO::PARAM_STR);
                        break;
                    case '`ACHIEVED`':
                        $stmt->bindValue($identifier, (int) $this->achieved, PDO::PARAM_INT);
                        break;
                    case '`NOTES`':
                        $stmt->bindValue($identifier, $this->notes, PDO::PARAM_STR);
                        break;
                    case '`RESPONSIBLECODE`':
                        $stmt->bindValue($identifier, $this->responsiblecode, PDO::PARAM_INT);
                        break;
                    case '`USERID`':
                        $stmt->bindValue($identifier, $this->userid, PDO::PARAM_INT);
                        break;
                    case '`USERBYAFFILIATESID`':
                        $stmt->bindValue($identifier, $this->userbyaffiliatesid, PDO::PARAM_INT);
                        break;
                    case '`UPDATED`':
                        $stmt->bindValue($identifier, $this->updated, PDO::PARAM_STR);
                        break;
                    case '`CHANGES`':
                        $stmt->bindValue($identifier, $this->changes, PDO::PARAM_INT);
                        break;
                    case '`OLDID`':
                        $stmt->bindValue($identifier, $this->oldid, PDO::PARAM_INT);
                        break;
                    case '`STARTINGYEAR`':
                        $stmt->bindValue($identifier, $this->startingyear, PDO::PARAM_INT);
                        break;
                    case '`ENDINGYEAR`':
                        $stmt->bindValue($identifier, $this->endingyear, PDO::PARAM_INT);
                        break;
                    case '`DELETED_AT`':
                        $stmt->bindValue($identifier, $this->deleted_at, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aStrategicObjective !== null) {
                if (!$this->aStrategicObjective->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aStrategicObjective->getValidationFailures());
                }
            }

            if ($this->aPolicyGuideline !== null) {
                if (!$this->aPolicyGuideline->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aPolicyGuideline->getValidationFailures());
                }
            }

            if ($this->aUser !== null) {
                if (!$this->aUser->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aUser->getValidationFailures());
                }
            }

            if ($this->aPosition !== null) {
                if (!$this->aPosition->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aPosition->getValidationFailures());
                }
            }


            if (($retval = ObjectivePeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collIndicators !== null) {
                    foreach ($this->collIndicators as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collObjectiveRegions !== null) {
                    foreach ($this->collObjectiveRegions as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collObjectivePositions !== null) {
                    foreach ($this->collObjectivePositions as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collObjectiveLogs !== null) {
                    foreach ($this->collObjectiveLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjects !== null) {
                    foreach ($this->collProjects as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectLogs !== null) {
                    foreach ($this->collProjectLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ObjectivePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getName();
                break;
            case 2:
                return $this->getPolicyguidelineid();
                break;
            case 3:
                return $this->getStrategicobjectiveid();
                break;
            case 4:
                return $this->getAffiliateid();
                break;
            case 5:
                return $this->getDescription();
                break;
            case 6:
                return $this->getDate();
                break;
            case 7:
                return $this->getExpirationdate();
                break;
            case 8:
                return $this->getAchieved();
                break;
            case 9:
                return $this->getNotes();
                break;
            case 10:
                return $this->getResponsiblecode();
                break;
            case 11:
                return $this->getUserid();
                break;
            case 12:
                return $this->getUserbyaffiliatesid();
                break;
            case 13:
                return $this->getUpdated();
                break;
            case 14:
                return $this->getChanges();
                break;
            case 15:
                return $this->getOldid();
                break;
            case 16:
                return $this->getStartingyear();
                break;
            case 17:
                return $this->getEndingyear();
                break;
            case 18:
                return $this->getDeletedAt();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['Objective'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Objective'][$this->getPrimaryKey()] = true;
        $keys = ObjectivePeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getPolicyguidelineid(),
            $keys[3] => $this->getStrategicobjectiveid(),
            $keys[4] => $this->getAffiliateid(),
            $keys[5] => $this->getDescription(),
            $keys[6] => $this->getDate(),
            $keys[7] => $this->getExpirationdate(),
            $keys[8] => $this->getAchieved(),
            $keys[9] => $this->getNotes(),
            $keys[10] => $this->getResponsiblecode(),
            $keys[11] => $this->getUserid(),
            $keys[12] => $this->getUserbyaffiliatesid(),
            $keys[13] => $this->getUpdated(),
            $keys[14] => $this->getChanges(),
            $keys[15] => $this->getOldid(),
            $keys[16] => $this->getStartingyear(),
            $keys[17] => $this->getEndingyear(),
            $keys[18] => $this->getDeletedAt(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aStrategicObjective) {
                $result['StrategicObjective'] = $this->aStrategicObjective->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aPolicyGuideline) {
                $result['PolicyGuideline'] = $this->aPolicyGuideline->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aUser) {
                $result['User'] = $this->aUser->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aPosition) {
                $result['Position'] = $this->aPosition->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collIndicators) {
                $result['Indicators'] = $this->collIndicators->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collObjectiveRegions) {
                $result['ObjectiveRegions'] = $this->collObjectiveRegions->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collObjectivePositions) {
                $result['ObjectivePositions'] = $this->collObjectivePositions->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collObjectiveLogs) {
                $result['ObjectiveLogs'] = $this->collObjectiveLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjects) {
                $result['Projects'] = $this->collProjects->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectLogs) {
                $result['ProjectLogs'] = $this->collProjectLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ObjectivePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setPolicyguidelineid($value);
                break;
            case 3:
                $this->setStrategicobjectiveid($value);
                break;
            case 4:
                $this->setAffiliateid($value);
                break;
            case 5:
                $this->setDescription($value);
                break;
            case 6:
                $this->setDate($value);
                break;
            case 7:
                $this->setExpirationdate($value);
                break;
            case 8:
                $this->setAchieved($value);
                break;
            case 9:
                $this->setNotes($value);
                break;
            case 10:
                $this->setResponsiblecode($value);
                break;
            case 11:
                $this->setUserid($value);
                break;
            case 12:
                $this->setUserbyaffiliatesid($value);
                break;
            case 13:
                $this->setUpdated($value);
                break;
            case 14:
                $this->setChanges($value);
                break;
            case 15:
                $this->setOldid($value);
                break;
            case 16:
                $this->setStartingyear($value);
                break;
            case 17:
                $this->setEndingyear($value);
                break;
            case 18:
                $this->setDeletedAt($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = ObjectivePeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setName($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setPolicyguidelineid($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setStrategicobjectiveid($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setAffiliateid($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setDescription($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setDate($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setExpirationdate($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setAchieved($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setNotes($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setResponsiblecode($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setUserid($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setUserbyaffiliatesid($arr[$keys[12]]);
        if (array_key_exists($keys[13], $arr)) $this->setUpdated($arr[$keys[13]]);
        if (array_key_exists($keys[14], $arr)) $this->setChanges($arr[$keys[14]]);
        if (array_key_exists($keys[15], $arr)) $this->setOldid($arr[$keys[15]]);
        if (array_key_exists($keys[16], $arr)) $this->setStartingyear($arr[$keys[16]]);
        if (array_key_exists($keys[17], $arr)) $this->setEndingyear($arr[$keys[17]]);
        if (array_key_exists($keys[18], $arr)) $this->setDeletedAt($arr[$keys[18]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(ObjectivePeer::DATABASE_NAME);

        if ($this->isColumnModified(ObjectivePeer::ID)) $criteria->add(ObjectivePeer::ID, $this->id);
        if ($this->isColumnModified(ObjectivePeer::NAME)) $criteria->add(ObjectivePeer::NAME, $this->name);
        if ($this->isColumnModified(ObjectivePeer::POLICYGUIDELINEID)) $criteria->add(ObjectivePeer::POLICYGUIDELINEID, $this->policyguidelineid);
        if ($this->isColumnModified(ObjectivePeer::STRATEGICOBJECTIVEID)) $criteria->add(ObjectivePeer::STRATEGICOBJECTIVEID, $this->strategicobjectiveid);
        if ($this->isColumnModified(ObjectivePeer::AFFILIATEID)) $criteria->add(ObjectivePeer::AFFILIATEID, $this->affiliateid);
        if ($this->isColumnModified(ObjectivePeer::DESCRIPTION)) $criteria->add(ObjectivePeer::DESCRIPTION, $this->description);
        if ($this->isColumnModified(ObjectivePeer::DATE)) $criteria->add(ObjectivePeer::DATE, $this->date);
        if ($this->isColumnModified(ObjectivePeer::EXPIRATIONDATE)) $criteria->add(ObjectivePeer::EXPIRATIONDATE, $this->expirationdate);
        if ($this->isColumnModified(ObjectivePeer::ACHIEVED)) $criteria->add(ObjectivePeer::ACHIEVED, $this->achieved);
        if ($this->isColumnModified(ObjectivePeer::NOTES)) $criteria->add(ObjectivePeer::NOTES, $this->notes);
        if ($this->isColumnModified(ObjectivePeer::RESPONSIBLECODE)) $criteria->add(ObjectivePeer::RESPONSIBLECODE, $this->responsiblecode);
        if ($this->isColumnModified(ObjectivePeer::USERID)) $criteria->add(ObjectivePeer::USERID, $this->userid);
        if ($this->isColumnModified(ObjectivePeer::USERBYAFFILIATESID)) $criteria->add(ObjectivePeer::USERBYAFFILIATESID, $this->userbyaffiliatesid);
        if ($this->isColumnModified(ObjectivePeer::UPDATED)) $criteria->add(ObjectivePeer::UPDATED, $this->updated);
        if ($this->isColumnModified(ObjectivePeer::CHANGES)) $criteria->add(ObjectivePeer::CHANGES, $this->changes);
        if ($this->isColumnModified(ObjectivePeer::OLDID)) $criteria->add(ObjectivePeer::OLDID, $this->oldid);
        if ($this->isColumnModified(ObjectivePeer::STARTINGYEAR)) $criteria->add(ObjectivePeer::STARTINGYEAR, $this->startingyear);
        if ($this->isColumnModified(ObjectivePeer::ENDINGYEAR)) $criteria->add(ObjectivePeer::ENDINGYEAR, $this->endingyear);
        if ($this->isColumnModified(ObjectivePeer::DELETED_AT)) $criteria->add(ObjectivePeer::DELETED_AT, $this->deleted_at);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(ObjectivePeer::DATABASE_NAME);
        $criteria->add(ObjectivePeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Objective (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setName($this->getName());
        $copyObj->setPolicyguidelineid($this->getPolicyguidelineid());
        $copyObj->setStrategicobjectiveid($this->getStrategicobjectiveid());
        $copyObj->setAffiliateid($this->getAffiliateid());
        $copyObj->setDescription($this->getDescription());
        $copyObj->setDate($this->getDate());
        $copyObj->setExpirationdate($this->getExpirationdate());
        $copyObj->setAchieved($this->getAchieved());
        $copyObj->setNotes($this->getNotes());
        $copyObj->setResponsiblecode($this->getResponsiblecode());
        $copyObj->setUserid($this->getUserid());
        $copyObj->setUserbyaffiliatesid($this->getUserbyaffiliatesid());
        $copyObj->setUpdated($this->getUpdated());
        $copyObj->setChanges($this->getChanges());
        $copyObj->setOldid($this->getOldid());
        $copyObj->setStartingyear($this->getStartingyear());
        $copyObj->setEndingyear($this->getEndingyear());
        $copyObj->setDeletedAt($this->getDeletedAt());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getIndicators() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addIndicator($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getObjectiveRegions() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addObjectiveRegion($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getObjectivePositions() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addObjectivePosition($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getObjectiveLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addObjectiveLog($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjects() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProject($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectLog($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Objective Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return ObjectivePeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new ObjectivePeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a StrategicObjective object.
     *
     * @param             StrategicObjective $v
     * @return Objective The current object (for fluent API support)
     * @throws PropelException
     */
    public function setStrategicObjective(StrategicObjective $v = null)
    {
        if ($v === null) {
            $this->setStrategicobjectiveid(NULL);
        } else {
            $this->setStrategicobjectiveid($v->getId());
        }

        $this->aStrategicObjective = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the StrategicObjective object, it will not be re-added.
        if ($v !== null) {
            $v->addObjective($this);
        }


        return $this;
    }


    /**
     * Get the associated StrategicObjective object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return StrategicObjective The associated StrategicObjective object.
     * @throws PropelException
     */
    public function getStrategicObjective(PropelPDO $con = null)
    {
        if ($this->aStrategicObjective === null && ($this->strategicobjectiveid !== null)) {
            $this->aStrategicObjective = StrategicObjectiveQuery::create()->findPk($this->strategicobjectiveid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aStrategicObjective->addObjectives($this);
             */
        }

        return $this->aStrategicObjective;
    }

    /**
     * Declares an association between this object and a PolicyGuideline object.
     *
     * @param             PolicyGuideline $v
     * @return Objective The current object (for fluent API support)
     * @throws PropelException
     */
    public function setPolicyGuideline(PolicyGuideline $v = null)
    {
        if ($v === null) {
            $this->setPolicyguidelineid(NULL);
        } else {
            $this->setPolicyguidelineid($v->getId());
        }

        $this->aPolicyGuideline = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the PolicyGuideline object, it will not be re-added.
        if ($v !== null) {
            $v->addObjective($this);
        }


        return $this;
    }


    /**
     * Get the associated PolicyGuideline object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return PolicyGuideline The associated PolicyGuideline object.
     * @throws PropelException
     */
    public function getPolicyGuideline(PropelPDO $con = null)
    {
        if ($this->aPolicyGuideline === null && ($this->policyguidelineid !== null)) {
            $this->aPolicyGuideline = PolicyGuidelineQuery::create()->findPk($this->policyguidelineid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aPolicyGuideline->addObjectives($this);
             */
        }

        return $this->aPolicyGuideline;
    }

    /**
     * Declares an association between this object and a User object.
     *
     * @param             User $v
     * @return Objective The current object (for fluent API support)
     * @throws PropelException
     */
    public function setUser(User $v = null)
    {
        if ($v === null) {
            $this->setUserid(NULL);
        } else {
            $this->setUserid($v->getId());
        }

        $this->aUser = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the User object, it will not be re-added.
        if ($v !== null) {
            $v->addObjective($this);
        }


        return $this;
    }


    /**
     * Get the associated User object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return User The associated User object.
     * @throws PropelException
     */
    public function getUser(PropelPDO $con = null)
    {
        if ($this->aUser === null && ($this->userid !== null)) {
            $this->aUser = UserQuery::create()->findPk($this->userid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aUser->addObjectives($this);
             */
        }

        return $this->aUser;
    }

    /**
     * Declares an association between this object and a Position object.
     *
     * @param             Position $v
     * @return Objective The current object (for fluent API support)
     * @throws PropelException
     */
    public function setPosition(Position $v = null)
    {
        if ($v === null) {
            $this->setResponsiblecode(NULL);
        } else {
            $this->setResponsiblecode($v->getCode());
        }

        $this->aPosition = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Position object, it will not be re-added.
        if ($v !== null) {
            $v->addObjective($this);
        }


        return $this;
    }


    /**
     * Get the associated Position object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Position The associated Position object.
     * @throws PropelException
     */
    public function getPosition(PropelPDO $con = null)
    {
        if ($this->aPosition === null && ($this->responsiblecode !== null)) {
            $this->aPosition = PositionQuery::create()
                ->filterByObjective($this) // here
                ->findOne($con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aPosition->addObjectives($this);
             */
        }

        return $this->aPosition;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('Indicator' == $relationName) {
            $this->initIndicators();
        }
        if ('ObjectiveRegion' == $relationName) {
            $this->initObjectiveRegions();
        }
        if ('ObjectivePosition' == $relationName) {
            $this->initObjectivePositions();
        }
        if ('ObjectiveLog' == $relationName) {
            $this->initObjectiveLogs();
        }
        if ('Project' == $relationName) {
            $this->initProjects();
        }
        if ('ProjectLog' == $relationName) {
            $this->initProjectLogs();
        }
    }

    /**
     * Clears out the collIndicators collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addIndicators()
     */
    public function clearIndicators()
    {
        $this->collIndicators = null; // important to set this to null since that means it is uninitialized
        $this->collIndicatorsPartial = null;
    }

    /**
     * reset is the collIndicators collection loaded partially
     *
     * @return void
     */
    public function resetPartialIndicators($v = true)
    {
        $this->collIndicatorsPartial = $v;
    }

    /**
     * Initializes the collIndicators collection.
     *
     * By default this just sets the collIndicators collection to an empty array (like clearcollIndicators());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initIndicators($overrideExisting = true)
    {
        if (null !== $this->collIndicators && !$overrideExisting) {
            return;
        }
        $this->collIndicators = new PropelObjectCollection();
        $this->collIndicators->setModel('Indicator');
    }

    /**
     * Gets an array of Indicator objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Objective is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Indicator[] List of Indicator objects
     * @throws PropelException
     */
    public function getIndicators($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collIndicatorsPartial && !$this->isNew();
        if (null === $this->collIndicators || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collIndicators) {
                // return empty collection
                $this->initIndicators();
            } else {
                $collIndicators = IndicatorQuery::create(null, $criteria)
                    ->filterByObjective($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collIndicatorsPartial && count($collIndicators)) {
                      $this->initIndicators(false);

                      foreach($collIndicators as $obj) {
                        if (false == $this->collIndicators->contains($obj)) {
                          $this->collIndicators->append($obj);
                        }
                      }

                      $this->collIndicatorsPartial = true;
                    }

                    return $collIndicators;
                }

                if($partial && $this->collIndicators) {
                    foreach($this->collIndicators as $obj) {
                        if($obj->isNew()) {
                            $collIndicators[] = $obj;
                        }
                    }
                }

                $this->collIndicators = $collIndicators;
                $this->collIndicatorsPartial = false;
            }
        }

        return $this->collIndicators;
    }

    /**
     * Sets a collection of Indicator objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $indicators A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setIndicators(PropelCollection $indicators, PropelPDO $con = null)
    {
        $this->indicatorsScheduledForDeletion = $this->getIndicators(new Criteria(), $con)->diff($indicators);

        foreach ($this->indicatorsScheduledForDeletion as $indicatorRemoved) {
            $indicatorRemoved->setObjective(null);
        }

        $this->collIndicators = null;
        foreach ($indicators as $indicator) {
            $this->addIndicator($indicator);
        }

        $this->collIndicators = $indicators;
        $this->collIndicatorsPartial = false;
    }

    /**
     * Returns the number of related Indicator objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Indicator objects.
     * @throws PropelException
     */
    public function countIndicators(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collIndicatorsPartial && !$this->isNew();
        if (null === $this->collIndicators || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collIndicators) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getIndicators());
                }
                $query = IndicatorQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByObjective($this)
                    ->count($con);
            }
        } else {
            return count($this->collIndicators);
        }
    }

    /**
     * Method called to associate a BaseIndicator object to this object
     * through the BaseIndicator foreign key attribute.
     *
     * @param    BaseIndicator $l BaseIndicator
     * @return Objective The current object (for fluent API support)
     */
    public function addIndicator(BaseIndicator $l)
    {
        if ($this->collIndicators === null) {
            $this->initIndicators();
            $this->collIndicatorsPartial = true;
        }
        if (!$this->collIndicators->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddIndicator($l);
        }

        return $this;
    }

    /**
     * @param	Indicator $indicator The indicator object to add.
     */
    protected function doAddIndicator($indicator)
    {
        $this->collIndicators[]= $indicator;
        $indicator->setObjective($this);
    }

    /**
     * @param	Indicator $indicator The indicator object to remove.
     */
    public function removeIndicator($indicator)
    {
        if ($this->getIndicators()->contains($indicator)) {
            $this->collIndicators->remove($this->collIndicators->search($indicator));
            if (null === $this->indicatorsScheduledForDeletion) {
                $this->indicatorsScheduledForDeletion = clone $this->collIndicators;
                $this->indicatorsScheduledForDeletion->clear();
            }
            $this->indicatorsScheduledForDeletion[]= $indicator;
            $indicator->setObjective(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Objective is new, it will return
     * an empty collection; or if this Objective has previously
     * been saved, it will retrieve related Indicators from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Objective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Indicator[] List of Indicator objects
     */
    public function getIndicatorsJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = IndicatorQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getIndicators($query, $con);
    }

    /**
     * Clears out the collObjectiveRegions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addObjectiveRegions()
     */
    public function clearObjectiveRegions()
    {
        $this->collObjectiveRegions = null; // important to set this to null since that means it is uninitialized
        $this->collObjectiveRegionsPartial = null;
    }

    /**
     * reset is the collObjectiveRegions collection loaded partially
     *
     * @return void
     */
    public function resetPartialObjectiveRegions($v = true)
    {
        $this->collObjectiveRegionsPartial = $v;
    }

    /**
     * Initializes the collObjectiveRegions collection.
     *
     * By default this just sets the collObjectiveRegions collection to an empty array (like clearcollObjectiveRegions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initObjectiveRegions($overrideExisting = true)
    {
        if (null !== $this->collObjectiveRegions && !$overrideExisting) {
            return;
        }
        $this->collObjectiveRegions = new PropelObjectCollection();
        $this->collObjectiveRegions->setModel('ObjectiveRegion');
    }

    /**
     * Gets an array of ObjectiveRegion objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Objective is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ObjectiveRegion[] List of ObjectiveRegion objects
     * @throws PropelException
     */
    public function getObjectiveRegions($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collObjectiveRegionsPartial && !$this->isNew();
        if (null === $this->collObjectiveRegions || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collObjectiveRegions) {
                // return empty collection
                $this->initObjectiveRegions();
            } else {
                $collObjectiveRegions = ObjectiveRegionQuery::create(null, $criteria)
                    ->filterByObjective($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collObjectiveRegionsPartial && count($collObjectiveRegions)) {
                      $this->initObjectiveRegions(false);

                      foreach($collObjectiveRegions as $obj) {
                        if (false == $this->collObjectiveRegions->contains($obj)) {
                          $this->collObjectiveRegions->append($obj);
                        }
                      }

                      $this->collObjectiveRegionsPartial = true;
                    }

                    return $collObjectiveRegions;
                }

                if($partial && $this->collObjectiveRegions) {
                    foreach($this->collObjectiveRegions as $obj) {
                        if($obj->isNew()) {
                            $collObjectiveRegions[] = $obj;
                        }
                    }
                }

                $this->collObjectiveRegions = $collObjectiveRegions;
                $this->collObjectiveRegionsPartial = false;
            }
        }

        return $this->collObjectiveRegions;
    }

    /**
     * Sets a collection of ObjectiveRegion objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $objectiveRegions A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setObjectiveRegions(PropelCollection $objectiveRegions, PropelPDO $con = null)
    {
        $this->objectiveRegionsScheduledForDeletion = $this->getObjectiveRegions(new Criteria(), $con)->diff($objectiveRegions);

        foreach ($this->objectiveRegionsScheduledForDeletion as $objectiveRegionRemoved) {
            $objectiveRegionRemoved->setObjective(null);
        }

        $this->collObjectiveRegions = null;
        foreach ($objectiveRegions as $objectiveRegion) {
            $this->addObjectiveRegion($objectiveRegion);
        }

        $this->collObjectiveRegions = $objectiveRegions;
        $this->collObjectiveRegionsPartial = false;
    }

    /**
     * Returns the number of related ObjectiveRegion objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ObjectiveRegion objects.
     * @throws PropelException
     */
    public function countObjectiveRegions(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collObjectiveRegionsPartial && !$this->isNew();
        if (null === $this->collObjectiveRegions || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collObjectiveRegions) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getObjectiveRegions());
                }
                $query = ObjectiveRegionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByObjective($this)
                    ->count($con);
            }
        } else {
            return count($this->collObjectiveRegions);
        }
    }

    /**
     * Method called to associate a ObjectiveRegion object to this object
     * through the ObjectiveRegion foreign key attribute.
     *
     * @param    ObjectiveRegion $l ObjectiveRegion
     * @return Objective The current object (for fluent API support)
     */
    public function addObjectiveRegion(ObjectiveRegion $l)
    {
        if ($this->collObjectiveRegions === null) {
            $this->initObjectiveRegions();
            $this->collObjectiveRegionsPartial = true;
        }
        if (!$this->collObjectiveRegions->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddObjectiveRegion($l);
        }

        return $this;
    }

    /**
     * @param	ObjectiveRegion $objectiveRegion The objectiveRegion object to add.
     */
    protected function doAddObjectiveRegion($objectiveRegion)
    {
        $this->collObjectiveRegions[]= $objectiveRegion;
        $objectiveRegion->setObjective($this);
    }

    /**
     * @param	ObjectiveRegion $objectiveRegion The objectiveRegion object to remove.
     */
    public function removeObjectiveRegion($objectiveRegion)
    {
        if ($this->getObjectiveRegions()->contains($objectiveRegion)) {
            $this->collObjectiveRegions->remove($this->collObjectiveRegions->search($objectiveRegion));
            if (null === $this->objectiveRegionsScheduledForDeletion) {
                $this->objectiveRegionsScheduledForDeletion = clone $this->collObjectiveRegions;
                $this->objectiveRegionsScheduledForDeletion->clear();
            }
            $this->objectiveRegionsScheduledForDeletion[]= $objectiveRegion;
            $objectiveRegion->setObjective(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Objective is new, it will return
     * an empty collection; or if this Objective has previously
     * been saved, it will retrieve related ObjectiveRegions from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Objective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveRegion[] List of ObjectiveRegion objects
     */
    public function getObjectiveRegionsJoinRegion($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveRegionQuery::create(null, $criteria);
        $query->joinWith('Region', $join_behavior);

        return $this->getObjectiveRegions($query, $con);
    }

    /**
     * Clears out the collObjectivePositions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addObjectivePositions()
     */
    public function clearObjectivePositions()
    {
        $this->collObjectivePositions = null; // important to set this to null since that means it is uninitialized
        $this->collObjectivePositionsPartial = null;
    }

    /**
     * reset is the collObjectivePositions collection loaded partially
     *
     * @return void
     */
    public function resetPartialObjectivePositions($v = true)
    {
        $this->collObjectivePositionsPartial = $v;
    }

    /**
     * Initializes the collObjectivePositions collection.
     *
     * By default this just sets the collObjectivePositions collection to an empty array (like clearcollObjectivePositions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initObjectivePositions($overrideExisting = true)
    {
        if (null !== $this->collObjectivePositions && !$overrideExisting) {
            return;
        }
        $this->collObjectivePositions = new PropelObjectCollection();
        $this->collObjectivePositions->setModel('ObjectivePosition');
    }

    /**
     * Gets an array of ObjectivePosition objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Objective is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ObjectivePosition[] List of ObjectivePosition objects
     * @throws PropelException
     */
    public function getObjectivePositions($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collObjectivePositionsPartial && !$this->isNew();
        if (null === $this->collObjectivePositions || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collObjectivePositions) {
                // return empty collection
                $this->initObjectivePositions();
            } else {
                $collObjectivePositions = ObjectivePositionQuery::create(null, $criteria)
                    ->filterByObjective($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collObjectivePositionsPartial && count($collObjectivePositions)) {
                      $this->initObjectivePositions(false);

                      foreach($collObjectivePositions as $obj) {
                        if (false == $this->collObjectivePositions->contains($obj)) {
                          $this->collObjectivePositions->append($obj);
                        }
                      }

                      $this->collObjectivePositionsPartial = true;
                    }

                    return $collObjectivePositions;
                }

                if($partial && $this->collObjectivePositions) {
                    foreach($this->collObjectivePositions as $obj) {
                        if($obj->isNew()) {
                            $collObjectivePositions[] = $obj;
                        }
                    }
                }

                $this->collObjectivePositions = $collObjectivePositions;
                $this->collObjectivePositionsPartial = false;
            }
        }

        return $this->collObjectivePositions;
    }

    /**
     * Sets a collection of ObjectivePosition objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $objectivePositions A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setObjectivePositions(PropelCollection $objectivePositions, PropelPDO $con = null)
    {
        $this->objectivePositionsScheduledForDeletion = $this->getObjectivePositions(new Criteria(), $con)->diff($objectivePositions);

        foreach ($this->objectivePositionsScheduledForDeletion as $objectivePositionRemoved) {
            $objectivePositionRemoved->setObjective(null);
        }

        $this->collObjectivePositions = null;
        foreach ($objectivePositions as $objectivePosition) {
            $this->addObjectivePosition($objectivePosition);
        }

        $this->collObjectivePositions = $objectivePositions;
        $this->collObjectivePositionsPartial = false;
    }

    /**
     * Returns the number of related ObjectivePosition objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ObjectivePosition objects.
     * @throws PropelException
     */
    public function countObjectivePositions(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collObjectivePositionsPartial && !$this->isNew();
        if (null === $this->collObjectivePositions || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collObjectivePositions) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getObjectivePositions());
                }
                $query = ObjectivePositionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByObjective($this)
                    ->count($con);
            }
        } else {
            return count($this->collObjectivePositions);
        }
    }

    /**
     * Method called to associate a ObjectivePosition object to this object
     * through the ObjectivePosition foreign key attribute.
     *
     * @param    ObjectivePosition $l ObjectivePosition
     * @return Objective The current object (for fluent API support)
     */
    public function addObjectivePosition(ObjectivePosition $l)
    {
        if ($this->collObjectivePositions === null) {
            $this->initObjectivePositions();
            $this->collObjectivePositionsPartial = true;
        }
        if (!$this->collObjectivePositions->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddObjectivePosition($l);
        }

        return $this;
    }

    /**
     * @param	ObjectivePosition $objectivePosition The objectivePosition object to add.
     */
    protected function doAddObjectivePosition($objectivePosition)
    {
        $this->collObjectivePositions[]= $objectivePosition;
        $objectivePosition->setObjective($this);
    }

    /**
     * @param	ObjectivePosition $objectivePosition The objectivePosition object to remove.
     */
    public function removeObjectivePosition($objectivePosition)
    {
        if ($this->getObjectivePositions()->contains($objectivePosition)) {
            $this->collObjectivePositions->remove($this->collObjectivePositions->search($objectivePosition));
            if (null === $this->objectivePositionsScheduledForDeletion) {
                $this->objectivePositionsScheduledForDeletion = clone $this->collObjectivePositions;
                $this->objectivePositionsScheduledForDeletion->clear();
            }
            $this->objectivePositionsScheduledForDeletion[]= $objectivePosition;
            $objectivePosition->setObjective(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Objective is new, it will return
     * an empty collection; or if this Objective has previously
     * been saved, it will retrieve related ObjectivePositions from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Objective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectivePosition[] List of ObjectivePosition objects
     */
    public function getObjectivePositionsJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectivePositionQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getObjectivePositions($query, $con);
    }

    /**
     * Clears out the collObjectiveLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addObjectiveLogs()
     */
    public function clearObjectiveLogs()
    {
        $this->collObjectiveLogs = null; // important to set this to null since that means it is uninitialized
        $this->collObjectiveLogsPartial = null;
    }

    /**
     * reset is the collObjectiveLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialObjectiveLogs($v = true)
    {
        $this->collObjectiveLogsPartial = $v;
    }

    /**
     * Initializes the collObjectiveLogs collection.
     *
     * By default this just sets the collObjectiveLogs collection to an empty array (like clearcollObjectiveLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initObjectiveLogs($overrideExisting = true)
    {
        if (null !== $this->collObjectiveLogs && !$overrideExisting) {
            return;
        }
        $this->collObjectiveLogs = new PropelObjectCollection();
        $this->collObjectiveLogs->setModel('ObjectiveLog');
    }

    /**
     * Gets an array of ObjectiveLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Objective is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     * @throws PropelException
     */
    public function getObjectiveLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collObjectiveLogsPartial && !$this->isNew();
        if (null === $this->collObjectiveLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collObjectiveLogs) {
                // return empty collection
                $this->initObjectiveLogs();
            } else {
                $collObjectiveLogs = ObjectiveLogQuery::create(null, $criteria)
                    ->filterByObjective($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collObjectiveLogsPartial && count($collObjectiveLogs)) {
                      $this->initObjectiveLogs(false);

                      foreach($collObjectiveLogs as $obj) {
                        if (false == $this->collObjectiveLogs->contains($obj)) {
                          $this->collObjectiveLogs->append($obj);
                        }
                      }

                      $this->collObjectiveLogsPartial = true;
                    }

                    return $collObjectiveLogs;
                }

                if($partial && $this->collObjectiveLogs) {
                    foreach($this->collObjectiveLogs as $obj) {
                        if($obj->isNew()) {
                            $collObjectiveLogs[] = $obj;
                        }
                    }
                }

                $this->collObjectiveLogs = $collObjectiveLogs;
                $this->collObjectiveLogsPartial = false;
            }
        }

        return $this->collObjectiveLogs;
    }

    /**
     * Sets a collection of ObjectiveLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $objectiveLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setObjectiveLogs(PropelCollection $objectiveLogs, PropelPDO $con = null)
    {
        $this->objectiveLogsScheduledForDeletion = $this->getObjectiveLogs(new Criteria(), $con)->diff($objectiveLogs);

        foreach ($this->objectiveLogsScheduledForDeletion as $objectiveLogRemoved) {
            $objectiveLogRemoved->setObjective(null);
        }

        $this->collObjectiveLogs = null;
        foreach ($objectiveLogs as $objectiveLog) {
            $this->addObjectiveLog($objectiveLog);
        }

        $this->collObjectiveLogs = $objectiveLogs;
        $this->collObjectiveLogsPartial = false;
    }

    /**
     * Returns the number of related ObjectiveLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ObjectiveLog objects.
     * @throws PropelException
     */
    public function countObjectiveLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collObjectiveLogsPartial && !$this->isNew();
        if (null === $this->collObjectiveLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collObjectiveLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getObjectiveLogs());
                }
                $query = ObjectiveLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByObjective($this)
                    ->count($con);
            }
        } else {
            return count($this->collObjectiveLogs);
        }
    }

    /**
     * Method called to associate a ObjectiveLog object to this object
     * through the ObjectiveLog foreign key attribute.
     *
     * @param    ObjectiveLog $l ObjectiveLog
     * @return Objective The current object (for fluent API support)
     */
    public function addObjectiveLog(ObjectiveLog $l)
    {
        if ($this->collObjectiveLogs === null) {
            $this->initObjectiveLogs();
            $this->collObjectiveLogsPartial = true;
        }
        if (!$this->collObjectiveLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddObjectiveLog($l);
        }

        return $this;
    }

    /**
     * @param	ObjectiveLog $objectiveLog The objectiveLog object to add.
     */
    protected function doAddObjectiveLog($objectiveLog)
    {
        $this->collObjectiveLogs[]= $objectiveLog;
        $objectiveLog->setObjective($this);
    }

    /**
     * @param	ObjectiveLog $objectiveLog The objectiveLog object to remove.
     */
    public function removeObjectiveLog($objectiveLog)
    {
        if ($this->getObjectiveLogs()->contains($objectiveLog)) {
            $this->collObjectiveLogs->remove($this->collObjectiveLogs->search($objectiveLog));
            if (null === $this->objectiveLogsScheduledForDeletion) {
                $this->objectiveLogsScheduledForDeletion = clone $this->collObjectiveLogs;
                $this->objectiveLogsScheduledForDeletion->clear();
            }
            $this->objectiveLogsScheduledForDeletion[]= $objectiveLog;
            $objectiveLog->setObjective(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Objective is new, it will return
     * an empty collection; or if this Objective has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Objective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinStrategicObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('StrategicObjective', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Objective is new, it will return
     * an empty collection; or if this Objective has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Objective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinPolicyGuideline($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('PolicyGuideline', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Objective is new, it will return
     * an empty collection; or if this Objective has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Objective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Objective is new, it will return
     * an empty collection; or if this Objective has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Objective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }

    /**
     * Clears out the collProjects collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjects()
     */
    public function clearProjects()
    {
        $this->collProjects = null; // important to set this to null since that means it is uninitialized
        $this->collProjectsPartial = null;
    }

    /**
     * reset is the collProjects collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjects($v = true)
    {
        $this->collProjectsPartial = $v;
    }

    /**
     * Initializes the collProjects collection.
     *
     * By default this just sets the collProjects collection to an empty array (like clearcollProjects());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjects($overrideExisting = true)
    {
        if (null !== $this->collProjects && !$overrideExisting) {
            return;
        }
        $this->collProjects = new PropelObjectCollection();
        $this->collProjects->setModel('Project');
    }

    /**
     * Gets an array of Project objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Objective is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Project[] List of Project objects
     * @throws PropelException
     */
    public function getProjects($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectsPartial && !$this->isNew();
        if (null === $this->collProjects || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjects) {
                // return empty collection
                $this->initProjects();
            } else {
                $collProjects = ProjectQuery::create(null, $criteria)
                    ->filterByObjective($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectsPartial && count($collProjects)) {
                      $this->initProjects(false);

                      foreach($collProjects as $obj) {
                        if (false == $this->collProjects->contains($obj)) {
                          $this->collProjects->append($obj);
                        }
                      }

                      $this->collProjectsPartial = true;
                    }

                    return $collProjects;
                }

                if($partial && $this->collProjects) {
                    foreach($this->collProjects as $obj) {
                        if($obj->isNew()) {
                            $collProjects[] = $obj;
                        }
                    }
                }

                $this->collProjects = $collProjects;
                $this->collProjectsPartial = false;
            }
        }

        return $this->collProjects;
    }

    /**
     * Sets a collection of Project objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projects A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjects(PropelCollection $projects, PropelPDO $con = null)
    {
        $this->projectsScheduledForDeletion = $this->getProjects(new Criteria(), $con)->diff($projects);

        foreach ($this->projectsScheduledForDeletion as $projectRemoved) {
            $projectRemoved->setObjective(null);
        }

        $this->collProjects = null;
        foreach ($projects as $project) {
            $this->addProject($project);
        }

        $this->collProjects = $projects;
        $this->collProjectsPartial = false;
    }

    /**
     * Returns the number of related Project objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Project objects.
     * @throws PropelException
     */
    public function countProjects(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectsPartial && !$this->isNew();
        if (null === $this->collProjects || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjects) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjects());
                }
                $query = ProjectQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByObjective($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjects);
        }
    }

    /**
     * Method called to associate a Project object to this object
     * through the Project foreign key attribute.
     *
     * @param    Project $l Project
     * @return Objective The current object (for fluent API support)
     */
    public function addProject(Project $l)
    {
        if ($this->collProjects === null) {
            $this->initProjects();
            $this->collProjectsPartial = true;
        }
        if (!$this->collProjects->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProject($l);
        }

        return $this;
    }

    /**
     * @param	Project $project The project object to add.
     */
    protected function doAddProject($project)
    {
        $this->collProjects[]= $project;
        $project->setObjective($this);
    }

    /**
     * @param	Project $project The project object to remove.
     */
    public function removeProject($project)
    {
        if ($this->getProjects()->contains($project)) {
            $this->collProjects->remove($this->collProjects->search($project));
            if (null === $this->projectsScheduledForDeletion) {
                $this->projectsScheduledForDeletion = clone $this->collProjects;
                $this->projectsScheduledForDeletion->clear();
            }
            $this->projectsScheduledForDeletion[]= $project;
            $project->setObjective(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Objective is new, it will return
     * an empty collection; or if this Objective has previously
     * been saved, it will retrieve related Projects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Objective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Project[] List of Project objects
     */
    public function getProjectsJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getProjects($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Objective is new, it will return
     * an empty collection; or if this Objective has previously
     * been saved, it will retrieve related Projects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Objective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Project[] List of Project objects
     */
    public function getProjectsJoinIndicator($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectQuery::create(null, $criteria);
        $query->joinWith('Indicator', $join_behavior);

        return $this->getProjects($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Objective is new, it will return
     * an empty collection; or if this Objective has previously
     * been saved, it will retrieve related Projects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Objective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Project[] List of Project objects
     */
    public function getProjectsJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getProjects($query, $con);
    }

    /**
     * Clears out the collProjectLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectLogs()
     */
    public function clearProjectLogs()
    {
        $this->collProjectLogs = null; // important to set this to null since that means it is uninitialized
        $this->collProjectLogsPartial = null;
    }

    /**
     * reset is the collProjectLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectLogs($v = true)
    {
        $this->collProjectLogsPartial = $v;
    }

    /**
     * Initializes the collProjectLogs collection.
     *
     * By default this just sets the collProjectLogs collection to an empty array (like clearcollProjectLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectLogs($overrideExisting = true)
    {
        if (null !== $this->collProjectLogs && !$overrideExisting) {
            return;
        }
        $this->collProjectLogs = new PropelObjectCollection();
        $this->collProjectLogs->setModel('ProjectLog');
    }

    /**
     * Gets an array of ProjectLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Objective is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectLog[] List of ProjectLog objects
     * @throws PropelException
     */
    public function getProjectLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectLogsPartial && !$this->isNew();
        if (null === $this->collProjectLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectLogs) {
                // return empty collection
                $this->initProjectLogs();
            } else {
                $collProjectLogs = ProjectLogQuery::create(null, $criteria)
                    ->filterByObjective($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectLogsPartial && count($collProjectLogs)) {
                      $this->initProjectLogs(false);

                      foreach($collProjectLogs as $obj) {
                        if (false == $this->collProjectLogs->contains($obj)) {
                          $this->collProjectLogs->append($obj);
                        }
                      }

                      $this->collProjectLogsPartial = true;
                    }

                    return $collProjectLogs;
                }

                if($partial && $this->collProjectLogs) {
                    foreach($this->collProjectLogs as $obj) {
                        if($obj->isNew()) {
                            $collProjectLogs[] = $obj;
                        }
                    }
                }

                $this->collProjectLogs = $collProjectLogs;
                $this->collProjectLogsPartial = false;
            }
        }

        return $this->collProjectLogs;
    }

    /**
     * Sets a collection of ProjectLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectLogs(PropelCollection $projectLogs, PropelPDO $con = null)
    {
        $this->projectLogsScheduledForDeletion = $this->getProjectLogs(new Criteria(), $con)->diff($projectLogs);

        foreach ($this->projectLogsScheduledForDeletion as $projectLogRemoved) {
            $projectLogRemoved->setObjective(null);
        }

        $this->collProjectLogs = null;
        foreach ($projectLogs as $projectLog) {
            $this->addProjectLog($projectLog);
        }

        $this->collProjectLogs = $projectLogs;
        $this->collProjectLogsPartial = false;
    }

    /**
     * Returns the number of related ProjectLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectLog objects.
     * @throws PropelException
     */
    public function countProjectLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectLogsPartial && !$this->isNew();
        if (null === $this->collProjectLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectLogs());
                }
                $query = ProjectLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByObjective($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectLogs);
        }
    }

    /**
     * Method called to associate a ProjectLog object to this object
     * through the ProjectLog foreign key attribute.
     *
     * @param    ProjectLog $l ProjectLog
     * @return Objective The current object (for fluent API support)
     */
    public function addProjectLog(ProjectLog $l)
    {
        if ($this->collProjectLogs === null) {
            $this->initProjectLogs();
            $this->collProjectLogsPartial = true;
        }
        if (!$this->collProjectLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectLog($l);
        }

        return $this;
    }

    /**
     * @param	ProjectLog $projectLog The projectLog object to add.
     */
    protected function doAddProjectLog($projectLog)
    {
        $this->collProjectLogs[]= $projectLog;
        $projectLog->setObjective($this);
    }

    /**
     * @param	ProjectLog $projectLog The projectLog object to remove.
     */
    public function removeProjectLog($projectLog)
    {
        if ($this->getProjectLogs()->contains($projectLog)) {
            $this->collProjectLogs->remove($this->collProjectLogs->search($projectLog));
            if (null === $this->projectLogsScheduledForDeletion) {
                $this->projectLogsScheduledForDeletion = clone $this->collProjectLogs;
                $this->projectLogsScheduledForDeletion->clear();
            }
            $this->projectLogsScheduledForDeletion[]= $projectLog;
            $projectLog->setObjective(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Objective is new, it will return
     * an empty collection; or if this Objective has previously
     * been saved, it will retrieve related ProjectLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Objective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectLog[] List of ProjectLog objects
     */
    public function getProjectLogsJoinProject($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectLogQuery::create(null, $criteria);
        $query->joinWith('Project', $join_behavior);

        return $this->getProjectLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Objective is new, it will return
     * an empty collection; or if this Objective has previously
     * been saved, it will retrieve related ProjectLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Objective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectLog[] List of ProjectLog objects
     */
    public function getProjectLogsJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectLogQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getProjectLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Objective is new, it will return
     * an empty collection; or if this Objective has previously
     * been saved, it will retrieve related ProjectLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Objective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectLog[] List of ProjectLog objects
     */
    public function getProjectLogsJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectLogQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getProjectLogs($query, $con);
    }

    /**
     * Clears out the collRegions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addRegions()
     */
    public function clearRegions()
    {
        $this->collRegions = null; // important to set this to null since that means it is uninitialized
        $this->collRegionsPartial = null;
    }

    /**
     * Initializes the collRegions collection.
     *
     * By default this just sets the collRegions collection to an empty collection (like clearRegions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initRegions()
    {
        $this->collRegions = new PropelObjectCollection();
        $this->collRegions->setModel('Region');
    }

    /**
     * Gets a collection of Region objects related by a many-to-many relationship
     * to the current object by way of the objectives_region cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Objective is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Region[] List of Region objects
     */
    public function getRegions($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collRegions || null !== $criteria) {
            if ($this->isNew() && null === $this->collRegions) {
                // return empty collection
                $this->initRegions();
            } else {
                $collRegions = RegionQuery::create(null, $criteria)
                    ->filterByObjective($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collRegions;
                }
                $this->collRegions = $collRegions;
            }
        }

        return $this->collRegions;
    }

    /**
     * Sets a collection of Region objects related by a many-to-many relationship
     * to the current object by way of the objectives_region cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $regions A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setRegions(PropelCollection $regions, PropelPDO $con = null)
    {
        $this->clearRegions();
        $currentRegions = $this->getRegions();

        $this->regionsScheduledForDeletion = $currentRegions->diff($regions);

        foreach ($regions as $region) {
            if (!$currentRegions->contains($region)) {
                $this->doAddRegion($region);
            }
        }

        $this->collRegions = $regions;
    }

    /**
     * Gets the number of Region objects related by a many-to-many relationship
     * to the current object by way of the objectives_region cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Region objects
     */
    public function countRegions($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collRegions || null !== $criteria) {
            if ($this->isNew() && null === $this->collRegions) {
                return 0;
            } else {
                $query = RegionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByObjective($this)
                    ->count($con);
            }
        } else {
            return count($this->collRegions);
        }
    }

    /**
     * Associate a Region object to this object
     * through the objectives_region cross reference table.
     *
     * @param  Region $region The ObjectiveRegion object to relate
     * @return void
     */
    public function addRegion(Region $region)
    {
        if ($this->collRegions === null) {
            $this->initRegions();
        }
        if (!$this->collRegions->contains($region)) { // only add it if the **same** object is not already associated
            $this->doAddRegion($region);

            $this->collRegions[]= $region;
        }
    }

    /**
     * @param	Region $region The region object to add.
     */
    protected function doAddRegion($region)
    {
        $objectiveRegion = new ObjectiveRegion();
        $objectiveRegion->setRegion($region);
        $this->addObjectiveRegion($objectiveRegion);
    }

    /**
     * Remove a Region object to this object
     * through the objectives_region cross reference table.
     *
     * @param Region $region The ObjectiveRegion object to relate
     * @return void
     */
    public function removeRegion(Region $region)
    {
        if ($this->getRegions()->contains($region)) {
            $this->collRegions->remove($this->collRegions->search($region));
            if (null === $this->regionsScheduledForDeletion) {
                $this->regionsScheduledForDeletion = clone $this->collRegions;
                $this->regionsScheduledForDeletion->clear();
            }
            $this->regionsScheduledForDeletion[]= $region;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->policyguidelineid = null;
        $this->strategicobjectiveid = null;
        $this->affiliateid = null;
        $this->description = null;
        $this->date = null;
        $this->expirationdate = null;
        $this->achieved = null;
        $this->notes = null;
        $this->responsiblecode = null;
        $this->userid = null;
        $this->userbyaffiliatesid = null;
        $this->updated = null;
        $this->changes = null;
        $this->oldid = null;
        $this->startingyear = null;
        $this->endingyear = null;
        $this->deleted_at = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collIndicators) {
                foreach ($this->collIndicators as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collObjectiveRegions) {
                foreach ($this->collObjectiveRegions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collObjectivePositions) {
                foreach ($this->collObjectivePositions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collObjectiveLogs) {
                foreach ($this->collObjectiveLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjects) {
                foreach ($this->collProjects as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectLogs) {
                foreach ($this->collProjectLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collRegions) {
                foreach ($this->collRegions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collIndicators instanceof PropelCollection) {
            $this->collIndicators->clearIterator();
        }
        $this->collIndicators = null;
        if ($this->collObjectiveRegions instanceof PropelCollection) {
            $this->collObjectiveRegions->clearIterator();
        }
        $this->collObjectiveRegions = null;
        if ($this->collObjectivePositions instanceof PropelCollection) {
            $this->collObjectivePositions->clearIterator();
        }
        $this->collObjectivePositions = null;
        if ($this->collObjectiveLogs instanceof PropelCollection) {
            $this->collObjectiveLogs->clearIterator();
        }
        $this->collObjectiveLogs = null;
        if ($this->collProjects instanceof PropelCollection) {
            $this->collProjects->clearIterator();
        }
        $this->collProjects = null;
        if ($this->collProjectLogs instanceof PropelCollection) {
            $this->collProjectLogs->clearIterator();
        }
        $this->collProjectLogs = null;
        if ($this->collRegions instanceof PropelCollection) {
            $this->collRegions->clearIterator();
        }
        $this->collRegions = null;
        $this->aStrategicObjective = null;
        $this->aPolicyGuideline = null;
        $this->aUser = null;
        $this->aPosition = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // soft_delete behavior

    /**
     * Bypass the soft_delete behavior and force a hard delete of the current object
     */
    public function forceDelete(PropelPDO $con = null)
    {
        if ($isSoftDeleteEnabled = ObjectivePeer::isSoftDeleteEnabled()) {
            ObjectivePeer::disableSoftDelete();
        }
        $this->delete($con);
        if ($isSoftDeleteEnabled) {
            ObjectivePeer::enableSoftDelete();
        }
    }

    /**
     * Undelete a row that was soft_deleted
     *
     * @return		 int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        $this->setDeletedAt(null);

        return $this->save($con);
    }

}
