<?php


/**
 * Base class that represents a query for the 'issues_issueLog' table.
 *
 *
 *
 * @method IssueVersionQuery orderById($order = Criteria::ASC) Order by the id column
 * @method IssueVersionQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method IssueVersionQuery orderByParentid($order = Criteria::ASC) Order by the parentId column
 * @method IssueVersionQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method IssueVersionQuery orderByImpact($order = Criteria::ASC) Order by the impact column
 * @method IssueVersionQuery orderByValoration($order = Criteria::ASC) Order by the valoration column
 * @method IssueVersionQuery orderByEvolution($order = Criteria::ASC) Order by the evolution column
 * @method IssueVersionQuery orderByObjecttype($order = Criteria::ASC) Order by the objectType column
 * @method IssueVersionQuery orderByObjectid($order = Criteria::ASC) Order by the objectId column
 * @method IssueVersionQuery orderByCreatedAt($order = Criteria::ASC) Order by the created_at column
 * @method IssueVersionQuery orderByUpdatedAt($order = Criteria::ASC) Order by the updated_at column
 * @method IssueVersionQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 * @method IssueVersionQuery orderByVersion($order = Criteria::ASC) Order by the version column
 * @method IssueVersionQuery orderByVersionCreatedBy($order = Criteria::ASC) Order by the version_created_by column
 *
 * @method IssueVersionQuery groupById() Group by the id column
 * @method IssueVersionQuery groupByName() Group by the name column
 * @method IssueVersionQuery groupByParentid() Group by the parentId column
 * @method IssueVersionQuery groupByDescription() Group by the description column
 * @method IssueVersionQuery groupByImpact() Group by the impact column
 * @method IssueVersionQuery groupByValoration() Group by the valoration column
 * @method IssueVersionQuery groupByEvolution() Group by the evolution column
 * @method IssueVersionQuery groupByObjecttype() Group by the objectType column
 * @method IssueVersionQuery groupByObjectid() Group by the objectId column
 * @method IssueVersionQuery groupByCreatedAt() Group by the created_at column
 * @method IssueVersionQuery groupByUpdatedAt() Group by the updated_at column
 * @method IssueVersionQuery groupByDeletedAt() Group by the deleted_at column
 * @method IssueVersionQuery groupByVersion() Group by the version column
 * @method IssueVersionQuery groupByVersionCreatedBy() Group by the version_created_by column
 *
 * @method IssueVersionQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method IssueVersionQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method IssueVersionQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method IssueVersionQuery leftJoinIssue($relationAlias = null) Adds a LEFT JOIN clause to the query using the Issue relation
 * @method IssueVersionQuery rightJoinIssue($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Issue relation
 * @method IssueVersionQuery innerJoinIssue($relationAlias = null) Adds a INNER JOIN clause to the query using the Issue relation
 *
 * @method IssueVersion findOne(PropelPDO $con = null) Return the first IssueVersion matching the query
 * @method IssueVersion findOneOrCreate(PropelPDO $con = null) Return the first IssueVersion matching the query, or a new IssueVersion object populated from the query conditions when no match is found
 *
 * @method IssueVersion findOneById(int $id) Return the first IssueVersion filtered by the id column
 * @method IssueVersion findOneByName(string $name) Return the first IssueVersion filtered by the name column
 * @method IssueVersion findOneByParentid(int $parentId) Return the first IssueVersion filtered by the parentId column
 * @method IssueVersion findOneByDescription(string $description) Return the first IssueVersion filtered by the description column
 * @method IssueVersion findOneByImpact(int $impact) Return the first IssueVersion filtered by the impact column
 * @method IssueVersion findOneByValoration(int $valoration) Return the first IssueVersion filtered by the valoration column
 * @method IssueVersion findOneByEvolution(int $evolution) Return the first IssueVersion filtered by the evolution column
 * @method IssueVersion findOneByObjecttype(string $objectType) Return the first IssueVersion filtered by the objectType column
 * @method IssueVersion findOneByObjectid(int $objectId) Return the first IssueVersion filtered by the objectId column
 * @method IssueVersion findOneByCreatedAt(string $created_at) Return the first IssueVersion filtered by the created_at column
 * @method IssueVersion findOneByUpdatedAt(string $updated_at) Return the first IssueVersion filtered by the updated_at column
 * @method IssueVersion findOneByDeletedAt(string $deleted_at) Return the first IssueVersion filtered by the deleted_at column
 * @method IssueVersion findOneByVersion(int $version) Return the first IssueVersion filtered by the version column
 * @method IssueVersion findOneByVersionCreatedBy(string $version_created_by) Return the first IssueVersion filtered by the version_created_by column
 *
 * @method array findById(int $id) Return IssueVersion objects filtered by the id column
 * @method array findByName(string $name) Return IssueVersion objects filtered by the name column
 * @method array findByParentid(int $parentId) Return IssueVersion objects filtered by the parentId column
 * @method array findByDescription(string $description) Return IssueVersion objects filtered by the description column
 * @method array findByImpact(int $impact) Return IssueVersion objects filtered by the impact column
 * @method array findByValoration(int $valoration) Return IssueVersion objects filtered by the valoration column
 * @method array findByEvolution(int $evolution) Return IssueVersion objects filtered by the evolution column
 * @method array findByObjecttype(string $objectType) Return IssueVersion objects filtered by the objectType column
 * @method array findByObjectid(int $objectId) Return IssueVersion objects filtered by the objectId column
 * @method array findByCreatedAt(string $created_at) Return IssueVersion objects filtered by the created_at column
 * @method array findByUpdatedAt(string $updated_at) Return IssueVersion objects filtered by the updated_at column
 * @method array findByDeletedAt(string $deleted_at) Return IssueVersion objects filtered by the deleted_at column
 * @method array findByVersion(int $version) Return IssueVersion objects filtered by the version column
 * @method array findByVersionCreatedBy(string $version_created_by) Return IssueVersion objects filtered by the version_created_by column
 *
 * @package    propel.generator.issues.classes.om
 */
abstract class BaseIssueVersionQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseIssueVersionQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'IssueVersion', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new IssueVersionQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     IssueVersionQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return IssueVersionQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof IssueVersionQuery) {
            return $criteria;
        }
        $query = new IssueVersionQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$id, $version]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   IssueVersion|IssueVersion[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = IssueVersionPeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(IssueVersionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   IssueVersion A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `NAME`, `PARENTID`, `DESCRIPTION`, `IMPACT`, `VALORATION`, `EVOLUTION`, `OBJECTTYPE`, `OBJECTID`, `CREATED_AT`, `UPDATED_AT`, `DELETED_AT`, `VERSION`, `VERSION_CREATED_BY` FROM `issues_issueLog` WHERE `ID` = :p0 AND `VERSION` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new IssueVersion();
            $obj->hydrate($row);
            IssueVersionPeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return IssueVersion|IssueVersion[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|IssueVersion[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return IssueVersionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(IssueVersionPeer::ID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(IssueVersionPeer::VERSION, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return IssueVersionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(IssueVersionPeer::ID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(IssueVersionPeer::VERSION, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @see       filterByIssue()
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueVersionQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(IssueVersionPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueVersionQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(IssueVersionPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the parentId column
     *
     * Example usage:
     * <code>
     * $query->filterByParentid(1234); // WHERE parentId = 1234
     * $query->filterByParentid(array(12, 34)); // WHERE parentId IN (12, 34)
     * $query->filterByParentid(array('min' => 12)); // WHERE parentId > 12
     * </code>
     *
     * @param     mixed $parentid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueVersionQuery The current query, for fluid interface
     */
    public function filterByParentid($parentid = null, $comparison = null)
    {
        if (is_array($parentid)) {
            $useMinMax = false;
            if (isset($parentid['min'])) {
                $this->addUsingAlias(IssueVersionPeer::PARENTID, $parentid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($parentid['max'])) {
                $this->addUsingAlias(IssueVersionPeer::PARENTID, $parentid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssueVersionPeer::PARENTID, $parentid, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueVersionQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(IssueVersionPeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the impact column
     *
     * Example usage:
     * <code>
     * $query->filterByImpact(1234); // WHERE impact = 1234
     * $query->filterByImpact(array(12, 34)); // WHERE impact IN (12, 34)
     * $query->filterByImpact(array('min' => 12)); // WHERE impact > 12
     * </code>
     *
     * @param     mixed $impact The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueVersionQuery The current query, for fluid interface
     */
    public function filterByImpact($impact = null, $comparison = null)
    {
        if (is_array($impact)) {
            $useMinMax = false;
            if (isset($impact['min'])) {
                $this->addUsingAlias(IssueVersionPeer::IMPACT, $impact['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($impact['max'])) {
                $this->addUsingAlias(IssueVersionPeer::IMPACT, $impact['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssueVersionPeer::IMPACT, $impact, $comparison);
    }

    /**
     * Filter the query on the valoration column
     *
     * Example usage:
     * <code>
     * $query->filterByValoration(1234); // WHERE valoration = 1234
     * $query->filterByValoration(array(12, 34)); // WHERE valoration IN (12, 34)
     * $query->filterByValoration(array('min' => 12)); // WHERE valoration > 12
     * </code>
     *
     * @param     mixed $valoration The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueVersionQuery The current query, for fluid interface
     */
    public function filterByValoration($valoration = null, $comparison = null)
    {
        if (is_array($valoration)) {
            $useMinMax = false;
            if (isset($valoration['min'])) {
                $this->addUsingAlias(IssueVersionPeer::VALORATION, $valoration['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($valoration['max'])) {
                $this->addUsingAlias(IssueVersionPeer::VALORATION, $valoration['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssueVersionPeer::VALORATION, $valoration, $comparison);
    }

    /**
     * Filter the query on the evolution column
     *
     * Example usage:
     * <code>
     * $query->filterByEvolution(1234); // WHERE evolution = 1234
     * $query->filterByEvolution(array(12, 34)); // WHERE evolution IN (12, 34)
     * $query->filterByEvolution(array('min' => 12)); // WHERE evolution > 12
     * </code>
     *
     * @param     mixed $evolution The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueVersionQuery The current query, for fluid interface
     */
    public function filterByEvolution($evolution = null, $comparison = null)
    {
        if (is_array($evolution)) {
            $useMinMax = false;
            if (isset($evolution['min'])) {
                $this->addUsingAlias(IssueVersionPeer::EVOLUTION, $evolution['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($evolution['max'])) {
                $this->addUsingAlias(IssueVersionPeer::EVOLUTION, $evolution['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssueVersionPeer::EVOLUTION, $evolution, $comparison);
    }

    /**
     * Filter the query on the objectType column
     *
     * Example usage:
     * <code>
     * $query->filterByObjecttype('fooValue');   // WHERE objectType = 'fooValue'
     * $query->filterByObjecttype('%fooValue%'); // WHERE objectType LIKE '%fooValue%'
     * </code>
     *
     * @param     string $objecttype The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueVersionQuery The current query, for fluid interface
     */
    public function filterByObjecttype($objecttype = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($objecttype)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $objecttype)) {
                $objecttype = str_replace('*', '%', $objecttype);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(IssueVersionPeer::OBJECTTYPE, $objecttype, $comparison);
    }

    /**
     * Filter the query on the objectId column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectid(1234); // WHERE objectId = 1234
     * $query->filterByObjectid(array(12, 34)); // WHERE objectId IN (12, 34)
     * $query->filterByObjectid(array('min' => 12)); // WHERE objectId > 12
     * </code>
     *
     * @param     mixed $objectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueVersionQuery The current query, for fluid interface
     */
    public function filterByObjectid($objectid = null, $comparison = null)
    {
        if (is_array($objectid)) {
            $useMinMax = false;
            if (isset($objectid['min'])) {
                $this->addUsingAlias(IssueVersionPeer::OBJECTID, $objectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($objectid['max'])) {
                $this->addUsingAlias(IssueVersionPeer::OBJECTID, $objectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssueVersionPeer::OBJECTID, $objectid, $comparison);
    }

    /**
     * Filter the query on the created_at column
     *
     * Example usage:
     * <code>
     * $query->filterByCreatedAt('2011-03-14'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt('now'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt(array('max' => 'yesterday')); // WHERE created_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $createdAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueVersionQuery The current query, for fluid interface
     */
    public function filterByCreatedAt($createdAt = null, $comparison = null)
    {
        if (is_array($createdAt)) {
            $useMinMax = false;
            if (isset($createdAt['min'])) {
                $this->addUsingAlias(IssueVersionPeer::CREATED_AT, $createdAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($createdAt['max'])) {
                $this->addUsingAlias(IssueVersionPeer::CREATED_AT, $createdAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssueVersionPeer::CREATED_AT, $createdAt, $comparison);
    }

    /**
     * Filter the query on the updated_at column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdatedAt('2011-03-14'); // WHERE updated_at = '2011-03-14'
     * $query->filterByUpdatedAt('now'); // WHERE updated_at = '2011-03-14'
     * $query->filterByUpdatedAt(array('max' => 'yesterday')); // WHERE updated_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $updatedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueVersionQuery The current query, for fluid interface
     */
    public function filterByUpdatedAt($updatedAt = null, $comparison = null)
    {
        if (is_array($updatedAt)) {
            $useMinMax = false;
            if (isset($updatedAt['min'])) {
                $this->addUsingAlias(IssueVersionPeer::UPDATED_AT, $updatedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updatedAt['max'])) {
                $this->addUsingAlias(IssueVersionPeer::UPDATED_AT, $updatedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssueVersionPeer::UPDATED_AT, $updatedAt, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueVersionQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(IssueVersionPeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(IssueVersionPeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssueVersionPeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query on the version column
     *
     * Example usage:
     * <code>
     * $query->filterByVersion(1234); // WHERE version = 1234
     * $query->filterByVersion(array(12, 34)); // WHERE version IN (12, 34)
     * $query->filterByVersion(array('min' => 12)); // WHERE version > 12
     * </code>
     *
     * @param     mixed $version The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueVersionQuery The current query, for fluid interface
     */
    public function filterByVersion($version = null, $comparison = null)
    {
        if (is_array($version) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(IssueVersionPeer::VERSION, $version, $comparison);
    }

    /**
     * Filter the query on the version_created_by column
     *
     * Example usage:
     * <code>
     * $query->filterByVersionCreatedBy('fooValue');   // WHERE version_created_by = 'fooValue'
     * $query->filterByVersionCreatedBy('%fooValue%'); // WHERE version_created_by LIKE '%fooValue%'
     * </code>
     *
     * @param     string $versionCreatedBy The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueVersionQuery The current query, for fluid interface
     */
    public function filterByVersionCreatedBy($versionCreatedBy = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($versionCreatedBy)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $versionCreatedBy)) {
                $versionCreatedBy = str_replace('*', '%', $versionCreatedBy);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(IssueVersionPeer::VERSION_CREATED_BY, $versionCreatedBy, $comparison);
    }

    /**
     * Filter the query by a related Issue object
     *
     * @param   Issue|PropelObjectCollection $issue The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IssueVersionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIssue($issue, $comparison = null)
    {
        if ($issue instanceof Issue) {
            return $this
                ->addUsingAlias(IssueVersionPeer::ID, $issue->getId(), $comparison);
        } elseif ($issue instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(IssueVersionPeer::ID, $issue->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByIssue() only accepts arguments of type Issue or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Issue relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IssueVersionQuery The current query, for fluid interface
     */
    public function joinIssue($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Issue');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Issue');
        }

        return $this;
    }

    /**
     * Use the Issue relation Issue object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IssueQuery A secondary query class using the current class as primary query
     */
    public function useIssueQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinIssue($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Issue', 'IssueQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   IssueVersion $issueVersion Object to remove from the list of results
     *
     * @return IssueVersionQuery The current query, for fluid interface
     */
    public function prune($issueVersion = null)
    {
        if ($issueVersion) {
            $this->addCond('pruneCond0', $this->getAliasedColName(IssueVersionPeer::ID), $issueVersion->getId(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(IssueVersionPeer::VERSION), $issueVersion->getVersion(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

}
