<?php


/**
 * Base static class for performing query and update operations on the 'indicators_indicator' table.
 *
 * Indicators
 *
 * @package propel.generator.indicators.classes.om
 */
abstract class BaseIndicatorPeer
{

    /** the default database name for this class */
    const DATABASE_NAME = 'application';

    /** the table name for this class */
    const TABLE_NAME = 'indicators_indicator';

    /** the related Propel class for this table */
    const OM_CLASS = 'Indicator';

    /** the related TableMap class for this table */
    const TM_CLASS = 'IndicatorTableMap';

    /** The total number of columns. */
    const NUM_COLUMNS = 14;

    /** The number of lazy-loaded columns. */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /** The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS) */
    const NUM_HYDRATE_COLUMNS = 14;

    /** the column name for the ID field */
    const ID = 'indicators_indicator.ID';

    /** the column name for the NAME field */
    const NAME = 'indicators_indicator.NAME';

    /** the column name for the DESCRIPTION field */
    const DESCRIPTION = 'indicators_indicator.DESCRIPTION';

    /** the column name for the ARCHIVED field */
    const ARCHIVED = 'indicators_indicator.ARCHIVED';

    /** the column name for the METHODOLOGY field */
    const METHODOLOGY = 'indicators_indicator.METHODOLOGY';

    /** the column name for the DECIMALS field */
    const DECIMALS = 'indicators_indicator.DECIMALS';

    /** the column name for the GOAL field */
    const GOAL = 'indicators_indicator.GOAL';

    /** the column name for the GOALDATE field */
    const GOALDATE = 'indicators_indicator.GOALDATE';

    /** the column name for the IDEALBEHAVIOR field */
    const IDEALBEHAVIOR = 'indicators_indicator.IDEALBEHAVIOR';

    /** the column name for the POSITIONID field */
    const POSITIONID = 'indicators_indicator.POSITIONID';

    /** the column name for the OBJECTIVEID field */
    const OBJECTIVEID = 'indicators_indicator.OBJECTIVEID';

    /** the column name for the DUEDATE field */
    const DUEDATE = 'indicators_indicator.DUEDATE';

    /** the column name for the FINISHEDDATE field */
    const FINISHEDDATE = 'indicators_indicator.FINISHEDDATE';

    /** the column name for the CLASSKEY field */
    const CLASSKEY = 'indicators_indicator.CLASSKEY';

    /** A key representing a particular subclass */
    const CLASSKEY_1 = '1';

    /** A key representing a particular subclass */
    const CLASSKEY_INDICATOR = '1';

    /** A class that can be returned by this peer. */
    const CLASSNAME_1 = 'Indicator';

    /** A key representing a particular subclass */
    const CLASSKEY_2 = '2';

    /** A key representing a particular subclass */
    const CLASSKEY_NUMERICINDICATOR = '2';

    /** A class that can be returned by this peer. */
    const CLASSNAME_2 = 'NumericIndicator';

    /** A key representing a particular subclass */
    const CLASSKEY_3 = '3';

    /** A key representing a particular subclass */
    const CLASSKEY_BOOLEANINDICATOR = '3';

    /** A class that can be returned by this peer. */
    const CLASSNAME_3 = 'BooleanIndicator';

    /** The default string format for model objects of the related table **/
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * An identiy map to hold any loaded instances of Indicator objects.
     * This must be public so that other peer classes can access this when hydrating from JOIN
     * queries.
     * @var        array Indicator[]
     */
    public static $instances = array();


    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. IndicatorPeer::$fieldNames[IndicatorPeer::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        BasePeer::TYPE_PHPNAME => array ('Id', 'Name', 'Description', 'Archived', 'Methodology', 'Decimals', 'Goal', 'Goaldate', 'Idealbehavior', 'Positionid', 'Objectiveid', 'Duedate', 'Finisheddate', 'Classkey', ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id', 'name', 'description', 'archived', 'methodology', 'decimals', 'goal', 'goaldate', 'idealbehavior', 'positionid', 'objectiveid', 'duedate', 'finisheddate', 'classkey', ),
        BasePeer::TYPE_COLNAME => array (IndicatorPeer::ID, IndicatorPeer::NAME, IndicatorPeer::DESCRIPTION, IndicatorPeer::ARCHIVED, IndicatorPeer::METHODOLOGY, IndicatorPeer::DECIMALS, IndicatorPeer::GOAL, IndicatorPeer::GOALDATE, IndicatorPeer::IDEALBEHAVIOR, IndicatorPeer::POSITIONID, IndicatorPeer::OBJECTIVEID, IndicatorPeer::DUEDATE, IndicatorPeer::FINISHEDDATE, IndicatorPeer::CLASSKEY, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID', 'NAME', 'DESCRIPTION', 'ARCHIVED', 'METHODOLOGY', 'DECIMALS', 'GOAL', 'GOALDATE', 'IDEALBEHAVIOR', 'POSITIONID', 'OBJECTIVEID', 'DUEDATE', 'FINISHEDDATE', 'CLASSKEY', ),
        BasePeer::TYPE_FIELDNAME => array ('id', 'name', 'description', 'archived', 'methodology', 'decimals', 'goal', 'goalDate', 'idealBehavior', 'positionId', 'objectiveId', 'dueDate', 'finishedDate', 'classKey', ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. IndicatorPeer::$fieldNames[BasePeer::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        BasePeer::TYPE_PHPNAME => array ('Id' => 0, 'Name' => 1, 'Description' => 2, 'Archived' => 3, 'Methodology' => 4, 'Decimals' => 5, 'Goal' => 6, 'Goaldate' => 7, 'Idealbehavior' => 8, 'Positionid' => 9, 'Objectiveid' => 10, 'Duedate' => 11, 'Finisheddate' => 12, 'Classkey' => 13, ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id' => 0, 'name' => 1, 'description' => 2, 'archived' => 3, 'methodology' => 4, 'decimals' => 5, 'goal' => 6, 'goaldate' => 7, 'idealbehavior' => 8, 'positionid' => 9, 'objectiveid' => 10, 'duedate' => 11, 'finisheddate' => 12, 'classkey' => 13, ),
        BasePeer::TYPE_COLNAME => array (IndicatorPeer::ID => 0, IndicatorPeer::NAME => 1, IndicatorPeer::DESCRIPTION => 2, IndicatorPeer::ARCHIVED => 3, IndicatorPeer::METHODOLOGY => 4, IndicatorPeer::DECIMALS => 5, IndicatorPeer::GOAL => 6, IndicatorPeer::GOALDATE => 7, IndicatorPeer::IDEALBEHAVIOR => 8, IndicatorPeer::POSITIONID => 9, IndicatorPeer::OBJECTIVEID => 10, IndicatorPeer::DUEDATE => 11, IndicatorPeer::FINISHEDDATE => 12, IndicatorPeer::CLASSKEY => 13, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID' => 0, 'NAME' => 1, 'DESCRIPTION' => 2, 'ARCHIVED' => 3, 'METHODOLOGY' => 4, 'DECIMALS' => 5, 'GOAL' => 6, 'GOALDATE' => 7, 'IDEALBEHAVIOR' => 8, 'POSITIONID' => 9, 'OBJECTIVEID' => 10, 'DUEDATE' => 11, 'FINISHEDDATE' => 12, 'CLASSKEY' => 13, ),
        BasePeer::TYPE_FIELDNAME => array ('id' => 0, 'name' => 1, 'description' => 2, 'archived' => 3, 'methodology' => 4, 'decimals' => 5, 'goal' => 6, 'goalDate' => 7, 'idealBehavior' => 8, 'positionId' => 9, 'objectiveId' => 10, 'dueDate' => 11, 'finishedDate' => 12, 'classKey' => 13, ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, )
    );

    /**
     * Translates a fieldname to another type
     *
     * @param      string $name field name
     * @param      string $fromType One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                         BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @param      string $toType   One of the class type constants
     * @return string          translated name of the field.
     * @throws PropelException - if the specified name could not be found in the fieldname mappings.
     */
    public static function translateFieldName($name, $fromType, $toType)
    {
        $toNames = IndicatorPeer::getFieldNames($toType);
        $key = isset(IndicatorPeer::$fieldKeys[$fromType][$name]) ? IndicatorPeer::$fieldKeys[$fromType][$name] : null;
        if ($key === null) {
            throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(IndicatorPeer::$fieldKeys[$fromType], true));
        }

        return $toNames[$key];
    }

    /**
     * Returns an array of field names.
     *
     * @param      string $type The type of fieldnames to return:
     *                      One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                      BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @return array           A list of field names
     * @throws PropelException - if the type is not valid.
     */
    public static function getFieldNames($type = BasePeer::TYPE_PHPNAME)
    {
        if (!array_key_exists($type, IndicatorPeer::$fieldNames)) {
            throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME, BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. ' . $type . ' was given.');
        }

        return IndicatorPeer::$fieldNames[$type];
    }

    /**
     * Convenience method which changes table.column to alias.column.
     *
     * Using this method you can maintain SQL abstraction while using column aliases.
     * <code>
     *		$c->addAlias("alias1", TablePeer::TABLE_NAME);
     *		$c->addJoin(TablePeer::alias("alias1", TablePeer::PRIMARY_KEY_COLUMN), TablePeer::PRIMARY_KEY_COLUMN);
     * </code>
     * @param      string $alias The alias for the current table.
     * @param      string $column The column name for current table. (i.e. IndicatorPeer::COLUMN_NAME).
     * @return string
     */
    public static function alias($alias, $column)
    {
        return str_replace(IndicatorPeer::TABLE_NAME.'.', $alias.'.', $column);
    }

    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param      Criteria $criteria object containing the columns to add.
     * @param      string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(IndicatorPeer::ID);
            $criteria->addSelectColumn(IndicatorPeer::NAME);
            $criteria->addSelectColumn(IndicatorPeer::DESCRIPTION);
            $criteria->addSelectColumn(IndicatorPeer::ARCHIVED);
            $criteria->addSelectColumn(IndicatorPeer::METHODOLOGY);
            $criteria->addSelectColumn(IndicatorPeer::DECIMALS);
            $criteria->addSelectColumn(IndicatorPeer::GOAL);
            $criteria->addSelectColumn(IndicatorPeer::GOALDATE);
            $criteria->addSelectColumn(IndicatorPeer::IDEALBEHAVIOR);
            $criteria->addSelectColumn(IndicatorPeer::POSITIONID);
            $criteria->addSelectColumn(IndicatorPeer::OBJECTIVEID);
            $criteria->addSelectColumn(IndicatorPeer::DUEDATE);
            $criteria->addSelectColumn(IndicatorPeer::FINISHEDDATE);
            $criteria->addSelectColumn(IndicatorPeer::CLASSKEY);
        } else {
            $criteria->addSelectColumn($alias . '.ID');
            $criteria->addSelectColumn($alias . '.NAME');
            $criteria->addSelectColumn($alias . '.DESCRIPTION');
            $criteria->addSelectColumn($alias . '.ARCHIVED');
            $criteria->addSelectColumn($alias . '.METHODOLOGY');
            $criteria->addSelectColumn($alias . '.DECIMALS');
            $criteria->addSelectColumn($alias . '.GOAL');
            $criteria->addSelectColumn($alias . '.GOALDATE');
            $criteria->addSelectColumn($alias . '.IDEALBEHAVIOR');
            $criteria->addSelectColumn($alias . '.POSITIONID');
            $criteria->addSelectColumn($alias . '.OBJECTIVEID');
            $criteria->addSelectColumn($alias . '.DUEDATE');
            $criteria->addSelectColumn($alias . '.FINISHEDDATE');
            $criteria->addSelectColumn($alias . '.CLASSKEY');
        }
    }

    /**
     * Returns the number of rows matching criteria.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @return int Number of matching rows.
     */
    public static function doCount(Criteria $criteria, $distinct = false, PropelPDO $con = null)
    {
        // we may modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(IndicatorPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            IndicatorPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
        $criteria->setDbName(IndicatorPeer::DATABASE_NAME); // Set the correct dbName

        if ($con === null) {
            $con = Propel::getConnection(IndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        // BasePeer returns a PDOStatement
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }
    /**
     * Selects one object from the DB.
     *
     * @param      Criteria $criteria object used to create the SELECT statement.
     * @param      PropelPDO $con
     * @return                 Indicator
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectOne(Criteria $criteria, PropelPDO $con = null)
    {
        $critcopy = clone $criteria;
        $critcopy->setLimit(1);
        $objects = IndicatorPeer::doSelect($critcopy, $con);
        if ($objects) {
            return $objects[0];
        }

        return null;
    }
    /**
     * Selects several row from the DB.
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con
     * @return array           Array of selected Objects
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelect(Criteria $criteria, PropelPDO $con = null)
    {
        return IndicatorPeer::populateObjects(IndicatorPeer::doSelectStmt($criteria, $con));
    }
    /**
     * Prepares the Criteria object and uses the parent doSelect() method to execute a PDOStatement.
     *
     * Use this method directly if you want to work with an executed statement durirectly (for example
     * to perform your own object hydration).
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con The connection to use
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return PDOStatement The executed PDOStatement object.
     * @see        BasePeer::doSelect()
     */
    public static function doSelectStmt(Criteria $criteria, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(IndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        if (!$criteria->hasSelectClause()) {
            $criteria = clone $criteria;
            IndicatorPeer::addSelectColumns($criteria);
        }

        // Set the correct dbName
        $criteria->setDbName(IndicatorPeer::DATABASE_NAME);

        // BasePeer returns a PDOStatement
        return BasePeer::doSelect($criteria, $con);
    }
    /**
     * Adds an object to the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doSelect*()
     * methods in your stub classes -- you may need to explicitly add objects
     * to the cache in order to ensure that the same objects are always returned by doSelect*()
     * and retrieveByPK*() calls.
     *
     * @param      Indicator $obj A Indicator object.
     * @param      string $key (optional) key to use for instance map (for performance boost if key was already calculated externally).
     */
    public static function addInstanceToPool($obj, $key = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if ($key === null) {
                $key = (string) $obj->getId();
            } // if key === null
            IndicatorPeer::$instances[$key] = $obj;
        }
    }

    /**
     * Removes an object from the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doDelete
     * methods in your stub classes -- you may need to explicitly remove objects
     * from the cache in order to prevent returning objects that no longer exist.
     *
     * @param      mixed $value A Indicator object or a primary key value.
     *
     * @return void
     * @throws PropelException - if the value is invalid.
     */
    public static function removeInstanceFromPool($value)
    {
        if (Propel::isInstancePoolingEnabled() && $value !== null) {
            if (is_object($value) && $value instanceof Indicator) {
                $key = (string) $value->getId();
            } elseif (is_scalar($value)) {
                // assume we've been passed a primary key
                $key = (string) $value;
            } else {
                $e = new PropelException("Invalid value passed to removeInstanceFromPool().  Expected primary key or Indicator object; got " . (is_object($value) ? get_class($value) . ' object.' : var_export($value,true)));
                throw $e;
            }

            unset(IndicatorPeer::$instances[$key]);
        }
    } // removeInstanceFromPool()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      string $key The key (@see getPrimaryKeyHash()) for this instance.
     * @return   Indicator Found object or null if 1) no instance exists for specified key or 2) instance pooling has been disabled.
     * @see        getPrimaryKeyHash()
     */
    public static function getInstanceFromPool($key)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if (isset(IndicatorPeer::$instances[$key])) {
                return IndicatorPeer::$instances[$key];
            }
        }

        return null; // just to be explicit
    }

    /**
     * Clear the instance pool.
     *
     * @return void
     */
    public static function clearInstancePool()
    {
        IndicatorPeer::$instances = array();
    }

    /**
     * Method to invalidate the instance pool of all tables related to indicators_indicator
     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
        // Invalidate objects in IndicatorValuePeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        IndicatorValuePeer::clearInstancePool();
        // Invalidate objects in IndicatorGraphSeriePeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        IndicatorGraphSeriePeer::clearInstancePool();
        // Invalidate objects in PolicyGuidelineIndicatorsPeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        PolicyGuidelineIndicatorsPeer::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return string A string version of PK or null if the components of primary key in result array are all null.
     */
    public static function getPrimaryKeyHashFromRow($row, $startcol = 0)
    {
        // If the PK cannot be derived from the row, return null.
        if ($row[$startcol] === null) {
            return null;
        }

        return (string) $row[$startcol];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $startcol = 0)
    {

        return (int) $row[$startcol];
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function populateObjects(PDOStatement $stmt)
    {
        $results = array();

        // populate the object(s)
        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key = IndicatorPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj = IndicatorPeer::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                // class must be set each time from the record row
                $cls = IndicatorPeer::getOMClass($row, 0);
                $cls = substr('.'.$cls, strrpos('.'.$cls, '.') + 1);
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                IndicatorPeer::addInstanceToPool($obj, $key);
            } // if key exists
        }
        $stmt->closeCursor();

        return $results;
    }
    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return array (Indicator object, last column rank)
     */
    public static function populateObject($row, $startcol = 0)
    {
        $key = IndicatorPeer::getPrimaryKeyHashFromRow($row, $startcol);
        if (null !== ($obj = IndicatorPeer::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $startcol, true); // rehydrate
            $col = $startcol + IndicatorPeer::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = IndicatorPeer::getOMClass($row, $startcol);
            $obj = new $cls();
            $col = $obj->hydrate($row, $startcol);
            IndicatorPeer::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }


    /**
     * Returns the number of rows matching criteria, joining the related Position table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinPosition(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(IndicatorPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            IndicatorPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(IndicatorPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(IndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(IndicatorPeer::POSITIONID, PositionPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Objective table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinObjective(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(IndicatorPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            IndicatorPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(IndicatorPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(IndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(IndicatorPeer::OBJECTIVEID, ObjectivePeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of Indicator objects pre-filled with their Position objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Indicator objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinPosition(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(IndicatorPeer::DATABASE_NAME);
        }

        IndicatorPeer::addSelectColumns($criteria);
        $startcol = IndicatorPeer::NUM_HYDRATE_COLUMNS;
        PositionPeer::addSelectColumns($criteria);

        $criteria->addJoin(IndicatorPeer::POSITIONID, PositionPeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = IndicatorPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = IndicatorPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $omClass = IndicatorPeer::getOMClass($row, 0);
                $cls = substr('.'.$omClass, strrpos('.'.$omClass, '.') + 1);

                $obj1 = new $cls();
                $obj1->hydrate($row);
                IndicatorPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = PositionPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = PositionPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    PositionPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (Indicator) to $obj2 (Position)
                $obj2->addIndicator($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of Indicator objects pre-filled with their Objective objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Indicator objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinObjective(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(IndicatorPeer::DATABASE_NAME);
        }

        IndicatorPeer::addSelectColumns($criteria);
        $startcol = IndicatorPeer::NUM_HYDRATE_COLUMNS;
        ObjectivePeer::addSelectColumns($criteria);

        $criteria->addJoin(IndicatorPeer::OBJECTIVEID, ObjectivePeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = IndicatorPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = IndicatorPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $omClass = IndicatorPeer::getOMClass($row, 0);
                $cls = substr('.'.$omClass, strrpos('.'.$omClass, '.') + 1);

                $obj1 = new $cls();
                $obj1->hydrate($row);
                IndicatorPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = ObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = ObjectivePeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = ObjectivePeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    ObjectivePeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (Indicator) to $obj2 (Objective)
                $obj2->addIndicator($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining all related tables
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAll(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(IndicatorPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            IndicatorPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(IndicatorPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(IndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(IndicatorPeer::POSITIONID, PositionPeer::ID, $join_behavior);

        $criteria->addJoin(IndicatorPeer::OBJECTIVEID, ObjectivePeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }

    /**
     * Selects a collection of Indicator objects pre-filled with all related objects.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Indicator objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAll(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(IndicatorPeer::DATABASE_NAME);
        }

        IndicatorPeer::addSelectColumns($criteria);
        $startcol2 = IndicatorPeer::NUM_HYDRATE_COLUMNS;

        PositionPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + PositionPeer::NUM_HYDRATE_COLUMNS;

        ObjectivePeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + ObjectivePeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(IndicatorPeer::POSITIONID, PositionPeer::ID, $join_behavior);

        $criteria->addJoin(IndicatorPeer::OBJECTIVEID, ObjectivePeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = IndicatorPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = IndicatorPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $omClass = IndicatorPeer::getOMClass($row, 0);
        $cls = substr('.'.$omClass, strrpos('.'.$omClass, '.') + 1);

                $obj1 = new $cls();
                $obj1->hydrate($row);
                IndicatorPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

            // Add objects for joined Position rows

            $key2 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol2);
            if ($key2 !== null) {
                $obj2 = PositionPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = PositionPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    PositionPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 loaded

                // Add the $obj1 (Indicator) to the collection in $obj2 (Position)
                $obj2->addIndicator($obj1);
            } // if joined row not null

            // Add objects for joined Objective rows

            $key3 = ObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol3);
            if ($key3 !== null) {
                $obj3 = ObjectivePeer::getInstanceFromPool($key3);
                if (!$obj3) {

                    $cls = ObjectivePeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    ObjectivePeer::addInstanceToPool($obj3, $key3);
                } // if obj3 loaded

                // Add the $obj1 (Indicator) to the collection in $obj3 (Objective)
                $obj3->addIndicator($obj1);
            } // if joined row not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Position table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptPosition(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(IndicatorPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            IndicatorPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(IndicatorPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(IndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(IndicatorPeer::OBJECTIVEID, ObjectivePeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Objective table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptObjective(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(IndicatorPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            IndicatorPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(IndicatorPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(IndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(IndicatorPeer::POSITIONID, PositionPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of Indicator objects pre-filled with all related objects except Position.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Indicator objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptPosition(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(IndicatorPeer::DATABASE_NAME);
        }

        IndicatorPeer::addSelectColumns($criteria);
        $startcol2 = IndicatorPeer::NUM_HYDRATE_COLUMNS;

        ObjectivePeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + ObjectivePeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(IndicatorPeer::OBJECTIVEID, ObjectivePeer::ID, $join_behavior);


        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = IndicatorPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = IndicatorPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $omClass = IndicatorPeer::getOMClass($row, 0);
                $cls = substr('.'.$omClass, strrpos('.'.$omClass, '.') + 1);

                $obj1 = new $cls();
                $obj1->hydrate($row);
                IndicatorPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined Objective rows

                $key2 = ObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = ObjectivePeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = ObjectivePeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    ObjectivePeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (Indicator) to the collection in $obj2 (Objective)
                $obj2->addIndicator($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of Indicator objects pre-filled with all related objects except Objective.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Indicator objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptObjective(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(IndicatorPeer::DATABASE_NAME);
        }

        IndicatorPeer::addSelectColumns($criteria);
        $startcol2 = IndicatorPeer::NUM_HYDRATE_COLUMNS;

        PositionPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + PositionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(IndicatorPeer::POSITIONID, PositionPeer::ID, $join_behavior);


        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = IndicatorPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = IndicatorPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $omClass = IndicatorPeer::getOMClass($row, 0);
                $cls = substr('.'.$omClass, strrpos('.'.$omClass, '.') + 1);

                $obj1 = new $cls();
                $obj1->hydrate($row);
                IndicatorPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined Position rows

                $key2 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = PositionPeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = PositionPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    PositionPeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (Indicator) to the collection in $obj2 (Position)
                $obj2->addIndicator($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }

    /**
     * Returns the TableMap related to this peer.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getDatabaseMap(IndicatorPeer::DATABASE_NAME)->getTable(IndicatorPeer::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this peer class.
     */
    public static function buildTableMap()
    {
      $dbMap = Propel::getDatabaseMap(BaseIndicatorPeer::DATABASE_NAME);
      if (!$dbMap->hasTable(BaseIndicatorPeer::TABLE_NAME)) {
        $dbMap->addTableObject(new IndicatorTableMap());
      }
    }

    /**
     * The returned Class will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param      array $row PropelPDO result row.
     * @param      int $colnum Column to examine for OM class information (first is 0).
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function getOMClass($row, $colnum)
    {
        try {

            $omClass = null;
            $classKey = $row[$colnum + 13];

            switch ($classKey) {

                case IndicatorPeer::CLASSKEY_1:
                    $omClass = IndicatorPeer::CLASSNAME_1;
                    break;

                case IndicatorPeer::CLASSKEY_2:
                    $omClass = IndicatorPeer::CLASSNAME_2;
                    break;

                case IndicatorPeer::CLASSKEY_3:
                    $omClass = IndicatorPeer::CLASSNAME_3;
                    break;

                default:
                    $omClass = IndicatorPeer::OM_CLASS;

            } // switch

        } catch (Exception $e) {
            throw new PropelException('Unable to get OM class.', $e);
        }

        return $omClass;
    }

    /**
     * Performs an INSERT on the database, given a Indicator or Criteria object.
     *
     * @param      mixed $values Criteria or Indicator object containing data that is used to create the INSERT statement.
     * @param      PropelPDO $con the PropelPDO connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doInsert($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(IndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity
        } else {
            $criteria = $values->buildCriteria(); // build Criteria from Indicator object
        }

        if ($criteria->containsKey(IndicatorPeer::ID) && $criteria->keyContainsValue(IndicatorPeer::ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.IndicatorPeer::ID.')');
        }


        // Set the correct dbName
        $criteria->setDbName(IndicatorPeer::DATABASE_NAME);

        try {
            // use transaction because $criteria could contain info
            // for more than one table (I guess, conceivably)
            $con->beginTransaction();
            $pk = BasePeer::doInsert($criteria, $con);
            $con->commit();
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }

        return $pk;
    }

    /**
     * Performs an UPDATE on the database, given a Indicator or Criteria object.
     *
     * @param      mixed $values Criteria or Indicator object containing data that is used to create the UPDATE statement.
     * @param      PropelPDO $con The connection to use (specify PropelPDO connection object to exert more control over transactions).
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doUpdate($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(IndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $selectCriteria = new Criteria(IndicatorPeer::DATABASE_NAME);

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity

            $comparison = $criteria->getComparison(IndicatorPeer::ID);
            $value = $criteria->remove(IndicatorPeer::ID);
            if ($value) {
                $selectCriteria->add(IndicatorPeer::ID, $value, $comparison);
            } else {
                $selectCriteria->setPrimaryTableName(IndicatorPeer::TABLE_NAME);
            }

        } else { // $values is Indicator object
            $criteria = $values->buildCriteria(); // gets full criteria
            $selectCriteria = $values->buildPkeyCriteria(); // gets criteria w/ primary key(s)
        }

        // set the correct dbName
        $criteria->setDbName(IndicatorPeer::DATABASE_NAME);

        return BasePeer::doUpdate($selectCriteria, $criteria, $con);
    }

    /**
     * Deletes all rows from the indicators_indicator table.
     *
     * @param      PropelPDO $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException
     */
    public static function doDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(IndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $affectedRows = 0; // initialize var to track total num of affected rows
        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();
            $affectedRows += IndicatorPeer::doOnDeleteCascade(new Criteria(IndicatorPeer::DATABASE_NAME), $con);
            $affectedRows += BasePeer::doDeleteAll(IndicatorPeer::TABLE_NAME, $con, IndicatorPeer::DATABASE_NAME);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            IndicatorPeer::clearInstancePool();
            IndicatorPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs a DELETE on the database, given a Indicator or Criteria object OR a primary key value.
     *
     * @param      mixed $values Criteria or Indicator object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param      PropelPDO $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *				if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, PropelPDO $con = null)
     {
        if ($con === null) {
            $con = Propel::getConnection(IndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = clone $values;
        } elseif ($values instanceof Indicator) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(IndicatorPeer::DATABASE_NAME);
            $criteria->add(IndicatorPeer::ID, (array) $values, Criteria::IN);
        }

        // Set the correct dbName
        $criteria->setDbName(IndicatorPeer::DATABASE_NAME);

        $affectedRows = 0; // initialize var to track total num of affected rows

        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();

            // cloning the Criteria in case it's modified by doSelect() or doSelectStmt()
            $c = clone $criteria;
            $affectedRows += IndicatorPeer::doOnDeleteCascade($c, $con);

            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            if ($values instanceof Criteria) {
                IndicatorPeer::clearInstancePool();
            } elseif ($values instanceof Indicator) { // it's a model object
                IndicatorPeer::removeInstanceFromPool($values);
            } else { // it's a primary key, or an array of pks
                foreach ((array) $values as $singleval) {
                    IndicatorPeer::removeInstanceFromPool($singleval);
                }
            }

            $affectedRows += BasePeer::doDelete($criteria, $con);
            IndicatorPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * This is a method for emulating ON DELETE CASCADE for DBs that don't support this
     * feature (like MySQL or SQLite).
     *
     * This method is not very speedy because it must perform a query first to get
     * the implicated records and then perform the deletes by calling those Peer classes.
     *
     * This method should be used within a transaction if possible.
     *
     * @param      Criteria $criteria
     * @param      PropelPDO $con
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    protected static function doOnDeleteCascade(Criteria $criteria, PropelPDO $con)
    {
        // initialize var to track total num of affected rows
        $affectedRows = 0;

        // first find the objects that are implicated by the $criteria
        $objects = IndicatorPeer::doSelect($criteria, $con);
        foreach ($objects as $obj) {


            // delete related IndicatorValue objects
            $criteria = new Criteria(IndicatorValuePeer::DATABASE_NAME);

            $criteria->add(IndicatorValuePeer::NUMERICINDICATORID, $obj->getId());
            $affectedRows += IndicatorValuePeer::doDelete($criteria, $con);

            // delete related IndicatorGraphSerie objects
            $criteria = new Criteria(IndicatorGraphSeriePeer::DATABASE_NAME);

            $criteria->add(IndicatorGraphSeriePeer::INDICATORID, $obj->getId());
            $affectedRows += IndicatorGraphSeriePeer::doDelete($criteria, $con);

            // delete related PolicyGuidelineIndicators objects
            $criteria = new Criteria(PolicyGuidelineIndicatorsPeer::DATABASE_NAME);

            $criteria->add(PolicyGuidelineIndicatorsPeer::INDICATORID, $obj->getId());
            $affectedRows += PolicyGuidelineIndicatorsPeer::doDelete($criteria, $con);
        }

        return $affectedRows;
    }

    /**
     * Validates all modified columns of given Indicator object.
     * If parameter $columns is either a single column name or an array of column names
     * than only those columns are validated.
     *
     * NOTICE: This does not apply to primary or foreign keys for now.
     *
     * @param      Indicator $obj The object to validate.
     * @param      mixed $cols Column name or array of column names.
     *
     * @return mixed TRUE if all columns are valid or the error message of the first invalid column.
     */
    public static function doValidate($obj, $cols = null)
    {
        $columns = array();

        if ($cols) {
            $dbMap = Propel::getDatabaseMap(IndicatorPeer::DATABASE_NAME);
            $tableMap = $dbMap->getTable(IndicatorPeer::TABLE_NAME);

            if (! is_array($cols)) {
                $cols = array($cols);
            }

            foreach ($cols as $colName) {
                if ($tableMap->hasColumn($colName)) {
                    $get = 'get' . $tableMap->getColumn($colName)->getPhpName();
                    $columns[$colName] = $obj->$get();
                }
            }
        } else {

        }

        return BasePeer::doValidate(IndicatorPeer::DATABASE_NAME, IndicatorPeer::TABLE_NAME, $columns);
    }

    /**
     * Retrieve a single object by pkey.
     *
     * @param      int $pk the primary key.
     * @param      PropelPDO $con the connection to use
     * @return Indicator
     */
    public static function retrieveByPK($pk, PropelPDO $con = null)
    {

        if (null !== ($obj = IndicatorPeer::getInstanceFromPool((string) $pk))) {
            return $obj;
        }

        if ($con === null) {
            $con = Propel::getConnection(IndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria = new Criteria(IndicatorPeer::DATABASE_NAME);
        $criteria->add(IndicatorPeer::ID, $pk);

        $v = IndicatorPeer::doSelect($criteria, $con);

        return !empty($v) > 0 ? $v[0] : null;
    }

    /**
     * Retrieve multiple objects by pkey.
     *
     * @param      array $pks List of primary keys
     * @param      PropelPDO $con the connection to use
     * @return Indicator[]
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function retrieveByPKs($pks, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(IndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $objs = null;
        if (empty($pks)) {
            $objs = array();
        } else {
            $criteria = new Criteria(IndicatorPeer::DATABASE_NAME);
            $criteria->add(IndicatorPeer::ID, $pks, Criteria::IN);
            $objs = IndicatorPeer::doSelect($criteria, $con);
        }

        return $objs;
    }

} // BaseIndicatorPeer

// This is the static code needed to register the TableMap for this table with the main Propel class.
//
BaseIndicatorPeer::buildTableMap();

