<?php

class IndicatorsNumericEditAction extends BaseSelectAction {
    
    
        /**
         * 
         * @param type $entityClassName
         * Constructor
         */
	function __construct($entityClassName = 'NumericIndicator') {
		parent::__construct($entityClassName);
	}

	protected function postSelect() {
		parent::postSelect();

		$this->smarty->assign('includeJQuery', true);

		// Graph 
		$classMap = [
			'expected' => IndicatorValuePeer::CLASSKEY_EXPECTEDINDICATORVALUE,
			'real' => IndicatorValuePeer::CLASSKEY_REALINDICATORVALUE
		];

		$expectedValues = ExpectedIndicatorValueQuery::create()->orderByDate(Criteria::ASC)->findByNumericIndicatorId($this->entity->getId());
		$realValues = RealIndicatorValueQuery::create()->orderByDate(Criteria::ASC)->findByNumericIndicatorId($this->entity->getId());
		
		$graphValues = [
			'expected' => $this->graphMap($expectedValues),
			'real' => $this->graphMap($realValues)
		];

		global $system;
		$dateFormatLabel = $system['config']['system']['parameters']['dateFormat']['value'];
		$dateFormat = preg_replace("/(^|-)/", "$1%", $dateFormatLabel);

		$this->smarty->assign([
			'classMap' => $classMap,
			'graphValues' => $graphValues,
			'dateFormat' => $dateFormat,
			'dateFormatLabel' => $dateFormatLabel
		]);
	}

	private function graphMap($indicatorValues) {
		$mappedValues = [];
		foreach ($indicatorValues as $indicatorValue) {
			$mappedValues[] = [
				'x' => $indicatorValue->getDate('U'),
				'y' => $indicatorValue->getValue()
			];
		}
		return json_encode($mappedValues);
	}
}