<?php



/**
 * This class defines the structure of the 'headlines_headline' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.headlines.classes.map
 */
class HeadlineTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'headlines.classes.map.HeadlineTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('headlines_headline');
        $this->setPhpName('Headline');
        $this->setClassname('Headline');
        $this->setPackage('headlines.classes');
        $this->setUseIdGenerator(true);
        $this->setSingleTableInheritance(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('NAME', 'Name', 'VARCHAR', true, 255, null);
        $this->getColumn('NAME', false)->setPrimaryString(true);
        $this->addColumn('CONTENT', 'Content', 'LONGVARCHAR', false, null, null);
        $this->addColumn('DATEPUBLISHED', 'Datepublished', 'TIMESTAMP', false, null, null);
        $this->addColumn('HEADLINEDATE', 'Headlinedate', 'TIMESTAMP', false, null, null);
        $this->addColumn('URL', 'Url', 'VARCHAR', false, 255, null);
        $this->addColumn('TWITTS', 'Twitts', 'INTEGER', false, null, null);
        $this->addColumn('FCB', 'Fcb', 'INTEGER', false, null, null);
        $this->addColumn('GPLUS', 'Gplus', 'INTEGER', false, null, null);
        $this->addColumn('COMMENT', 'Comment', 'INTEGER', false, null, null);
        $this->addColumn('PICTURE', 'Picture', 'BOOLEAN', false, 1, null);
        $this->addColumn('CAMPAIGNID', 'Campaignid', 'INTEGER', false, null, null);
        $this->addForeignKey('MEDIAID', 'Mediaid', 'INTEGER', 'medias_media', 'ID', false, null, null);
        $this->addColumn('VALUE', 'Value', 'TINYINT', false, null, 0);
        $this->addColumn('RELEVANCE', 'Relevance', 'TINYINT', false, null, 0);
        $this->addColumn('INTERNALID', 'Internalid', 'VARCHAR', true, 255, null);
        $this->addColumn('PAGE', 'Page', 'INTEGER', false, null, null);
        $this->addColumn('SECTION', 'Section', 'VARCHAR', false, 255, null);
        $this->addColumn('AUTHOR', 'Author', 'VARCHAR', false, 255, null);
        $this->addColumn('SOURCE', 'Source', 'VARCHAR', false, 255, null);
        $this->addColumn('SUMMARY', 'Summary', 'VARCHAR', false, 255, null);
        $this->addColumn('CAPTION', 'Caption', 'VARCHAR', false, 255, null);
        $this->addColumn('PROGRAM', 'Program', 'VARCHAR', false, 255, null);
        $this->addColumn('STRATEGY', 'Strategy', 'VARCHAR', false, 50, null);
        $this->addColumn('LENGTH', 'Length', 'INTEGER', false, null, null);
        $this->addColumn('AGENDA', 'Agenda', 'TINYINT', false, null, 0);
        $this->addColumn('HEADLINESCOPE', 'Headlinescope', 'TINYINT', false, null, 0);
        $this->addColumn('PROCESSED', 'Processed', 'BOOLEAN', false, 1, false);
        $this->addColumn('CLASS_KEY', 'ClassKey', 'INTEGER', false, null, null);
        $this->addColumn('CREATED_AT', 'CreatedAt', 'TIMESTAMP', false, null, null);
        $this->addColumn('UPDATED_AT', 'UpdatedAt', 'TIMESTAMP', false, null, null);
        $this->addColumn('ISSUESCOUNT', 'Issuescount', 'INTEGER', false, null, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Media', 'Media', RelationMap::MANY_TO_ONE, array('mediaId' => 'id', ), 'CASCADE', null);
        $this->addRelation('HeadlineActor', 'HeadlineActor', RelationMap::ONE_TO_MANY, array('id' => 'headlineId', ), 'CASCADE', null, 'HeadlineActors');
        $this->addRelation('HeadlineIssue', 'HeadlineIssue', RelationMap::ONE_TO_MANY, array('id' => 'headlineId', ), 'CASCADE', null, 'HeadlineIssues');
        $this->addRelation('HeadlineDocument', 'HeadlineDocument', RelationMap::ONE_TO_MANY, array('id' => 'headlineId', ), 'CASCADE', null, 'HeadlineDocuments');
        $this->addRelation('HeadlineTagRelation', 'HeadlineTagRelation', RelationMap::ONE_TO_MANY, array('id' => 'headlineId', ), 'CASCADE', null, 'HeadlineTagRelations');
        $this->addRelation('Actor', 'Actor', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Actors');
        $this->addRelation('Issue', 'Issue', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Issues');
        $this->addRelation('Document', 'Document', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Documents');
        $this->addRelation('HeadlineTag', 'HeadlineTag', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'HeadlineTags');
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'timestampable' => array('create_column' => 'created_at', 'update_column' => 'updated_at', 'disable_updated_at' => 'false', ),
            'aggregate_column' => array('name' => 'issuesCount', 'expression' => 'COUNT(headlineId)', 'foreign_table' => 'headlines_issue', 'foreign_schema' => '', ),
        );
    } // getBehaviors()

} // HeadlineTableMap
