<?php

abstract class BingApiStrategy extends AbstractParserStrategy {

	private $bingApiUrl = 'https://api.datamarket.azure.com/Bing/Search/v1';
	protected $type;

	function initialize() {}

	// public function getNextQueryParameters() {
	// 	$params = parent::getQueryParameters();
	// 	$nextParams = parent::getNextQueryParameters();

	// 	if (!$params['start'])
	// 		$params['start'] = 0;
	// 	$nextParams['start'] = $params['start'] + 10;

	// 	return $nextParams;
	// }

	function parse($url = null) {

		$requestUri = $this->bingApiUrl . '/' . $this->type . '?$format=json&Query=%27' . $this->getKeywords() . '%27';
		$acctKey = ConfigModule::get('global', 'msAzureMarketplaceAccKey');

		$auth = base64_encode("$acctKey:$acctKey");
		$contextData = array(
			'http' => array(
				'request_fulluri' => true,
				'ignore_errors' => false,
				'header' => "Authorization: Basic $auth"
			)
		);
		$context = stream_context_create($contextData);

		$response = file_get_contents($requestUri, 0, $context);

		return array_map([$this, 'mapItem'], json_decode($response)->d->results);
	}

	abstract protected function mapItem($item);
}
