<?php


/**
 * Base static class for performing query and update operations on the 'campaigns_campaign' table.
 *
 * Base de Campaigns
 *
 * @package propel.generator.campaigns.classes.om
 */
abstract class BaseCampaignPeer
{

    /** the default database name for this class */
    const DATABASE_NAME = 'application';

    /** the table name for this class */
    const TABLE_NAME = 'campaigns_campaign';

    /** the related Propel class for this table */
    const OM_CLASS = 'Campaign';

    /** the related TableMap class for this table */
    const TM_CLASS = 'CampaignTableMap';

    /** The total number of columns. */
    const NUM_COLUMNS = 13;

    /** The number of lazy-loaded columns. */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /** The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS) */
    const NUM_HYDRATE_COLUMNS = 13;

    /** the column name for the ID field */
    const ID = 'campaigns_campaign.ID';

    /** the column name for the NAME field */
    const NAME = 'campaigns_campaign.NAME';

    /** the column name for the TYPE field */
    const TYPE = 'campaigns_campaign.TYPE';

    /** the column name for the STARTDATE field */
    const STARTDATE = 'campaigns_campaign.STARTDATE';

    /** the column name for the FINISHDATE field */
    const FINISHDATE = 'campaigns_campaign.FINISHDATE';

    /** the column name for the CLIENTID field */
    const CLIENTID = 'campaigns_campaign.CLIENTID';

    /** the column name for the DESCRIPTION field */
    const DESCRIPTION = 'campaigns_campaign.DESCRIPTION';

    /** the column name for the LANGCODE field */
    const LANGCODE = 'campaigns_campaign.LANGCODE';

    /** the column name for the DEFAULTKEYWORDS field */
    const DEFAULTKEYWORDS = 'campaigns_campaign.DEFAULTKEYWORDS';

    /** the column name for the RESPONSIBLE field */
    const RESPONSIBLE = 'campaigns_campaign.RESPONSIBLE';

    /** the column name for the SOURCES field */
    const SOURCES = 'campaigns_campaign.SOURCES';

    /** the column name for the SEARCHQUERIES field */
    const SEARCHQUERIES = 'campaigns_campaign.SEARCHQUERIES';

    /** the column name for the DELETED_AT field */
    const DELETED_AT = 'campaigns_campaign.DELETED_AT';

    /** The default string format for model objects of the related table **/
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * An identiy map to hold any loaded instances of Campaign objects.
     * This must be public so that other peer classes can access this when hydrating from JOIN
     * queries.
     * @var        array Campaign[]
     */
    public static $instances = array();


    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. CampaignPeer::$fieldNames[CampaignPeer::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        BasePeer::TYPE_PHPNAME => array ('Id', 'Name', 'Type', 'Startdate', 'Finishdate', 'Clientid', 'Description', 'Langcode', 'Defaultkeywords', 'Responsible', 'Sources', 'Searchqueries', 'DeletedAt', ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id', 'name', 'type', 'startdate', 'finishdate', 'clientid', 'description', 'langcode', 'defaultkeywords', 'responsible', 'sources', 'searchqueries', 'deletedAt', ),
        BasePeer::TYPE_COLNAME => array (CampaignPeer::ID, CampaignPeer::NAME, CampaignPeer::TYPE, CampaignPeer::STARTDATE, CampaignPeer::FINISHDATE, CampaignPeer::CLIENTID, CampaignPeer::DESCRIPTION, CampaignPeer::LANGCODE, CampaignPeer::DEFAULTKEYWORDS, CampaignPeer::RESPONSIBLE, CampaignPeer::SOURCES, CampaignPeer::SEARCHQUERIES, CampaignPeer::DELETED_AT, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID', 'NAME', 'TYPE', 'STARTDATE', 'FINISHDATE', 'CLIENTID', 'DESCRIPTION', 'LANGCODE', 'DEFAULTKEYWORDS', 'RESPONSIBLE', 'SOURCES', 'SEARCHQUERIES', 'DELETED_AT', ),
        BasePeer::TYPE_FIELDNAME => array ('id', 'name', 'type', 'startDate', 'finishDate', 'clientId', 'description', 'langCode', 'defaultKeywords', 'responsible', 'sources', 'searchQueries', 'deleted_at', ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. CampaignPeer::$fieldNames[BasePeer::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        BasePeer::TYPE_PHPNAME => array ('Id' => 0, 'Name' => 1, 'Type' => 2, 'Startdate' => 3, 'Finishdate' => 4, 'Clientid' => 5, 'Description' => 6, 'Langcode' => 7, 'Defaultkeywords' => 8, 'Responsible' => 9, 'Sources' => 10, 'Searchqueries' => 11, 'DeletedAt' => 12, ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id' => 0, 'name' => 1, 'type' => 2, 'startdate' => 3, 'finishdate' => 4, 'clientid' => 5, 'description' => 6, 'langcode' => 7, 'defaultkeywords' => 8, 'responsible' => 9, 'sources' => 10, 'searchqueries' => 11, 'deletedAt' => 12, ),
        BasePeer::TYPE_COLNAME => array (CampaignPeer::ID => 0, CampaignPeer::NAME => 1, CampaignPeer::TYPE => 2, CampaignPeer::STARTDATE => 3, CampaignPeer::FINISHDATE => 4, CampaignPeer::CLIENTID => 5, CampaignPeer::DESCRIPTION => 6, CampaignPeer::LANGCODE => 7, CampaignPeer::DEFAULTKEYWORDS => 8, CampaignPeer::RESPONSIBLE => 9, CampaignPeer::SOURCES => 10, CampaignPeer::SEARCHQUERIES => 11, CampaignPeer::DELETED_AT => 12, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID' => 0, 'NAME' => 1, 'TYPE' => 2, 'STARTDATE' => 3, 'FINISHDATE' => 4, 'CLIENTID' => 5, 'DESCRIPTION' => 6, 'LANGCODE' => 7, 'DEFAULTKEYWORDS' => 8, 'RESPONSIBLE' => 9, 'SOURCES' => 10, 'SEARCHQUERIES' => 11, 'DELETED_AT' => 12, ),
        BasePeer::TYPE_FIELDNAME => array ('id' => 0, 'name' => 1, 'type' => 2, 'startDate' => 3, 'finishDate' => 4, 'clientId' => 5, 'description' => 6, 'langCode' => 7, 'defaultKeywords' => 8, 'responsible' => 9, 'sources' => 10, 'searchQueries' => 11, 'deleted_at' => 12, ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, )
    );

    /**
     * Translates a fieldname to another type
     *
     * @param      string $name field name
     * @param      string $fromType One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                         BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @param      string $toType   One of the class type constants
     * @return string          translated name of the field.
     * @throws PropelException - if the specified name could not be found in the fieldname mappings.
     */
    public static function translateFieldName($name, $fromType, $toType)
    {
        $toNames = CampaignPeer::getFieldNames($toType);
        $key = isset(CampaignPeer::$fieldKeys[$fromType][$name]) ? CampaignPeer::$fieldKeys[$fromType][$name] : null;
        if ($key === null) {
            throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(CampaignPeer::$fieldKeys[$fromType], true));
        }

        return $toNames[$key];
    }

    /**
     * Returns an array of field names.
     *
     * @param      string $type The type of fieldnames to return:
     *                      One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                      BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @return array           A list of field names
     * @throws PropelException - if the type is not valid.
     */
    public static function getFieldNames($type = BasePeer::TYPE_PHPNAME)
    {
        if (!array_key_exists($type, CampaignPeer::$fieldNames)) {
            throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME, BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. ' . $type . ' was given.');
        }

        return CampaignPeer::$fieldNames[$type];
    }

    /**
     * Convenience method which changes table.column to alias.column.
     *
     * Using this method you can maintain SQL abstraction while using column aliases.
     * <code>
     *		$c->addAlias("alias1", TablePeer::TABLE_NAME);
     *		$c->addJoin(TablePeer::alias("alias1", TablePeer::PRIMARY_KEY_COLUMN), TablePeer::PRIMARY_KEY_COLUMN);
     * </code>
     * @param      string $alias The alias for the current table.
     * @param      string $column The column name for current table. (i.e. CampaignPeer::COLUMN_NAME).
     * @return string
     */
    public static function alias($alias, $column)
    {
        return str_replace(CampaignPeer::TABLE_NAME.'.', $alias.'.', $column);
    }

    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param      Criteria $criteria object containing the columns to add.
     * @param      string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(CampaignPeer::ID);
            $criteria->addSelectColumn(CampaignPeer::NAME);
            $criteria->addSelectColumn(CampaignPeer::TYPE);
            $criteria->addSelectColumn(CampaignPeer::STARTDATE);
            $criteria->addSelectColumn(CampaignPeer::FINISHDATE);
            $criteria->addSelectColumn(CampaignPeer::CLIENTID);
            $criteria->addSelectColumn(CampaignPeer::DESCRIPTION);
            $criteria->addSelectColumn(CampaignPeer::LANGCODE);
            $criteria->addSelectColumn(CampaignPeer::DEFAULTKEYWORDS);
            $criteria->addSelectColumn(CampaignPeer::RESPONSIBLE);
            $criteria->addSelectColumn(CampaignPeer::SOURCES);
            $criteria->addSelectColumn(CampaignPeer::SEARCHQUERIES);
            $criteria->addSelectColumn(CampaignPeer::DELETED_AT);
        } else {
            $criteria->addSelectColumn($alias . '.ID');
            $criteria->addSelectColumn($alias . '.NAME');
            $criteria->addSelectColumn($alias . '.TYPE');
            $criteria->addSelectColumn($alias . '.STARTDATE');
            $criteria->addSelectColumn($alias . '.FINISHDATE');
            $criteria->addSelectColumn($alias . '.CLIENTID');
            $criteria->addSelectColumn($alias . '.DESCRIPTION');
            $criteria->addSelectColumn($alias . '.LANGCODE');
            $criteria->addSelectColumn($alias . '.DEFAULTKEYWORDS');
            $criteria->addSelectColumn($alias . '.RESPONSIBLE');
            $criteria->addSelectColumn($alias . '.SOURCES');
            $criteria->addSelectColumn($alias . '.SEARCHQUERIES');
            $criteria->addSelectColumn($alias . '.DELETED_AT');
        }
    }

    /**
     * Returns the number of rows matching criteria.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @return int Number of matching rows.
     */
    public static function doCount(Criteria $criteria, $distinct = false, PropelPDO $con = null)
    {
        // we may modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(CampaignPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            CampaignPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
        $criteria->setDbName(CampaignPeer::DATABASE_NAME); // Set the correct dbName

        if ($con === null) {
            $con = Propel::getConnection(CampaignPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        // soft_delete behavior
        if (CampaignQuery::isSoftDeleteEnabled()) {
            $criteria->add(CampaignPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            CampaignPeer::enableSoftDelete();
        }
        // BasePeer returns a PDOStatement
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }
    /**
     * Selects one object from the DB.
     *
     * @param      Criteria $criteria object used to create the SELECT statement.
     * @param      PropelPDO $con
     * @return                 Campaign
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectOne(Criteria $criteria, PropelPDO $con = null)
    {
        $critcopy = clone $criteria;
        $critcopy->setLimit(1);
        $objects = CampaignPeer::doSelect($critcopy, $con);
        if ($objects) {
            return $objects[0];
        }

        return null;
    }
    /**
     * Selects several row from the DB.
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con
     * @return array           Array of selected Objects
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelect(Criteria $criteria, PropelPDO $con = null)
    {
        return CampaignPeer::populateObjects(CampaignPeer::doSelectStmt($criteria, $con));
    }
    /**
     * Prepares the Criteria object and uses the parent doSelect() method to execute a PDOStatement.
     *
     * Use this method directly if you want to work with an executed statement durirectly (for example
     * to perform your own object hydration).
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con The connection to use
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return PDOStatement The executed PDOStatement object.
     * @see        BasePeer::doSelect()
     */
    public static function doSelectStmt(Criteria $criteria, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(CampaignPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        if (!$criteria->hasSelectClause()) {
            $criteria = clone $criteria;
            CampaignPeer::addSelectColumns($criteria);
        }

        // Set the correct dbName
        $criteria->setDbName(CampaignPeer::DATABASE_NAME);
        // soft_delete behavior
        if (CampaignQuery::isSoftDeleteEnabled()) {
            $criteria->add(CampaignPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            CampaignPeer::enableSoftDelete();
        }

        // BasePeer returns a PDOStatement
        return BasePeer::doSelect($criteria, $con);
    }
    /**
     * Adds an object to the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doSelect*()
     * methods in your stub classes -- you may need to explicitly add objects
     * to the cache in order to ensure that the same objects are always returned by doSelect*()
     * and retrieveByPK*() calls.
     *
     * @param      Campaign $obj A Campaign object.
     * @param      string $key (optional) key to use for instance map (for performance boost if key was already calculated externally).
     */
    public static function addInstanceToPool($obj, $key = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if ($key === null) {
                $key = (string) $obj->getId();
            } // if key === null
            CampaignPeer::$instances[$key] = $obj;
        }
    }

    /**
     * Removes an object from the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doDelete
     * methods in your stub classes -- you may need to explicitly remove objects
     * from the cache in order to prevent returning objects that no longer exist.
     *
     * @param      mixed $value A Campaign object or a primary key value.
     *
     * @return void
     * @throws PropelException - if the value is invalid.
     */
    public static function removeInstanceFromPool($value)
    {
        if (Propel::isInstancePoolingEnabled() && $value !== null) {
            if (is_object($value) && $value instanceof Campaign) {
                $key = (string) $value->getId();
            } elseif (is_scalar($value)) {
                // assume we've been passed a primary key
                $key = (string) $value;
            } else {
                $e = new PropelException("Invalid value passed to removeInstanceFromPool().  Expected primary key or Campaign object; got " . (is_object($value) ? get_class($value) . ' object.' : var_export($value,true)));
                throw $e;
            }

            unset(CampaignPeer::$instances[$key]);
        }
    } // removeInstanceFromPool()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      string $key The key (@see getPrimaryKeyHash()) for this instance.
     * @return   Campaign Found object or null if 1) no instance exists for specified key or 2) instance pooling has been disabled.
     * @see        getPrimaryKeyHash()
     */
    public static function getInstanceFromPool($key)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if (isset(CampaignPeer::$instances[$key])) {
                return CampaignPeer::$instances[$key];
            }
        }

        return null; // just to be explicit
    }

    /**
     * Clear the instance pool.
     *
     * @return void
     */
    public static function clearInstancePool()
    {
        CampaignPeer::$instances = array();
    }

    /**
     * Method to invalidate the instance pool of all tables related to campaigns_campaign
     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
        // Invalidate objects in CampaignParticipantPeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        CampaignParticipantPeer::clearInstancePool();
        // Invalidate objects in CampaignCommitmentPeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        CampaignCommitmentPeer::clearInstancePool();
        // Invalidate objects in CampaignDocumentPeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        CampaignDocumentPeer::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return string A string version of PK or null if the components of primary key in result array are all null.
     */
    public static function getPrimaryKeyHashFromRow($row, $startcol = 0)
    {
        // If the PK cannot be derived from the row, return null.
        if ($row[$startcol] === null) {
            return null;
        }

        return (string) $row[$startcol];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $startcol = 0)
    {

        return (int) $row[$startcol];
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function populateObjects(PDOStatement $stmt)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = CampaignPeer::getOMClass();
        // populate the object(s)
        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key = CampaignPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj = CampaignPeer::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                CampaignPeer::addInstanceToPool($obj, $key);
            } // if key exists
        }
        $stmt->closeCursor();

        return $results;
    }
    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return array (Campaign object, last column rank)
     */
    public static function populateObject($row, $startcol = 0)
    {
        $key = CampaignPeer::getPrimaryKeyHashFromRow($row, $startcol);
        if (null !== ($obj = CampaignPeer::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $startcol, true); // rehydrate
            $col = $startcol + CampaignPeer::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = CampaignPeer::OM_CLASS;
            $obj = new $cls();
            $col = $obj->hydrate($row, $startcol);
            CampaignPeer::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * Returns the TableMap related to this peer.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getDatabaseMap(CampaignPeer::DATABASE_NAME)->getTable(CampaignPeer::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this peer class.
     */
    public static function buildTableMap()
    {
      $dbMap = Propel::getDatabaseMap(BaseCampaignPeer::DATABASE_NAME);
      if (!$dbMap->hasTable(BaseCampaignPeer::TABLE_NAME)) {
        $dbMap->addTableObject(new CampaignTableMap());
      }
    }

    /**
     * The class that the Peer will make instances of.
     *
     *
     * @return string ClassName
     */
    public static function getOMClass()
    {
        return CampaignPeer::OM_CLASS;
    }

    /**
     * Performs an INSERT on the database, given a Campaign or Criteria object.
     *
     * @param      mixed $values Criteria or Campaign object containing data that is used to create the INSERT statement.
     * @param      PropelPDO $con the PropelPDO connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doInsert($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(CampaignPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity
        } else {
            $criteria = $values->buildCriteria(); // build Criteria from Campaign object
        }

        if ($criteria->containsKey(CampaignPeer::ID) && $criteria->keyContainsValue(CampaignPeer::ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.CampaignPeer::ID.')');
        }


        // Set the correct dbName
        $criteria->setDbName(CampaignPeer::DATABASE_NAME);

        try {
            // use transaction because $criteria could contain info
            // for more than one table (I guess, conceivably)
            $con->beginTransaction();
            $pk = BasePeer::doInsert($criteria, $con);
            $con->commit();
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }

        return $pk;
    }

    /**
     * Performs an UPDATE on the database, given a Campaign or Criteria object.
     *
     * @param      mixed $values Criteria or Campaign object containing data that is used to create the UPDATE statement.
     * @param      PropelPDO $con The connection to use (specify PropelPDO connection object to exert more control over transactions).
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doUpdate($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(CampaignPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $selectCriteria = new Criteria(CampaignPeer::DATABASE_NAME);

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity

            $comparison = $criteria->getComparison(CampaignPeer::ID);
            $value = $criteria->remove(CampaignPeer::ID);
            if ($value) {
                $selectCriteria->add(CampaignPeer::ID, $value, $comparison);
            } else {
                $selectCriteria->setPrimaryTableName(CampaignPeer::TABLE_NAME);
            }

        } else { // $values is Campaign object
            $criteria = $values->buildCriteria(); // gets full criteria
            $selectCriteria = $values->buildPkeyCriteria(); // gets criteria w/ primary key(s)
        }

        // set the correct dbName
        $criteria->setDbName(CampaignPeer::DATABASE_NAME);

        return BasePeer::doUpdate($selectCriteria, $criteria, $con);
    }

    /**
     * Deletes all rows from the campaigns_campaign table.
     *
     * @param      PropelPDO $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException
     */
    public static function doForceDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(CampaignPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $affectedRows = 0; // initialize var to track total num of affected rows
        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();
            $affectedRows += CampaignPeer::doOnDeleteCascade(new Criteria(CampaignPeer::DATABASE_NAME), $con);
            $affectedRows += BasePeer::doDeleteAll(CampaignPeer::TABLE_NAME, $con, CampaignPeer::DATABASE_NAME);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            CampaignPeer::clearInstancePool();
            CampaignPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs a DELETE on the database, given a Campaign or Criteria object OR a primary key value.
     *
     * @param      mixed $values Criteria or Campaign object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param      PropelPDO $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *				if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
     public static function doForceDelete($values, PropelPDO $con = null)
     {
        if ($con === null) {
            $con = Propel::getConnection(CampaignPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = clone $values;
        } elseif ($values instanceof Campaign) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(CampaignPeer::DATABASE_NAME);
            $criteria->add(CampaignPeer::ID, (array) $values, Criteria::IN);
        }

        // Set the correct dbName
        $criteria->setDbName(CampaignPeer::DATABASE_NAME);

        $affectedRows = 0; // initialize var to track total num of affected rows

        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();

            // cloning the Criteria in case it's modified by doSelect() or doSelectStmt()
            $c = clone $criteria;
            $affectedRows += CampaignPeer::doOnDeleteCascade($c, $con);

            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            if ($values instanceof Criteria) {
                CampaignPeer::clearInstancePool();
            } elseif ($values instanceof Campaign) { // it's a model object
                CampaignPeer::removeInstanceFromPool($values);
            } else { // it's a primary key, or an array of pks
                foreach ((array) $values as $singleval) {
                    CampaignPeer::removeInstanceFromPool($singleval);
                }
            }

            $affectedRows += BasePeer::doDelete($criteria, $con);
            CampaignPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * This is a method for emulating ON DELETE CASCADE for DBs that don't support this
     * feature (like MySQL or SQLite).
     *
     * This method is not very speedy because it must perform a query first to get
     * the implicated records and then perform the deletes by calling those Peer classes.
     *
     * This method should be used within a transaction if possible.
     *
     * @param      Criteria $criteria
     * @param      PropelPDO $con
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    protected static function doOnDeleteCascade(Criteria $criteria, PropelPDO $con)
    {
        // initialize var to track total num of affected rows
        $affectedRows = 0;

        // first find the objects that are implicated by the $criteria
        $objects = CampaignPeer::doSelect($criteria, $con);
        foreach ($objects as $obj) {


            // delete related CampaignParticipant objects
            $criteria = new Criteria(CampaignParticipantPeer::DATABASE_NAME);

            $criteria->add(CampaignParticipantPeer::CAMPAIGNID, $obj->getId());
            $affectedRows += CampaignParticipantPeer::doDelete($criteria, $con);

            // delete related CampaignCommitment objects
            $criteria = new Criteria(CampaignCommitmentPeer::DATABASE_NAME);

            $criteria->add(CampaignCommitmentPeer::CAMPAIGNID, $obj->getId());
            $affectedRows += CampaignCommitmentPeer::doDelete($criteria, $con);

            // delete related CampaignDocument objects
            $criteria = new Criteria(CampaignDocumentPeer::DATABASE_NAME);

            $criteria->add(CampaignDocumentPeer::CAMPAIGNID, $obj->getId());
            $affectedRows += CampaignDocumentPeer::doDelete($criteria, $con);
        }

        return $affectedRows;
    }

    /**
     * Validates all modified columns of given Campaign object.
     * If parameter $columns is either a single column name or an array of column names
     * than only those columns are validated.
     *
     * NOTICE: This does not apply to primary or foreign keys for now.
     *
     * @param      Campaign $obj The object to validate.
     * @param      mixed $cols Column name or array of column names.
     *
     * @return mixed TRUE if all columns are valid or the error message of the first invalid column.
     */
    public static function doValidate($obj, $cols = null)
    {
        $columns = array();

        if ($cols) {
            $dbMap = Propel::getDatabaseMap(CampaignPeer::DATABASE_NAME);
            $tableMap = $dbMap->getTable(CampaignPeer::TABLE_NAME);

            if (! is_array($cols)) {
                $cols = array($cols);
            }

            foreach ($cols as $colName) {
                if ($tableMap->hasColumn($colName)) {
                    $get = 'get' . $tableMap->getColumn($colName)->getPhpName();
                    $columns[$colName] = $obj->$get();
                }
            }
        } else {

        }

        return BasePeer::doValidate(CampaignPeer::DATABASE_NAME, CampaignPeer::TABLE_NAME, $columns);
    }

    /**
     * Retrieve a single object by pkey.
     *
     * @param      int $pk the primary key.
     * @param      PropelPDO $con the connection to use
     * @return Campaign
     */
    public static function retrieveByPK($pk, PropelPDO $con = null)
    {

        if (null !== ($obj = CampaignPeer::getInstanceFromPool((string) $pk))) {
            return $obj;
        }

        if ($con === null) {
            $con = Propel::getConnection(CampaignPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria = new Criteria(CampaignPeer::DATABASE_NAME);
        $criteria->add(CampaignPeer::ID, $pk);

        $v = CampaignPeer::doSelect($criteria, $con);

        return !empty($v) > 0 ? $v[0] : null;
    }

    /**
     * Retrieve multiple objects by pkey.
     *
     * @param      array $pks List of primary keys
     * @param      PropelPDO $con the connection to use
     * @return Campaign[]
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function retrieveByPKs($pks, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(CampaignPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $objs = null;
        if (empty($pks)) {
            $objs = array();
        } else {
            $criteria = new Criteria(CampaignPeer::DATABASE_NAME);
            $criteria->add(CampaignPeer::ID, $pks, Criteria::IN);
            $objs = CampaignPeer::doSelect($criteria, $con);
        }

        return $objs;
    }

    // soft_delete behavior

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        CampaignQuery::enableSoftDelete();
        // some soft_deleted objects may be in the instance pool
        CampaignPeer::clearInstancePool();
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        CampaignQuery::disableSoftDelete();
    }

    /**
     * Check the soft_delete behavior for this model
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return CampaignQuery::isSoftDeleteEnabled();
    }

    /**
     * Soft delete records, given a Campaign or Criteria object OR a primary key value.
     *
     * @param			 mixed $values Criteria or Campaign object or primary key or array of primary keys
     *							which is used to create the DELETE statement
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doSoftDelete($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(CampaignPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        if ($values instanceof Criteria) {
            // rename for clarity
            $selectCriteria = clone $values;
         } elseif ($values instanceof Campaign) {
            // create criteria based on pk values
            $selectCriteria = $values->buildPkeyCriteria();
        } else {
            // it must be the primary key
            $selectCriteria = new Criteria(self::DATABASE_NAME);
             $selectCriteria->add(CampaignPeer::ID, (array) $values, Criteria::IN);
        }
        // Set the correct dbName
        $selectCriteria->setDbName(CampaignPeer::DATABASE_NAME);
        $updateCriteria = new Criteria(self::DATABASE_NAME);
        $updateCriteria->add(CampaignPeer::DELETED_AT, time());

         return BasePeer::doUpdate($selectCriteria, $updateCriteria, $con);
    }

    /**
     * Delete or soft delete records, depending on CampaignPeer::$softDelete
     *
     * @param			 mixed $values Criteria or Campaign object or primary key or array of primary keys
     *							which is used to create the DELETE statement
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doDelete($values, PropelPDO $con = null)
    {
        if (CampaignPeer::isSoftDeleteEnabled()) {
            return CampaignPeer::doSoftDelete($values, $con);
        } else {
            return CampaignPeer::doForceDelete($values, $con);
        }
    }
    /**
     * Method to soft delete all rows from the campaigns_campaign table.
     *
     * @param			 PropelPDO $con the connection to use
     * @return		 int The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doSoftDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(CampaignPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $selectCriteria = new Criteria();
        $selectCriteria->add(CampaignPeer::DELETED_AT, null, Criteria::ISNULL);
        $selectCriteria->setDbName(CampaignPeer::DATABASE_NAME);
        $modifyCriteria = new Criteria();
        $modifyCriteria->add(CampaignPeer::DELETED_AT, time());

        return BasePeer::doUpdate($selectCriteria, $modifyCriteria, $con);
    }

    /**
     * Delete or soft delete all records, depending on CampaignPeer::$softDelete
     *
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doDeleteAll(PropelPDO $con = null)
    {
        if (CampaignPeer::isSoftDeleteEnabled()) {
            return CampaignPeer::doSoftDeleteAll($con);
        } else {
            return CampaignPeer::doForceDeleteAll($con);
        }
    }

} // BaseCampaignPeer

// This is the static code needed to register the TableMap for this table with the main Propel class.
//
BaseCampaignPeer::buildTableMap();

