<?php


/**
 * Base class that represents a query for the 'campaigns_campaignCommitment' table.
 *
 * Base de Compromisos de Campaigns
 *
 * @method CampaignCommitmentQuery orderById($order = Criteria::ASC) Order by the id column
 * @method CampaignCommitmentQuery orderByCampaignid($order = Criteria::ASC) Order by the campaignId column
 * @method CampaignCommitmentQuery orderByParticipantid($order = Criteria::ASC) Order by the participantId column
 * @method CampaignCommitmentQuery orderByResponsible($order = Criteria::ASC) Order by the responsible column
 * @method CampaignCommitmentQuery orderByCommitment($order = Criteria::ASC) Order by the commitment column
 * @method CampaignCommitmentQuery orderByAchieved($order = Criteria::ASC) Order by the achieved column
 * @method CampaignCommitmentQuery orderByDate($order = Criteria::ASC) Order by the date column
 * @method CampaignCommitmentQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 *
 * @method CampaignCommitmentQuery groupById() Group by the id column
 * @method CampaignCommitmentQuery groupByCampaignid() Group by the campaignId column
 * @method CampaignCommitmentQuery groupByParticipantid() Group by the participantId column
 * @method CampaignCommitmentQuery groupByResponsible() Group by the responsible column
 * @method CampaignCommitmentQuery groupByCommitment() Group by the commitment column
 * @method CampaignCommitmentQuery groupByAchieved() Group by the achieved column
 * @method CampaignCommitmentQuery groupByDate() Group by the date column
 * @method CampaignCommitmentQuery groupByDeletedAt() Group by the deleted_at column
 *
 * @method CampaignCommitmentQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method CampaignCommitmentQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method CampaignCommitmentQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method CampaignCommitmentQuery leftJoinCampaign($relationAlias = null) Adds a LEFT JOIN clause to the query using the Campaign relation
 * @method CampaignCommitmentQuery rightJoinCampaign($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Campaign relation
 * @method CampaignCommitmentQuery innerJoinCampaign($relationAlias = null) Adds a INNER JOIN clause to the query using the Campaign relation
 *
 * @method CampaignCommitmentQuery leftJoinCampaignParticipant($relationAlias = null) Adds a LEFT JOIN clause to the query using the CampaignParticipant relation
 * @method CampaignCommitmentQuery rightJoinCampaignParticipant($relationAlias = null) Adds a RIGHT JOIN clause to the query using the CampaignParticipant relation
 * @method CampaignCommitmentQuery innerJoinCampaignParticipant($relationAlias = null) Adds a INNER JOIN clause to the query using the CampaignParticipant relation
 *
 * @method CampaignCommitment findOne(PropelPDO $con = null) Return the first CampaignCommitment matching the query
 * @method CampaignCommitment findOneOrCreate(PropelPDO $con = null) Return the first CampaignCommitment matching the query, or a new CampaignCommitment object populated from the query conditions when no match is found
 *
 * @method CampaignCommitment findOneById(int $id) Return the first CampaignCommitment filtered by the id column
 * @method CampaignCommitment findOneByCampaignid(int $campaignId) Return the first CampaignCommitment filtered by the campaignId column
 * @method CampaignCommitment findOneByParticipantid(int $participantId) Return the first CampaignCommitment filtered by the participantId column
 * @method CampaignCommitment findOneByResponsible(string $responsible) Return the first CampaignCommitment filtered by the responsible column
 * @method CampaignCommitment findOneByCommitment(string $commitment) Return the first CampaignCommitment filtered by the commitment column
 * @method CampaignCommitment findOneByAchieved(boolean $achieved) Return the first CampaignCommitment filtered by the achieved column
 * @method CampaignCommitment findOneByDate(string $date) Return the first CampaignCommitment filtered by the date column
 * @method CampaignCommitment findOneByDeletedAt(string $deleted_at) Return the first CampaignCommitment filtered by the deleted_at column
 *
 * @method array findById(int $id) Return CampaignCommitment objects filtered by the id column
 * @method array findByCampaignid(int $campaignId) Return CampaignCommitment objects filtered by the campaignId column
 * @method array findByParticipantid(int $participantId) Return CampaignCommitment objects filtered by the participantId column
 * @method array findByResponsible(string $responsible) Return CampaignCommitment objects filtered by the responsible column
 * @method array findByCommitment(string $commitment) Return CampaignCommitment objects filtered by the commitment column
 * @method array findByAchieved(boolean $achieved) Return CampaignCommitment objects filtered by the achieved column
 * @method array findByDate(string $date) Return CampaignCommitment objects filtered by the date column
 * @method array findByDeletedAt(string $deleted_at) Return CampaignCommitment objects filtered by the deleted_at column
 *
 * @package    propel.generator.campaigns.classes.om
 */
abstract class BaseCampaignCommitmentQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BaseCampaignCommitmentQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'CampaignCommitment', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new CampaignCommitmentQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     CampaignCommitmentQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return CampaignCommitmentQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof CampaignCommitmentQuery) {
            return $criteria;
        }
        $query = new CampaignCommitmentQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   CampaignCommitment|CampaignCommitment[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = CampaignCommitmentPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(CampaignCommitmentPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   CampaignCommitment A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `CAMPAIGNID`, `PARTICIPANTID`, `RESPONSIBLE`, `COMMITMENT`, `ACHIEVED`, `DATE`, `DELETED_AT` FROM `campaigns_campaignCommitment` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new CampaignCommitment();
            $obj->hydrate($row);
            CampaignCommitmentPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return CampaignCommitment|CampaignCommitment[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|CampaignCommitment[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return CampaignCommitmentQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(CampaignCommitmentPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return CampaignCommitmentQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(CampaignCommitmentPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignCommitmentQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(CampaignCommitmentPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the campaignId column
     *
     * Example usage:
     * <code>
     * $query->filterByCampaignid(1234); // WHERE campaignId = 1234
     * $query->filterByCampaignid(array(12, 34)); // WHERE campaignId IN (12, 34)
     * $query->filterByCampaignid(array('min' => 12)); // WHERE campaignId > 12
     * </code>
     *
     * @see       filterByCampaign()
     *
     * @param     mixed $campaignid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignCommitmentQuery The current query, for fluid interface
     */
    public function filterByCampaignid($campaignid = null, $comparison = null)
    {
        if (is_array($campaignid)) {
            $useMinMax = false;
            if (isset($campaignid['min'])) {
                $this->addUsingAlias(CampaignCommitmentPeer::CAMPAIGNID, $campaignid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($campaignid['max'])) {
                $this->addUsingAlias(CampaignCommitmentPeer::CAMPAIGNID, $campaignid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CampaignCommitmentPeer::CAMPAIGNID, $campaignid, $comparison);
    }

    /**
     * Filter the query on the participantId column
     *
     * Example usage:
     * <code>
     * $query->filterByParticipantid(1234); // WHERE participantId = 1234
     * $query->filterByParticipantid(array(12, 34)); // WHERE participantId IN (12, 34)
     * $query->filterByParticipantid(array('min' => 12)); // WHERE participantId > 12
     * </code>
     *
     * @see       filterByCampaignParticipant()
     *
     * @param     mixed $participantid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignCommitmentQuery The current query, for fluid interface
     */
    public function filterByParticipantid($participantid = null, $comparison = null)
    {
        if (is_array($participantid)) {
            $useMinMax = false;
            if (isset($participantid['min'])) {
                $this->addUsingAlias(CampaignCommitmentPeer::PARTICIPANTID, $participantid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($participantid['max'])) {
                $this->addUsingAlias(CampaignCommitmentPeer::PARTICIPANTID, $participantid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CampaignCommitmentPeer::PARTICIPANTID, $participantid, $comparison);
    }

    /**
     * Filter the query on the responsible column
     *
     * Example usage:
     * <code>
     * $query->filterByResponsible('fooValue');   // WHERE responsible = 'fooValue'
     * $query->filterByResponsible('%fooValue%'); // WHERE responsible LIKE '%fooValue%'
     * </code>
     *
     * @param     string $responsible The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignCommitmentQuery The current query, for fluid interface
     */
    public function filterByResponsible($responsible = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($responsible)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $responsible)) {
                $responsible = str_replace('*', '%', $responsible);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(CampaignCommitmentPeer::RESPONSIBLE, $responsible, $comparison);
    }

    /**
     * Filter the query on the commitment column
     *
     * Example usage:
     * <code>
     * $query->filterByCommitment('fooValue');   // WHERE commitment = 'fooValue'
     * $query->filterByCommitment('%fooValue%'); // WHERE commitment LIKE '%fooValue%'
     * </code>
     *
     * @param     string $commitment The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignCommitmentQuery The current query, for fluid interface
     */
    public function filterByCommitment($commitment = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($commitment)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $commitment)) {
                $commitment = str_replace('*', '%', $commitment);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(CampaignCommitmentPeer::COMMITMENT, $commitment, $comparison);
    }

    /**
     * Filter the query on the achieved column
     *
     * Example usage:
     * <code>
     * $query->filterByAchieved(true); // WHERE achieved = true
     * $query->filterByAchieved('yes'); // WHERE achieved = true
     * </code>
     *
     * @param     boolean|string $achieved The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignCommitmentQuery The current query, for fluid interface
     */
    public function filterByAchieved($achieved = null, $comparison = null)
    {
        if (is_string($achieved)) {
            $achieved = in_array(strtolower($achieved), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(CampaignCommitmentPeer::ACHIEVED, $achieved, $comparison);
    }

    /**
     * Filter the query on the date column
     *
     * Example usage:
     * <code>
     * $query->filterByDate('2011-03-14'); // WHERE date = '2011-03-14'
     * $query->filterByDate('now'); // WHERE date = '2011-03-14'
     * $query->filterByDate(array('max' => 'yesterday')); // WHERE date > '2011-03-13'
     * </code>
     *
     * @param     mixed $date The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignCommitmentQuery The current query, for fluid interface
     */
    public function filterByDate($date = null, $comparison = null)
    {
        if (is_array($date)) {
            $useMinMax = false;
            if (isset($date['min'])) {
                $this->addUsingAlias(CampaignCommitmentPeer::DATE, $date['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($date['max'])) {
                $this->addUsingAlias(CampaignCommitmentPeer::DATE, $date['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CampaignCommitmentPeer::DATE, $date, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignCommitmentQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(CampaignCommitmentPeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(CampaignCommitmentPeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CampaignCommitmentPeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query by a related Campaign object
     *
     * @param   Campaign|PropelObjectCollection $campaign The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   CampaignCommitmentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByCampaign($campaign, $comparison = null)
    {
        if ($campaign instanceof Campaign) {
            return $this
                ->addUsingAlias(CampaignCommitmentPeer::CAMPAIGNID, $campaign->getId(), $comparison);
        } elseif ($campaign instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(CampaignCommitmentPeer::CAMPAIGNID, $campaign->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByCampaign() only accepts arguments of type Campaign or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Campaign relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return CampaignCommitmentQuery The current query, for fluid interface
     */
    public function joinCampaign($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Campaign');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Campaign');
        }

        return $this;
    }

    /**
     * Use the Campaign relation Campaign object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   CampaignQuery A secondary query class using the current class as primary query
     */
    public function useCampaignQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinCampaign($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Campaign', 'CampaignQuery');
    }

    /**
     * Filter the query by a related CampaignParticipant object
     *
     * @param   CampaignParticipant|PropelObjectCollection $campaignParticipant The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   CampaignCommitmentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByCampaignParticipant($campaignParticipant, $comparison = null)
    {
        if ($campaignParticipant instanceof CampaignParticipant) {
            return $this
                ->addUsingAlias(CampaignCommitmentPeer::PARTICIPANTID, $campaignParticipant->getId(), $comparison);
        } elseif ($campaignParticipant instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(CampaignCommitmentPeer::PARTICIPANTID, $campaignParticipant->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByCampaignParticipant() only accepts arguments of type CampaignParticipant or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the CampaignParticipant relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return CampaignCommitmentQuery The current query, for fluid interface
     */
    public function joinCampaignParticipant($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('CampaignParticipant');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'CampaignParticipant');
        }

        return $this;
    }

    /**
     * Use the CampaignParticipant relation CampaignParticipant object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   CampaignParticipantQuery A secondary query class using the current class as primary query
     */
    public function useCampaignParticipantQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinCampaignParticipant($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'CampaignParticipant', 'CampaignParticipantQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   CampaignCommitment $campaignCommitment Object to remove from the list of results
     *
     * @return CampaignCommitmentQuery The current query, for fluid interface
     */
    public function prune($campaignCommitment = null)
    {
        if ($campaignCommitment) {
            $this->addUsingAlias(CampaignCommitmentPeer::ID, $campaignCommitment->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (CampaignCommitmentQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(CampaignCommitmentPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            CampaignCommitmentPeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (CampaignCommitmentQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see CampaignCommitmentQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return CampaignCommitmentQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return CampaignCommitmentPeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return CampaignCommitmentPeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

}
