<?php

/**
 * BackupListAction
 *
 * Listado de archivos de respaldo disponibles y formulario para subir respaldos
 *
 * @package backup
 */

class BackupListAction extends BaseAction {

	/**
	 * Acciones a ejecutar antes de generar el display
	 */
	protected function exec() {
		parent::exec();

		require_once('Backup.php');
		$backup = new Backup();

		$order = 'asc';
		if (isset($_GET['order']) && $_GET['order'] == 'desc')
			$order = 'desc';

		// Obtengo los archivos de respaldo disponibles y asigno a smarty
		$this->smarty->assign('filenames', $backup->getBackupList($order));
		$this->smarty->assign('order', $order);

	}

}
