<?php


/**
 * Base class that represents a query for the 'actors_activeRelationQuestions' table.
 *
 * Tabla de preguntas activas de relacion
 *
 * @method ActorActiveRelationQuestionQuery orderByActorfromid($order = Criteria::ASC) Order by the actorFromId column
 * @method ActorActiveRelationQuestionQuery orderByActortoid($order = Criteria::ASC) Order by the actorToId column
 * @method ActorActiveRelationQuestionQuery orderByQuestionid($order = Criteria::ASC) Order by the questionId column
 *
 * @method ActorActiveRelationQuestionQuery groupByActorfromid() Group by the actorFromId column
 * @method ActorActiveRelationQuestionQuery groupByActortoid() Group by the actorToId column
 * @method ActorActiveRelationQuestionQuery groupByQuestionid() Group by the questionId column
 *
 * @method ActorActiveRelationQuestionQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ActorActiveRelationQuestionQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ActorActiveRelationQuestionQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ActorActiveRelationQuestionQuery leftJoinActor($relationAlias = null) Adds a LEFT JOIN clause to the query using the Actor relation
 * @method ActorActiveRelationQuestionQuery rightJoinActor($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Actor relation
 * @method ActorActiveRelationQuestionQuery innerJoinActor($relationAlias = null) Adds a INNER JOIN clause to the query using the Actor relation
 *
 * @method ActorActiveRelationQuestionQuery leftJoinProfileForm($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProfileForm relation
 * @method ActorActiveRelationQuestionQuery rightJoinProfileForm($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProfileForm relation
 * @method ActorActiveRelationQuestionQuery innerJoinProfileForm($relationAlias = null) Adds a INNER JOIN clause to the query using the ProfileForm relation
 *
 * @method ActorActiveRelationQuestion findOne(PropelPDO $con = null) Return the first ActorActiveRelationQuestion matching the query
 * @method ActorActiveRelationQuestion findOneOrCreate(PropelPDO $con = null) Return the first ActorActiveRelationQuestion matching the query, or a new ActorActiveRelationQuestion object populated from the query conditions when no match is found
 *
 * @method ActorActiveRelationQuestion findOneByActorfromid(int $actorFromId) Return the first ActorActiveRelationQuestion filtered by the actorFromId column
 * @method ActorActiveRelationQuestion findOneByActortoid(int $actorToId) Return the first ActorActiveRelationQuestion filtered by the actorToId column
 * @method ActorActiveRelationQuestion findOneByQuestionid(int $questionId) Return the first ActorActiveRelationQuestion filtered by the questionId column
 *
 * @method array findByActorfromid(int $actorFromId) Return ActorActiveRelationQuestion objects filtered by the actorFromId column
 * @method array findByActortoid(int $actorToId) Return ActorActiveRelationQuestion objects filtered by the actorToId column
 * @method array findByQuestionid(int $questionId) Return ActorActiveRelationQuestion objects filtered by the questionId column
 *
 * @package    propel.generator.actors.classes.om
 */
abstract class BaseActorActiveRelationQuestionQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseActorActiveRelationQuestionQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ActorActiveRelationQuestion', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ActorActiveRelationQuestionQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ActorActiveRelationQuestionQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ActorActiveRelationQuestionQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ActorActiveRelationQuestionQuery) {
            return $criteria;
        }
        $query = new ActorActiveRelationQuestionQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34, 56), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$actorFromId, $actorToId, $questionId]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ActorActiveRelationQuestion|ActorActiveRelationQuestion[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ActorActiveRelationQuestionPeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1], (string) $key[2]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ActorActiveRelationQuestionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ActorActiveRelationQuestion A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ACTORFROMID`, `ACTORTOID`, `QUESTIONID` FROM `actors_activeRelationQuestions` WHERE `ACTORFROMID` = :p0 AND `ACTORTOID` = :p1 AND `QUESTIONID` = :p2';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->bindValue(':p2', $key[2], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ActorActiveRelationQuestion();
            $obj->hydrate($row);
            ActorActiveRelationQuestionPeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1], (string) $key[2])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ActorActiveRelationQuestion|ActorActiveRelationQuestion[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ActorActiveRelationQuestion[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ActorActiveRelationQuestionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(ActorActiveRelationQuestionPeer::ACTORFROMID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(ActorActiveRelationQuestionPeer::ACTORTOID, $key[1], Criteria::EQUAL);
        $this->addUsingAlias(ActorActiveRelationQuestionPeer::QUESTIONID, $key[2], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ActorActiveRelationQuestionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(ActorActiveRelationQuestionPeer::ACTORFROMID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(ActorActiveRelationQuestionPeer::ACTORTOID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $cton2 = $this->getNewCriterion(ActorActiveRelationQuestionPeer::QUESTIONID, $key[2], Criteria::EQUAL);
            $cton0->addAnd($cton2);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the actorFromId column
     *
     * Example usage:
     * <code>
     * $query->filterByActorfromid(1234); // WHERE actorFromId = 1234
     * $query->filterByActorfromid(array(12, 34)); // WHERE actorFromId IN (12, 34)
     * $query->filterByActorfromid(array('min' => 12)); // WHERE actorFromId > 12
     * </code>
     *
     * @see       filterByActor()
     *
     * @param     mixed $actorfromid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorActiveRelationQuestionQuery The current query, for fluid interface
     */
    public function filterByActorfromid($actorfromid = null, $comparison = null)
    {
        if (is_array($actorfromid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ActorActiveRelationQuestionPeer::ACTORFROMID, $actorfromid, $comparison);
    }

    /**
     * Filter the query on the actorToId column
     *
     * Example usage:
     * <code>
     * $query->filterByActortoid(1234); // WHERE actorToId = 1234
     * $query->filterByActortoid(array(12, 34)); // WHERE actorToId IN (12, 34)
     * $query->filterByActortoid(array('min' => 12)); // WHERE actorToId > 12
     * </code>
     *
     * @see       filterByActor()
     *
     * @param     mixed $actortoid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorActiveRelationQuestionQuery The current query, for fluid interface
     */
    public function filterByActortoid($actortoid = null, $comparison = null)
    {
        if (is_array($actortoid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ActorActiveRelationQuestionPeer::ACTORTOID, $actortoid, $comparison);
    }

    /**
     * Filter the query on the questionId column
     *
     * Example usage:
     * <code>
     * $query->filterByQuestionid(1234); // WHERE questionId = 1234
     * $query->filterByQuestionid(array(12, 34)); // WHERE questionId IN (12, 34)
     * $query->filterByQuestionid(array('min' => 12)); // WHERE questionId > 12
     * </code>
     *
     * @see       filterByProfileForm()
     *
     * @param     mixed $questionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorActiveRelationQuestionQuery The current query, for fluid interface
     */
    public function filterByQuestionid($questionid = null, $comparison = null)
    {
        if (is_array($questionid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ActorActiveRelationQuestionPeer::QUESTIONID, $questionid, $comparison);
    }

    /**
     * Filter the query by a related Actor object
     *
     * @param   Actor $actor The related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ActorActiveRelationQuestionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByActor($actor, $comparison = null)
    {
        if ($actor instanceof Actor) {
            return $this
                ->addUsingAlias(ActorActiveRelationQuestionPeer::ACTORFROMID, $actor->getId(), $comparison)
                ->addUsingAlias(ActorActiveRelationQuestionPeer::ACTORTOID, $actor->getId(), $comparison);
        } else {
            throw new PropelException('filterByActor() only accepts arguments of type Actor');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Actor relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ActorActiveRelationQuestionQuery The current query, for fluid interface
     */
    public function joinActor($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Actor');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Actor');
        }

        return $this;
    }

    /**
     * Use the Actor relation Actor object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ActorQuery A secondary query class using the current class as primary query
     */
    public function useActorQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinActor($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Actor', 'ActorQuery');
    }

    /**
     * Filter the query by a related ProfileForm object
     *
     * @param   ProfileForm|PropelObjectCollection $profileForm The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ActorActiveRelationQuestionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProfileForm($profileForm, $comparison = null)
    {
        if ($profileForm instanceof ProfileForm) {
            return $this
                ->addUsingAlias(ActorActiveRelationQuestionPeer::QUESTIONID, $profileForm->getId(), $comparison);
        } elseif ($profileForm instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ActorActiveRelationQuestionPeer::QUESTIONID, $profileForm->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProfileForm() only accepts arguments of type ProfileForm or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProfileForm relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ActorActiveRelationQuestionQuery The current query, for fluid interface
     */
    public function joinProfileForm($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProfileForm');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProfileForm');
        }

        return $this;
    }

    /**
     * Use the ProfileForm relation ProfileForm object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProfileFormQuery A secondary query class using the current class as primary query
     */
    public function useProfileFormQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProfileForm($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProfileForm', 'ProfileFormQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ActorActiveRelationQuestion $actorActiveRelationQuestion Object to remove from the list of results
     *
     * @return ActorActiveRelationQuestionQuery The current query, for fluid interface
     */
    public function prune($actorActiveRelationQuestion = null)
    {
        if ($actorActiveRelationQuestion) {
            $this->addCond('pruneCond0', $this->getAliasedColName(ActorActiveRelationQuestionPeer::ACTORFROMID), $actorActiveRelationQuestion->getActorfromid(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(ActorActiveRelationQuestionPeer::ACTORTOID), $actorActiveRelationQuestion->getActortoid(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond2', $this->getAliasedColName(ActorActiveRelationQuestionPeer::QUESTIONID), $actorActiveRelationQuestion->getQuestionid(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1', 'pruneCond2'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

}
