<?php

namespace Egytca\Statements;

class BinaryInvertingStatement extends BinaryStatement {

	private $operatorMap = [
		'AND' => 'OR',
		'OR' => 'AND',
	];

	function __construct($operator, Statement $operand1, Statement $operand2) {
		parent::__construct($operator, $this->operatorMap, $operand1, $operand2);
	}

	function invert() {
		$this->operand1->invert();
		$this->operand2->invert();
		$this->invertOperator();
		return $this;
	}
}
