<?php

namespace Egytca;

use Criteria;
use Exception;

trait Order {

	abstract protected function getOrderPeers();

	private function getOrderColumn() {
		$peer = self::PEER;
		return $peer::ORDER;
	}

	private function getAscOrderCriteria() {
		$peer = self::PEER;
		$ascOrderCriteria = new Criteria($peer::DATABASE_NAME);
		$ascOrderCriteria->addAscendingOrderByColumn($this->getOrderColumn());
		return $ascOrderCriteria;
	}

	function isOrderUnique() {

		$orderPeers = $this->getOrderPeers();

		foreach ($orderPeers as $orderPeer) {
			if ($this === $orderPeer) // when $this is part of multiple unsaved elements it may appear as an $orderPeer
				continue;
			if ($this->getOrder() == $orderPeer->getOrder())
				return false;
		}
		return true;
	}

	function setOrderLast() {
		$orderCriteria = $this->getAscOrderCriteria();
		$lastItem = $this->getOrderPeers($orderCriteria)->getLast();
		$thisOrder = $lastItem ? ($lastItem->getOrder() + 1) : 1;
		$this->setOrder($thisOrder);
	}

    function _preSave(PropelPDO $con = null) {

        if ($this->getOrder()) {
			if ($this->isNew() || $this->isColumnModified($this->getOrderColumn())) { // has new order -> check uniqueness
				if (!$this->isOrderUnique())
					throw new Exception('order must be unique');
			}
			// has unchanged order -> do nothing
		} else {
			if ($this->isNew()) { // new item, no order -> calculate and assign
				$this->setOrderLast();
			} else { // existent item, no order -> error
				throw new Exception('order required');
			}
		}

		return true;
    }
}
