<?php

namespace Egytca\ErrorReporting;

// Creo que ya el hack no hace falta, no se usa la escritura en directorio y la ruta a las clases Common y Emailmanagement son relativas.
/* +++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* + when shutdown function triggers context is lost + */
/* +++++++++++ along with pwd. so... hack! +++++++++++ */
$matches;
preg_match("/^.*WEB-INF/", __DIR__, $matches);
global $webInfHack;
$webInfHack = $matches[0];
/* ++++++++++++++++++++++++++++++++++++++++++++++++++ */

/**
 * Clase para manejo de reporte de errores
 *
 */

require_once(__DIR__ . '/../Common.class.php');
require_once(__DIR__ . '/../EmailManagement.php');

use Common;
use Egytca\Utils;
use EmailManagement;
use Exception;

class ErrorReport {

	private $message;
	private $datetime;

	function __construct($message = 'unknown error', $datetime = null) {
		$this->datetime = $datetime ? $datetime : date('Y-m-d H:i:s (T)');
		$this->message = $message;
	}

	static function createFromException($e) {
		$message = $e->__toString();
		return new self($message);
	}

	static function createFromError($type , $message, $file, $line) {
		$message = 'Error ' . ErrorCodeString::get($type) . " with message $message \n".
			"thrown in file $file on line $line";
		return new self($message);
	}

	static function getErrorFilesDir() {
		global $webInfHack;
		return "$webInfHack/generated-files/errors";
	}

	/*

	probar

	static function createFromFile($filename) {
		$fullFilename = self::getErrorFilesDir() . '/' . $filename;
		$fileContents = file_get_contents($fullFilename);
		$parts = explode("\n", $fileContents, 2);
		return new self($parts[1], $parts[0]);
	}

	function sendToFile() {
		$fileContents = $this->datetime . "\n" . $this->message;
		$filename = uniqid();
		Utils::ensureWritable(self::getErrorFilesDir());
		$fullFilename = self::getErrorFilesDir() . '/' . $filename;
		if (!file_put_contents($fullFilename, $fileContents))
			throw new Exception("error writing \"$fullFilename\"");
	}
	*/

	/**
	 * Obtiene el mensaje de error
	 */
	function getMessage() {
		return $this->message;
	}

	/**
	 * Genera el reporte de error y lo envia por mail
	 */
	function sendByMail() {
		$reportMessage = '<pre>HTTP HOST: ' . $_SERVER['HTTP_HOST'] . substr($_SERVER['REQUEST_URI'], 0, strrpos($_SERVER['REQUEST_URI'], '/')) . "\n\n";
		$reportMessage .= 'QUERY STRING: ' . $_SERVER['QUERY_STRING'] . "\n\n"; // double quotes required for \n
		$reportMessage .= "ERROR REPORT:\n\n" . $this->datetime . "\n\n" . $this->message . '</pre>'; // double quotes required for \n

		$manager = new EmailManagement();

		$user = Common::getLoggedUser();
		$userInfo = is_object($user) ? $user->getUsername() : 'Visitor';

		global $system;
		$subject = $_SERVER['HTTP_HOST'] . ' ## ' . $system['config']['system']['parameters']['siteShortName'] . ' / Error - ' . $userInfo;
		$email = explode(',', $system['config']['system']['parameters']['debugMail']);
		$mailFrom = $system['config']['system']['parameters']['fromEmail'];

		$message = $manager->createHTMLMessage($subject, $reportMessage);

		return $manager->sendMessage($email, $mailFrom, $message);

	}
}
