<?php

namespace Egytca;

use JsonSerializable;

class DebugData implements JsonSerializable {

    private $data = [];

    function set($name, $data) {
        $this->data[$name] = $data;
    }

    function get($name) {
        return isset($this->data[$name]) ? $this->data[$name] : null;
    }

    function getAll() {
        return $this->data;
    }

    function count($name) {
        return isset($this->data[$name]) ? count($this->data[$name]) : 0;
    }

    function countAll() {
        return count($this->data);
    }

    function jsonSerialize() {
        return $this->data;
    }
}