<?php

//namespace Egytca;

/**
* Config XML Management
*/
class ConfigXmlManagement
{

	/**
	 * Diff entre dos arrays - array_diff_assoc_recursive
	 *
	 * @param  array $array1 Array a comparar
	 * @param  array $array2 Array a comparar
	 * @return array         Array con diferencias
	 */
	public function diff($array1, $array2)
	{
		foreach($array1 as $key => $value)
		{
			if(is_array($value))
			{
				  if(!isset($array2[$key]))
					  $difference[$key] = $value;
				  elseif(!is_array($array2[$key]))
					  $difference[$key] = $value;
				  else
				  {
					  $new_diff = $this->diff($value, $array2[$key]);
					  if($new_diff != FALSE)
							$difference[$key] = $new_diff;
				  }
			  }
			  elseif(!isset($array2[$key]) || $array2[$key] != $value)
				  $difference[$key] = $value;
		}
		return !isset($difference) ? 0 : $difference;
	}

	/**
	 * Agrego a un objeto SimpleXML datos desde un array.
	 *
	 * @param  SimpleXMLElement $object [description]
	 * @param  array            $data   [description]
	 * @return [type]                   [description]
	 */
	public function toXml(SimpleXMLElement $object, array $data)
	{
		foreach ($data as $key => $value) {
			if (is_array($value)) {
				$new_object = $object->addChild($key);
				$this->toXml($new_object, $value);
			} else {
					if (is_numeric( $key ))
						$key = "numeric_$key";
				$object->addChild($key, $value);
			}
		}
	}

	public function getLocalConfig($dir = null) {
		global $appDir;

		if (is_null($dir))
			$localConfigDir = $appDir . '/config/config.local.data';
		else
			$localConfigDir = $appDir . $dir;

		//verify file exists
		return unserialize(file_get_contents($localConfigDir));
	}

	public function getBaseConfigData($dir = null) {
		global $appDir;

		if (is_null($dir))
			$baseConfigDir = $appDir . '/config/config.data';
		else
			$baseConfigDir = $appDir . $dir;

		return unserialize(file_get_contents($baseConfigDir));
	}

	public function getBaseConfigXmlArray() {
		global $appDir;

		$baseConfig = simplexml_load_string(file_get_contents($appDir . '/config/config.xml'), "SimpleXMLElement", LIBXML_NOCDATA);
		$baseConfigJson = json_encode($baseConfig);

		return json_decode($baseConfigJson, TRUE);
	}
}