var egytcaDirectives = angular.module('egytcaDirectives', ['egytcaDirectivesIcons']);

egytcaDirectives.directive('entityLink', function() {
	return {
		restrict: 'A',
		scope: {
			entity: '=entityLink'
		},
		link: function(scope, element, attrs) {

			if ('entityType' in attrs) {
				egytcaDeprecate('attribute entityType is no longer needed and will be removed in the future');
			}

			var action = attrs.action || 'edit';
			var entityType = ('entityType' in attrs) ? attrs.entityType : scope.entity._class;
			element.attr('href', RouteConfig.routeTo(entityType, action, scope.entity));
		}
	};
});

egytcaDirectives.directive('entityEdit', function() {
	return {
		restrict: 'E',
		scope: {
			entity: '=',
			entityParent: '=',
			saveFn: '=',
			cancelFn: '='
		},
		templateUrl: function(elem, attr) {
			return RouteConfig.routeTo(attr.entityType, 'editTemplate');
		}
	};
});

egytcaDirectives.directive('entityView', function() {
	return {
		restrict: 'E',
		scope: {
			entity: '=',
			entityParent: '='
		},
		templateUrl: function(elem, attr) {
			return RouteConfig.routeTo(attr.entityType, 'viewTemplate');
		}
	};
});

egytcaDirectives.directive('entityAutocomplete', function() {
	return {
		restrict: 'E',
		scope: {
			value: '='
		},
		template: function(elem, attr) {
			return '' +
'<div class="ui-front">' +
	'<input type="text" size="50" class="autocompleteIcon">' +
'</div>';
		},
		link: function(scope, element, attrs) {

			if (!attrs.type)
				throw 'attribute \'type\' is mandatory';

			var div = element[0].children[0];
			var input = $(div).find('input');

			if (attrs.class) {
				input.addClass(attrs.class);
			}

			input.val(attrs.label);

			var previousLabel = input.val();
			var previousValue = scope.value;

			var updateLink = function() {
				var id = scope.value;
				var link = $(div).find('a');
				if (link)
					$(link).remove();
				if (id) {
					var href = RouteConfig.routeTo(attrs.type, 'edit') + '&id=' + id;
					var newLink = '<a href="' + href + '" class="icon iconFollow parent-link" style="float: left; margin-left:5px" title="Go"></a>';
					$(div).append(newLink);
				}
			}

			updateLink();

			$(input).autocomplete({
				source: 'Main.php?do=commonAutocompleteListNewX&type=json&object=' + attrs.type,
				change: function(event, ui) {
					// si no se selecciona un item, vuelve al valor inicial
					$(this).val(ui.item ? ui.item.label : previousLabel);
					updateLink();
				},
				select: function(event, ui) {

					if (ui.item.value === null) {
						$(this).val(previousLabel); // revert label
					} else {
						$(this).val(ui.item.label);
						scope.$apply(function() {
							scope.value = previousValue = ui.item.value;
						});
						previousLabel = ui.item.label;
					}

					updateLink();

					return false;
				},
				response: function(event, ui) {
					var menu = ui.content;
					if (menu.length === 0)
						menu.push({ label: 'No hay resultados' , value: null })
				},
				minLength: 3
			});
		}
	};
});
