<?php
/**
 * Formacion (array) de Variables de configuracion de modulos
 *
 * @package config
 * @author Modulos Empresarios / Egytca
 * @copyright Copyright (c) 2017, Egytca
 */
return array(
	"global" => array(
		"debugMode" => true,
		"warnDeprecated" => false,
		"noSecurity" => false,
		"noCheckLogin" => false,
		"nonConcurrentSession" => false,
		"developmentMode" => true,
		"showSwiftExceptions" => false,
		"showPropelExceptions" => false,
		"doLog" => true,
		"unifiedLogin" => true,
		"unifiedUsernames" => true,
		"backupTimeLimit" => 720,
		"tmpwatch" => "/usr/sbin/tmpwatch",
		"loginFailureThreshold" => 10,
		"loginFailureThresholdTime" => 5,
		"loginFailureBlockedTimeTime" => 15,
		"securityFailureThreshold" => 10,
		"securityFailureThresholdTime" => 15,
		"securityFailureBlockedTime" => 15
	),
	"users" => array(
		"useTimezones" => false,
		"forceFirstPasswordChange" => true,
		"askForNewPasswordOnRecovery" => false,
		"useFilterByUserGroup" => true,
		"passwordRecoveryExpirationTimeInHours" => 24,
		"loginFailureThreshold" => 10,
		"loginFailureThresholdTime" => 5,
		"loginFailureBlockedTimeTime" => 15,
		"internalMail" => true
	),
	"positions" => array(
		"stopOnPlanning" => false,
		"useFemale" => true,
		"treeRootType" => 6,
		"lowestType" => 11,
		"highestType" => 17,
		"userGroupType" => 16,
		"activePositionTypes" => array(
			11 => 'Secretary',
			12 => 'Sub secretary',
			13 => 'General Director',
			14 => 'Director',
			15 => 'Sub Director',
			16 => 'Coordinator'
		)
	),
	"objectives" => array(
		"verifyGroupWriteAccess" => true,
		"useFilterByUserGroup" => true,
		"useLogs" => true,
		"logsPerPage" => 5,
		"useMinorChanges" => false,
		"useRegions" => false,
		"regionsTypes" => array(
			"Commune" => 11,
			"Neighborhood" => 12
		),
		"positionsTypes" => array(
			11 => 'Secretary',
			12 => 'Sub secretary',
			13 => 'General Director',
			14 => 'Director',
			15 => 'Sub Director',
			16 => 'Coordinator'
		)
	),
	"projects" => array(
		"verifyGroupWriteAccess" => true,
		"useFilterByUserGroup" => true,
		"useLogs" => true,
		"logsPerPage" => 5,
		"useMinorChanges" => false,
		"useCoordinates" => false,
		"useRegions" => true,
		"regionsTypes" => array(
			"Commune" => 11,
			"Neighborhood" => 12
		),
		"positionsTypes" => array(
			11 => 'Secretary',
			12 => 'Sub secretary',
			13 => 'General Director',
			14 => 'Director',
			15 => 'Sub Director',
			16 => 'Coordinator'
			),
		"useDocuments" => true,
		"showAttachments" => false,
		"useDisbursements" => false,
		"useCodeAux" => false,
		"useFinancingSources" => false,
		"showActivitiesDates" => true
	),
	"projectsActivities" => array(
		"useDocuments" => true,
		"showAttachments" => false
	),
	"planning" => array(
		"startingYear" => 2016,
		"endingYear" => 2019,
		"minYear" => 2016,
		"maxYear" => 2019
	),
	"notifications" => array(
		"activeNotificationTypes" => array(
			1 => 'Alert',
			2 => 'Schedule',
		)
	),
	"documents" => array(
		"usePasswords" => false,
		"useKeywords" => false,
		"useAuthors" => false,
		"useFullTextSearch" => false,
		"catdocPath" => "/usr/local/bin/",
		"pdftotextPath" => "/usr/local/bin/",
		"maxUploadSize" => '15M',
		"useSWFUploader" => false,
		"documentTypes" => array(
			"Word" => "doc,docx",
			"Excel" => "xls,xlsx",
			"Powerpoint" => "ppt,pptx",
			"Pdf" => "pdf",
			"Images" => "jpeg,jpg,png,gif"
			)
	),
	"constructions" => array(
		"inspectionPhotosDir" => 'images/constructionInspection'
	),
	"regions" => array(
		"treeRootType" => 3,
		"lowestType" => 4,
		"highestType" => 12,
		"activeRegionTypes" => array(
			"Subregion" => 4,
			"State" => 5,
			"County" => 6,
			"District" => 7,
			"Municipality" => 8,
			11 => 'Commune',
			12 => 'Neighborhood'
		),
		"activeFields" => array(   // All available: 'postalCode', 'latitude', 'longitude', 'population', 'populationYear', 'area', 'capital' or 'none'
			 'latitude', 'longitude', 'area'
		),
		"useRegionPlotMap" => false,
	),
	"task" => array(
		"remoteProtocol" => "http",
		"remoteUrl" => "updates.tablero.online",
		"remoteSshPort" => "6621",
		"remoteDir" => "public_html/municipios",
		"remoteFile" => "serverlist.xml",
		"remoteUsername" => "updatestbl",
		"propelVersion" => "1.6.7",
		"gitUrl" => "git@gitlab.com:WeTech/pdigital.git",
		"gitRemote" => "origin",
		"gitBranch" => "master"
	),
	"actors" => array(
		"toStringFormat" => "Name Surname (Institution)" // "Surname, Name (Institution)"
	),
	"issues" => array(
		"logsPerPage" => 5,
		"basic" => true
	),
	"medias" => array(
		"useAudiences" => true,
		"useMarkets" => false
	),
	"headlines" => array(
		"useClients" => false,
		"uniqueByCampaigns" => true,
		"relationToHeadlines" => false,
		"parserTimeLimit" => 720,
		"searchEngineUrl" => "http://news.google.com",
		"clippingsPath" => "./WEB-INF/classes/modules/headlines/files/clipping/",
		"clippingsTmpPath" => "./WEB-INF/classes/modules/headlines/files/clipping/tmp/",
		"clippingApp" => "./WEB-INF/classes/modules/headlines/classes/urlcaptor/wkhtmltoimage",
		"phantomjsBin" => "WEB-INF/classes/includes/phantomjs/bin/phantomjs",
		"htmlRenderer" => "PhantomHtmlRenderer", // [ PhantomHtmlRenderer | WebkitHtmlRenderer ]
		"contentProvider" => array(
			"strategies" => array(
				"default"    => "GoogleNewsStrategy",
				"bing"       => "BingStrategy",
				"bingNews"   => "BingNewsStrategy",
				"compound"   => "CompoundStrategy",
				"googleNews" => "GoogleNewsStrategy",
				"google"     => "GoogleStrategy",
				"topsy"      => "TopsyStrategy"
			),
			"strategies_options" => array(
				// "twitter" => "Twitter",
				"bing"       => "Bing",
				"bingNews"   => "Bing News",
				"googleNews" => "Google News",
				"google"     => "Google",
				"topsy"      => "Topsy"
			),
			"errors" => array(
				"service_unavailable" => "Ha realizado muchas consultas, espere 5 min e intente de nuevo.",
				"empty_response"      => "No hubo respuesta",
				"invalid_headline"    => "Hay algunos resultados con errores"
			)
		),
		//"typeMap" => array(
		//	'web' => array('class' => 'WebHeadline', 'url' => 'http://localhost/htdocs2/apps/trunk/GCABA/mdp/rss1.xml'),
		//	'multimedia' => array('class' => 'MultimediaHeadline', 'url' => 'http://localhost/htdocs2/apps/trunk/GCABA/mdp/rss2.xml'),
		//	'press' => array('class' => 'PressHeadline', 'url' => 'http://localhost/htdocs2/apps/trunk/GCABA/mdp/rss3.xml')
		//),
		"feedBackupsPath" => "./WEB-INF/classes/modules/headlines/files/feeds"
	)
);