<script>
	var RouteConfig = {

		config: |-$egytca.routeConfig-|,
		urlPrefix: 'Main.php?do=',

		resolveType: function(type) {
			return type.replace(/_/g, '\\');
		},

		getDefaultPrefix: function(type) {
			var matches = type.match(/^Egytca\\Modules\\(\w+)\\(\w+)$/);
			if (matches) {
				return lcfirst(matches[1]) + ucfirst(matches[2]);
			} else {
				return lcfirst(type) + 's';
			}
		},

		actionFor: function(type, action) {

			type = this.resolveType(type);

			if (type in this.config) {
				var typeConfig = this.config[type];
				if ( ('actions' in typeConfig) && (action in typeConfig.actions) ) { // rule exception exists
					return typeConfig.actions[action];
				} else { // no rule exception
					if ('prefix' in typeConfig) { // if prefix is defined, use it. otherwise fallback to default
						return typeConfig.prefix + ucfirst(action);
					}
				}
			}

			return this.getDefaultPrefix(type) + ucfirst(action); // default
		},

		routeTo: function(type, action, entity) {
			var route = this.urlPrefix + this.actionFor(type, action);
			if (entity !== undefined)
				route += '&id=' + entity.Id;
			return route;
		}
	};
</script>
