
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

-- ---------------------------------------------------------------------
-- medias_media
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `medias_media`;

CREATE TABLE `medias_media`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Id log',
    `name` VARCHAR(200) NOT NULL COMMENT 'Nombre del medio',
    `address` VARCHAR(200) NOT NULL COMMENT 'Direccion',
    `phone` VARCHAR(200) NOT NULL COMMENT 'Telefono',
    `url` VARCHAR(200) NOT NULL COMMENT 'Direccion web',
    `mediakitUrl` VARCHAR(200) NOT NULL COMMENT 'Direccion del mediakit',
    `fax` VARCHAR(200) NOT NULL COMMENT 'Fax',
    `email` VARCHAR(200) NOT NULL COMMENT 'Direccion email',
    `receptionist` VARCHAR(200) NOT NULL COMMENT 'Recepcionista',
    `description` MEDIUMTEXT COMMENT 'Descripcion del medio',
    `typeId` INTEGER COMMENT 'ID media destino',
    `groupId` INTEGER COMMENT 'ID media destino',
    `importance` TINYINT COMMENT 'Importancia del medio',
    `bias` TINYINT COMMENT 'Afinidad del medio',
    `aliasOf` INTEGER COMMENT 'ID media referenciado',
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`),
    INDEX `medias_media_FI_1` (`typeId`),
    INDEX `medias_media_FI_2` (`groupId`),
    INDEX `medias_media_FI_3` (`aliasOf`),
    CONSTRAINT `medias_media_FK_1`
        FOREIGN KEY (`typeId`)
        REFERENCES `medias_type` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `medias_media_FK_2`
        FOREIGN KEY (`groupId`)
        REFERENCES `medias_media` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `medias_media_FK_3`
        FOREIGN KEY (`aliasOf`)
        REFERENCES `medias_media` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Archivo de medios';

-- ---------------------------------------------------------------------
-- medias_type
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `medias_type`;

CREATE TABLE `medias_type`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Id tipo medio',
    `name` VARCHAR(200) NOT NULL COMMENT 'Tipo de medio',
    PRIMARY KEY (`id`),
    UNIQUE INDEX `medias_type_U_1` (`name`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Tipo de medios';

-- ---------------------------------------------------------------------
-- medias_market
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `medias_market`;

CREATE TABLE `medias_market`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Id mercado del medio',
    `name` VARCHAR(200) NOT NULL COMMENT 'Mercado del medio',
    PRIMARY KEY (`id`),
    UNIQUE INDEX `medias_market_U_1` (`name`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Tipo de medios';

-- ---------------------------------------------------------------------
-- medias_marketRelation
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `medias_marketRelation`;

CREATE TABLE `medias_marketRelation`
(
    `mediaId` INTEGER NOT NULL COMMENT 'ID media origen',
    `mediaMarketId` INTEGER NOT NULL COMMENT 'ID media destino',
    PRIMARY KEY (`mediaId`,`mediaMarketId`),
    INDEX `medias_marketRelation_FI_2` (`mediaMarketId`),
    CONSTRAINT `medias_marketRelation_FK_1`
        FOREIGN KEY (`mediaId`)
        REFERENCES `medias_media` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `medias_marketRelation_FK_2`
        FOREIGN KEY (`mediaMarketId`)
        REFERENCES `medias_market` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM COMMENT='Tabla de relaciones de medios y sus mercados';

-- ---------------------------------------------------------------------
-- medias_audience
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `medias_audience`;

CREATE TABLE `medias_audience`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Id mercado de la audiencia',
    `name` VARCHAR(200) NOT NULL COMMENT 'Mercado del medio',
    PRIMARY KEY (`id`),
    UNIQUE INDEX `medias_audience_U_1` (`name`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Tipo de medios';

-- ---------------------------------------------------------------------
-- medias_audienceRelation
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `medias_audienceRelation`;

CREATE TABLE `medias_audienceRelation`
(
    `mediaId` INTEGER NOT NULL COMMENT 'ID media origen',
    `mediaAudienceId` INTEGER NOT NULL COMMENT 'ID media destino',
    PRIMARY KEY (`mediaId`,`mediaAudienceId`),
    INDEX `medias_audienceRelation_FI_2` (`mediaAudienceId`),
    CONSTRAINT `medias_audienceRelation_FK_1`
        FOREIGN KEY (`mediaId`)
        REFERENCES `medias_media` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `medias_audienceRelation_FK_2`
        FOREIGN KEY (`mediaAudienceId`)
        REFERENCES `medias_audience` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM COMMENT='Tabla de relaciones de medios y sus audiencias';

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
