
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

-- ---------------------------------------------------------------------
-- headlines_headline
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `headlines_headline`;

CREATE TABLE `headlines_headline`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Headline Id',
    `name` VARCHAR(255) NOT NULL COMMENT 'Headline',
    `content` MEDIUMTEXT COMMENT 'Headline content',
    `datePublished` DATETIME COMMENT 'Fecha de publicacion',
    `headlineDate` DATETIME COMMENT 'Fecha del titular',
    `url` VARCHAR(255) COMMENT 'Url del titular',
    `twitts` INTEGER COMMENT 'Twitts del titular',
    `fcb` INTEGER COMMENT 'Fcb del titular',
    `gplus` INTEGER COMMENT 'G+ del titular',
    `comment` INTEGER COMMENT 'Comentario del titular',
    `picture` TINYINT(1) COMMENT 'Foto del titular',
    `campaignId` INTEGER COMMENT 'Campaign ID',
    `mediaId` INTEGER COMMENT 'Media ID',
    `value` TINYINT DEFAULT 0 COMMENT 'Valoracion de la noticia',
    `relevance` TINYINT DEFAULT 0 COMMENT 'Valoracion del medio',
    `internalId` VARCHAR(255) NOT NULL COMMENT 'Headline internal Id',
    `page` INTEGER COMMENT 'Pagina',
    `section` VARCHAR(255) COMMENT 'Seccion',
    `author` VARCHAR(255) COMMENT 'Autor',
    `source` VARCHAR(255) COMMENT 'Fuente',
    `summary` VARCHAR(255) COMMENT 'Resumen',
    `caption` VARCHAR(255),
    `program` VARCHAR(255),
    `strategy` VARCHAR(50) COMMENT 'Estrategia que parseo el titular',
    `length` INTEGER COMMENT 'Duracion en segs o superficie en mm2',
    `agenda` TINYINT DEFAULT 0 COMMENT 'Tipo de agenda',
    `headlineScope` TINYINT DEFAULT 0 COMMENT 'Ambito',
    `processed` BOOL DEFAULT 0 COMMENT 'Indica si esta procesado',
    `class_key` INTEGER,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    `issuesCount` INTEGER,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `headlines_headline_U_1` (`internalId`),
    INDEX `headlines_headline_FI_1` (`mediaId`),
    CONSTRAINT `headlines_headline_FK_1`
        FOREIGN KEY (`mediaId`)
        REFERENCES `medias_media` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Headline';

-- ---------------------------------------------------------------------
-- headlines_actor
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `headlines_actor`;

CREATE TABLE `headlines_actor`
(
    `headlineId` INTEGER NOT NULL COMMENT 'Headline ID',
    `actorId` INTEGER NOT NULL COMMENT 'Actor ID',
    `actorType` INTEGER NOT NULL COMMENT 'Actor type ID',
    `role` INTEGER COMMENT 'Actor role',
    PRIMARY KEY (`headlineId`,`actorId`,`actorType`),
    INDEX `headlines_actor_FI_2` (`actorId`),
    CONSTRAINT `headlines_actor_FK_1`
        FOREIGN KEY (`headlineId`)
        REFERENCES `headlines_headline` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `headlines_actor_FK_2`
        FOREIGN KEY (`actorId`)
        REFERENCES `actors_actor` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM COMMENT='Headlines / Actors';

-- ---------------------------------------------------------------------
-- headlines_issue
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `headlines_issue`;

CREATE TABLE `headlines_issue`
(
    `headlineId` INTEGER NOT NULL COMMENT 'Headline ID',
    `issueId` INTEGER NOT NULL COMMENT 'Issues ID',
    PRIMARY KEY (`headlineId`,`issueId`),
    INDEX `headlines_issue_FI_2` (`issueId`),
    CONSTRAINT `headlines_issue_FK_1`
        FOREIGN KEY (`headlineId`)
        REFERENCES `headlines_headline` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `headlines_issue_FK_2`
        FOREIGN KEY (`issueId`)
        REFERENCES `issues_issue` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM COMMENT='Headlines / Issues';

-- ---------------------------------------------------------------------
-- headlines_headlineDocument
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `headlines_headlineDocument`;

CREATE TABLE `headlines_headlineDocument`
(
    `headlineId` INTEGER NOT NULL,
    `documentId` INTEGER NOT NULL,
    PRIMARY KEY (`headlineId`,`documentId`),
    INDEX `headlines_headlineDocument_FI_2` (`documentId`),
    CONSTRAINT `headlines_headlineDocument_FK_1`
        FOREIGN KEY (`headlineId`)
        REFERENCES `headlines_headline` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `headlines_headlineDocument_FK_2`
        FOREIGN KEY (`documentId`)
        REFERENCES `documents_document` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci';

-- ---------------------------------------------------------------------
-- headlines_tag
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `headlines_tag`;

CREATE TABLE `headlines_tag`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Tag Id',
    `name` VARCHAR(120) NOT NULL COMMENT 'Etiquetas de Headline',
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `headlines_tag_U_1` (`name`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Etiquetas de titulares';

-- ---------------------------------------------------------------------
-- headlines_headlineTags
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `headlines_headlineTags`;

CREATE TABLE `headlines_headlineTags`
(
    `headlineId` INTEGER NOT NULL COMMENT 'Headline ID',
    `tagId` INTEGER NOT NULL COMMENT 'Etiqueta ID',
    PRIMARY KEY (`headlineId`,`tagId`),
    INDEX `headlines_headlineTags_FI_2` (`tagId`),
    CONSTRAINT `headlines_headlineTags_FK_1`
        FOREIGN KEY (`headlineId`)
        REFERENCES `headlines_headline` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `headlines_headlineTags_FK_2`
        FOREIGN KEY (`tagId`)
        REFERENCES `headlines_tag` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM COMMENT='Headlines / Etiquetas';

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
