
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

-- ---------------------------------------------------------------------
-- campaigns_campaign
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `campaigns_campaign`;

CREATE TABLE `campaigns_campaign`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Identificacion de la Campaign',
    `name` VARCHAR(255) COMMENT 'Nombre de la Campaign',
    `type` INTEGER COMMENT 'Tipo de Campaign',
    `startDate` DATE COMMENT 'Fecha inicio de la campaign',
    `finishDate` DATE COMMENT 'Fecha final de la campaign',
    `clientId` INTEGER COMMENT 'Cliente asociado',
    `description` TEXT COMMENT 'Descripcion de la Campaign',
    `langCode` CHAR(2) COMMENT 'Idioma de la campaign',
    `defaultKeywords` CHAR(255) COMMENT 'Palabras clave por defecto para prensa',
    `responsible` CHAR(120) COMMENT 'Persona Responsable de la campaign',
    `sources` INTEGER DEFAULT 1 COMMENT 'Indica las fuentes de informacion',
    `searchQueries` TEXT COMMENT 'Busquedas',
    `deleted_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Base de Campaigns';

-- ---------------------------------------------------------------------
-- campaigns_campaignParticipant
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `campaigns_campaignParticipant`;

CREATE TABLE `campaigns_campaignParticipant`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Identificacion del Participante de la Campaign',
    `campaignId` INTEGER NOT NULL COMMENT 'Id de la campaign',
    `objectType` VARCHAR(50) NOT NULL COMMENT 'Tipo de participante',
    `objectId` INTEGER NOT NULL COMMENT 'Id del participante',
    PRIMARY KEY (`id`),
    UNIQUE INDEX `campaigns_campaignParticipant_U_1` (`campaignId`, `objectType`, `objectId`),
    CONSTRAINT `campaigns_campaignParticipant_FK_1`
        FOREIGN KEY (`campaignId`)
        REFERENCES `campaigns_campaign` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Base de participantes en campaignes';

-- ---------------------------------------------------------------------
-- campaigns_campaignCommitment
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `campaigns_campaignCommitment`;

CREATE TABLE `campaigns_campaignCommitment`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Identificacion de Compromiso de la Campaign',
    `campaignId` INTEGER COMMENT 'Id de la Campaign',
    `participantId` INTEGER COMMENT 'Id del participante',
    `responsible` CHAR(255) COMMENT 'Responsables',
    `commitment` TEXT COMMENT 'Descripcion del Compromiso',
    `achieved` BOOL COMMENT 'Logrado',
    `date` DATE NOT NULL COMMENT 'Fecha del compromiso',
    `deleted_at` DATETIME,
    PRIMARY KEY (`id`),
    INDEX `campaigns_campaignCommitment_FI_1` (`campaignId`),
    INDEX `campaigns_campaignCommitment_FI_2` (`participantId`),
    CONSTRAINT `campaigns_campaignCommitment_FK_1`
        FOREIGN KEY (`campaignId`)
        REFERENCES `campaigns_campaign` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `campaigns_campaignCommitment_FK_2`
        FOREIGN KEY (`participantId`)
        REFERENCES `campaigns_campaignParticipant` (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Base de Compromisos de Campaigns';

-- ---------------------------------------------------------------------
-- campaigns_campaignDocument
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `campaigns_campaignDocument`;

CREATE TABLE `campaigns_campaignDocument`
(
    `campaignId` INTEGER NOT NULL,
    `documentId` INTEGER NOT NULL,
    PRIMARY KEY (`campaignId`,`documentId`),
    INDEX `campaigns_campaignDocument_FI_2` (`documentId`),
    CONSTRAINT `campaigns_campaignDocument_FK_1`
        FOREIGN KEY (`campaignId`)
        REFERENCES `campaigns_campaign` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `campaigns_campaignDocument_FK_2`
        FOREIGN KEY (`documentId`)
        REFERENCES `documents_document` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci';

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
