<?php
 class PhpMVC_Log { var $attribute = array(); var $logPtr = NULL; function PhpMVC_Log($key='', $val='') { if($key != '' && $val != '') { $this->setLog($key, $val); } } function setLog($key, $val) { $this->attribute[$key] = $val; } function getLog($key) { if( array_key_exists($key, $this->attribute) ) return $this->attribute[$key]; else return NULL; } function clearLog() { unset($this->attribute); $this->attribute = array(); } function debug($msgString) { echo 'Debug: '.$msgString."\n"; } function warn($msgString) { echo 'Warning: '.$msgString."\n"; } function error($msgString, $error='') { echo 'Error: '.$msgString.' ('.$error.")\n"; } function trace($msgString) { echo 'Trace: '.$msgString."\n"; } function write($msgString, $logFile='log.txt', $mode='w') { if($logFile != '' && $this->logPtr == NULL) { $this->logPtr = @fopen($logFile, $mode); } if($this->logPtr != NULL) { fwrite($this->logPtr, $msgString); } else { echo 'Error writing log file: ['.$logFile.']<br>'; } } function closeLogFile() { if($this->logPtr != NULL) { fclose($this->logPtr); } } } ?>
<?php
 class ActionDispatcher { var $appRequest = NULL; var $appResponse = NULL; var $context = NULL; var $debug = 0; var $including = False; var $info = 'phpmvc.ApplicationDispatcher/1.0'; var $name = NULL; var $pathInfo = NULL; var $queryString = NULL; var $appServerPath = NULL; var $log = NULL; var $uri = NULL; var $actionServer = NULL; function getInfo() { return $this->info; } function &getActionServer() { return $this->actionServer; } function setActionServer(&$actionServer) { $this->actionServer =& $actionServer; } function ActionDispatcher($uri='', $wrapper='', $servletPath='', $pathInfo='', $queryString='', $name='') { $this->log = new PhpMVC_Log(); $this->log->setLog('isDebugEnabled' , False); $this->log->setLog('isInfoEnabled' , False); $this->log->setLog('isTraceEnabled' , False); $this->uri = $uri; $this->wrapper = $wrapper; $this->servletPath= $servletPath; $this->pathInfo = $pathInfo; $this->queryString= $queryString; $this->name = $name; $debug = $this->log->getLog('isDebugEnabled'); if($debug) { $this->log->debug('ActionDispatcher::Constructor('. 'uri='.$this->uri. ', servletPath='.$this->servletPath. ', pathInfo='.$this->pathInfo. ', queryString='.$this->queryString. ', name='.$this->name.')'); } } function forward($uri, &$request, &$response) { $debug = $this->log->getLog('isDebugEnabled'); $trace = $this->log->getLog('isTraceEnabled'); if($trace) $this->log->trace('Start: ActionDispatcher->forward(..)['.__LINE__.']'); $this->uri = $uri; if($response->isCommitted()) { if($debug) { $this->log->debug('  Forward on committed response --> '. 'IllegalStateException'); return 'IllegalStateException'; } $e = $response->resetBuffer(); if($e != NULL) { if($debug) $this->log->debug('  Forward resetBuffer()'. ' returned IllegalStateException: '. $e); return $e; } } $this->setup($request, $response, False); $hrequest = NULL; if( is_subclass_of($request, 'HttpRequestBase') ) $hrequest = $request; $hresponse = NULL; if( is_subclass_of($response, 'HttpResponseBase') ) { $hresponse = $response; } if(($hrequest == NULL) || ($hresponse == NULL)) { if($debug) $this->log->debug(' Non-HTTP Forward'); $this->invoke($request, $response); } elseif( ($this->$appServerPath == NULL) && ($this->pathInfo == NULL) ) { if($debug) $this->log->debug(' Named Dispatcher Forward'); $this->invoke($request, $response); } else { if(debug) $this->log->debug(' HTTP Path Based Forward'); $this->invoke($outerRequest, $response); } if($debug) $this->log->debug(' Committing and closing response'); $respBuff = $response->getResponseBuffer(); $mode = ''; if($mode == 'smtp') { } else { ; echo $respBuff; } } function invoke(&$request, &$response) { $debug = $this->log->getLog('isDebugEnabled'); $trace = $this->log->getLog('isTraceEnabled'); if($trace) $this->log->trace('Start: ActionDispatcher->invoke(..)['.__LINE__.']'); $servlet = NULL; $ioException = NULL; $servletException = NULL; $runtimeException = NULL; if( (is_subclass_of($request, 'HttpRequestBase')) && (is_subclass_of($response, 'HttpResponseBase')) ) { if($debug) $this->log->debug('  Calling HTTP-specific $this->serviceResponse() ('. $this->uri.')'); $this->serviceResponse($request, $response); } else { if($debug) $this->log->debug('  Calling Non-HTTP-specific $this->serviceResponse() (' .$this->uri.')'); $this->serviceResponse($request, $response); } } function serviceResponse(&$request, &$response) { $debug = $this->log->getLog('isDebugEnabled'); $trace = $this->log->getLog('isTraceEnabled'); if($trace) $this->log->trace('Start: ActionDispatcher->serviceResponse(..)['.__LINE__.']'); $resourceURI = $this->uri; $firstChar = substr($resourceURI, 0, 1); if($firstChar == '/' || $firstChar == '\\') { $resourceURI = substr($resourceURI, 1); } $form = $request->getAttribute(Action::getKey('FORM_BEAN_KEY')); $errors = $request->getAttribute( Action::getKey('ERROR_KEY') ); $data = $request->getAttribute( Action::getKey('VALUE_OBJECT_KEY') ); $appConfig = NULL; $appConfig = $request->getAttribute(Action::getKey('APPLICATION_KEY')); $viewConfig = NULL; $viewConfig =& $appConfig->getViewResourcesConfig(); $pageBuff = ''; ob_start(); include $resourceURI; $pageBuff = ob_get_contents(); ob_end_clean(); $response->setResponseBuffer($pageBuff); } function setup($request, $response, $including) { $this->appRequest = $request; $this->appResponse = $response; $this->including = $including; } function unwrapRequest() { } function unwrapResponse() { } function wrapRequest() { } function wrapResponse() { } } ?>
<?php  class ClassPath {   function setClassPath($appServerRootDir='', $subAppPaths='', $osType='') {   if($appServerRootDir == '') {   echo 'Error: ClassPath :- No php.MVC application root directory specified';  exit;  }  $appDirs = array();  $appDirs[] = '';  $appDirs[] = 'WEB-INF';  $appDirs[] = 'WEB-INF/lib-phpmvc';  $appDirs[] = 'WEB-INF/lib-phpmvc/Propel';  if(is_array($subAppPaths)) {   $appDirs = array_merge($appDirs, $subAppPaths);  }  $delim = NULL;  if($osType != '') {   if(stristr($osType,"WIN") || stristr(PHP_OS,"WIN")) {   $delim = ';';  }  elseif(stristr($osType,"UNIX") || stristr(PHP_OS,"LINUX")) {   $delim = ':';  }  elseif(stristr($osType,"MAC") || stristr(PHP_OS,"MAC")) {   $delim = ':';  }  }  if($delim == NULL) {   if(stristr($osType,"WIN")) {   $delim = ';';  }  else {   $delim = ':';  }  }  $path = $appServerRootDir;  $pathToWebInf = $pathToWebInf = preg_replace("/WEB-INF.*$/i", '', $path);  $pathToWebInf = str_replace("\\", "/", $pathToWebInf);  $pathToWebInf = preg_replace("/\/$/i", '', $pathToWebInf);  $classPath = NULL;  foreach($appDirs as $appDir) {   $classPath .= $pathToWebInf.'/'.$appDir.$delim;  }  $classPath = substr($classPath, 0, -1);  ini_set('include_path', $classPath);  return $classPath;  }  function getClassPath($appServerRootDir='', $appDirs, $osType='') {   if($appServerRootDir == '') {   echo 'Error: ClassPath :- No php.MVC application root directory specified';  exit;  }  $delim = NULL;  if($osType == '') {   $delim = PATH_SEPARATOR;  }  else {   $delim = ClassPath::getPathDelimiter($osType);  }  $path = $appServerRootDir;  $pathToWebInf = preg_replace("/WEB-INF.*$/i", '', $path);  $pathToWebInf = str_replace("\\", "/", $pathToWebInf);  $pathToWebInf = preg_replace("/\/$/i", '', $pathToWebInf);  $classPath = NULL;  $AbsolutePath = False;  foreach($appDirs as $appDir) {   $AbsolutePath = ClassPath::absolutePath($appDir);  if($AbsolutePath == True) {   $classPath .= $appDir.$delim;  }  else {   $classPath .= $pathToWebInf.'/'.$appDir.$delim;  }  }  $classPath = substr($classPath, 0, -1);  return $classPath;  }  function concatPaths($path1, $path2, $osType='') {   $delim = NULL;  $delim = ClassPath::getPathDelimiter($osType);  $path = $path1 . $delim . $path2;  return $path;  }  function getPathDelimiter($osType='') {   $delim = NULL;  if($osType != '') {   if(stristr($osType,"WIN") ) {   $delim = ';';  }  elseif(stristr($osType,"UNIX") ) {   $delim = ':';  }  elseif(stristr($osType,"MAC") ) {   $delim = ':';  }  }  if($delim == NULL) {   if(stristr($osType,"WIN") ) {   $delim = ';';  }  else {   $delim = ':';  }  }  return $delim;  }  function absolutePath($systemPath) {   $fAbsolutePath = False;  if (preg_match("/^\//", $systemPath)) {   $fAbsolutePath = True;  }  elseif(preg_match("/^[a-z]:\\\/i", $systemPath)) {   $fAbsolutePath = True;  }  elseif(preg_match("/^[a-z]:\//i", $systemPath)) {   $fAbsolutePath = True;  }  return $fAbsolutePath;  }  }  ?>
<?php
 class FileUtils { function trustedFile($file) { if (!eregi("^([a-z]+)://", $file) && fileowner($file) == getmyuid() ) { return True; } return False; } function utime() { $time = explode( ' ', microtime()); $usec = (double)$time[0]; $sec = (double)$time[1]; return $sec + $usec; } function zapTmpFiles($targetDir, $fileTTL) { $handle=opendir($targetDir); while( False !== ($file = readdir($handle)) ) { if($file != "." && $file != ".."){ $timeNow = time(); $timeFile = filemtime("$targetDir/$file"); if(($timeNow - $timeFile) >= $fileTTL){ if(!unlink("$targetDir/$file")){ $error = ''; return False; } } } } closedir($handle); return True; } function saveObject($sessFile, $obj) { $strObj = serialize($obj); $fp = fopen($sessFile, 'w'); fputs($fp, $strObj); fclose($fp); } function restoreObject($sessFile) { $obj = NULL; if( file_exists( $sessFile ) ) { $strObj = implode('', @file($sessFile)); $obj = unserialize($strObj); return $obj; } else { touch ( $sessFile ); return $obj; } } function listDir($dirPath) { $fileArray = NULL; if ( $handle = opendir($dirPath) ) { while (false !== ($file = readdir($handle))) { if ($file != "." && $file != "..") { $fileArray[] = $file; } } closedir($handle); } return $fileArray; } } ?>
<?php
 class BootUtils {  	function loadAppConfig(&$actionServer, &$appServerConfig, $configPath='', $cfgId='config',  									$cfgValue='', $appServerRootDir='', $globalPrependXML='') {  		$initXMLConfig	= False; 		$cfgDataMTime	= 0; 		$cfgXMLMTime	= 0; 		$forceCompile	= False;		 		$oApplicationConfig	= ''; 		$phpmvcConfigXMLFile	= 'phpmvc-config.xml'; 		$phpmvcConfigDataFile= 'phpmvc-config.data';  		if($cfgValue != '') { 			$phpmvcConfigXMLFile 	= $cfgValue['name']; 			$forceCompile				= $cfgValue['fc']; 			$phpmvcConfigDataFile	= preg_replace("/\..*/", '', $phpmvcConfigXMLFile);  			$phpmvcConfigDataFile  .= '.data';	 		}  		if($configPath == '') { 			$configPath = './WEB-INF'; 		}   		if( (! file_exists($configPath.'/'.$phpmvcConfigDataFile)) || $forceCompile == True ) {	 			$initXMLConfig = True; 		} else { 			$cfgDataMTime	= filemtime($configPath.'/'.$phpmvcConfigDataFile); 			$cfgXMLMTime	= filemtime($configPath.'/'.$phpmvcConfigXMLFile); 			if($cfgXMLMTime > $cfgDataMTime) { 				$initXMLConfig = True; 			}  			if (!$initXMLConfig) { 				global $moduleRootDir; 				$modulesPath = $moduleRootDir."WEB-INF/classes/modules"; 	 				$modules = scandir($modulesPath); 				$i = 0; 				while ($i<count($modules) && !$initXMLConfig) { 					$module = $modules[$i]; 					if (substr("$module", -1) != "." && $module != ".svn" && is_dir($modulesPath.'/'.$module)) { 						$expectedFile = $moduleRootDir."WEB-INF/classes/modules/".$module."/setup/phpmvc-config-".$module.".xml"; 						if (file_exists($expectedFile)) { 							$cfgXMLMTime	= filemtime($expectedFile); 							if($cfgXMLMTime > $cfgDataMTime) { 								$initXMLConfig = True; 							} 						} 					} 					$i++; 				}	 			} 			 		}  		if($initXMLConfig == False) { 			$strConfig = implode('', @file($configPath.'/'.$phpmvcConfigDataFile)); 			$oApplicationConfig = @unserialize($strConfig);  			if($oApplicationConfig) { 				$strClassID	= $_strClassID = '';  				$strClassID	= $oApplicationConfig->getClassID(); 				$_strClassID = ApplicationConfig::_getClassID();  				$aClassID = explode(':', $strClassID);	 				$classVersionID = $aClassID[2];			 				$_aClassID = explode(':', $_strClassID); 				$_classVersionID = $_aClassID[2];  				if($_classVersionID != $classVersionID) { 					$initXMLConfig = True;	 					$oApplicationConfig = NULL; 				}  				$actionServer->appServerConfig = $appServerConfig;  			} else {  				$initXMLConfig = True; 				echo "<b>Warning:</b>Cached ApplicationConfig data file seems corrupted ...<br>"; 				echo "Trying to recompile the application configuration file: "; 				echo "$configPath/$phpmvcConfigXMLFile<br><br>"; 			} 		}   		if($initXMLConfig) {  			global $moduleRootDir; 			$modulesPath = $moduleRootDir."WEB-INF/classes/modules"; 			$xmlPath = $moduleRootDir."WEB-INF/".$phpmvcConfigXMLFile; 			$fullXmlPath = $moduleRootDir."WEB-INF/phpmvc-config-all.xml"; 			$xmlContent = file_get_contents($xmlPath); 			 			$xmlContent = str_replace("</phpmvc-config>", "", $xmlContent);  			$modules = scandir($modulesPath); 			foreach ($modules as $module) { 				if (substr("$module", -1) != "." && $module != ".svn" && is_dir($modulesPath.'/'.$module)) { 					$expectedFile = $moduleRootDir."WEB-INF/classes/modules/".$module."/setup/phpmvc-config-".$module.".xml"; 					if (file_exists($expectedFile)) { 						$content = file_get_contents($expectedFile); 						$xmlContent .= $content; 					} 				} 			} 			 			$xmlContent .= "</phpmvc-config>"; 			 			file_put_contents($fullXmlPath, $xmlContent);   			$actionServer->setConfigPath($configPath.'/phpmvc-config-all.xml');  			if($appServerRootDir == '') { 				$path = __FILE__; 				preg_match("/^(.*)web-inf.*$/i", $path, $regs); 				$phpmvcRoot  = $regs[1];							 				$phpmvcRoot = substr($phpmvcRoot, 0, -1); 	 				$appServerRootDir = $phpmvcRoot;	 			} 			if($globalPrependXML == '') { 				$globalPrependXML = 'lib-phpmvc/PhpMvcOneXML.php.ws'; 			}  			if(!file_exists($appServerRootDir.'/WEB-INF/'.$globalPrependXML)) { 				echo "<b>Warning:</b> Cannot find the XML prepend file : <br>". 				$appServerRootDir.'/WEB-INF/'.$globalPrependXML."<br>". 				"In BootUtils::loadAppConfig(...)<br>"; 				return; 			}  			include_once $appServerRootDir.'/WEB-INF/'.$globalPrependXML;  			$oApplicationConfig = $actionServer->init($appServerConfig);  			$strConfig = serialize($oApplicationConfig); 			$fp = fopen($configPath.'/'.$phpmvcConfigDataFile, 'w'); 			fputs($fp, $strConfig); 			fclose($fp);  		}  		return $oApplicationConfig;  	}   	function getActionPath($_REQ_VARS, $actionID='do', $actPathMin=1, $actPathMax=35) {  		$pattern = '/^[a-z0-9_]{'.$actPathMin.','.$actPathMax.'}$/i';  		foreach($_REQ_VARS as $varName => $varVal) {  			if($varName != '' && $varName == $actionID) { 				if( preg_match($pattern, $varVal) ) { 					return $varVal; 				} 			} 		}  		return NULL;  	}  } ?>
<?php
 class HelperUtils { function zapArrayElement($key, &$array) { $idx = array_search( $key, array_keys($array) ); if( $idx === NULL || $idx === False) { return False; } else { array_splice( $array, $idx, 1); return True; } } } ?>
<?php
 class PhpBeanUtils { var $log = NULL; function PhpBeanUtils() { $this->log = new PhpMVC_Log(); $this->log->setLog('isDebugEnabled', False); $this->log->setLog('isTraceEnabled', False); } function cloneBean($object) { } function copyProperties($dest, $orig) { } function copyProperty($object, $name, $value) { } function describe($object) { } function getArrayProperty($object, $name) { } function getIndexedProperty($object, $name, $index=0) { } function getMappedProperty($object, $name, $key=NULL) { } function getNestedProperty($object, $name) { } function getProperty($object, $name) { } function getSimpleProperty($object, $name) { } function populate(&$object, $properties) { $debug = $this->log->getLog('isDebugEnabled'); if(($object == NULL) || ($properties == NULL)) { return; } if($debug) { $this->log->debug( 'PhpBeanUtils->populate(' . get_class($object).', '.$properties.')['.__LINE__.']' ); } foreach($properties as $name => $value) { if($name == NULL) { continue; } $this->setProperty($object, $name, $value); } } function setProperty(&$object, $methodName, $value) { $trace = $this->log->getLog('isTraceEnabled'); $classMethods = get_class_methods($object); $methodName = 'set'.ucfirst($methodName); $res = NULL; foreach($classMethods as $val) { if(strtolower($methodName) == strtolower($val)) { $res = True; } } if( is_null($res) ) { return 0; } $strBuff = ''; if($trace) { $strBuff = '  setProperty('; $strBuff .= get_class($object); $strBuff .= ', '; $strBuff .= $methodName; $strBuff .= ', '; if(value == NULL) { $strBuff .= '<NULL>'; } else if( is_string($value) ) { $strBuff .= $value; } else { $strBuff .= (string) $value; } $strBuff .= ")"; $this->log->trace($strBuff); } $object->$methodName($value); return 1; } } ?>
<?php
 class RequestUtils { var $log = NULL; var $PREFIXES_KEY = "PREFIXES"; function RequestUtils() { $this->log = new PhpMVC_Log(); $this->log->setLog('isDebugEnabled' , False); $this->log->setLog('isInfoEnabled' , False); $this->log->setLog('isTraceEnabled' , False); } function classLoader($className) { $debug = $this->log->getLog('isDebugEnabled'); $classFileName = $className.'.php'; if($debug) { $this->log->debug("  RequestUtils->classLoader()[" . __LINE__ . "]: Loading class file '" . $classFileName . "'" ); } if(!class_exists($className)) { include_once $classFileName; } $oClass = new $className; return $oClass; } function createActionForm($request, $mapping, $appConfig, $actionServer) { $log_trace = $this->log->getLog('isTraceEnabled'); $attribute = $mapping->getAttribute(); if($attribute == NULL) { } $name = $mapping->getName(); $config = $appConfig->findFormBeanConfig($name); if($config == NULL) { return NULL; } $controllerCfg = $appConfig->getControllerConfig(); $debug = $controllerCfg->getDebug(); if($debug >= 2) { } $instance = NULL; $session = NULL; if( 'request' == $mapping->getScope() ) { } else { } if($instance != NULL) { if($config->getDynamic()) { $className = ''; $actionForm = NULL; $actionForm = $instance->getDynaClass(); $className = $actionForm->getName(); if( $className == $config->getName() ) { $controllerConfig = $appConfig.getControllerConfig(); if($controllerConfig->getDebug() >= 2) { } return $instance; } } else { $className = $instance->getName(); if( $className == $config->getType() ) { if($controllerConfig->getDebug() >= 2) { } return $instance; } } } if($config->getDynamic()) { $dynaClass = DynaActionFormClass::createDynaActionFormClass($config); $instance = $dynaClass->newInstance(); } else { $actionForm = $config->getType(); $instance = $this->classLoader($actionForm); } if($log_trace) { $this->log->trace("RequestUtils->createActionForm()[".__LINE__. "]: ActionForm:  '" . $actionForm."' extends " . "'". get_parent_class($actionForm) ."'" ); } $instance->setActionServer($actionServer); $instance->reset($mapping, $request); return $instance; } function populate(&$bean, $prefix, $suffix, $request) { $properties = array(); $names = NULL; $multipartElements = NULL; $contentType = $request->getContentType(); $method = strtoupper($request->getMethod()); $isMultipart = False; $multiPart = False; if( ereg("^multipart/form-data", $contentType) ) { $multiPart = True; } if( ($contentType != NULL) && ($multiPart == True) && ($method == 'POST') ) { $multipartHandler = NULL; if($multipartHandler != NULL) { $isMultipart = True; } $request->removeAttribute(Action::getKey('MAPPING_KEY')); } if(! $isMultipart) { $names = $request->getParameterNames(); } foreach($names as $name) { } if($method == 'GET') { $properties = $request->getGetVars(); } elseif($method == 'POST') { $getProperties = $request->getGetVars(); $postProperties = $request->getPostVars(); $properties = array_merge($getProperties, $postProperties); } $beanUtils = new PhpBeanUtils; $beanUtils->populate($bean, $properties); } function getMultipartHandler($request, $actionServer) { } function requestURL($request) { } function serverURL($request) { } function selectApplication(&$request, $context) { $matchPath = $request->getAppServerPath(); $prefix = ''; $prefixes = $this->getApplicationPrefixes($context); if($prefixes != NULL) { foreach($prefixes as $prefixVal) { if( ereg("^$prefixVal", $matchPath) ) { $prefix = $prefixVal; break; } } } $config = $context->getAttribute(Action::getKey('APPLICATION_KEY').$prefix); if($config != NULL) $request->setAttribute(Action::getKey('APPLICATION_KEY'), $config); $resources = $context->getAttribute(Action::getKey('MESSAGES_KEY').$prefix); if($resources != NULL) $request->setAttribute(Action::getKey('MESSAGES_KEY'), $resources); } function getApplicationPrefixes($context) { return NULL; } } ?>
<?php
// class Format { var $pattern = ''; function Format($pattern) { $this->pattern = $pattern; } function formatMsg($args='', $arg0='', $arg1='', $arg2='', $arg3='') { } } ?>
<?php
// class MessageFormat extends Format { function MessageFormat($pattern) { parent::Format($pattern); } function formatMsg($args='', $arg0='', $arg1='', $arg2='', $arg3='') { if( !is_array($args) && $arg0=='' && $arg1=='' && $arg2=='' && $arg3=='' ) return $this->pattern; if( (!is_array($args)) && ($arg0!=''||$arg1!=''||$arg2!=''||$arg3!='') ) { if($arg0 != '') $args[0] = $arg0; if($arg1 != '') $args[1] = $arg1; if($arg2 != '') $args[2] = $arg2; if($arg3 != '') $args[3] = $arg3; } if( is_string($this->pattern) && strlen($this->pattern) > 0 ) { $pattern = $this->pattern; } else { return "Opps, we got a problem with the message pattern"; } $params = array('{0}', '{1}', '{2}', '{3}'); foreach($args as $key => $val) { $pattern = str_replace($params[$key], $val, $pattern); } return $pattern; } } ?>
<?php
// class Locale { var $ENGLISH = NULL; var $FRENCH = NULL; var $GERMAN = NULL; var $ITALIAN = NULL; var $JAPANESE = NULL; var $KOREAN = NULL; var $CHINESE = NULL; var $SIMPLIFIED_CHINESE = NULL; var $TRADITIONAL_CHINESE = NULL; var $FRANCE = NULL; var $GERMANY = NULL; var $ITALY = NULL; var $JAPAN = NULL; var $KOREA = NULL; var $CHINA = NULL; var $PRC = NULL; var $TAIWAN = NULL; var $UK = NULL; var $US = NULL; var $CANADA = NULL; var $CANADA_FRENCH = NULL; var $language; var $country; var $variant; var $defaultLocale = NULL; function convertLanguage($language) { if($language == '') return $language; $language = strtolower(language); $index = strpos("he,id,yi", $language); if($index > 0) return substr("iw,in,ji", $index, $index + 2); return $language; } function Locale($language='', $country='', $variant='', $defaultLocale=NULL) { $this->defaultLocale = $defaultLocale; $this->language= strtolower($language); $this->country = strtoupper($country); $this->variant = strtoupper($variant); } function getDefault() { return $this->defaultLocale; } function setDefault($newLocale) { if($newLocale == NULL){ return 'NullPointerException'; } $this->defaultLocale = $newLocale; } function getAvailableLocales() { } function getISOCountries() { return array( "AD", "AE", "AF", "AG", "AI", "AL", "AM", "AN", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BM", "BN", "BO", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "FX", "GA", "GB", "GD", "GE", "GF", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IN", "IO", "IQ", "IR", "IS", "IT", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PT", "PW", "PY", "QA", "RE", "RO", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "ST", "SV", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TM", "TN", "TO", "TP", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "YU", "ZA", "ZM", "ZR", "ZW" ); } function getISOLanguages() { return array( "aa", "ab", "af", "am", "ar", "as", "ay", "az", "ba", "be", "bg", "bh", "bi", "bn", "bo", "br", "ca", "co", "cs", "cy", "da", "de", "dz", "el", "en", "eo", "es", "et", "eu", "fa", "fi", "fj", "fo", "fr", "fy", "ga", "gd", "gl", "gn", "gu", "ha", "he", "hi", "hr", "hu", "hy", "ia", "id", "ie", "ik", "in", "is", "it", "iu", "iw", "ja", "ji", "jw", "ka", "kk", "kl", "km", "kn", "ko", "ks", "ku", "ky", "la", "ln", "lo", "lt", "lv", "mg", "mi", "mk", "ml", "mn", "mo", "mr", "ms", "mt", "my", "na", "ne", "nl", "no", "oc", "om", "or", "pa", "pl", "ps", "pt", "qu", "rm", "rn", "ro", "ru", "rw", "sa", "sd", "sg", "sh", "si", "sk", "sl", "sm", "sn", "so", "sq", "sr", "ss", "st", "su", "sv", "sw", "ta", "te", "tg", "th", "ti", "tk", "tl", "tn", "to", "tr", "ts", "tt", "tw", "ug", "uk", "ur", "uz", "vi", "vo", "wo", "xh", "yi", "yo", "za", "zh", "zu" ); } function getLanguage() { return $this->language; } function getCountry() { return $this->country; } function getVariant() { return $this->variant; } function toString() { if ( (strlen($this->language) == 0) && (strlen($this->country) == 0) ) return ''; $localeStr = ''; $l_ = ''; $c_ = ''; if(strlen($this->language) != 0) { $localeStr .= $this->language; $l_ = '_'; } if(strlen($this->country) != 0) { $localeStr .= $l_; $localeStr .= $this->country; $c_ = '_'; } if(strlen($this->variant) != 0) $localeStr .= $c_; $localeStr .= $this->variant; return $localeStr; } function getISO3Language() { } function getISO3Country() { } function getDisplayLanguage($locale=NULL) { if($locale == NULL) $locale = $this->defaultLocale; return $this->language; } function getDisplayCountry($locale=NULL) { if($locale == NULL) return $this->getDisplayCountry($this->defaultLocale); return $this->country; } function getDisplayVariant($locale=NULL) { if($locale == NULL) return $this->getDisplayVariant($this->defaultLocale); return $this->variant; } function getDisplayName($locale=NULL) { if($locale == NULL) $locale = $this->defaultLocale; $result = ''; $count = 0; $delimiters = array('', ' (', ','); if(strlen($this->language) != 0) { $result .= $delimiters[$count++]; $result .= $this->getDisplayLanguage($locale); } if(strlen($this->country) != 0) { $result .= $delimiters[$count++]; $result .= $this->getDisplayCountry($locale); } if(strlen($this->variant) != 0) { $result .= $delimiters[$count++]; $result .= $this->getDisplayVariant($locale); } if($count > 1) $result .= ')'; return $result; } function hashCode() { } function equals($obj) { if( get_class($obj) == get_class($this) ) return False; $l = $obj; return ($this->language == $l->language) && ($this->country == $l->country) && ($this->variant == $l->variant); } } ?>
<?php
 class MessageResources { var $log = NULL; var $config = NULL; var $defaultLocale = NULL; var $factory = NULL; var $defaultFactory = NULL; var $formats = array(); var $returnNull = False; function getConfig() { return $this->config; } function getDefaultLocale() { return $this->defaultLocale; } function setDefaultLocale($locale) { $this->defaultLocale = $locale; } function getFactory() { return $this->factory; } function getReturnNull() { return $this->returnNull; } function setReturnNull($returnNull) { $this->returnNull = $returnNull; } function MessageResources($factory, $config, $returnNull=False) { $this->factory = $factory; $this->config = $config; $this->returnNull = $returnNull; $this->log = new PhpMVC_Log(); $this->log->setLog('isTraceEnabled' , False); $this->log->setLog('isDebugEnabled' , False); $this->log->setLog('isErrorEnabled' , False); } function _getMessage($locale, $key) { ; } function getMessage($locale, $key, $args='', $arg0='', $arg1='', $arg2='', $arg3='') { $trace = $this->log->getLog('isTraceEnabled'); $debug = $this->log->getLog('isDebugEnabled'); if($trace) { $this->log->trace('Start: MessageResources->getMessage(...)'. '['.__LINE__.']'); } if($locale == NULL) $locale = $this->defaultLocale; $format = NULL; $localeKey = $this->localeKey($locale); $formatKey = $this->messageKey($localeKey, $key); if(array_key_exists($formatKey, $this->formats)) $format = $this->formats[$formatKey]; if($format == NULL) { $formatString = $this->_getMessage($locale, $key); if($formatString == NULL) { if($this->returnNull) return NULL; else return '???' . $formatKey . '???'; } $format = new MessageFormat( $this->escape($formatString) ); $this->formats[$formatKey] = $format; } return $format->formatMsg($args, $arg0, $arg1, $arg2, $arg3); } function isPresent($locale=NULL, $key) { $message = $this->getMessage($locale, $key); if($message == NULL) return False; elseif( eregi("^???.*???$") ) return False; else return True; } function escape($string) { if( ($string == '') || (strpos($string, '\'') < 1) ) return $string; $string = str_replace("\'", "\\\'", $string); return $string; } function localeKey($locale) { if($locale == NULL) { return ''; } else { return $locale->toString(); } } function messageKey($localeKey, $key) { $messageKey = ''; if($localeKey != '') $messageKey .= $localeKey . '.'; return $messageKey .= $key; } function getMessageResources($config) { if($this->defaultFactory == NULL) $this->defaultFactory = MessageResourcesFactory::createFactory(); return $this->defaultFactory->createResources($config); } } ?>
<?php  class PropertyMessageResources extends MessageResources { var $locales = array(); var $messages = array(); function PropertyMessageResources($factory, $config, $returnNull=NULL) { parent::MessageResources($factory, $config, $returnNull); } function _getMessage($locale, $key) { $trace = $this->log->getLog('isTraceEnabled'); $debug = $this->log->getLog('isDebugEnabled'); if($trace) { $this->log->trace('Start: PropertyMessageResources->_getMessage(...)'. '['.__LINE__.']'); } $localeKey = $this->localeKey($locale); $originalKey= $this->messageKey($localeKey, $key); $messageKey = ''; $message = ''; $underscore = 0; $addIt = False; while(True) { $this->loadLocale($localeKey); $messageKey = $this->messageKey($localeKey, $key); if($debug) { $this->log->debug( ' Loop from specific to general Locales looking for this message: ' .$localeKey.$messageKey.'['.__LINE__.']'); } if( array_key_exists($messageKey, $this->messages) ) $message = $this->messages[$messageKey]; if($message != '') { if($addIt) $this->messages[$originalKey] = $message; return $message; } $addIt = True; $pos = strrpos($localeKey, '_'); if($pos < 1 ) break; $localeKey = substr($localeKey, 0, $pos); } if(!$this->defaultLocale->equals($locale)) { $localeKey = $this->localeKey($this->defaultLocale); $messageKey = $this->messageKey($localeKey, $key); if($debug) { $this->log->debug( ' Trying the default locale if the current locale is different: ' .$messageKey.'['.__LINE__.']'); } $this->loadLocale($localeKey); $message = ''; if( array_key_exists($messageKey, $this->messages) ) $message = $this->messages[$messageKey]; if($message != '') { if($addIt) { $this->messages[$originalKey] = $message; } return $message; } } $localeKey = ''; $messageKey = $this->messageKey($localeKey, $key); if($debug) { $this->log->debug(' Last resort, try the default Locale: '.$messageKey.'['.__LINE__.']'); } $this->loadLocale($localeKey); if( array_key_exists($messageKey, $this->messages) ) $message = $this->messages[$messageKey]; if($message != '') { if($addIt) $this->messages[$originalKey] = $message; return $message; } if($this->returnNull) { return NULL; } else { $localeKey = $this->localeKey($locale); return ("???" . $this->messageKey($localeKey, $key) . "???"); } } function loadLocale($localeKey) { $trace = $this->log->getLog('isTraceEnabled'); $debug = $this->log->getLog('isDebugEnabled'); if($trace) { $this->log->trace( 'Start: PropertyMessageResources->loadLocale(' . $localeKey .')' . '[' . __LINE__ . ']' ); } if($debug) { $this->log->debug(' LocaleKey = "' . $localeKey . '" [' . __LINE__ . ']'); } if( array_key_exists($localeKey, $this->locales) ) return; $this->locales[$localeKey] = $localeKey; if( (strpos($this->config, '/')) || (strpos($this->config, '\\')) ) { $name = $this->config; } else { $name = str_replace('.', '/', $this->config); } if(strlen($localeKey) > 0) $name .= '_' . $localeKey; $name .= '.properties'; if($debug) { $this->log->debug(' Loading the property resource "' . $name . '" [' . __LINE__ . ']'); } $fp = ''; $fp = @fopen($name, 'r', 1); if($fp) { $delimChar = '='; $maxLineLen = 1000; $messages = NULL; while( !feof($fp) ) { $lineCSV = fgetcsv($fp, $maxLineLen, $delimChar); if(trim($lineCSV[0]) == '') continue; if (preg_match("/^\S*[#!]/", $lineCSV[0])) { continue; } $msgKey = $lineCSV[0]; $localeMsgKey = $this->messageKey($localeKey, $msgKey); $this->messages[$localeMsgKey] = $lineCSV[1]; } fclose($fp); } } } ?>
<?php
 class HttpAppServer { var $log = NULL; function HttpAppServer() { $this->log = new PhpMVC_Log(); $this->log->setLog('isDebugEnabled' , False); $this->log->setLog('isInfoEnabled' , False); $this->log->setLog('isTraceEnabled' , False); } function doGet($request, $response) { } function doPost($request, $response) { } function service($request, $response) { $debug = $this->log->getLog('isDebugEnabled'); $trace = $this->log->getLog('isTraceEnabled'); if($trace) $this->log->trace('Start: HttpAppServer->service(..)'); } } ?>
<?php
 class RequestBase { var $attributes = array(); var $authorization = NULL; var $characterEncoding = NULL; var $contentLength = -1; var $contentType = NULL; var $context = NULL; var $defaultLocale = NULL; var $info = 'phpmvc.connector.RequestBase/1.0'; var $locales = array(); var $protocol = NULL; var $remoteAddr = NULL; var $remoteHost = NULL; var $response = NULL; var $scheme = NULL; var $secure = False; var $serverName = NULL; var $serverPort = -1; var $socket = NULL; var $wrapper = NULL; function getAuthorization() { return $this->authorization; } function setAuthorization($authorization) { $this->authorization = $authorization; } function getContext() { return $this->context; } function setContext($context) { $this->context = $context; } function getInfo() { return $this->info; } function getRequest() { return $this->facade; } function getResponse() { return $this->response; } function setResponse($response) { $this->response = $response; } function getWrapper() { return $this->wrapper; } function setWrapper($wrapper) { $this->wrapper = $wrapper; } function addLocale($locale) { $this->locales[] = $locale; } function finishRequest() { if($this->reader != NULL) { $this->reader->close(); } if($this->stream != NULL) { $this->stream->close(); } } function recycle() { $this->attributes = array(); $this->authorization = NULL; $this->characterEncoding= NULL; $this->contentLength = -1; $this->contentType = NULL; $this->context = NULL; $this->input = NULL; $this->locales = array(); $this->notes = array(); $this->protocol = NULL; $this->reader = NULL; $this->remoteAddr = NULL; $this->remoteHost = NULL; $this->response = NULL; $this->scheme = NULL; $this->secure = False; $this->serverName = NULL; $this->serverPort = -1; $this->socket = NULL; $this->stream = NULL; $this->wrapper = NULL; } function setContentLength($length) { $this->contentLength = $length; } function setContentType($type) { $this->contentType = $type; } function setProtocol($protocol) { $this->protocol = $protocol; } function setRemoteAddr($remoteAddr) { $this->remoteAddr = $remoteAddr; } function setRemoteHost($remoteHost) { $this->remoteHost = $remoteHost; } function setScheme($scheme) { $this->scheme = $scheme; } function setSecure($secure) { $this->secure = $secure; } function setServerName($name) { $this->serverName = $name; } function setServerPort($port) { $this->serverPort = $port; } function getAttribute($name) { if( array_key_exists($name, $this->attributes) ) return $this->attributes[$name]; else return NULL; } function getAttributeNames() { return array_keys($this->attributes); } function getCharacterEncoding() { return $this->characterEncoding; } function getContentLength() { return $this->contentLength; } function getContentType() { return $this->contentType; } function getLocale() { if( count($locales) > 0 ) return $locales[0]; else return $this->defaultLocale; } function getLocales() { if( count($locales) > 0 ) return $this->locales; $results = array(); $results[] = $this->defaultLocale; return $results; } function getParameter($name) {} function getParameterMap() {} function getParameterNames() {} function getParameterValues($name) {} function getProtocol() { return $this->protocol; } function getRemoteAddr() { return $this->remoteAddr; } function getRemoteHost() { return $this->remoteHost; } function getRequestDispatcher($path) {} function getScheme() { return $this->scheme; } function getServerName() { return $this->serverName; } function getServerPort() { return $this->serverPort; } function isSecure() { return $this->secure; } function removeAttribute($name) { HelperUtils::zapArrayElement($name, $this->attributes); } function setAttribute($name, $value) { if($name == NULL) { return; } if($value == NULL) { $this->removeAttribute($name); return; } $this->attributes[$name] = $value; } function setCharacterEncoding($enc) { $this->characterEncoding = $enc; } } ?>
<?php
 class HttpRequestBase extends RequestBase { var $authType = NULL; var $contextPath = ''; var $cookies = array(); var $empty = array(); var $headers = array(); var $locales = array(); var $languagePriority = array(); var $info = 'HttpRequestBase/1.0'; var $method = NULL; var $parameters = array(); var $parsed = False; var $pathInfo = NULL; var $queryString = NULL; var $requestedSessionCookie = False; var $requestedSessionId = NULL; var $requestedSessionURL = False; var $requestURI = NULL; var $decodedRequestURI = NULL; var $secure = False; var $appServerPath = NULL; var $session = NULL; var $userPrincipal = NULL; var $_get_vars = NULL; var $_post_vars = NULL; var $_files_vars = NULL; function getInfo() { return $this->info; } function setGetVars(&$_get_vars) { $this->_get_vars = $_get_vars; } function &getGetVars() { return $this->_get_vars; } function setPostVars(&$_post_vars) { $this->_post_vars = $_post_vars; } function &getPostVars() { return $this->_post_vars; } function setFilesVars(&$_files_vars) { $this->_files_vars = $_files_vars; } function &getFilesVars() { return $this->_files_vars; } function addCookie($cookie) { $this->cookies[] = $cookie; } function addHeader($name, $value) { $name = strtolower($name); $values = $this->headers[$name]; if($values == NULL) { $values = array(); } $values[] = $value; $headers[$name] = $values; } function addParameter($name, $values) { $this->parameters[$name] = $values; } function clearCookies() { $this->cookies = array(); } function clearHeaders() { $this->headers = array(); } function clearLocales() { $this->locales = array(); } function clearParameters() { if($this->parameters != NULL) { $this->parameters = array(); } else { $this->parameters = array(); } } function recycle() { $this->authType = NULL; $this->contextPath = ''; $this->cookies = array(); $this->headers = array(); $this->method = NULL; if($this->parameters != NULL) { $this->parameters = array(); } $this->parsed = False; $this->pathInfo = NULL; $this->queryString = NULL; $this->requestedSessionCookie = False; $this->requestedSessionId = NULL; $this->requestedSessionURL = False; $this-> requestURI = NULL; $this->decodedRequestURI = NULL; $this->secure = False; $this->servletPath = NULL; $this->session = NULL; $this->userPrincipal = NULL; } function setContextPath($contextPath) { if($contextPath == '') { $this->contextPath = ""; } else { $this->contextPath = $contextPath; } } function setMethod($method) { $this->method = $method; } function setPathInfo($path) { $this->pathInfo = $path; } function setRequestURI($uri) { $this->requestURI = $uri; } function setAppServerPath($path) { $this->appServerPath = $path; } function parseParameters() { if($this->parsed == True) { return; } $results = array(); if((int)phpversion() > 4) { $results = array_merge($_GET, $_POST); } else { global $HTTP_SERVER_VARS; global $HTTP_POST_VARS; global $HTTP_GET_VARS; if( isset($HTTP_SERVER_VARS) ) { $results = array_merge($HTTP_GET_VARS, $HTTP_POST_VARS); } } if( count($this->parameters) > 0 ) { $results = array_merge($this->parameters, $results); } $this->parsed = True; $this->parameters = $results; } function getParameter($name) { if($this->parsed == False) { $this->parseParameters(); } $values = NULL; if(array_key_exists($name, $this->parameters)) { $values = $this->parameters[$name]; } if($values != NULL) { if(is_array($values)) { return $values[0]; }else { return $values; } } else { return NULL; } } function getParameterNames() { if($this->parsed == False) { $this->parseParameters(); } return array_keys($this->parameters); } function getParameterValues($name) { if($this->parsed == False) { $this->parseParameters(); } $values = NULL; if(array_key_exists($name, $this->parameters)) { $values = $this->parameters[$name]; } if($values != NULL) { if(is_array($values)) { return $values; }else { return array($values); } } else { return NULL; } } function isSecure() { return $this->secure; } function getAuthType() { return $this->authType; } function getContextPath() { return $this->contextPath; } function getCookies() { } function getHeader($name) { } function getHeaders($name) { } function getMethod() { return $this->method; } function getPathInfo() { return $this->pathInfo; } function getQueryString() { return $this->queryString; } function getRequestedSessionId() { return $this->requestedSessionId; } function getRequestURI() { return $this->requestURI; } function getAppServerPath() { return $this->appServerPath; } function getSession() { return; } function isUserInRole($role) { } } ?>
<?php
 class ResponseBase { var $appCommitted = False; var $buffer = ''; var $bufferCount = 0; var $responseBuffer = NULL; var $committed = False; var $contentCount = 0; var $contentLength = -1; var $contentType = NULL; var $context = NULL; var $encoding = NULL; var $included = False; var $info = 'phpmvc.connector.ResponseBase/1.0'; var $locale = NULL; var $output = NULL; var $request = NULL; var $suspended = False; var $error = False; function setResponseBuffer(&$responseBuffer) { $this->responseBuffer = $responseBuffer; } function getResponseBuffer() { return $this->responseBuffer; } function isAppCommitted() { return ($this->appCommitted || $this->committed); } function getIncluded() { return $this->included; } function setIncluded($included) { $this->included = $included; } function getInfo() { return $this->info; } function getRequest() { return $this->request; } function setRequest($request) { $this->request = $request; } function getStream() { return $this->output; } function setStream($stream) { $this->output = $stream; } function getContentLength() { return $this->contentLength; } function getContentType() { return $this->contentType; } function recycle() { $this->bufferCount = 0; $this->committed = False; $this->appCommitted = False; $this->suspended = False; $this->contentCount = 0; $this->contentLength = -1; $this->contentType = NULL; $this->context = NULL; $this->encoding = NULL; $this->included = False; $this->locale = Locale.getDefault(); $this->output = NULL; $this->request = NULL; $this->stream = NULL; $this->writer = NULL; $this->error = False; } function flushBuffer() { $this->committed = True; if(bufferCount > 0) { $this->bufferCount = 0; } } function getBufferSize() { return strlen($this->buffer); } function getCharacterEncoding() { if (encoding == null) return ("ISO-8859-1"); else return (encoding); } function getLocale() { return $this->locale; } function isCommitted() { return $this->committed; } function reset() { if($this->committed) return '"responseBase.reset.ise"'; if($this->included) return; $this->bufferCount = 0; $this->contentLength = -1; $this->contentType =NULL; } function resetBuffer() { if($this->committed) { return 'responseBase.resetBuffer.ise'; } $this->bufferCount = 0; return NULL; } function setContentType($type) { return; } function setLocale($locale) { } } ?>
<?php
 class HttpResponseBase extends ResponseBase { var $cookies = array(); var $format = array("EEE, dd MMM yyyy HH:mm:ss zzz", 'AU'); var $headers = array(); var $info = 'phpmvc.connector.HttpResponseBase/1.0'; function HttpResponseBase() { } function getCookies() { return $this->cookies; } function getHeader($name) { $values = NULL; $values = $this->headers[$name]; if (values != NULL) return $values; else return NULL; } function recycle() { parent::recycle(); $this->cookies = array(); $this->headers = array(); } function getStatusMessage($status) { switch ($status) { case SC_OK: return ("OK"); case SC_ACCEPTED: return ("Accepted"); case SC_BAD_GATEWAY: return ("Bad Gateway"); case SC_BAD_REQUEST: return ("Bad Request"); case SC_CONFLICT: return ("Conflict"); case SC_CONTINUE: return ("Continue"); case SC_CREATED: return ("Created"); case SC_EXPECTATION_FAILED: return ("Expectation Failed"); case SC_FORBIDDEN: return ("Forbidden"); case SC_GATEWAY_TIMEOUT: return ("Gateway Timeout"); case SC_GONE: return ("Gone"); case SC_HTTP_VERSION_NOT_SUPPORTED: return ("HTTP Version Not Supported"); case SC_INTERNAL_SERVER_ERROR: return ("Internal Server Error"); case SC_LENGTH_REQUIRED: return ("Length Required"); case SC_METHOD_NOT_ALLOWED: return ("Method Not Allowed"); case SC_MOVED_PERMANENTLY: return ("Moved Permanently"); case SC_MOVED_TEMPORARILY: return ("Moved Temporarily"); case SC_MULTIPLE_CHOICES: return ("Multiple Choices"); case SC_NO_CONTENT: return ("No Content"); case SC_NON_AUTHORITATIVE_INFORMATION: return ("Non-Authoritative Information"); case SC_NOT_ACCEPTABLE: return ("Not Acceptable"); case SC_NOT_FOUND: return ("Not Found"); case SC_NOT_IMPLEMENTED: return ("Not Implemented"); case SC_NOT_MODIFIED: return ("Not Modified"); case SC_PARTIAL_CONTENT: return ("Partial Content"); case SC_PAYMENT_REQUIRED: return ("Payment Required"); case SC_PRECONDITION_FAILED: return ("Precondition Failed"); case SC_PROXY_AUTHENTICATION_REQUIRED: return ("Proxy Authentication Required"); case SC_REQUEST_ENTITY_TOO_LARGE: return ("Request Entity Too Large"); case SC_REQUEST_TIMEOUT: return ("Request Timeout"); case SC_REQUEST_URI_TOO_LONG: return ("Request URI Too Long"); case SC_REQUESTED_RANGE_NOT_SATISFIABLE: return ("Requested Range Not Satisfiable"); case SC_RESET_CONTENT: return ("Reset Content"); case SC_SEE_OTHER: return ("See Other"); case SC_SERVICE_UNAVAILABLE: return ("Service Unavailable"); case SC_SWITCHING_PROTOCOLS: return ("Switching Protocols"); case SC_UNAUTHORIZED: return ("Unauthorized"); case SC_UNSUPPORTED_MEDIA_TYPE: return ("Unsupported Media Type"); case SC_USE_PROXY: return ("Use Proxy"); case 207: return ("Multi-Status"); case 422: return ("Unprocessable Entity"); case 423: return ("Locked"); case 507: return ("Insufficient Storage"); default: return ("HTTP Response Status " . $status); } } function sendHeaders() { return; $this->committed = True; } function flushBuffer() { } function reset($status='', $message='') { parent::reset(); $this->cookies = array(); $this->headers = array(); } function setContentType($type) { if($this->isCommitted()) return; parent::setContentType($type); } function setLocale($locale) { if($this->isCommitted()) return; parent::setLocale($locale); } function addCookie($cookie) { if($this->isCommitted()) return; $this->cookies[] = $cookie; } function setHeader($name, $value) { if($this->isCommitted()) return; $values = array(); $values[] = $value; $this->headers[$name] = $values; $match = strtolower($name); if($match == "content-length") { $contentLength = -1; $contentLength = (int) $value; ; if($contentLength >= 0) $this->setContentLength($contentLength); } elseif($match == "content-type") { $this->setContentType($value); } } function setIntHeader($name, $value) { if($this->isCommitted()) return; $this->setHeader($name, "" . $value); } } ?>
<?php
 class Action { var $defaultLocale = NULL; var $actionServer = NULL; function getKey($key) { switch($key) { case 'ACTION_SERVER_KEY': $keyVal = 'phpmvc.action.ACTION_SERVER'; break; case 'APPLICATION_KEY': $keyVal = 'phpmvc.action.APPLICATION'; break; case 'DATA_SOURCE_KEY': $keyVal = 'phpmvc.action.DATA_SOURCE'; break; case 'ERROR_KEY': $keyVal = 'phpmvc.action.ERROR'; break; case 'EXCEPTION_KEY': $keyVal = 'phpmvc.action.EXCEPTION'; break; case 'LOCALE_KEY': $keyVal = 'phpmvc.action.LOCALE'; break; case 'MAPPING_KEY': $keyVal = 'phpmvc.action.mapping.instance'; break; case 'MESSAGE_KEY': $keyVal = 'phpmvc.action.ACTION_MESSAGE'; break; case 'MESSAGES_KEY': $keyVal = 'phpmvc.action.MESSAGES'; break; case 'MULTIPART_KEY': $keyVal = 'phpmvc.action.mapping.multipartclass'; break; case 'APP_SERVER_KEY': $keyVal = 'phpmvc.action.APP_SERVER_MAPPING'; break; case 'TRANSACTION_TOKEN_KEY': $keyVal = 'phpmvc.action.TOKEN'; break; case 'FORM_BEAN_KEY': $keyVal = 'phpmvc.action.FORM_BEAN'; break; case 'VALUE_OBJECT_KEY': $keyVal = 'phpmvc.action.VALUE_OBJECT'; break; default: $keyVal = 'phpmvc.action.ERROR_KEY_NOT_FOUND'; } return $keyVal; } function &getActionServer() { return $this->actionServer; } function setActionServer(&$actionServer) { $this->actionServer =& $actionServer; } function execute($mapping, $form, &$request, &$response) { return NULL; } function saveErrors(&$request, $errors) { if(($errors == NULL) || $errors->isEmpty()) { $request->removeAttribute($this->getKey('ERROR_KEY')); return; } $request->setAttribute($this->getKey('ERROR_KEY'), $errors); } function saveFormBean(&$request, &$form) { if(($form == NULL)) { $request->removeAttribute($this->getKey('FORM_BEAN_KEY')); return; } $request->setAttribute($this->getKey('FORM_BEAN_KEY'), $form); } function saveValueObject(&$request, &$valueObject) { if(($valueObject == NULL)) { $request->removeAttribute($this->getKey('VALUE_OBJECT_KEY')); return; } $request->setAttribute($this->getKey('VALUE_OBJECT_KEY'), $valueObject); } } ?>
<?php
// class ActionForm { var $actionServer = NULL; var $multipartRequestHandler = NULL; function getActionServer() { return $this->actionServer; } function getActionServerWrapper() { return NULL; } function getMultipartRequestHandler() { return $this->multipartRequestHandler; } function setActionServer(&$actionServer) { $this->actionServer =& $actionServer; } function setMultipartRequestHandler($multipartRequestHandler) { $this->multipartRequestHandler = $multipartRequestHandler; } function reset($mapping, $request) { $this->resetHttp($mapping, $request); } function resetHttp($mapping, $request) { ; } function validate($mapping, $request) { $validate = $this->validateHttp($mapping, $request); if(! $validate) { return NULL; } return $validate; } function validateHttp($mapping, $request) { return NULL; } function saveErrors(&$request, $errors) { if(($errors == NULL) || $errors->isEmpty()) { $request->removeAttribute(Action::getKey('ERROR_KEY')); return; } $request->setAttribute(Action::getKey('ERROR_KEY'), $errors); } function saveFormBean(&$request, &$form) { if(($form == NULL)) { $request->removeAttribute(Action::getKey('FORM_BEAN_KEY')); return; } $request->setAttribute(Action::getKey('FORM_BEAN_KEY'), $form); } function saveValueObject(&$request, &$valueObject) { if(($valueObject == NULL)) { $request->removeAttribute(Action::getKey('VALUE_OBJECT_KEY')); return; } $request->setAttribute(Action::getKey('VALUE_OBJECT_KEY'), $valueObject); } } ?>
<?php
 class ActionServer extends HttpAppServer { var $configPath = './WEB-INF/phpmvc-config.xml';  var $digester = NULL;  var $parserCaseFolding = False;  var $dataSources = array();  var $debug = 0;  var $detail = 0;  var $internalRes = NULL;  var $internalResName = 'ActionResources';  var $log = NULL;  var $processor = NULL;  var $validating = False;  var $appServerConfig = NULL;  var $plugIns = array();  function setConfigPath($configPath) { $this->configPath = $configPath;  } function ActionServer () { $this->log = new PhpMVC_Log();  $this->log->setLog('isDebugEnabled' , False);  $this->log->setLog('isTraceEnabled' , False);  } function destroy() { $debug = $this->log->getLog('isDebugEnabled');  if($debug) { $this->log->debug(" Finalising ...");  } $this->destroyApplications();  $this->destroyDataSources();  $appContext = AppServer::getAppserverContext();  $appContext->removeAttribute(Action::getKey('ACTION_SERVER_KEY'));  } function init(&$appServerConfig) { $this->appServerConfig = $appServerConfig;  $this->initInternal();  $this->initOther();  $this->initServlet();  $applConfig = $this->initApplicationConfig('', $this->configPath);  $this->initApplicationMessageResources($applConfig); /* $this->initApplicationDataSources($applConfig); */  $this->initApplicationPlugIns($applConfig);  $this->destroyConfigDigester();  return $applConfig;  } function doGet(&$request, &$response, $GET='') { if($GET == '') { $GET = $_GET;  } $request->setMethod('GET');  $this->doPost($request, $response, '', '', $GET);  } function doPost(&$request, &$response, $POST='', $FILES='', $GET='') { if($POST == '') { $POST = $_POST;  } if($FILES == '') { $FILES = $_FILES;  } if($GET == '') { $GET = $_GET;  } $request->setMethod('POST');  $request->setPostVars($POST);  $request->setFilesVars($FILES);  $request->setGetVars($GET);  $this->process($request, $response);  } function getDebug() { return $this->debug;  } function getInternalRes() { return ($this->internalRes);  } function log($message, $level) { if($this->debug >= $level) { $this->log($message);  } } function &getDataSource($dataSourceKey) { if( array_key_exists($dataSourceKey, $this->dataSources) ) { $db =& $this->dataSources[$dataSourceKey];  $db->open();  return $db;  } else { $debug = $this->log->getLog('isDebugEnabled');  if($debug) { $this->log->debug('No datasource found: ActionServer->getDataSource(...)'. '['.__LINE__.']');  } $ret = NULL;  return $ret;  } } function &getPlugIn($plugInKey) { $config = NULL;  if( array_key_exists($plugInKey, $this->plugIns) ) { $plugIn =& $this->plugIns[$plugInKey];  $plugIn->init($config);  return $plugIn->plugIn;  } else { $debug = $this->log->getLog('isDebugEnabled');  if($debug) { $this->log->debug('No plugin found: ActionServer->getPlugIn('.$plugInKey.')'. '['.__LINE__.']');  } $ret = NULL;  return $ret;  } } function destroyApplications() { return NULL;  } function destroyConfigDigester() { $this->digester = NULL;  } function destroyInternal() { $this->internalRes = NULL;  } function getApplicationConfig($request) { $appConfig = $request->getAttribute(Action::getKey('APPLICATION_KEY'));  if($appConfig == NULL) { $appContext = $this->appServerConfig->getAppServerContext();  $appConfig = $appContext->getAttribute(Action::getKey('APPLICATION_KEY'));  } return $appConfig;  } function initApplicationConfig($prefix=NULL, $configPath) { $debug = $this->log->getLog('isDebugEnabled');  if($debug) { $this->log->debug("Initializing application path '".$prefix. "' configuration from '".$configPath."'");  } $applConfig = NULL;  $mapping = NULL;  $applConfig = new ApplicationConfig($prefix, $this);  $mapping = $this->appServerConfig->getInitParameter('mapping');  if($mapping != NULL) { $applConfig->setActionMappingClass($mapping);  } $this->initConfigDigester();  $this->digester->push($applConfig);  $applConfig = $this->digester->parse($configPath);  $appContext = $this->appServerConfig->getAppServerContext();  $appContext->setAttribute (Action::getKey('APPLICATION_KEY').$prefix, $applConfig);  $applConfig->freeze();  return $applConfig;  } function initApplicationDataSources($config) { $debug = $this->log->getLog('isDebugEnabled');  $trace = $this->log->getLog('isTraceEnabled');  if($trace) { $this->log->trace('Start: ActionServer->initApplicationDataSources(...)'. '['.__LINE__.']');  } if($debug) { $this->log->debug(" ActionServer->initApplicationDataSources()[". __LINE__."]: Initializing application path: '". $config->getPrefix()."' data sources.");  } $dataSources = array();  $dataSources = $config->findDataSourceConfigs();  if($dataSources == NULL) { $dataSources[0] = new DataSourceConfig;  } foreach($dataSources as $dataSource) { $error = NULL;  if($debug) { $this->log->debug("  ActionServer->initApplicationDataSources()[". __LINE__."]: Initializing application path: '". $config->getPrefix()."' DataSourceConfig: '".get_class($dataSource)."'");  } $oDataSource = NULL;  $dataSourceType = $dataSource->getType();  $oDataSource = new $dataSourceType;  $beanUtils = new PhpBeanUtils;  $beanUtils->populate($oDataSource, $dataSource->getProperties());  if($error) { $msg = $this->internalRes->getMessage("dataSource->init", $dataSource->getKey());  $this->log->error($msg, $error);  } $appContext = $this->appServerConfig->getAppserverContext();  $appContext->setAttribute($dataSource->getKey(), $oDataSource);  $this->dataSources[$dataSource->getKey()] = $oDataSource;  } } function initApplicationPlugIns($config) { $debug = $this->log->getLog('isDebugEnabled');  if($debug) { $this->log->debug("Initializing application path '". $config->getPrefix()."' plug ins");  } $plugIns = array();  $plugIns = $config->findPlugIns();  if($plugIns == NULL) { return 'No PlugIns loaded';  } foreach($plugIns as $idx => $plugIn) { $keyStr = $plugIn->getKey();  $this->plugIns[$keyStr] =& $plugIns[$idx];  } } function initApplicationMessageResources($config) { $error = NULL;  $msgResrs = array();  $msgResrs = $config->findMessageResourcesConfigs();  if($msgResrs == NULL) { return 'No MessageResourcesConfigs found.';  } foreach($msgResrs as $msgRes) { if(($msgRes->getFactory() == NULL)||($msgRes->getParameter() == NULL)) { continue;  } $debug = $this->log->getLog('isDebugEnabled');  if($debug) { $this->log->debug("Initializing application path '".$config->getPrefix(). "' message resources from '".$msgRes->getParameter()."'");  } $factory = $msgRes->getFactory();  MessageResourcesFactory::setFactoryClass($factory);  $factoryObject = MessageResourcesFactory::createFactory();  $resources = $factoryObject->createResources($msgRes->getParameter());  $resources->setReturnNull($msgRes->getNull());  $appContext = AppServer::getAppserverContext();  $appContext->setAttribute($msgRes->getKey().$config->getPrefix(), $resources);  if($error) { $msg = $this->internalRes->getMessage("applicationResources", $msgRes->getParameter());  $this->log->error($msg, $error);  } } } function initConfigDigester() { if($this->digester != NULL) { return $this->digester;  } $digester = new Digester();  $digester->setValidating($this->validating);  $digester->parserSetOption(XML_OPTION_CASE_FOLDING, $this->parserCaseFolding);  $digester->addRuleSet(new ConfigRuleSet());  $this->digester = $digester;  } function initInternal() { $error = NULL;  return;  $error = 'in ActionServer->initInternal()';  if($this->internalRes == NULL) { $this->log->error("Cannot load internal resources from '" . $this->internalResName . "'", $error);  } } function initOther() { $error = NULL;  $value = NULL;  } function initServlet() { } function process($request, $response) { $appContext = $this->appServerConfig->getAppServerContext();  $reqUtils = new RequestUtils;  $reqUtils->selectApplication($request, $appContext);  $appConfig = $this->getApplicationConfig($request);  $requestProcessor = $appConfig->getProcessor();  $requestProcessor->process($request, $response);  } } ?>
<?php
 class RequestProcessor {  	var $INCLUDE_PATH_INFO = 'phpmvc.appserver.include.path_info';  	var $INCLUDE_APPSERVER_PATH = 'phpmvc.appserver.include.appserver_path';  	var $actions = array();	  	var $appConfig = NULL;  	var $log = NULL;   	var $actionServer = NULL;  	function RequestProcessor () {  		$this->log	= new PhpMVC_Log(); 		$this->log->setLog('isDebugEnabled'	, False); 		$this->log->setLog('isInfoEnabled'	, False); 		$this->log->setLog('isTraceEnabled'	, False);  	}  	function destroy() {  		$actions = array_keys($this->actions); 		foreach($actions as $action) { 			$action->setActionServer(NULL); 		} 		$this->actions = array(); 		$this->actionServer = NULL;  	}  	function init(&$actionServer, &$appConfig) {  		$this->actions = array(); 		$this->actionServer =& $actionServer; 		$this->appConfig =& $appConfig;  	}  	function process($request, $response) {  		$debug = $this->log->getLog('isDebugEnabled'); 		$trace = $this->log->getLog('isTraceEnabled');  		if($trace) { 			$this->log->trace('Start: RequestProcessor->process(...)'. 									'['.__LINE__.']'); 		}   		$shutdown = False; 		while(!$shutdown) {  			$path = $this->processPath($request, $response);     			if($debug) { 				$this->log->debug("RequestProcessor->process()[".__LINE__. 										"]: Processing a '".$request->getMethod(). 	                     		"' request for path '" .$path."'"); 			}  			$this->processContent($request, $response);  			$this->processNoCache($request, $response);   			if(!$this->processPreprocess($request, $response, $path)) { 				return; 			}  			$mapping = $this->processMapping($request, $response, $path); 			if($mapping == NULL) { 				return; 			}  			if (!$this->processRoles($request, $response, $mapping)) { 				return; 			}  			$form = $this->processActionForm($request, $response, $mapping);	  			$this->processPopulate($request, $response, $form, $mapping); 			if(!$this->processValidate($request, $response, $form, $mapping)) { 				return; 			}  			if(!$this->processForward($request, $response, $mapping)) { 				return; 			}  			if(!$this->processInclude($request, $response, $mapping)) { 				return; 			}  			$action = $this->processActionCreate($request, $response, $mapping);  			if($action == NULL) { 				return; 			}  			$forward = $this->processActionPerform($request, $response,  																$action, $form, $mapping);	  			$shutdown = $this->processActionChain($request, $forward);  			$this->processActionForward($request, $response, $forward);  		}    	}   	function processActionCreate($request, $response, $mapping) {  		$debug = $this->log->getLog('isDebugEnabled'); 		$trace = $this->log->getLog('isTraceEnabled');  		if($trace) { 			$this->log->trace('Start: RequestProcessor->processActionCreate(...)'. 									'['.__LINE__.']'); 		}  		$className = $mapping->getType();    		if($debug) { 			$this->log->debug(" Looking for Action instance for class '".$className."'"); 		}  		$instance = NULL;	  		if(array_key_exists($className, $this->actions)) 			$instance = $this->actions[$className];	   		if($instance != NULL) { 			if($trace) { 				$this->log->trace("  Returning existing Action instance");  			}  			return $instance; 		}  		if($trace) { 			$this->log->trace("  Creating new Action instance '".$className."'"); 		}  		$requestUtils = new RequestUtils; 		$instance = $requestUtils->classLoader($className);  		$instance->setActionServer($this->actionServer);  		$this->actions['className'] =&  $instance; 		 		return $instance;  	}  	function processActionForm($request, $response, $mapping) {  		$requestUtils = new RequestUtils; 		$instance = $requestUtils->createActionForm($request, $mapping,  																$this->appConfig,  																$this->actionServer);   		if($instance == NULL) { 			return NULL; 		}  		$debug = $this->log->getLog('isDebugEnabled'); 		if($debug) { 			$this->log->debug(" Storing ActionForm bean instance in scope '" . 			$mapping->getScope() . "' under attribute key '" . 			$mapping->getAttribute() . "'"); 		}  		if('request' == $mapping->getScope()) { 			$request->setAttribute($mapping->getAttribute(), $instance); 		} else { 		}  		return $instance;  	}   	function processActionForward(&$request, &$response, $forward) {  		$debug = $this->log->getLog('isDebugEnabled'); 		$trace = $this->log->getLog('isTraceEnabled');  		if($trace) { 			$this->log->trace('Start: RequestProcessor->processActionForward(...)'. 									'['.__LINE__.']'); 		}  		if($forward == NULL) { 			return; 		}  		$path = $forward->getPath();	 	 		if($path == NULL) { 			return; 		}   		if( strtolower($forward->getRedirect()) == True) {  			$host = $_SERVER['HTTP_HOST'];  			if( substr($path, 0, 1) == '/' ) {  				if($forward->getContextRelative()) { 					$path = $request->getContextPath().$path; 				} else { 					$path = $request->getContextPath() .                         $this->appConfig->getPrefix().$path;  				} 			}  			$pathScheme = ''; 			$scheme = '';	 			if(is_array($_SERVER)) { 				$scheme = (@$_SERVER['HTTPS'] == 'on' ? 'https' : 'http'); 			} elseif(is_array($HTTP_SERVER_VARS)) { 				$scheme = (@$HTTP_SERVER_VARS['HTTPS'] == 'on' ? 'https' : 'http'); 			} else { 				$scheme = 'http'; 			}  			if( !preg_match("/^([a-z]+):\/\//i", $path) ) {  				if($scheme == 'http' || $scheme == 'https' || $scheme == 'ftp') { 					$pathScheme = $scheme.'://'; 				}  				if( substr($path, 0, 1) != '/' ) { 					$path = "/".$path; 				}  				$redirPath = $pathScheme.$host.$path;   			} else {  				$redirPath = $path;  			}  			header("Location: $redirPath");  			exit;   		} else {  			$leadingPathSlash = False; 			if( substr($path, 0, 1) == '/' ) { 				$leadingPathSlash = True; 			}  			if($leadingPathSlash && !$forward->getContextRelative()) { 				$path = $this->appConfig->getPrefix() . $path; 			}  			$this->doForward($path, $request, $response); 		}  	}   	function processActionPerform(&$request, &$response, $action, $form, $mapping) {  		$debug = $this->log->getLog('isDebugEnabled'); 		$trace = $this->log->getLog('isTraceEnabled');  		if($trace) { 			$this->log->trace('Start: RequestProcessor->processActionPerform(...)'. 									'['.__LINE__.']'); 		}   		$actionForward = NULL; 		$actionForward = $action->execute($mapping, $form, $request, $response);  		if($actionForward == NULL) { 			return NULL; 		}  		return $actionForward;  	}   	function processActionChain(&$request, $forward) {  		$debug = $this->log->getLog('isDebugEnabled'); 		$trace = $this->log->getLog('isTraceEnabled');  		if($trace) { 			$this->log->trace('Start: RequestProcessor->processActionChain(...)'. 									'['.__LINE__.']'); 		}	  		if($forward == NULL) { 			return True;	 		}  		$nextActionPath = '';	  		$nextActionPath = $forward->getNextActionPath();  		if($nextActionPath == '') { 			return True;  		} else { 			$request->setAttribute('ACTION_DO_PATH', $nextActionPath);  			return False;  		}  	}   	function processContent($request, $response) {  		$controllerConfig = $this->appConfig->getControllerConfig(); 		$contentType = $controllerConfig->getContentType();  		if($contentType != NULL) { 			$response->setContentType($contentType); 		}  	}   	function processForward($request, $response, $mapping) {  		$debug = $this->log->getLog('isDebugEnabled'); 		$trace = $this->log->getLog('isTraceEnabled');  		if($trace) { 			$this->log->trace('Start: RequestProcessor->processForward(...)'. 									'['.__LINE__.']'); 		}   		$forward = $mapping->getForward(); 		if($forward == NULL) { 			return True; 		}  		if(is_a($request, 'MultipartRequestWrapper')) {	 			$request = $request->getRequest(); 		}  		$uri = $this->appConfig->getPrefix().$forward;	  		if($debug) { 			$this->log->debug(" Delegating via forward to '" . $uri . "'"); 		}  		$this->doForward($uri, $request, $response);  		return False;      }  	function processInclude($request, $response, $mapping) {  		$debug = $this->log->getLog('isDebugEnabled');  		$include = $mapping->getInclude(); 		if($include == NULL) { 			return True; 		}  		if(is_a($request, 'MultipartRequestWrapper')) {	 			$request = $request->getRequest();  		}  		$uri = $this->appConfig->getPrefix() . $include;   		  		if($debug) { 			$this->log->debug(" Delegating via include to '" . $uri + "'"); 		}  		$this->doInclude($uri, $request, $response);  		return False;  	}   	function processMapping($request, $response, $path) {  		$debug = $this->log->getLog('isDebugEnabled'); 		$trace = $this->log->getLog('isTraceEnabled');  		if($trace) { 			$this->log->trace('Start: RequestProcessor->processMapping(...)'. 									'['.__LINE__.']'); 		}  		$mapping = $this->appConfig->findActionConfig($path);   		if($mapping != NULL) { 			$request->setAttribute(Action::getKey('MAPPING_KEY'), $mapping); 			return $mapping; 		} 		 		$match = preg_split("/[A-Z]/", $path); 		if (count($match) > 1) { 			$module = $match[0];  			global $moduleRootDir; 			$expectedFile = $moduleRootDir."WEB-INF/classes/modules/".$module."/actions/".ucwords($path)."Action.php"; 			if (file_exists($expectedFile)) {  				$newActionConfig = new ActionConfig(); 				$newActionConfig->setName($path); 				$newActionConfig->setPath($path); 				$newActionConfig->setType(ucwords($path)."Action"); 				 				 								$forwardsRules = array();				$forwardsRules["DoEdit"] = array();				$forwardsRules["DoEdit"]["success"] = "/Main.php?do=MODULEList&message=ok";				$forwardsRules["DoEdit"]["success-add"] = "/Main.php?do=MODULEEdit&message=ok";				$forwardsRules["DoEdit"]["success-edit"] = "/Main.php?do=MODULEEdit&message=ok";				$forwardsRules["DoEdit"]["failure"] = "MODULEEdit.tpl";				$forwardsRules["DoEdit"]["failure-edit"] = "MODULEEdit.tpl";				$forwardsRules["DoEdit"]["failure-error"] = "Error.tpl";				$forwardsRules["DoEdit"]["failure-list"] = "/Main.php?do=MODULEList&message=not_edited";				$forwardsRules["DoDelete"] = array();				$forwardsRules["DoDelete"]["success"] = "/Main.php?do=MODULEList&message=deleted_ok";						$forwardsRules["DoDelete"]["failure"] = "/Main.php?do=MODULEList&message=not_deleted";		 				 				$action = str_replace($module,"",$path); 				 				$forwards = false; 				$moduleSection = "";  				function strstrb($h,$n){ 				    return array_shift(explode($n,$h,2)); 				} 				 				foreach ($forwardsRules as $key => $rules) { 					if (preg_match("/".$key."$/",$action)) { 						$forwards = $rules; 						$moduleSection = strstrb($action, $key); 					} 				}  				 				if (!empty($forwards)) { 					foreach ($forwards as $forwardName => $forwardPath) { 						$forwardObject = new ForwardConfig(); 						$forwardObject->setName($forwardName); 						 						if (substr($forwardPath, strlen($forwardPath)-3) != "tpl") { 							$forwardObject->setRedirect(true); 							$moduleForPath = $module . $moduleSection; 						} else { 							$moduleForPath = ucwords($module) . $moduleSection; 						} 							 						$forwardObject->setPath(str_replace("MODULE", $moduleForPath, $forwardPath)); 											 						$newActionConfig->addForwardConfig($forwardObject);						 					} 				} else { 					$successForward = new ForwardConfig(); 					$successForward->setName("success"); 					$successForward->setPath(ucwords($path).".tpl"); 					$newActionConfig->addForwardConfig($successForward);					 									$successForward = new ForwardConfig();					$successForward->setName("failure");					$successForward->setPath("Error.tpl");					$newActionConfig->addForwardConfig($successForward);} 				 				$this->appConfig->addActionConfig($newActionConfig); 				$mapping = $this->appConfig->findActionConfig($path); 				return $mapping; 			}			 		} 		 		$configs = NULL; 		$configs = $this->appConfig->findActionConfigs();  		if($configs != NULL) { 			foreach($configs as $config) { 				if($config->getUnknown() === True) { 					$mapping = $config; 					$request->setAttribute(Action::getKey('MAPPING_KEY'), $mapping); 					return $mapping; 				} 			} 		}   		$this->log->error("RequestProcessor->processMapping()[".__LINE__."]: Invalid path '$path' was requested"); 		return NULL;  	}   	function processMultipart($request) {  		if('POST' != $request->getMethod()) { 			return $request; 		}  		$contentType = $request->getContentType();    		$multiPart = False; 		if( ereg("^multipart/form-data", $contentType) ) 			$multiPart = True;  		if( ($contentType != NULL) && ($multiPart == True) ) { 			$multiPartWrapper = new MultipartRequestWrapper($request); 			return $multiPartWrapper; 		} else { 			return $request; 		}  	}   	function processNoCache($request, $response) {  		$controllerConfig = $this->appConfig->getControllerConfig(); 		if($controllerConfig->getNocache()) { 			$response->setHeader("Pragma", "No-cache"); 			$response->setHeader("Cache-Control", "no-cache"); 			$response->setDateHeader("Expires", 1); 		}  	}  	function processPath(&$request, &$response) {  		$debug = $this->log->getLog('isDebugEnabled'); 		$trace = $this->log->getLog('isTraceEnabled');  		if($trace) { 			$this->log->trace('Start: RequestProcessor->processPath(...)'. 									'['.__LINE__.']'); 		}  		$path = NULL;	   		$path = $request->getAttribute('INCLUDE_PATH_INFO'); 		if($path == NULL) { 			$path = $request->getPathInfo(); 		}  		if( ($path != NULL) && (strlen($path) > 0) ) { 			return $path; 		}  		$path = $request->getAttribute('INCLUDE_APPSERVER_PATH');   		if($path == NULL) { 			$path = $request->getAppServerPath(); 		}  		$prefix = $this->appConfig->getPrefix();	   		if(!preg_match("/^$prefix/", $path)) {  			return NULL; 		}  		$path = substr($path, strlen($prefix));  		$slash = $period = 0;   		$slash = strrpos($path, '/');     		$period = strrpos($path, '.');  		if(($period >= 0) && ($period > $slash)) { 			$path = substr($path, 0, $period); 		}   		$path = $request->getAttribute('ACTION_DO_PATH'); 		if($path != '') { 			if($trace) 				$this->log->debug('  RequestProcessor->processPath(...)'. 										'Found an Action path "'. $path. '" for this request'. 										'['.__LINE__.']'); 		} else { 			return NULL; 		}  		return $path;  	}  	function processPopulate($request, $response, &$form, $mapping) {  		$debug = $this->log->getLog('isDebugEnabled'); 		$trace = $this->log->getLog('isTraceEnabled');  		if($trace) { 			$this->log->trace('Start: RequestProcessor->processPopulate(...)'. 									'['.__LINE__.']'); 		}   		if($form == NULL) { 			return; 		}  		if($debug) { 			$this->log->debug(" Populating bean properties from this request"); 		}  		$form->reset($mapping, $request); 		if($mapping->getMultipartClass() != NULL) { 			$request->setAttribute(Action::getKey('MULTIPART_KEY'), 											$mapping->getMultipartClass()); 		}  		RequestUtils::populate($form, $mapping->getPrefix(),  										$mapping->getSuffix(), $request); 		$form->setActionServer($this->actionServer);   	}    	function processPreprocess(&$request, &$response, &$path) {          return True;      }   	function processRoles($request, $response, $mapping) {  		$debug = $this->log->getLog('isDebugEnabled');  		$roles = NULL;								 		$roles = $mapping->getRoleNames();	 		if(($roles == NULL) || (count($roles) < 1)) { 			return True; 		}  		$appServerContext =& $this->actionServer->appServerConfig->getAppServerContext(); 		if($request->getUserPrincipal() == Null) { 			$oPrincipal = AuthenticatorBase::invoke($request, $response, $appServerContext); 			$request->setUserPrincipal($oPrincipal); 			if($oPrincipal == Null) { 				if($debug) { 					$this->log->debug(" Failed to create a Principal for user '" .  												$request->getRemoteUser() . "'"); 				} 				return False; 			}	 		}  		$oRealm = $appServerContext->getRealm();		 		foreach($roles as $role) { 			if($request->isUserInRole($role, $oRealm)) { 				if($debug) { 					$this->log->debug(" User '" . $request->getRemoteUser() .  					"' has role '" . $role . "', granting access"); 				}  				return True;   			} 		}  		if($debug) { 			$this->log->debug(" User '" . $request->getRemoteUser() .                       "' does not have any required role, denying access"); 		}   		return False;  	}  	function processValidate(&$request, &$response, &$form, &$mapping) {  		$debug = $this->log->getLog('isDebugEnabled'); 		$trace = $this->log->getLog('isTraceEnabled');  		if($trace) { 			$this->log->trace('Start: RequestProcessor->processValidate(...)'. 									'['.__LINE__.']'); 		}  		if($form == NULL) { 			return True; 		}  		if(($request->getParameter('CANCEL_PROPERTY') != NULL) || 			($request->getParameter('CANCEL_PROPERTY_X') != NULL)) { 			if($debug) { 				$this->log->debug(" Cancelled transaction, skipping validation"); 			}  			return True;  		}  		if($mapping->getValidate() == False) { 			return True;	 		}  		if($debug) { 			$this->log->debug(" Validating input form properties"); 		}    		$errors = NULL; 		$errors = $form->validate($mapping, $request);  		$errorsEmpty = True;	 		if( is_object($errors) ) { 			$errorsEmpty = $errors->isEmpty();  		}  		if($errors == NULL || $errorsEmpty) { 			if($trace) { 				$this->log->trace("  No errors detected, accepting input"); 			}  			return True; 		}  		if($form->getMultipartRequestHandler() != NULL) { 			if($trace) { 				$this->log->trace("  Rolling back multipart request"); 			}  			$mpReqHandler = $form->getMultipartRequestHandler(); 			$mpReqHandler->rollback(); 		}  		$input = $mapping->getInput();	  		if($input == NULL) { 			if($trace) { 				$this->log->trace("  Validation failed but no input form available"); 			}  			return False; 		}  		if($debug) { 			$this->log->debug(" Validation failed, returning to '".$input."'"); 		}  		$request->setAttribute(Action::getKey('FORM_BEAN_KEY'), $form);  		$request->setAttribute(Action::getKey('ERROR_KEY'), $errors); 		if( get_class($request) == 'MultipartRequestWrapper' ) { 			$request = $request->getRequest(); 		}  		$uri = $input;	  		$this->doForward($uri, $request, $response); 		return False;  	}  	function doForward($uri, &$request, &$response) {  		$debug = $this->log->getLog('isDebugEnabled'); 		$trace = $this->log->getLog('isTraceEnabled');  		if($trace) { 			$this->log->trace('Start: RequestProcessor->doForward(...)'. 									'['.__LINE__.']'); 		}  		$appServerContext =  				$this->actionServer->appServerConfig->getAppServerContext(); 		$actionDispatcher = $appServerContext->getInitParameter('ACTION_DISPATCHER');		 		$ad = new $actionDispatcher;   		if($ad == NULL) { 			return; 		}  		$ad->setActionServer($this->actionServer);  		$ad->forward($uri, $request, $response);      }  	function doInclude($uri, $request, $response) {  		$appServerContext =  				$this->actionServer->appServerConfig->getAppServerContext(); 		$rd = $appServerContext->getRequestDispatcher($uri);  		if($rd == NULL) {  			return;  		}  		$rd->include($request, $response); 	}  	function getDebug() {  		return $this->actionServer->getDebug();  	}   	function getInternal() {  		return $this->actionServer->getInternal();  	}   	function getServletContext() {  		$appServerContext =  				$this->actionServer->appServerConfig->getAppServerContext(); 		return $appServerContext;  	}    	function log($message, $exception='') {          $actionServer->log($message, $exception);      }  } ?>
<?php
// class ActionMessage { var $key = NULL; var $values = array(); function ActionMessage($key, $value0='', $value1='', $value2='', $value3='', $values='') { $this->key = $key; $this->values = NULL; if($value0 != '') { $this->values[] = $value0; } if($value1 != '') { $this->values[] = $value1; } if($value2 != '') { $this->values[] = $value2; } if($value3 != '') { $this->values[] = $value3; } if($values != '' && is_array($values)) { $this->values = NULL; $this->values = $values; } } function getKey() { return $this->key; } function getValues() { return $this->values; } } ?>
<?php
// class ActionError extends ActionMessage { function ActionError($key, $value0='', $value1='', $value2='', $value3='', $values='') { parent::ActionMessage($key, $value0, $value1, $value2, $value3, $values); } } ?>
<?php
// class ActionMessages { var $GLOBAL_MESSAGE = "phpmvc.action.GLOBAL_MESSAGE"; var $messages = array(); var $iCount = 0; function add($property, $message) { if( array_key_exists($property, $this->messages) ) { $ami =& $this->messages[$property]; } else { $ami = NULL; } $list = NULL; if($ami == NULL) { $list = array(); $list[] = $message; $ami = new ActionMessageItem($list, $this->iCount++); $this->messages[$property] = $ami; } else { $list =& $ami->getList(); $list[] = $message; } } function clear() { $this->messages = array(); } function isEmpty() { if( count($this->messages) == 0) return True; else return False; } function _get() { } function get($property) { if( array_key_exists($property, $this->messages) ) { $ami = $this->messages[$property]; } else { $ami = NULL; } if($ami == NULL) return 'EMPTY_LIST'; else return $ami->getList(); } function getItemString($property, $index=0) { if( array_key_exists($property, $this->messages) ) { $ami = $this->messages[$property]; } else { $ami = NULL; } if($ami == NULL) { return ''; } else { $messageSet = $ami->getList(); } if( array_key_exists($index, $messageSet) ) { return $messageSet[$index]->getKey(); } else { return ''; } } function properties() { return array_keys($this->messages); } function size($property='') { if($property == '') { $total = 0; foreach($this->messages as $key => $value) { $ami = $value; $total += count($ami->getList()); } return $total; } else { $ami = $this->messages[$property]; if($ami == NULL) return 0; else return count($ami->getList()); } } } class ActionMessageItem { var $list = NULL; var $iOrder = 0; function ActionMessageItem($list, $iOrder) { $this->list = $list; $this->iOrder = $iOrder; } function &getList() { return $this->list; } function setList($list) { $this->list = $list; } function getOrder() { return $this->iOrder; } function setOrder($iOrder) { $this->iOrder = $iOrder; } } ?>
<?php
// class ActionErrors extends ActionMessages { var $GLOBAL_ERROR = 'phpmvc.action.GLOBAL_ERROR'; function getGlobalErrorKey() { return $this->GLOBAL_ERROR; } function add($property, $error) { parent::add($property, $error); } } ?>
<?php
 class ForwardAction extends Action { var $log = NULL; function ForwardAction() { $this->log = new PhpMVC_Log(); $this->log->setLog('isDebugEnabled' , False); $this->log->setLog('isInfoEnabled' , False); $this->log->setLog('isTraceEnabled' , False); } function execute($mapping, $form, $request, $response) { $debug = $this->log->getLog('isDebugEnabled'); $trace = $this->log->getLog('isTraceEnabled'); if($trace) { $this->log->trace('Start: ForwardAction->execute(...)'. '['.__LINE__.']'); } $path = $mapping->getParameter(); if($path == NULL) { return NULL; } $appServerContext = $this->actionServer->appServerConfig->getAppServerContext(); $actionDispatcher = $appServerContext->getInitParameter('ACTION_DISPATCHER'); $ad = new $actionDispatcher; if($ad == NULL) { return; } $ad->setActionServer($this->actionServer); $ad->forward($path, $request, $response); return NULL; } } ?>
<?php
 class DispatchAction extends Action { var $messages = NULL; var $methods = array(); var $log = NULL; function DispatchAction($config='LocalStrings') { $returnNull = False; $defaultLocale = new Locale(); $factory = NULL; $pmr = NULL; $this->messages = new PropertyMessageResources($factory, $config, $returnNull); $this->messages->setDefaultLocale($defaultLocale); $this->log = new PhpMVC_Log(); $this->log->setLog('isTraceEnabled' , False); $this->log->setLog('isDebugEnabled' , False); $this->log->setLog('isErrorEnabled' , False); } function dispatchMethod($mapping, $form, &$request, &$response, $name) { $trace = $this->log->getLog('isTraceEnabled'); $debug = $this->log->getLog('isDebugEnabled'); $error = $this->log->getLog('isErrorEnabled'); if($trace) { $this->log->trace('Start: DispatchAction->dispatchMethod(...)'. '['.__LINE__.']'); } $locale = $request->getAttribute('locale'); if(get_class($locale) != 'locale') $locale = NULL; $method = NULL; $method = $this->getMethod($name); if($method == NULL) { $args = array($mapping->getPath(), $name); $message = $this->messages->getMessage($locale, 'dispatch.method', $args); if($error) { $this->log->error('DispatchAction->dispatchMethod(...)'. '['.__LINE__.'] ' . $message); } return NULL; } $forward = NULL; $forward = $this->$name($mapping, $form, $request, $response); if($forward == NULL) { $args = array($mapping->getPath(), $name); $message = $this->messages->getMessage($locale, "dispatch.error", $args); if($error) { $this->log->error('DispatchAction->dispatchMethod(...)'. '['.__LINE__.'] ' . $message); } return NULL; } return $forward; } function execute($mapping, $form, &$request, &$response) { $trace = $this->log->getLog('isTraceEnabled'); $debug = $this->log->getLog('isDebugEnabled'); $error = $this->log->getLog('isErrorEnabled'); if($trace) { $this->log->trace('Start: DispatchAction->execute(...)'. '['.__LINE__.']'); } $locale = $request->getAttribute('locale'); if(get_class($locale) != 'locale') $locale = NULL; $parameter = $mapping->getParameter(); if($parameter == NULL) { $args = array($mapping->getPath()); $message = $this->messages->getMessage($locale, "dispatch.handler", $args); if($error) { $this->log->error('DispatchAction->execute(...)'. '['.__LINE__.'] ' . $message); } return NULL; } $name = $request->getParameter($parameter); if($name == NULL) { $args = array($mapping->getPath(), $parameter); $message = $this->messages->getMessage( $locale, "dispatch.parameter", $args); if($error) { $this->log->error('DispatchAction->execute(...)'. '['.__LINE__.'] ' . $message); } return NULL; } return $this->dispatchMethod($mapping, $form, $request, $response, $name); } function getMethod($name) { $trace = $this->log->getLog('isTraceEnabled'); if($trace) { $this->log->trace('Start: DispatchAction->getMethod(...)'. '['.__LINE__.']'); } $method = NULL; if( array_key_exists($name, $this->methods) ) $method = $this->methods[$name]; if($method == NULL) { $class_methods = get_class_methods(get_class($this)); foreach($class_methods as $method_name) { if(strtolower($name) == strtolower($method_name)) { $this->methods[$name] = $name; $method = $name; break; } } } return $method; } } ?>
<?php
 class LookupDispatchAction extends DispatchAction { var $lookupMap = NULL; var $keyMethodMap = NULL; var $log = NULL; function LookupDispatchAction($config='') { parent::DispatchAction($config); $this->log = new PhpMVC_Log(); $this->log->setLog('isDebugEnabled' , False); $this->log->setLog('isInfoEnabled' , False); $this->log->setLog('isTraceEnabled' , False); } function execute($mapping, $form, &$request, &$response) { $debug = $this->log->getLog('isDebugEnabled'); $trace = $this->log->getLog('isTraceEnabled'); if($trace) { $this->log->trace('Start: LookupDispatchAction->execute(...)'. '['.__LINE__.']'); } $locale = $request->getAttribute('locale'); if(get_class($locale) != 'locale') $locale = NULL; $msgRes = $this->messages; $parameter = $mapping->getParameter(); if($parameter == NULL) { $args = array( $mapping->getPath() ); $message = $msgRes->getMessage('', 'dispatch.handler', $args); return $message; } $name = $request->getParameter($parameter); if($name == NULL) { $args = array($mapping->getPath(), $parameter); $message = $msgRes->getMessage('', 'dispatch.parameter', $args); return $message; } if($this->lookupMap == NULL) { $this->lookupMap = array(); $keyMethodMap = $this->getKeyMethodMap(); foreach($keyMethodMap as $key => $value) { $text = NULL; $htmlenc = $msgRes->getMessage($locale, $key); $text = $this->unhtmlentities($htmlenc); if( ($text != NULL) && (!array_key_exists($text, $this->lookupMap)) ) { $this->lookupMap[$text] = $key; } $this->keyMethodMap = $keyMethodMap; } } $key = $this->lookupMap[$name]; $methodName = $this->keyMethodMap[$key]; return $this->dispatchMethod($mapping, $form, $request, $response, $methodName); } function getKeyMethodMap() { } function unhtmlentities($string) { $trans_tbl = get_html_translation_table(HTML_ENTITIES); $trans_tbl = array_flip($trans_tbl); return strtr($string, $trans_tbl); } } ?>
<?php
 class AppServerConfig { var $mapping = 'ActionConfig'; var $context = NULL; var $parameter = array(); function AppServerConfig() { ; } function getInitParameter($name) { if( array_key_exists($name, $this->parameter) ) return $this->parameter[$name]; else return NULL; } function setInitParameter($key, $value) { $this->parameter[$key] = $value; } function getAppServerContext() { return $this->context; } function setAppServerContext(&$context) { $this->context = $context; } } ?>
<?php
 class AppServerContext { var $appAttributes = array(); var $parameter = NULL; function AppServerContext() { ; } function getInitParameter($name) { if( array_key_exists($name, $this->parameter) ) return $this->parameter[$name]; else return NULL; } function setInitParameter($key, $value) { $this->parameter[$key] = $value; } function getAttribute($name) { if( array_key_exists($name, $this->appAttributes) ) return $this->appAttributes[$name]; else return NULL; } function setAttribute($name, &$object) { return $this->appAttributes[$name] = $object; } } ?>
<?php
 class ActionConfig { var $configured = False; var $exceptions = array(); var $forwards = array(); var $applicationConfig = NULL; var $attribute = NULL; var $forward = NULL; var $include = NULL; var $input = NULL; var $multipartClass = NULL; var $name = NULL; var $parameter = NULL; var $path = NULL; var $prefix = NULL; var $roles = NULL; var $roleNames = ''; var $scope = "session"; var $suffix = NULL; var $type = NULL; var $unknown = False; var $validate = True; function getApplicationConfig() { return $this->applicationConfig; } function setApplicationConfig(&$applicationConfig) { if($this->configured) { return 'Configuration is frozen'; } $this->applicationConfig =& $applicationConfig; } function getAttribute() { if($this->attribute == NULL) { return $this->name; } else { return $this->attribute; } } function setAttribute($attribute) { if($this->configured) { return 'Configuration is frozen'; } $this->attribute = $attribute; } function getForward() { return $this->forward; } function setForward($forward) { if($this->configured) { return 'Configuration is frozen'; } $this->forward = $forward; } function getInclude() { return $this->include; } function setInclude($include) { if($this->configured) { return 'Configuration is frozen'; } $this->include = $include; } function getInput() { return $this->input; } function setInput($input) { if($this->configured) { return 'Configuration is frozen'; } $this->input = $input; } function getMultipartClass() { return $this->multipartClass; } function setMultipartClass($multipartClass) { if($this->configured) { return 'Configuration is frozen'; } $this->multipartClass = $multipartClass; } function getName() { return $this->name; } function setName($name) { if($this->configured) { return 'Configuration is frozen'; } $this->name = $name; } function getParameter() { return $this->parameter; } function setParameter($parameter) { if($this->configured) { return 'Configuration is frozen'; } $this->parameter = $parameter; } function getPath() { return $this->path; } function setPath($path) { if ($this->configured) { return 'Configuration is frozen'; } $this->path = $path; } function getPrefix() { return $this->prefix; } function setPrefix($prefix) { if($this->configured) { return 'Configuration is frozen'; } $this->prefix = $prefix; } function getRoles() { return $this->roles; } function setRoles($roles) { if($this->configured) { return 'Configuration is frozen'; } $this->roles = $roles; if($this->roles == NULL) { $this->roleNames = ''; return; } $list = array(); while(True) { $comma = strpos($roles, ','); if($comma === False) { break; } $list[] = trim( substr($roles, 0, $comma) ); $roles = substr($roles, $comma + 1); } $roles = trim($roles); if(strlen($roles) > 0) { $list[] = $roles; } $this->roleNames = $list; } function getRoleNames() { return $this->roleNames; } function getScope() { return $this->scope; } function setScope($scope) { if($this->configured) { return 'Configuration is frozen'; } $this->scope = $scope; } function getSuffix() { return $this->suffix; } function setSuffix($suffix) { if($this->configured) { return 'Configuration is frozen'; } $this->suffix = $suffix; } function getType() { return $this->type; } function setType($type) { if($this->configured) { return 'Configuration is frozen'; } $this->type = $type; } function getUnknown() { return $this->unknown; } function setUnknown($unknown) { if($this->configured) { return 'Configuration is frozen'; } $this->unknown = $unknown; } function getValidate() { return $this->validate; } function setValidate($validate) { if($this->configured) { return 'Configuration is frozen'; } $this->validate = $validate; } function addProperty($name, $value) { if($this->configured) { return 'Configuration is frozen'; } if( strtolower($value) == 'true') { $value = True; } elseif(strtolower($value) == 'false') { $value = False; } $beanUtils = new PhpBeanUtils(); $beanUtils->setProperty($this, $name, $value); } function addExceptionConfig($config) { if($this->configured) { return 'Configuration is frozen'; } $this->exceptions[$config->getType()] = $config; } function addForwardConfig($config) { if($this->configured) { return 'Configuration is frozen'; } $key = $config->getName(); $this->forwards[$key] = $config; } function findExceptionConfig($type) { return $this->exceptions[$type]; } function findExceptionConfigs() { } function findForwardConfig($name) { return $this->forwards[$name]; } function &findForwardConfigs() { $forwards = array(); $forwards =& $this->forwards; return $forwards; } function freeze() { $this->configured = True; $econfigs = $this->findExceptionConfigs(); if($econfigs != NULL) { foreach($econfigs as $econfig) { $econfig->freeze(); } } $fconfigs =& $this->findForwardConfigs(); if($fconfigs != NULL) { foreach($fconfigs as $key => $val) { $fconfigs[$key]->freeze(); } } } function removeExceptionConfig($config) { if($this->configured) { return 'Configuration is frozen'; } HelperUtils::zapArrayElement($config->getType(), $this->exceptions); } function removeForwardConfig($config) { if($this->configured) { return 'Configuration is frozen'; } HelperUtils::zapArrayElement($config->getName(), $this->forwards); } function toString() { $strBuff = 'ActionConfig['; $strBuff .= 'path='; $strBuff .= $this->path; if($this->attribute != NULL) { $strBuff .= ',attribute='; $strBuff .= $this->attribute; } if($this->forward != NULL) { $strBuff .= ',forward='; $strBuff .= $this->forward; } if($this->include != NULL) { $strBuff .= ',include='; $strBuff .= $this->include; } if($this->input != NULL) { $strBuff .= ',input='; $strBuff .= $this->input; } if($this->multipartClass != NULL) { $strBuff .= ',multipartClass='; $strBuff .= $this->multipartClass; } if($this->name != NULL) { $strBuff .= ',name='; $strBuff .= $this->name; } if($this->parameter != NULL) { $strBuff .= ',parameter='; $strBuff .= $this->parameter; } if($this->prefix != NULL) { $strBuff .= ',prefix='; $strBuff .= $this->prefix; } if($this->roles != NULL) { $strBuff .= ',roles='; $strBuff .= $this->roles; } if($this->scope != NULL) { $strBuff .= ',scope='; $strBuff .= $this->scope; } if($this->suffix != NULL) { $strBuff .= ',suffix='; $strBuff .= $this->suffix; } if($this->type != NULL) { $strBuff .= ',type='; $strBuff .= $this->type; } return $strBuff; } function getClassID() { $className = 'ActionConfig'; $fileName = 'ActionConfig.php'; $versionID = '20040528-1130'; return "$className:$fileName:$versionID"; } } ?>
<?php
 class ControllerConfig { var $configured = False; var $bufferSize = 4096; var $contentType = 'text/html'; var $debug = 0; var $locale = False; var $maxFileSize = '2M'; var $multipartClass = 'DiskMultipartRequestHandler'; var $nocache = False; var $processorClass = 'RequestProcessor'; var $tempDir = NULL; function getBufferSize() { return $this->bufferSize; } function setBufferSize($bufferSize) { if($this->configured) { return 'Configuration is frozen'; } $this->bufferSize = $bufferSize; } function getContentType() { return $this->contentType; } function setContentType($contentType) { if($this->configured) { return 'Configuration is frozen'; } $this->contentType = $contentType; } function getDebug() { return ($this->debug); } function setDebug($debug) { if ($this->configured) { return 'Configuration is frozen'; } $this->debug = $debug; } function getLocale() { return $this->locale; } function setLocale($locale) { if($this->configured) { return 'Configuration is frozen'; } $this->locale = $locale; } function getMaxFileSize() { return $this->maxFileSize; } function setMaxFileSize($maxFileSize) { if ($this->configured) { return 'Configuration is frozen'; } $this->maxFileSize = $maxFileSize; } function getMultipartClass() { return $this->multipartClass; } function setMultipartClass($multipartClass) { if($this->configured) { return 'Configuration is frozen'; } $this->multipartClass = $multipartClass; } function getNocache() { return $this->nocache; } function setNocache($nocache) { if($this->configured) { return 'Configuration is frozen'; } $this->nocache = $nocache; } function getProcessorClass() { return $this->processorClass; } function setProcessorClass($processorClass) { if($this->configured) { return 'Configuration is frozen'; } $this->processorClass = $processorClass; } function getTempDir() { return $this->tempDir; } function setTempDir($tempDir) { if($this->configured) { return 'Configuration is frozen'; } $this->tempDir = $tempDir; } function addProperty($name, $value) { if($this->configured) { return 'Configuration is frozen'; } if( strtolower($value) == 'true') { $value = True; } elseif(strtolower($value) == 'false') { $value = False; } $beanUtils = new PhpBeanUtils(); $beanUtils->setProperty($this, $name, $value); } function freeze() { $this->configured = True; } function toString() { $strBuff = 'ControllerConfig['; $strBuff .= 'bufferSize='; $strBuff .= $this->bufferSize; if($this->contentType != NULL) { $strBuff .= ',contentType='; $strBuff .= $this->contentType; } $strBuff .= ',locale='; $strBuff .= $this->locale; if($this->maxFileSize != NULL) { $strBuff .= ',maxFileSzie='; $strBuff .= $this->maxFileSize; } $strBuff .= ',nocache='; $strBuff .= $this->nocache; $strBuff .= ',processorClass='; $strBuff .= $this->processorClass; if($this->tempDir != NULL) { $strBuff .= ',tempDir='; $strBuff .= $this->tempDir; } $strBuff .= ']'; return $strBuff; } function getClassID() { $className = 'ControllerConfig'; $fileName = 'ControllerConfig.php'; $versionID = '20021025-0955'; return "$className:$fileName:$versionID"; } } ?>
<?php
 class ForwardConfig { var $configured = False; var $contextRelative = False; var $name = NULL; var $path = NULL; var $nextActionPath = NULL; var $redirect = False; var $properties = array(); function getContextRelative() { return $this->contextRelative; } function setContextRelative($contextRelative) { if($this->configured) { return 'Configuration is frozen'; } $this->contextRelative = $contextRelative; } function getName() { return $this->name; } function setName($name) { if($this->configured) { return 'Configuration is frozen'; } $this->name = $name; } function getPath() { return $this->path; } function setPath($path) { if($this->configured) { return 'Configuration is frozen'; } $URLDecodedPath = ''; $URLDecodedPath = urldecode($path); $this->path = $URLDecodedPath; } function getNextActionPath() { return $this->nextActionPath; } function setNextActionPath($nextActionPath) { if($this->configured) { } $this->nextActionPath = $nextActionPath; } function getRedirect() { return $this->redirect; } function setRedirect($redirect) { if($this->configured) { return 'Configuration is frozen'; } $this->redirect =$redirect; } function addProperty($name, $value) { if($this->configured) { return 'Configuration is frozen'; } if( strtolower($value) == 'true') { $value = True; } elseif(strtolower($value) == 'false') { $value = False; } $beanUtils = new PhpBeanUtils(); $beanUtils->setProperty($this, $name, $value); } function ForwardConfig($path='', $redirect='') { $this->setName(NULL); $this->setPath($path); $this->setRedirect($redirect); } function freeze() { $this->configured = True; } function toString() { $sb = 'ForwardConfig['; $sb .= 'name='; $sb .= $this->name; $sb .= ',path='; $sb .= $this->path; $sb .= ',redirect='; $sb .= $this->redirect; $sb .= ']'; return $sb; } function getClassID() { $className = 'ForwardConfig'; $fileName = 'ForwardConfig.php'; $versionID = '20021025-0955'; return "$className:$fileName:$versionID"; } } ?>
<?php
 class FormBeanConfig { var $configured = False; var $formProperties = array(); var $dynamic = False; var $name = NULL; var $type = NULL; function getDynamic() { return $this->dynamic; } function setDynamic($dynamic) { if($this->configured) { return "Configuration is frozen"; } $this->dynamic = $dynamic; } function getName() { return $this->name; } function setName($name) { if($this->configured) { return "Configuration is frozen"; } $this->name = $name; } function getType() { return $this->type; } function setType($type) { if($this->configured) { return "Configuration is frozen"; } $this->type = $type; if('phpmvc.action.DynaActionForm' == $type) { $this->dynamic = True; } } function addProperty($name, $value) { if($this->configured) { return 'Configuration is frozen'; } if( strtolower($value) == 'true') { $value = True; } elseif(strtolower($value) == 'false') { $value = False; } $beanUtils = new PhpBeanUtils(); $beanUtils->setProperty($this, $name, $value); } function addFormPropertyConfig($config) { if($this->configured) { return "Configuration is frozen"; } $this->formProperties[$config->getName()] = $config; } function findFormPropertyConfig($name) { return $this->formProperties[$name]; } function findFormPropertyConfigs() { return array_values($this->formProperties); } function freeze() { $this->configured = True; $fpconfigs = array(); $fpconfigs = $this->findFormPropertyConfigs(); foreach($fpconfigs as $fpconfig) { $fpconfig->freeze(); } } function removeFormPropertyConfig($config) { if($this->configured) { return "Configuration is frozen"; } $this->formProperties->remove($config->getName()); } function toString() { $sb = 'FormBeanConfig['; $sb .= 'name='; $sb .= $this->name; $sb .= ',type='; $sb .= $this->type; $sb .= ']'; return $sb; } function getClassID() { $className = 'FormBeanConfig'; $fileName = 'FormBeanConfig.php'; $versionID = '20021025-0955'; return "$className:$fileName:$versionID"; } } ?>
<?php
 class ViewResourcesConfig { var $configured = False; var $appTitle = 'My Web Application'; var $appVersion = '1.0'; var $copyright = 'Copyright � YYYY My Name. All rights reserved.'; var $contactInfo = 'webmaster@myhost.com'; var $processTags = False; var $compileAll = False; var $tagL = '<@'; var $tagR = '@>'; var $tplDir = './WEB-INF/tpl'; var $tplDirC = './WEB-INF/tpl_C'; var $extC = 'C'; var $maxFileLength = 250000; var $tagFlagStr = '.ssp'; var $tagFlagCnt = -4; function setAppTitle($appTitle) { if($this->configured) { return "Configuration is frozen"; } $this->appTitle = $appTitle; } function getAppTitle() { return $this->appTitle; } function setAppVersion($appVersion) { if($this->configured) { return "Configuration is frozen"; } $this->applVersion = $appVersion; } function getAppVersion() { return $this->appVersion; } function setCopyright($copyright) { if($this->configured) { return "Configuration is frozen"; } $this->copyright = $copyright; } function getCopyright() { return $this->copyright; } function setContactInfo($contactInfo) { if($this->configured) { return "Configuration is frozen"; } $this->contactInfo = $contactInfo; } function getContactInfo() { return $this->contactInfo; } function setProcessTags($process) { if($this->configured) { return "Configuration is frozen"; } $this->processTags = $process; } function getProcessTags() { return $this->processTags; } function setCompileAll($compileAll) { if($this->configured) { return "Configuration is frozen"; } $this->compileAll = $compileAll; } function getCompileAll() { return $this->compileAll; } function setTagLeft($tagL) { if($this->configured) { return "Configuration is frozen"; } $this->tagL = $tagL; } function getTagLeft() { return $this->tagL; } function setTagRight($tagR) { if($this->configured) { return "Configuration is frozen"; } $this->tagL = $tagR; } function getTagRight() { return $this->tagR; } function setTplDir($tplDir) { if($this->configured) { return "Configuration is frozen"; } $this->tplDir = $tplDir; } function getTplDir() { return $this->tplDir; } function setTplDirC($tplDirC) { if($this->configured) { return "Configuration is frozen"; } $this->tplDir = $tplDirC; } function getTplDirC() { return $this->tplDirC; } function setComplieExtChar($extC) { if($this->configured) { return "Configuration is frozen"; } $this->extC = $extC; } function getComplieExtChar() { return $this->extC; } function setMaxFileLength($maxFileLength) { if($this->configured) { return "Configuration is frozen"; } $this->maxFileLength = $maxFileLength; } function getMaxFileLength() { return $this->maxFileLength; } function setTagFlagStr($tagFlagStr) { if($this->configured) { return "Configuration is frozen"; } $this->tagFlagStr = $tagFlagStr; } function getTagFlagStr() { return $this->tagFlagStr; } function setTagFlagCnt($tagFlagCnt) { if($this->configured) { return "Configuration is frozen"; } $this->tagFlagCnt = $tagFlagCnt; } function getTagFlagCnt() { return $this->tagFlagCnt; } function addProperty($name, $value) { if($this->configured) { return 'Configuration is frozen'; } if( strtolower($value) == 'true') { $value = True; } elseif(strtolower($value) == 'false') { $value = False; } $beanUtils = new PhpBeanUtils(); $beanUtils->setProperty($this, $name, $value); } function freeze() { $this->configured = True; } function toString() { $sb = 'ViewResourcesConfig['; $sb .= 'configured='; ($this->configured == True) ? $sb .= "True" : $sb .= "False"; $sb .= ', appTitle='; $sb .= $this->appTitle; $sb .= ', appVersion='; $sb .= $this->appVersion; $sb .= ', copyright='; $sb .= $this->copyright; $sb .= ', contactInfo='; $sb .= $this->contactInfo; $sb .= ', processTags='; ($this->processTags == True) ? $sb .= "True" : $sb .= "False"; $sb .= ', compileAll='; ($this->compileAll == True) ? $sb .= "True" : $sb .= "False"; $sb .= ', tagL='; $sb .= $this->tagL; $sb .= ', tagR='; $sb .= $this->tagR; $sb .= ', tplDir='; $sb .= $this->tplDir; $sb .= ', tplDirC	='; $sb .= $this->tplDirC; $sb .= ', extC='; $sb .= $this->extC; $sb .= ', maxFileLength='; $sb .= $this->maxFileLength; $sb .= ', tagFlagStr='; $sb .= $this->tagFlagStr; $sb .= ', tagFlagCnt='; $sb .= $this->tagFlagCnt; $sb .= ']'; return $sb; } function getClassID() { $className = 'ViewResourcesConfig'; $fileName = 'ViewResources.php'; $versionID = '20040811-1200'; return "$className:$fileName:$versionID"; } } ?>
<?php
 class ApplicationConfig { var $classID = ''; var $actionConfigs = array(); var $dataSources = array(); var $exceptions = NULL; var $formBeans = array(); var $forwards = NULL; var $messageResources = NULL; var $plugIns = NULL; var $viewResourcesConfig = NULL; var $configured = False; var $controllerConfig = NULL; var $prefix = NULL; var $reqProcessor = NULL; var $actionServer = NULL; var $actionMappingClass = 'ActionMapping'; function getConfigured() { return $this->configured; } function &getControllerConfig() { if($this->controllerConfig == NULL) { $this->controllerConfig = new ControllerConfig(); } $controllerConfig =& $this->controllerConfig; return $controllerConfig; } function setControllerConfig($controllerConfig) { if( $this->getConfigured() ) { return; } $this->controllerConfig = $controllerConfig; } function &getViewResourcesConfig() { if($this->viewResourcesConfig == NULL) { $this->viewResourcesConfig = new ViewResourcesConfig(); } return $this->viewResourcesConfig; } function setViewResourcesConfig(&$viewResourcesConfig) { if($this->getConfigured()) { return "Configuration is frozen"; } $this->viewResourcesConfig =& $viewResourcesConfig; } function getPrefix() { return $this->prefix; } function getProcessor() { if($this->reqProcessor == NULL) { $controllerConfig = $this->getControllerConfig(); $reqProcessorClass = $controllerConfig->getProcessorClass(); $this->reqProcessor = new $reqProcessorClass; $this->reqProcessor->init($this->actionServer, $this); } return $this->reqProcessor; } function getActionServer() { return $this->actionServer; } function getActionMappingClass() { return $this->actionMappingClass; } function setActionMappingClass($actionMappingClass) { $this->actionMappingClass = $actionMappingClass; } function ApplicationConfig($prefix=NULL, &$actionServer) { $this->prefix = $prefix; $this->actionServer =& $actionServer; $this->classID = $this->_getClassID(); } function getAppContext() { ; } function addActionConfig($config) {  $config->setApplicationConfig($this); $path = $config->getPath(); $this->actionConfigs[$path]= $config; } function addDataSourceConfig($config) { if($this->getConfigured()) { return; } $key = $config->getKey(); $this->dataSources[$key]= $config; } function addExceptionConfig($config) { if($this->getConfigured()) { return; } $this->exceptions->put($config->getType(), $config); } function addFormBeanConfig($config) { if($this->getConfigured()) { return "Configuration is frozen"; } $this->formBeans[$config->getName()] = $config; } function addForwardConfig($config) { if($this->getConfigured()) { return; } $this->forwards->put($config->getName(), $config); } function addMessageResourcesConfig($config) { if($this->getConfigured()) { return; } $this->messageResources->put($config->getKey(), $config); } function addPlugIn($plugIn) { if($this->getConfigured()) { return; } $this->plugIns[] = $plugIn; } function findActionConfig($path) { if($this->actionConfigs == NULL) { return NULL; } $actionConfig = NULL; if( array_key_exists($path, $this->actionConfigs) ) { $actionConfig = $this->actionConfigs[$path]; } return $actionConfig; } function &findActionConfigs() { if($this->actionConfigs == NULL) { $ret = NULL; return $ret; } $actionConfigs = array(); $actionConfigs =& $this->actionConfigs; return $actionConfigs; } function findDataSourceConfig($key) { if($this->dataSources == NULL) { return NULL; } return $this->dataSources[$key]; } function &findDataSourceConfigs() { if($this->dataSources == NULL) { $ret = NULL; return $ret; } $dataSources = array(); $dataSources =& $this->dataSources; return $dataSources; } function findExceptionConfig($type) { if($this->exceptions == NULL) { return NULL; } return $this->exceptions->get($type); } function findExceptionConfigs() { if($this->exceptions == NULL) { return NULL; } $results = $this->exceptions->values(); return $results; } function findFormBeanConfig($name) { if($this->formBeans == NULL || $name == NULL) { return NULL; } if( array_key_exists($name, $this->formBeans) ) { return $this->formBeans[$name]; } else { return NULL; } } function &findFormBeanConfigs() { if($this->formBeans == NULL) { $ret = NULL; return $ret; } $formBeans = array(); $formBeans =& $this->formBeans; return $formBeans; } function findForwardConfig($name) { if($this->forwards == NULL) { return NULL; } return $this->forwards->get($name); } function &findForwardConfigs() { if($this->forwards == NULL) { $ret = NULL; return $ret; } $forwards = array(); $forwards =& $this->forwards; return $forwards; } function findMessageResourcesConfig($key) { if($this->messageResources == NULL) { return NULL; } return $this->messageResources->get($key); } function &findMessageResourcesConfigs() { if($this->messageResources == NULL) { $ret = NULL; return $ret; } $messageResources = array(); $messageResources =& $this->messageResources; return $messageResources; } function findPlugIns() { if($this->plugIns == NULL) { return NULL; } return $this->plugIns; } function freeze() { $this->configured = True; $aconfigs = array(); $aconfigs =& $this->findActionConfigs(); if($aconfigs != NULL) { foreach($aconfigs as $key => $val) { $aconfigs[$key]->freeze(); } } $controllerConfig =& $this->getControllerConfig(); if($controllerConfig != NULL) { $controllerConfig->freeze(); } $dsconfigs = array(); $dsconfigs =& $this->findDataSourceConfigs(); if($dsconfigs != NULL) { foreach($dsconfigs as $key => $val) { $dsconfigs[$key]->freeze(); } } $econfigs = array(); $econfigs = $this->findExceptionConfigs(); if($econfigs != NULL) { foreach($econfigs as $econfig) { $econfig->freeze(); } } $fbconfigs = array(); $fbconfigs =& $this->findFormBeanConfigs(); if($fbconfigs != NULL) { foreach($fbconfigs as $key => $val) { $fbconfigs[$key]->freeze(); } } $fconfigs = array(); $fconfigs =& $this->findForwardConfigs(); if($fconfigs != NULL) { foreach($fconfigs as $key => $val) { $fconfigs[$key]->freeze(); } } $mrconfigs = array(); $mrconfigs =& $this->findMessageResourcesConfigs(); if($mrconfigs != NULL) { foreach($mrconfigs as $key => $val) { $mrconfigs[$key]->freeze(); } } $viewResourceConfig =& $this->getViewResourcesConfig(); if($viewResourceConfig != NULL) { $viewResourceConfig->freeze(); } } function removeActionConfig($config) { if($this->getConfigured()) { return; } $config->setApplicationConfig(NULL); HelperUtils::zapArrayElement($config->getPath(), $this->actionConfigs); } function removeExceptionConfig($config) { if ($this->getConfigured()) { return; } HelperUtils::zapArrayElement($config->getType(), $this->exceptions); } function removeDataSourceConfig($config) { if($this->getConfigured()) { return; } HelperUtils::zapArrayElement($config->getKey(), $this->dataSources); } function removeFormBeanConfig($config) { if($this->getConfigured()) { return; } HelperUtils::zapArrayElement($config->getName(), $this->formBeans); } function removeForwardConfig($config) { if($this->getConfigured()) { return; } HelperUtils::zapArrayElement($config->getName(), $this->forwards); } function removeMessageResourcesConfig($config) { if ($this->getConfigured()) { return; } HelperUtils::zapArrayElement($config->getKey(), $this->messageResources); } function _getClassID() { $className = 'ApplicationConfig'; $fileName = 'ApplicationConfig.php'; $versionID = '20040811-1100'; return "$className:$fileName:$versionID"; } function getClassID() { return $this->classID; } } ?>
<?php
// class DataSourceConfig { var $configured = False; var $key = NULL; var $properties = array(); var $type = 'BasicDataSource'; function getKey() { return $this->key; } function setKey($key) { if($this->configured) { return 'Configuration is frozen'; } $this->key = $key; } function getProperties() { return $this->properties; } function getType() { return $this->type; } function setType($type) { if($this->configured) { return 'Configuration is frozen'; } $this->type = $type; } function DataSourceConfig() { $this->key = Action::getKey('DATA_SOURCE_KEY'); } function getProperty($name) { if( array_key_exists($name, $this->properties) ) { return $this->properties[$name]; } else { return NULL; } } function addProperty($name, $value) { if($this->configured) { return 'Configuration is frozen'; } if( strtolower($value) == 'true') { $value = True; } elseif(strtolower($value) == 'false') { $value = False; } $beanUtils = new PhpBeanUtils(); if( $beanUtils->setProperty($this, $name, $value) == 0 ) { $this->properties[$name] = $value; } } function freeze() { $this->configured = True; } function toString() { $strBuff = 'DataSourceConfig['; $strBuff .= 'key="'; $strBuff .= $this->key; $strBuff .= ',type='; $strBuff .= $this->type; foreach($this->properties as $name => $value) { $strBuff .= ','; $strBuff .= $name; $strBuff .= '='; $strBuff .= $value; } $strBuff .= ']'; return $strBuff; } function getClassID() { $className = 'DataSourceConfig'; $fileName = 'DataSourceConfig.php'; $versionID = '20021025-0955'; return "$className:$fileName:$versionID"; } } ?>
<?php
 class APlugIn { var $init = False; var $className = ''; var $key = ''; var $plugIn = NULL; function setClassName($value) { $this->className = $value; } function setKey($value) { $this->key = $value; } function getKey() { return $this->key; } function addProperty($name, $value) { $propertyName = 'set'.ucfirst($name); if( strtolower($value) == 'true') { $value = True; } elseif(strtolower($value) == 'false') { $value = False; } if( method_exists( $this, $propertyName) ) { $this->$propertyName($value); } else { $plugInVars = get_class_vars( get_class($this->plugIn) ); if( array_key_exists($name, $plugInVars) ) { $p =& $this->plugIn; $p->$name = $value; } else { $p =& $this->plugIn; switch ($name) { case 'template_dir': $p->setTemplateDir($value); break; case 'compile_dir': $p->setCompileDir($value); break; case 'config_dir': $p->setConfigDir($value); break; case 'cache_dir': $p->setCacheDir($value); break; default: $driverName = ucfirst(get_class($this)); print 'Error: '.$driverName.'->addProperty(): Method: '.$propertyName." not found<br>\n"; } } } } function APlugIn() { } function init($config='') { if($this->init) { return; } ; $this->init = True; } function destroy() { $this->plugIn = NULL; ; }} ?>
<?php  
 class SmartyPlugInDriver extends APlugIn { 	function SmartyPlugInDriver() {  		parent::APlugIn(); 	 		$this->plugIn = new Smarty;  	}    } ?>
<?php
 class SmartyMLPlugInDriver extends APlugIn {  	function SmartyMLPlugInDriver() {  		parent::APlugIn(); 	 		$this->plugIn = new SmartyML("en"); 	}  } ?>
<?php
 class SmartyActionDispatcher extends ActionDispatcher {   	function SmartyActionDispatcher($uri='', $wrapper='', $servletPath='',  											$pathInfo='', $queryString='', $name='') {   		parent::ActionDispatcher($uri='', $wrapper='', $servletPath='',  											$pathInfo='', $queryString='', $name='');  		$this->log->setLog('isDebugEnabled'	, False); 		$this->log->setLog('isInfoEnabled'	, False); 		$this->log->setLog('isTraceEnabled'	, False);  	}   	function serviceResponse(&$request, &$response) {  		$debug = $this->log->getLog('isDebugEnabled'); 		$trace = $this->log->getLog('isTraceEnabled');  		if($trace) 			$this->log->trace('Start: OOHFormsActionDispatcher->serviceResponse(..)['.__LINE__.']');   		$as =& $this->getActionServer(); 		 		$plugInKey = 'SMARTY_PLUGIN'; 		$smarty =& $as->getPlugIn($plugInKey); 		if($smarty == NULL) { 			echo 'No PlugIn found matching key: '.$plugInKey."<br>\n"; 		}  		$requestURI = $this->uri;   		$pageBuff = ''; 		ob_start();  			$smarty->display($requestURI); 			$pageBuff = ob_get_contents();  		ob_end_clean();   		$response->setResponseBuffer($pageBuff);  	}  } ?>
