<?php

/**
 * SecurityPermissionsEditAction
 *
 * Muestra permisos para cada modulo y diferentes tipos de usuarios y niveles
 *
 * @package security
 */

class SecurityPermissionsEditAction extends BaseAction {

	function SecurityPermissionsEditAction() {
		;
	}

	function execute($mapping, $form, &$request, &$response) {

		BaseAction::execute($mapping, $form, $request, $response);

		$plugInKey = 'SMARTY_PLUGIN';
		$smarty =& $this->actionServer->getPlugIn($plugInKey);
		if($smarty == NULL)
			echo 'No PlugIn found matching key: '.$plugInKey."<br>\n";

		$module = "Security";
		$smarty->assign("module",$module);

		$modules = Module::getActiveAndPresent();
		$smarty->assign("modules",$modules);
		if (!isset($_REQUEST['moduleName']))
			return $mapping->findForwardConfig('success');

		$languages = Array();
		if (isset($_REQUEST['languages']))
			foreach ($_REQUEST['languages'] as $languageCode)
				$language[] = MultilangLanguageQuery::create()->findOneByCode($languageCode);

		//buscamos todos los modulos sin instalar.

		$modulePath = "WEB-INF/classes/modules/" . $_REQUEST['moduleName'] . "/actions/";
		if ($directoryHandler = opendir($modulePath)) { //Si el directorio existe
			$actions = array();
	
			while (false !== ($filename = readdir($directoryHandler))) {
				//verifico si es un archivo php
				if (is_file($modulePath . $filename) && (preg_match('/(.*)Action.php$/',$filename,$regs)))
					array_push($actions,$regs[1]);
			}
			closedir($directoryHandler);
	
			$pairActions = array();
			//separacion entre accions con par y acciones sin par
			foreach ($actions as $action) {
	
				//separamos los pares de aquellos que no tienen pares
				if (preg_match("/(.*)([a-z]Do[A-Z])(.*)/",$action,$parts)) {
					//armamos el nombre de la posible action sin do
					$actionWithoutDo = $parts[1].$parts[2][0].$parts[2][3].$parts[3];
	
					if (in_array($actionWithoutDo,$actions))
						$pairActions[$actionWithoutDo] = $action;
				}
			}
	
			if (!empty($pairActions)) {
	
				$withPair = array_keys($pairActions);
				$arrays = array_diff($actions,$withPair);
	
				$actionsToDelete = array_merge(array_keys($pairActions), array_values($pairActions));
				$withoutPair = array_diff($actions,$actionsToDelete);
	
			}
			else {
				$withoutPair = $actions;
				$withPair = array();
			}
		}
		else
			unset($_GET['moduleName']);

		//$moduleSelected = SecurityModule::getAccess($_REQUEST['moduleName']);
		$moduleSelected = SecurityModuleQuery::create()->findOneByModule($_REQUEST['moduleName']);

		if (empty($moduleSelected))
			$moduleSelected = new SecurityModule();

		$generalAccess = SecurityModule::getAccessToModule($_REQUEST['moduleName']);

		$withoutPairAccess = SecurityAction::getAccessToActions($withoutPair);
		$withPairAccess = SecurityAction::getAccessToActions($withPair);

		$smarty->assign('moduleSelected', $moduleSelected);
		$smarty->assign('withoutPairAccess', $withoutPairAccess);
		$smarty->assign('withPairAccess', $withPairAccess);
		$smarty->assign('generalAccess', $generalAccess);


		$smarty->assign('levels', LevelQuery::create()->filterByBitlevel(1, Criteria::GREATER_THAN)->find());

		if (class_exists("AffiliateLevelQuery"))
			$smarty->assign('affiliateLevels', AffiliateLevelQuery::create()->find());

		if (class_exists("RegistrationUser"))
			$smarty->assign('registrationAvailable', 1);

		$smarty->assign("levelsave", SecurityModule::LEVEL_ALL);

		$smarty->assign('withoutPair', $withoutPair);
		$smarty->assign('withPair', $withPair);
		$smarty->assign('pairActions', $pairActions);
		$smarty->assign('moduleName', $_REQUEST['moduleName']);
		$smarty->assign('languages', $languages);

		$smarty->assign('message', isset($_REQUEST['message']) ? $_REQUEST['message'] : '');

		return $mapping->findForwardConfig('success');
	}

}
