<?php


/**
 * Base class that represents a query for the 'regions_timezone' table.
 *
 * Regiones y Zonas
 *
 * @method RegionTimezoneQuery orderById($order = Criteria::ASC) Order by the id column
 * @method RegionTimezoneQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method RegionTimezoneQuery orderByLabel($order = Criteria::ASC) Order by the label column
 * @method RegionTimezoneQuery orderByTreeLeft($order = Criteria::ASC) Order by the tree_left column
 * @method RegionTimezoneQuery orderByTreeRight($order = Criteria::ASC) Order by the tree_right column
 * @method RegionTimezoneQuery orderByTreeLevel($order = Criteria::ASC) Order by the tree_level column
 *
 * @method RegionTimezoneQuery groupById() Group by the id column
 * @method RegionTimezoneQuery groupByName() Group by the name column
 * @method RegionTimezoneQuery groupByLabel() Group by the label column
 * @method RegionTimezoneQuery groupByTreeLeft() Group by the tree_left column
 * @method RegionTimezoneQuery groupByTreeRight() Group by the tree_right column
 * @method RegionTimezoneQuery groupByTreeLevel() Group by the tree_level column
 *
 * @method RegionTimezoneQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method RegionTimezoneQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method RegionTimezoneQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method RegionTimezone findOne(PropelPDO $con = null) Return the first RegionTimezone matching the query
 * @method RegionTimezone findOneOrCreate(PropelPDO $con = null) Return the first RegionTimezone matching the query, or a new RegionTimezone object populated from the query conditions when no match is found
 *
 * @method RegionTimezone findOneById(int $id) Return the first RegionTimezone filtered by the id column
 * @method RegionTimezone findOneByName(string $name) Return the first RegionTimezone filtered by the name column
 * @method RegionTimezone findOneByLabel(string $label) Return the first RegionTimezone filtered by the label column
 * @method RegionTimezone findOneByTreeLeft(int $tree_left) Return the first RegionTimezone filtered by the tree_left column
 * @method RegionTimezone findOneByTreeRight(int $tree_right) Return the first RegionTimezone filtered by the tree_right column
 * @method RegionTimezone findOneByTreeLevel(int $tree_level) Return the first RegionTimezone filtered by the tree_level column
 *
 * @method array findById(int $id) Return RegionTimezone objects filtered by the id column
 * @method array findByName(string $name) Return RegionTimezone objects filtered by the name column
 * @method array findByLabel(string $label) Return RegionTimezone objects filtered by the label column
 * @method array findByTreeLeft(int $tree_left) Return RegionTimezone objects filtered by the tree_left column
 * @method array findByTreeRight(int $tree_right) Return RegionTimezone objects filtered by the tree_right column
 * @method array findByTreeLevel(int $tree_level) Return RegionTimezone objects filtered by the tree_level column
 *
 * @package    propel.generator.regions.classes.om
 */
abstract class BaseRegionTimezoneQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseRegionTimezoneQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'RegionTimezone', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new RegionTimezoneQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     RegionTimezoneQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return RegionTimezoneQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof RegionTimezoneQuery) {
            return $criteria;
        }
        $query = new RegionTimezoneQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   RegionTimezone|RegionTimezone[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = RegionTimezonePeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(RegionTimezonePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   RegionTimezone A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `NAME`, `LABEL`, `TREE_LEFT`, `TREE_RIGHT`, `TREE_LEVEL` FROM `regions_timezone` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new RegionTimezone();
            $obj->hydrate($row);
            RegionTimezonePeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return RegionTimezone|RegionTimezone[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|RegionTimezone[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return RegionTimezoneQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(RegionTimezonePeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return RegionTimezoneQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(RegionTimezonePeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionTimezoneQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(RegionTimezonePeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionTimezoneQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(RegionTimezonePeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the label column
     *
     * Example usage:
     * <code>
     * $query->filterByLabel('fooValue');   // WHERE label = 'fooValue'
     * $query->filterByLabel('%fooValue%'); // WHERE label LIKE '%fooValue%'
     * </code>
     *
     * @param     string $label The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionTimezoneQuery The current query, for fluid interface
     */
    public function filterByLabel($label = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($label)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $label)) {
                $label = str_replace('*', '%', $label);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(RegionTimezonePeer::LABEL, $label, $comparison);
    }

    /**
     * Filter the query on the tree_left column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeLeft(1234); // WHERE tree_left = 1234
     * $query->filterByTreeLeft(array(12, 34)); // WHERE tree_left IN (12, 34)
     * $query->filterByTreeLeft(array('min' => 12)); // WHERE tree_left > 12
     * </code>
     *
     * @param     mixed $treeLeft The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionTimezoneQuery The current query, for fluid interface
     */
    public function filterByTreeLeft($treeLeft = null, $comparison = null)
    {
        if (is_array($treeLeft)) {
            $useMinMax = false;
            if (isset($treeLeft['min'])) {
                $this->addUsingAlias(RegionTimezonePeer::TREE_LEFT, $treeLeft['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeLeft['max'])) {
                $this->addUsingAlias(RegionTimezonePeer::TREE_LEFT, $treeLeft['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(RegionTimezonePeer::TREE_LEFT, $treeLeft, $comparison);
    }

    /**
     * Filter the query on the tree_right column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeRight(1234); // WHERE tree_right = 1234
     * $query->filterByTreeRight(array(12, 34)); // WHERE tree_right IN (12, 34)
     * $query->filterByTreeRight(array('min' => 12)); // WHERE tree_right > 12
     * </code>
     *
     * @param     mixed $treeRight The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionTimezoneQuery The current query, for fluid interface
     */
    public function filterByTreeRight($treeRight = null, $comparison = null)
    {
        if (is_array($treeRight)) {
            $useMinMax = false;
            if (isset($treeRight['min'])) {
                $this->addUsingAlias(RegionTimezonePeer::TREE_RIGHT, $treeRight['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeRight['max'])) {
                $this->addUsingAlias(RegionTimezonePeer::TREE_RIGHT, $treeRight['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(RegionTimezonePeer::TREE_RIGHT, $treeRight, $comparison);
    }

    /**
     * Filter the query on the tree_level column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeLevel(1234); // WHERE tree_level = 1234
     * $query->filterByTreeLevel(array(12, 34)); // WHERE tree_level IN (12, 34)
     * $query->filterByTreeLevel(array('min' => 12)); // WHERE tree_level > 12
     * </code>
     *
     * @param     mixed $treeLevel The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionTimezoneQuery The current query, for fluid interface
     */
    public function filterByTreeLevel($treeLevel = null, $comparison = null)
    {
        if (is_array($treeLevel)) {
            $useMinMax = false;
            if (isset($treeLevel['min'])) {
                $this->addUsingAlias(RegionTimezonePeer::TREE_LEVEL, $treeLevel['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeLevel['max'])) {
                $this->addUsingAlias(RegionTimezonePeer::TREE_LEVEL, $treeLevel['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(RegionTimezonePeer::TREE_LEVEL, $treeLevel, $comparison);
    }

    /**
     * Exclude object from result
     *
     * @param   RegionTimezone $regionTimezone Object to remove from the list of results
     *
     * @return RegionTimezoneQuery The current query, for fluid interface
     */
    public function prune($regionTimezone = null)
    {
        if ($regionTimezone) {
            $this->addUsingAlias(RegionTimezonePeer::ID, $regionTimezone->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    // nested_set behavior

    /**
     * Filter the query to restrict the result to descendants of an object
     *
     * @param     RegionTimezone $regionTimezone The object to use for descendant search
     *
     * @return    RegionTimezoneQuery The current query, for fluid interface
     */
    public function descendantsOf($regionTimezone)
    {
        return $this
            ->addUsingAlias(RegionTimezonePeer::LEFT_COL, $regionTimezone->getLeftValue(), Criteria::GREATER_THAN)
            ->addUsingAlias(RegionTimezonePeer::LEFT_COL, $regionTimezone->getRightValue(), Criteria::LESS_THAN);
    }

    /**
     * Filter the query to restrict the result to the branch of an object.
     * Same as descendantsOf(), except that it includes the object passed as parameter in the result
     *
     * @param     RegionTimezone $regionTimezone The object to use for branch search
     *
     * @return    RegionTimezoneQuery The current query, for fluid interface
     */
    public function branchOf($regionTimezone)
    {
        return $this
            ->addUsingAlias(RegionTimezonePeer::LEFT_COL, $regionTimezone->getLeftValue(), Criteria::GREATER_EQUAL)
            ->addUsingAlias(RegionTimezonePeer::LEFT_COL, $regionTimezone->getRightValue(), Criteria::LESS_EQUAL);
    }

    /**
     * Filter the query to restrict the result to children of an object
     *
     * @param     RegionTimezone $regionTimezone The object to use for child search
     *
     * @return    RegionTimezoneQuery The current query, for fluid interface
     */
    public function childrenOf($regionTimezone)
    {
        return $this
            ->descendantsOf($regionTimezone)
            ->addUsingAlias(RegionTimezonePeer::LEVEL_COL, $regionTimezone->getLevel() + 1, Criteria::EQUAL);
    }

    /**
     * Filter the query to restrict the result to siblings of an object.
     * The result does not include the object passed as parameter.
     *
     * @param     RegionTimezone $regionTimezone The object to use for sibling search
     * @param      PropelPDO $con Connection to use.
     *
     * @return    RegionTimezoneQuery The current query, for fluid interface
     */
    public function siblingsOf($regionTimezone, PropelPDO $con = null)
    {
        if ($regionTimezone->isRoot()) {
            return $this->
                add(RegionTimezonePeer::LEVEL_COL, '1<>1', Criteria::CUSTOM);
        } else {
            return $this
                ->childrenOf($regionTimezone->getParent($con))
                ->prune($regionTimezone);
        }
    }

    /**
     * Filter the query to restrict the result to ancestors of an object
     *
     * @param     RegionTimezone $regionTimezone The object to use for ancestors search
     *
     * @return    RegionTimezoneQuery The current query, for fluid interface
     */
    public function ancestorsOf($regionTimezone)
    {
        return $this
            ->addUsingAlias(RegionTimezonePeer::LEFT_COL, $regionTimezone->getLeftValue(), Criteria::LESS_THAN)
            ->addUsingAlias(RegionTimezonePeer::RIGHT_COL, $regionTimezone->getRightValue(), Criteria::GREATER_THAN);
    }

    /**
     * Filter the query to restrict the result to roots of an object.
     * Same as ancestorsOf(), except that it includes the object passed as parameter in the result
     *
     * @param     RegionTimezone $regionTimezone The object to use for roots search
     *
     * @return    RegionTimezoneQuery The current query, for fluid interface
     */
    public function rootsOf($regionTimezone)
    {
        return $this
            ->addUsingAlias(RegionTimezonePeer::LEFT_COL, $regionTimezone->getLeftValue(), Criteria::LESS_EQUAL)
            ->addUsingAlias(RegionTimezonePeer::RIGHT_COL, $regionTimezone->getRightValue(), Criteria::GREATER_EQUAL);
    }

    /**
     * Order the result by branch, i.e. natural tree order
     *
     * @param     bool $reverse if true, reverses the order
     *
     * @return    RegionTimezoneQuery The current query, for fluid interface
     */
    public function orderByBranch($reverse = false)
    {
        if ($reverse) {
            return $this
                ->addDescendingOrderByColumn(RegionTimezonePeer::LEFT_COL);
        } else {
            return $this
                ->addAscendingOrderByColumn(RegionTimezonePeer::LEFT_COL);
        }
    }

    /**
     * Order the result by level, the closer to the root first
     *
     * @param     bool $reverse if true, reverses the order
     *
     * @return    RegionTimezoneQuery The current query, for fluid interface
     */
    public function orderByLevel($reverse = false)
    {
        if ($reverse) {
            return $this
                ->addAscendingOrderByColumn(RegionTimezonePeer::RIGHT_COL);
        } else {
            return $this
                ->addDescendingOrderByColumn(RegionTimezonePeer::RIGHT_COL);
        }
    }

    /**
     * Returns the root node for the tree
     *
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     RegionTimezone The tree root object
     */
    public function findRoot($con = null)
    {
        return $this
            ->addUsingAlias(RegionTimezonePeer::LEFT_COL, 1, Criteria::EQUAL)
            ->findOne($con);
    }

    /**
     * Returns the tree of objects
     *
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     mixed the list of results, formatted by the current formatter
     */
    public function findTree($con = null)
    {
        return $this
            ->orderByBranch()
            ->find($con);
    }

}
