<?php



/**
 * Skeleton subclass for representing a row from the 'regions_region' table.
 *
 * Regiones
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.regions.classes
 */
class Region extends BaseRegion {

 /** the default item name for this class */
	const ITEM_NAME = 'Region';

	// Tipos de region
	const CONTINENT    = 1;
	const BLOQUE       = 2;
	const COUNTRY      = 3;
	const SUBREGION    = 4;
	const STATE        = 5;
	const COUNTY       = 6;
	const DISTRICT     = 7;
	const MUNICIPALITY = 8;
	const CITY         = 9;
	const TOWN         = 10;
	const COMMUNE      = 11;
	const NEIGHBORHOOD = 12;
	const POSTAL_CODE  = 13;

	// Nombre de los tipos de region
	protected static $regionTypes = array(
				Region::CONTINENT    => 'Continent',
				Region::BLOQUE       => 'Bloque',
				Region::COUNTRY      => 'Country',
				Region::SUBREGION    => 'Subregion',
				Region::STATE        => 'State',
				Region::COUNTY       => 'County',
				Region::DISTRICT     => 'District',
				Region::MUNICIPALITY => 'Municipality',
				Region::CITY         => 'City',
				Region::TOWN         => 'Town',
				Region::COMMUNE      => 'Commune',
				Region::NEIGHBORHOOD => 'Neighborhood',
				Region::POSTAL_CODE  => 'Postal code',
			);

 /**
	* Devuelve los tipos de region activos
	*
	* @return array Tipos de region activos
	*/
	public static function getActiveRegionTypes()	{
		return array_intersect_key(Region::$regionTypes, ConfigModule::get('regions','activeRegionTypes'));
	}

 /**
	* Devuelve los nombres de los tipo de region traducidas
	*
	* @return array Nombres de tipos de region traducidas
	*/
	public static function getRegionTypesTranslated() {
		$regionTypes = Region::getActiveRegionTypes();
		foreach(array_keys($regionTypes) as $key)
			if ($key >= ConfigModule::get('regions', 'treeRootType'))
				$regionTypesTranslated[$key] = Common::getTranslation($regionTypes[$key], 'regions');
		return $regionTypesTranslated;
	}

 /**
	* Obtiene el nombre del padre de un region.
	*
	* @return array Informacion del region
	*/
	function getParentName() {
		$parent = $this->getParent();
		if (!empty($parent))
			return $parent->getName();
		else
			return;
	}

 /**
	* Obtiene el nombre del padre de un region.
	*
	* @return array Informacion del region
	*/
	function getParentId() {
		$parent = $this->getParent();
		if (!empty($parent))
			return $parent->getId();
		else
			return;
	}

 /**
	* Obtiene el nombre traducido fel tipo de region.
	*
	* @return array tipos de region
	*/
	function getRegionTypeTranslated() {
		$regionTypes = Region::$regionTypes;
		$regionTypeName = $regionTypes[$this->getType()];
		return Common::getTranslation($regionTypeName, 'regions');
	}

 /**
	 * Devuelve las partidas presupuestarias
	 * @return PropelObjectCollection partidas presupuestarias
	 */
	function getBudgetItems($criteria) {
		return BudgetRelationQuery::create(null, $criteria)->filterByBudgetgeolocation($this->getOldid())->find();
	}

 /**
	* Devuelve el string para ser usado en el historico de operaciones
	*	@return string con el texto a guardar en el historico de operaciones
	*/
	public function getLogData() {
		return substr($this->getName(),0,50);
	}

 /**
	* Obtiene todos los posibles padres a partir de un tipo de region.
	*
	*	@return array Posibles padres a partir de un tipo de region
	*/
	public function getAllPossibleParents($type = NULL) {
		if ($type == NULL && $this->getType() != NULL)
			$type = $this->getType();
		$root = RegionQuery::create()->findRoot();
		if (!empty($root)) {
			return RegionQuery::create()
										->branchOf($root)
										->orderByBranch()
										->filterByType(array(
											 'min' => ConfigModule::get('regions', 'treeRootType'),
											 'max' => !empty($type) ? ($type -1) : (ConfigModule::get('regions', 'highestType') -1),
										))
										->find();
		}
		else
			return;
	}

 /**
	* Obtiene todos los posibles padres a partir de un tipo de region.
	*
	*	@return array Posibles padres a partir de un tipo de region
	*/
	function getAllParentsByRegionType($type) {
		$treeRoot = RegionQuery::create()->findRoot();
		if (!empty($treeRoot))
			return RegionQuery::create()
								->orderByBranch()
								->filterByType(array(
									 'min' => ConfigModule::get('regions', 'treeRootType'),
									 'max' => $type-1,
								))
								->findTree();
		else
			return;
	}


 /**
	* Define si una region es eliminable
	*
	*	@return bool si se puede o no eliminar
	*/
	public function isDeletable() {
		if ($this->getType() == ConfigModule::get('regions', 'treeRootType'))
			return false;
		else
			return true;
	}

}
