<?php


/**
 * Base static class for performing query and update operations on the 'projects_activity' table.
 *
 * Activity
 *
 * @package propel.generator.projects.classes.om
 */
abstract class BaseProjectActivityPeer
{

    /** the default database name for this class */
    const DATABASE_NAME = 'application';

    /** the table name for this class */
    const TABLE_NAME = 'projects_activity';

    /** the related Propel class for this table */
    const OM_CLASS = 'ProjectActivity';

    /** the related TableMap class for this table */
    const TM_CLASS = 'ProjectActivityTableMap';

    /** The total number of columns. */
    const NUM_COLUMNS = 25;

    /** The number of lazy-loaded columns. */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /** The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS) */
    const NUM_HYDRATE_COLUMNS = 25;

    /** the column name for the ID field */
    const ID = 'projects_activity.ID';

    /** the column name for the PROJECTID field */
    const PROJECTID = 'projects_activity.PROJECTID';

    /** the column name for the NAME field */
    const NAME = 'projects_activity.NAME';

    /** the column name for the DESCRIPTION field */
    const DESCRIPTION = 'projects_activity.DESCRIPTION';

    /** the column name for the DATE field */
    const DATE = 'projects_activity.DATE';

    /** the column name for the EXPIRATIONDATE field */
    const EXPIRATIONDATE = 'projects_activity.EXPIRATIONDATE';

    /** the column name for the COMPLETED field */
    const COMPLETED = 'projects_activity.COMPLETED';

    /** the column name for the UPDATED field */
    const UPDATED = 'projects_activity.UPDATED';

    /** the column name for the UNIQUEGOALNUMERIC field */
    const UNIQUEGOALNUMERIC = 'projects_activity.UNIQUEGOALNUMERIC';

    /** the column name for the GOALPROGRESS field */
    const GOALPROGRESS = 'projects_activity.GOALPROGRESS';

    /** the column name for the NOTES field */
    const NOTES = 'projects_activity.NOTES';

    /** the column name for the USERID field */
    const USERID = 'projects_activity.USERID';

    /** the column name for the LASTMODIFICATION field */
    const LASTMODIFICATION = 'projects_activity.LASTMODIFICATION';

    /** the column name for the CHANGES field */
    const CHANGES = 'projects_activity.CHANGES';

    /** the column name for the PLANNEDSTART field */
    const PLANNEDSTART = 'projects_activity.PLANNEDSTART';

    /** the column name for the PLANNEDEND field */
    const PLANNEDEND = 'projects_activity.PLANNEDEND';

    /** the column name for the REALSTART field */
    const REALSTART = 'projects_activity.REALSTART';

    /** the column name for the REALEND field */
    const REALEND = 'projects_activity.REALEND';

    /** the column name for the CANCELLED field */
    const CANCELLED = 'projects_activity.CANCELLED';

    /** the column name for the STARTINGYEAR field */
    const STARTINGYEAR = 'projects_activity.STARTINGYEAR';

    /** the column name for the ENDINGYEAR field */
    const ENDINGYEAR = 'projects_activity.ENDINGYEAR';

    /** the column name for the PRESS field */
    const PRESS = 'projects_activity.PRESS';

    /** the column name for the BUDGET field */
    const BUDGET = 'projects_activity.BUDGET';

    /** the column name for the RESPONSIBLECODE field */
    const RESPONSIBLECODE = 'projects_activity.RESPONSIBLECODE';

    /** the column name for the DELETED_AT field */
    const DELETED_AT = 'projects_activity.DELETED_AT';

    /** The default string format for model objects of the related table **/
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * An identiy map to hold any loaded instances of ProjectActivity objects.
     * This must be public so that other peer classes can access this when hydrating from JOIN
     * queries.
     * @var        array ProjectActivity[]
     */
    public static $instances = array();


    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. ProjectActivityPeer::$fieldNames[ProjectActivityPeer::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        BasePeer::TYPE_PHPNAME => array ('Id', 'Projectid', 'Name', 'Description', 'Date', 'Expirationdate', 'Completed', 'Updated', 'Uniquegoalnumeric', 'Goalprogress', 'Notes', 'Userid', 'Lastmodification', 'Changes', 'Plannedstart', 'Plannedend', 'Realstart', 'Realend', 'Cancelled', 'Startingyear', 'Endingyear', 'Press', 'Budget', 'Responsiblecode', 'DeletedAt', ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id', 'projectid', 'name', 'description', 'date', 'expirationdate', 'completed', 'updated', 'uniquegoalnumeric', 'goalprogress', 'notes', 'userid', 'lastmodification', 'changes', 'plannedstart', 'plannedend', 'realstart', 'realend', 'cancelled', 'startingyear', 'endingyear', 'press', 'budget', 'responsiblecode', 'deletedAt', ),
        BasePeer::TYPE_COLNAME => array (ProjectActivityPeer::ID, ProjectActivityPeer::PROJECTID, ProjectActivityPeer::NAME, ProjectActivityPeer::DESCRIPTION, ProjectActivityPeer::DATE, ProjectActivityPeer::EXPIRATIONDATE, ProjectActivityPeer::COMPLETED, ProjectActivityPeer::UPDATED, ProjectActivityPeer::UNIQUEGOALNUMERIC, ProjectActivityPeer::GOALPROGRESS, ProjectActivityPeer::NOTES, ProjectActivityPeer::USERID, ProjectActivityPeer::LASTMODIFICATION, ProjectActivityPeer::CHANGES, ProjectActivityPeer::PLANNEDSTART, ProjectActivityPeer::PLANNEDEND, ProjectActivityPeer::REALSTART, ProjectActivityPeer::REALEND, ProjectActivityPeer::CANCELLED, ProjectActivityPeer::STARTINGYEAR, ProjectActivityPeer::ENDINGYEAR, ProjectActivityPeer::PRESS, ProjectActivityPeer::BUDGET, ProjectActivityPeer::RESPONSIBLECODE, ProjectActivityPeer::DELETED_AT, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID', 'PROJECTID', 'NAME', 'DESCRIPTION', 'DATE', 'EXPIRATIONDATE', 'COMPLETED', 'UPDATED', 'UNIQUEGOALNUMERIC', 'GOALPROGRESS', 'NOTES', 'USERID', 'LASTMODIFICATION', 'CHANGES', 'PLANNEDSTART', 'PLANNEDEND', 'REALSTART', 'REALEND', 'CANCELLED', 'STARTINGYEAR', 'ENDINGYEAR', 'PRESS', 'BUDGET', 'RESPONSIBLECODE', 'DELETED_AT', ),
        BasePeer::TYPE_FIELDNAME => array ('id', 'projectId', 'name', 'description', 'date', 'expirationDate', 'completed', 'updated', 'uniqueGoalNumeric', 'goalProgress', 'notes', 'userId', 'lastModification', 'changes', 'plannedStart', 'plannedEnd', 'realStart', 'realEnd', 'cancelled', 'startingYear', 'endingYear', 'press', 'budget', 'responsibleCode', 'deleted_at', ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. ProjectActivityPeer::$fieldNames[BasePeer::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        BasePeer::TYPE_PHPNAME => array ('Id' => 0, 'Projectid' => 1, 'Name' => 2, 'Description' => 3, 'Date' => 4, 'Expirationdate' => 5, 'Completed' => 6, 'Updated' => 7, 'Uniquegoalnumeric' => 8, 'Goalprogress' => 9, 'Notes' => 10, 'Userid' => 11, 'Lastmodification' => 12, 'Changes' => 13, 'Plannedstart' => 14, 'Plannedend' => 15, 'Realstart' => 16, 'Realend' => 17, 'Cancelled' => 18, 'Startingyear' => 19, 'Endingyear' => 20, 'Press' => 21, 'Budget' => 22, 'Responsiblecode' => 23, 'DeletedAt' => 24, ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id' => 0, 'projectid' => 1, 'name' => 2, 'description' => 3, 'date' => 4, 'expirationdate' => 5, 'completed' => 6, 'updated' => 7, 'uniquegoalnumeric' => 8, 'goalprogress' => 9, 'notes' => 10, 'userid' => 11, 'lastmodification' => 12, 'changes' => 13, 'plannedstart' => 14, 'plannedend' => 15, 'realstart' => 16, 'realend' => 17, 'cancelled' => 18, 'startingyear' => 19, 'endingyear' => 20, 'press' => 21, 'budget' => 22, 'responsiblecode' => 23, 'deletedAt' => 24, ),
        BasePeer::TYPE_COLNAME => array (ProjectActivityPeer::ID => 0, ProjectActivityPeer::PROJECTID => 1, ProjectActivityPeer::NAME => 2, ProjectActivityPeer::DESCRIPTION => 3, ProjectActivityPeer::DATE => 4, ProjectActivityPeer::EXPIRATIONDATE => 5, ProjectActivityPeer::COMPLETED => 6, ProjectActivityPeer::UPDATED => 7, ProjectActivityPeer::UNIQUEGOALNUMERIC => 8, ProjectActivityPeer::GOALPROGRESS => 9, ProjectActivityPeer::NOTES => 10, ProjectActivityPeer::USERID => 11, ProjectActivityPeer::LASTMODIFICATION => 12, ProjectActivityPeer::CHANGES => 13, ProjectActivityPeer::PLANNEDSTART => 14, ProjectActivityPeer::PLANNEDEND => 15, ProjectActivityPeer::REALSTART => 16, ProjectActivityPeer::REALEND => 17, ProjectActivityPeer::CANCELLED => 18, ProjectActivityPeer::STARTINGYEAR => 19, ProjectActivityPeer::ENDINGYEAR => 20, ProjectActivityPeer::PRESS => 21, ProjectActivityPeer::BUDGET => 22, ProjectActivityPeer::RESPONSIBLECODE => 23, ProjectActivityPeer::DELETED_AT => 24, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID' => 0, 'PROJECTID' => 1, 'NAME' => 2, 'DESCRIPTION' => 3, 'DATE' => 4, 'EXPIRATIONDATE' => 5, 'COMPLETED' => 6, 'UPDATED' => 7, 'UNIQUEGOALNUMERIC' => 8, 'GOALPROGRESS' => 9, 'NOTES' => 10, 'USERID' => 11, 'LASTMODIFICATION' => 12, 'CHANGES' => 13, 'PLANNEDSTART' => 14, 'PLANNEDEND' => 15, 'REALSTART' => 16, 'REALEND' => 17, 'CANCELLED' => 18, 'STARTINGYEAR' => 19, 'ENDINGYEAR' => 20, 'PRESS' => 21, 'BUDGET' => 22, 'RESPONSIBLECODE' => 23, 'DELETED_AT' => 24, ),
        BasePeer::TYPE_FIELDNAME => array ('id' => 0, 'projectId' => 1, 'name' => 2, 'description' => 3, 'date' => 4, 'expirationDate' => 5, 'completed' => 6, 'updated' => 7, 'uniqueGoalNumeric' => 8, 'goalProgress' => 9, 'notes' => 10, 'userId' => 11, 'lastModification' => 12, 'changes' => 13, 'plannedStart' => 14, 'plannedEnd' => 15, 'realStart' => 16, 'realEnd' => 17, 'cancelled' => 18, 'startingYear' => 19, 'endingYear' => 20, 'press' => 21, 'budget' => 22, 'responsibleCode' => 23, 'deleted_at' => 24, ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, )
    );

    /**
     * Translates a fieldname to another type
     *
     * @param      string $name field name
     * @param      string $fromType One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                         BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @param      string $toType   One of the class type constants
     * @return string          translated name of the field.
     * @throws PropelException - if the specified name could not be found in the fieldname mappings.
     */
    public static function translateFieldName($name, $fromType, $toType)
    {
        $toNames = ProjectActivityPeer::getFieldNames($toType);
        $key = isset(ProjectActivityPeer::$fieldKeys[$fromType][$name]) ? ProjectActivityPeer::$fieldKeys[$fromType][$name] : null;
        if ($key === null) {
            throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(ProjectActivityPeer::$fieldKeys[$fromType], true));
        }

        return $toNames[$key];
    }

    /**
     * Returns an array of field names.
     *
     * @param      string $type The type of fieldnames to return:
     *                      One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                      BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @return array           A list of field names
     * @throws PropelException - if the type is not valid.
     */
    public static function getFieldNames($type = BasePeer::TYPE_PHPNAME)
    {
        if (!array_key_exists($type, ProjectActivityPeer::$fieldNames)) {
            throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME, BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. ' . $type . ' was given.');
        }

        return ProjectActivityPeer::$fieldNames[$type];
    }

    /**
     * Convenience method which changes table.column to alias.column.
     *
     * Using this method you can maintain SQL abstraction while using column aliases.
     * <code>
     *		$c->addAlias("alias1", TablePeer::TABLE_NAME);
     *		$c->addJoin(TablePeer::alias("alias1", TablePeer::PRIMARY_KEY_COLUMN), TablePeer::PRIMARY_KEY_COLUMN);
     * </code>
     * @param      string $alias The alias for the current table.
     * @param      string $column The column name for current table. (i.e. ProjectActivityPeer::COLUMN_NAME).
     * @return string
     */
    public static function alias($alias, $column)
    {
        return str_replace(ProjectActivityPeer::TABLE_NAME.'.', $alias.'.', $column);
    }

    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param      Criteria $criteria object containing the columns to add.
     * @param      string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ProjectActivityPeer::ID);
            $criteria->addSelectColumn(ProjectActivityPeer::PROJECTID);
            $criteria->addSelectColumn(ProjectActivityPeer::NAME);
            $criteria->addSelectColumn(ProjectActivityPeer::DESCRIPTION);
            $criteria->addSelectColumn(ProjectActivityPeer::DATE);
            $criteria->addSelectColumn(ProjectActivityPeer::EXPIRATIONDATE);
            $criteria->addSelectColumn(ProjectActivityPeer::COMPLETED);
            $criteria->addSelectColumn(ProjectActivityPeer::UPDATED);
            $criteria->addSelectColumn(ProjectActivityPeer::UNIQUEGOALNUMERIC);
            $criteria->addSelectColumn(ProjectActivityPeer::GOALPROGRESS);
            $criteria->addSelectColumn(ProjectActivityPeer::NOTES);
            $criteria->addSelectColumn(ProjectActivityPeer::USERID);
            $criteria->addSelectColumn(ProjectActivityPeer::LASTMODIFICATION);
            $criteria->addSelectColumn(ProjectActivityPeer::CHANGES);
            $criteria->addSelectColumn(ProjectActivityPeer::PLANNEDSTART);
            $criteria->addSelectColumn(ProjectActivityPeer::PLANNEDEND);
            $criteria->addSelectColumn(ProjectActivityPeer::REALSTART);
            $criteria->addSelectColumn(ProjectActivityPeer::REALEND);
            $criteria->addSelectColumn(ProjectActivityPeer::CANCELLED);
            $criteria->addSelectColumn(ProjectActivityPeer::STARTINGYEAR);
            $criteria->addSelectColumn(ProjectActivityPeer::ENDINGYEAR);
            $criteria->addSelectColumn(ProjectActivityPeer::PRESS);
            $criteria->addSelectColumn(ProjectActivityPeer::BUDGET);
            $criteria->addSelectColumn(ProjectActivityPeer::RESPONSIBLECODE);
            $criteria->addSelectColumn(ProjectActivityPeer::DELETED_AT);
        } else {
            $criteria->addSelectColumn($alias . '.ID');
            $criteria->addSelectColumn($alias . '.PROJECTID');
            $criteria->addSelectColumn($alias . '.NAME');
            $criteria->addSelectColumn($alias . '.DESCRIPTION');
            $criteria->addSelectColumn($alias . '.DATE');
            $criteria->addSelectColumn($alias . '.EXPIRATIONDATE');
            $criteria->addSelectColumn($alias . '.COMPLETED');
            $criteria->addSelectColumn($alias . '.UPDATED');
            $criteria->addSelectColumn($alias . '.UNIQUEGOALNUMERIC');
            $criteria->addSelectColumn($alias . '.GOALPROGRESS');
            $criteria->addSelectColumn($alias . '.NOTES');
            $criteria->addSelectColumn($alias . '.USERID');
            $criteria->addSelectColumn($alias . '.LASTMODIFICATION');
            $criteria->addSelectColumn($alias . '.CHANGES');
            $criteria->addSelectColumn($alias . '.PLANNEDSTART');
            $criteria->addSelectColumn($alias . '.PLANNEDEND');
            $criteria->addSelectColumn($alias . '.REALSTART');
            $criteria->addSelectColumn($alias . '.REALEND');
            $criteria->addSelectColumn($alias . '.CANCELLED');
            $criteria->addSelectColumn($alias . '.STARTINGYEAR');
            $criteria->addSelectColumn($alias . '.ENDINGYEAR');
            $criteria->addSelectColumn($alias . '.PRESS');
            $criteria->addSelectColumn($alias . '.BUDGET');
            $criteria->addSelectColumn($alias . '.RESPONSIBLECODE');
            $criteria->addSelectColumn($alias . '.DELETED_AT');
        }
    }

    /**
     * Returns the number of rows matching criteria.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @return int Number of matching rows.
     */
    public static function doCount(Criteria $criteria, $distinct = false, PropelPDO $con = null)
    {
        // we may modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ProjectActivityPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ProjectActivityPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
        $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME); // Set the correct dbName

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        // soft_delete behavior
        if (ProjectActivityQuery::isSoftDeleteEnabled()) {
            $criteria->add(ProjectActivityPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ProjectActivityPeer::enableSoftDelete();
        }
        // BasePeer returns a PDOStatement
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }
    /**
     * Selects one object from the DB.
     *
     * @param      Criteria $criteria object used to create the SELECT statement.
     * @param      PropelPDO $con
     * @return                 ProjectActivity
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectOne(Criteria $criteria, PropelPDO $con = null)
    {
        $critcopy = clone $criteria;
        $critcopy->setLimit(1);
        $objects = ProjectActivityPeer::doSelect($critcopy, $con);
        if ($objects) {
            return $objects[0];
        }

        return null;
    }
    /**
     * Selects several row from the DB.
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con
     * @return array           Array of selected Objects
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelect(Criteria $criteria, PropelPDO $con = null)
    {
        return ProjectActivityPeer::populateObjects(ProjectActivityPeer::doSelectStmt($criteria, $con));
    }
    /**
     * Prepares the Criteria object and uses the parent doSelect() method to execute a PDOStatement.
     *
     * Use this method directly if you want to work with an executed statement durirectly (for example
     * to perform your own object hydration).
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con The connection to use
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return PDOStatement The executed PDOStatement object.
     * @see        BasePeer::doSelect()
     */
    public static function doSelectStmt(Criteria $criteria, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        if (!$criteria->hasSelectClause()) {
            $criteria = clone $criteria;
            ProjectActivityPeer::addSelectColumns($criteria);
        }

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME);
        // soft_delete behavior
        if (ProjectActivityQuery::isSoftDeleteEnabled()) {
            $criteria->add(ProjectActivityPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ProjectActivityPeer::enableSoftDelete();
        }

        // BasePeer returns a PDOStatement
        return BasePeer::doSelect($criteria, $con);
    }
    /**
     * Adds an object to the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doSelect*()
     * methods in your stub classes -- you may need to explicitly add objects
     * to the cache in order to ensure that the same objects are always returned by doSelect*()
     * and retrieveByPK*() calls.
     *
     * @param      ProjectActivity $obj A ProjectActivity object.
     * @param      string $key (optional) key to use for instance map (for performance boost if key was already calculated externally).
     */
    public static function addInstanceToPool($obj, $key = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if ($key === null) {
                $key = (string) $obj->getId();
            } // if key === null
            ProjectActivityPeer::$instances[$key] = $obj;
        }
    }

    /**
     * Removes an object from the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doDelete
     * methods in your stub classes -- you may need to explicitly remove objects
     * from the cache in order to prevent returning objects that no longer exist.
     *
     * @param      mixed $value A ProjectActivity object or a primary key value.
     *
     * @return void
     * @throws PropelException - if the value is invalid.
     */
    public static function removeInstanceFromPool($value)
    {
        if (Propel::isInstancePoolingEnabled() && $value !== null) {
            if (is_object($value) && $value instanceof ProjectActivity) {
                $key = (string) $value->getId();
            } elseif (is_scalar($value)) {
                // assume we've been passed a primary key
                $key = (string) $value;
            } else {
                $e = new PropelException("Invalid value passed to removeInstanceFromPool().  Expected primary key or ProjectActivity object; got " . (is_object($value) ? get_class($value) . ' object.' : var_export($value,true)));
                throw $e;
            }

            unset(ProjectActivityPeer::$instances[$key]);
        }
    } // removeInstanceFromPool()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      string $key The key (@see getPrimaryKeyHash()) for this instance.
     * @return   ProjectActivity Found object or null if 1) no instance exists for specified key or 2) instance pooling has been disabled.
     * @see        getPrimaryKeyHash()
     */
    public static function getInstanceFromPool($key)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if (isset(ProjectActivityPeer::$instances[$key])) {
                return ProjectActivityPeer::$instances[$key];
            }
        }

        return null; // just to be explicit
    }

    /**
     * Clear the instance pool.
     *
     * @return void
     */
    public static function clearInstancePool()
    {
        ProjectActivityPeer::$instances = array();
    }

    /**
     * Method to invalidate the instance pool of all tables related to projects_activity
     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
        // Invalidate objects in ActivityDocumentPeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        ActivityDocumentPeer::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return string A string version of PK or null if the components of primary key in result array are all null.
     */
    public static function getPrimaryKeyHashFromRow($row, $startcol = 0)
    {
        // If the PK cannot be derived from the row, return null.
        if ($row[$startcol] === null) {
            return null;
        }

        return (string) $row[$startcol];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $startcol = 0)
    {

        return (int) $row[$startcol];
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function populateObjects(PDOStatement $stmt)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = ProjectActivityPeer::getOMClass();
        // populate the object(s)
        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key = ProjectActivityPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj = ProjectActivityPeer::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ProjectActivityPeer::addInstanceToPool($obj, $key);
            } // if key exists
        }
        $stmt->closeCursor();

        return $results;
    }
    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return array (ProjectActivity object, last column rank)
     */
    public static function populateObject($row, $startcol = 0)
    {
        $key = ProjectActivityPeer::getPrimaryKeyHashFromRow($row, $startcol);
        if (null !== ($obj = ProjectActivityPeer::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $startcol, true); // rehydrate
            $col = $startcol + ProjectActivityPeer::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ProjectActivityPeer::OM_CLASS;
            $obj = new $cls();
            $col = $obj->hydrate($row, $startcol);
            ProjectActivityPeer::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }


    /**
     * Returns the number of rows matching criteria, joining the related Project table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinProject(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ProjectActivityPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ProjectActivityPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ProjectActivityPeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        // soft_delete behavior
        if (ProjectActivityQuery::isSoftDeleteEnabled()) {
            $criteria->add(ProjectActivityPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ProjectActivityPeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related User table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinUser(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ProjectActivityPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ProjectActivityPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ProjectActivityPeer::USERID, UserPeer::ID, $join_behavior);

        // soft_delete behavior
        if (ProjectActivityQuery::isSoftDeleteEnabled()) {
            $criteria->add(ProjectActivityPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ProjectActivityPeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Position table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinPosition(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ProjectActivityPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ProjectActivityPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ProjectActivityPeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        // soft_delete behavior
        if (ProjectActivityQuery::isSoftDeleteEnabled()) {
            $criteria->add(ProjectActivityPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ProjectActivityPeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of ProjectActivity objects pre-filled with their Project objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ProjectActivity objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinProject(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME);
        }

        ProjectActivityPeer::addSelectColumns($criteria);
        $startcol = ProjectActivityPeer::NUM_HYDRATE_COLUMNS;
        ProjectPeer::addSelectColumns($criteria);

        $criteria->addJoin(ProjectActivityPeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        // soft_delete behavior
        if (ProjectActivityQuery::isSoftDeleteEnabled()) {
            $criteria->add(ProjectActivityPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ProjectActivityPeer::enableSoftDelete();
        }
        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ProjectActivityPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ProjectActivityPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = ProjectActivityPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ProjectActivityPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = ProjectPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = ProjectPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = ProjectPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    ProjectPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (ProjectActivity) to $obj2 (Project)
                $obj2->addProjectActivity($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of ProjectActivity objects pre-filled with their User objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ProjectActivity objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinUser(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME);
        }

        ProjectActivityPeer::addSelectColumns($criteria);
        $startcol = ProjectActivityPeer::NUM_HYDRATE_COLUMNS;
        UserPeer::addSelectColumns($criteria);

        $criteria->addJoin(ProjectActivityPeer::USERID, UserPeer::ID, $join_behavior);

        // soft_delete behavior
        if (ProjectActivityQuery::isSoftDeleteEnabled()) {
            $criteria->add(ProjectActivityPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ProjectActivityPeer::enableSoftDelete();
        }
        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ProjectActivityPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ProjectActivityPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = ProjectActivityPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ProjectActivityPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = UserPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = UserPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    UserPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (ProjectActivity) to $obj2 (User)
                $obj2->addProjectActivity($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of ProjectActivity objects pre-filled with their Position objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ProjectActivity objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinPosition(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME);
        }

        ProjectActivityPeer::addSelectColumns($criteria);
        $startcol = ProjectActivityPeer::NUM_HYDRATE_COLUMNS;
        PositionPeer::addSelectColumns($criteria);

        $criteria->addJoin(ProjectActivityPeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        // soft_delete behavior
        if (ProjectActivityQuery::isSoftDeleteEnabled()) {
            $criteria->add(ProjectActivityPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ProjectActivityPeer::enableSoftDelete();
        }
        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ProjectActivityPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ProjectActivityPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = ProjectActivityPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ProjectActivityPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = PositionPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = PositionPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    PositionPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (ProjectActivity) to $obj2 (Position)
                $obj2->addProjectActivity($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining all related tables
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAll(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ProjectActivityPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ProjectActivityPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ProjectActivityPeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityPeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityPeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        // soft_delete behavior
        if (ProjectActivityQuery::isSoftDeleteEnabled()) {
            $criteria->add(ProjectActivityPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ProjectActivityPeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }

    /**
     * Selects a collection of ProjectActivity objects pre-filled with all related objects.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ProjectActivity objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAll(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME);
        }

        ProjectActivityPeer::addSelectColumns($criteria);
        $startcol2 = ProjectActivityPeer::NUM_HYDRATE_COLUMNS;

        ProjectPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + ProjectPeer::NUM_HYDRATE_COLUMNS;

        UserPeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + UserPeer::NUM_HYDRATE_COLUMNS;

        PositionPeer::addSelectColumns($criteria);
        $startcol5 = $startcol4 + PositionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ProjectActivityPeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityPeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityPeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        // soft_delete behavior
        if (ProjectActivityQuery::isSoftDeleteEnabled()) {
            $criteria->add(ProjectActivityPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ProjectActivityPeer::enableSoftDelete();
        }
        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ProjectActivityPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ProjectActivityPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ProjectActivityPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ProjectActivityPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

            // Add objects for joined Project rows

            $key2 = ProjectPeer::getPrimaryKeyHashFromRow($row, $startcol2);
            if ($key2 !== null) {
                $obj2 = ProjectPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = ProjectPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    ProjectPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 loaded

                // Add the $obj1 (ProjectActivity) to the collection in $obj2 (Project)
                $obj2->addProjectActivity($obj1);
            } // if joined row not null

            // Add objects for joined User rows

            $key3 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol3);
            if ($key3 !== null) {
                $obj3 = UserPeer::getInstanceFromPool($key3);
                if (!$obj3) {

                    $cls = UserPeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    UserPeer::addInstanceToPool($obj3, $key3);
                } // if obj3 loaded

                // Add the $obj1 (ProjectActivity) to the collection in $obj3 (User)
                $obj3->addProjectActivity($obj1);
            } // if joined row not null

            // Add objects for joined Position rows

            $key4 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol4);
            if ($key4 !== null) {
                $obj4 = PositionPeer::getInstanceFromPool($key4);
                if (!$obj4) {

                    $cls = PositionPeer::getOMClass();

                    $obj4 = new $cls();
                    $obj4->hydrate($row, $startcol4);
                    PositionPeer::addInstanceToPool($obj4, $key4);
                } // if obj4 loaded

                // Add the $obj1 (ProjectActivity) to the collection in $obj4 (Position)
                $obj4->addProjectActivity($obj1);
            } // if joined row not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Project table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptProject(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ProjectActivityPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ProjectActivityPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ProjectActivityPeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityPeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        // soft_delete behavior
        if (ProjectActivityQuery::isSoftDeleteEnabled()) {
            $criteria->add(ProjectActivityPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ProjectActivityPeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related User table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptUser(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ProjectActivityPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ProjectActivityPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ProjectActivityPeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityPeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        // soft_delete behavior
        if (ProjectActivityQuery::isSoftDeleteEnabled()) {
            $criteria->add(ProjectActivityPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ProjectActivityPeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Position table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptPosition(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ProjectActivityPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ProjectActivityPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ProjectActivityPeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityPeer::USERID, UserPeer::ID, $join_behavior);

        // soft_delete behavior
        if (ProjectActivityQuery::isSoftDeleteEnabled()) {
            $criteria->add(ProjectActivityPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ProjectActivityPeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of ProjectActivity objects pre-filled with all related objects except Project.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ProjectActivity objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptProject(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME);
        }

        ProjectActivityPeer::addSelectColumns($criteria);
        $startcol2 = ProjectActivityPeer::NUM_HYDRATE_COLUMNS;

        UserPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + UserPeer::NUM_HYDRATE_COLUMNS;

        PositionPeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + PositionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ProjectActivityPeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityPeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        // soft_delete behavior
        if (ProjectActivityQuery::isSoftDeleteEnabled()) {
            $criteria->add(ProjectActivityPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ProjectActivityPeer::enableSoftDelete();
        }

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ProjectActivityPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ProjectActivityPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ProjectActivityPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ProjectActivityPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined User rows

                $key2 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = UserPeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = UserPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    UserPeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (ProjectActivity) to the collection in $obj2 (User)
                $obj2->addProjectActivity($obj1);

            } // if joined row is not null

                // Add objects for joined Position rows

                $key3 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol3);
                if ($key3 !== null) {
                    $obj3 = PositionPeer::getInstanceFromPool($key3);
                    if (!$obj3) {

                        $cls = PositionPeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    PositionPeer::addInstanceToPool($obj3, $key3);
                } // if $obj3 already loaded

                // Add the $obj1 (ProjectActivity) to the collection in $obj3 (Position)
                $obj3->addProjectActivity($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of ProjectActivity objects pre-filled with all related objects except User.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ProjectActivity objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptUser(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME);
        }

        ProjectActivityPeer::addSelectColumns($criteria);
        $startcol2 = ProjectActivityPeer::NUM_HYDRATE_COLUMNS;

        ProjectPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + ProjectPeer::NUM_HYDRATE_COLUMNS;

        PositionPeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + PositionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ProjectActivityPeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityPeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        // soft_delete behavior
        if (ProjectActivityQuery::isSoftDeleteEnabled()) {
            $criteria->add(ProjectActivityPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ProjectActivityPeer::enableSoftDelete();
        }

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ProjectActivityPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ProjectActivityPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ProjectActivityPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ProjectActivityPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined Project rows

                $key2 = ProjectPeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = ProjectPeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = ProjectPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    ProjectPeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (ProjectActivity) to the collection in $obj2 (Project)
                $obj2->addProjectActivity($obj1);

            } // if joined row is not null

                // Add objects for joined Position rows

                $key3 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol3);
                if ($key3 !== null) {
                    $obj3 = PositionPeer::getInstanceFromPool($key3);
                    if (!$obj3) {

                        $cls = PositionPeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    PositionPeer::addInstanceToPool($obj3, $key3);
                } // if $obj3 already loaded

                // Add the $obj1 (ProjectActivity) to the collection in $obj3 (Position)
                $obj3->addProjectActivity($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of ProjectActivity objects pre-filled with all related objects except Position.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ProjectActivity objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptPosition(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME);
        }

        ProjectActivityPeer::addSelectColumns($criteria);
        $startcol2 = ProjectActivityPeer::NUM_HYDRATE_COLUMNS;

        ProjectPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + ProjectPeer::NUM_HYDRATE_COLUMNS;

        UserPeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + UserPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ProjectActivityPeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityPeer::USERID, UserPeer::ID, $join_behavior);

        // soft_delete behavior
        if (ProjectActivityQuery::isSoftDeleteEnabled()) {
            $criteria->add(ProjectActivityPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ProjectActivityPeer::enableSoftDelete();
        }

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ProjectActivityPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ProjectActivityPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ProjectActivityPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ProjectActivityPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined Project rows

                $key2 = ProjectPeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = ProjectPeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = ProjectPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    ProjectPeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (ProjectActivity) to the collection in $obj2 (Project)
                $obj2->addProjectActivity($obj1);

            } // if joined row is not null

                // Add objects for joined User rows

                $key3 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol3);
                if ($key3 !== null) {
                    $obj3 = UserPeer::getInstanceFromPool($key3);
                    if (!$obj3) {

                        $cls = UserPeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    UserPeer::addInstanceToPool($obj3, $key3);
                } // if $obj3 already loaded

                // Add the $obj1 (ProjectActivity) to the collection in $obj3 (User)
                $obj3->addProjectActivity($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }

    /**
     * Returns the TableMap related to this peer.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getDatabaseMap(ProjectActivityPeer::DATABASE_NAME)->getTable(ProjectActivityPeer::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this peer class.
     */
    public static function buildTableMap()
    {
      $dbMap = Propel::getDatabaseMap(BaseProjectActivityPeer::DATABASE_NAME);
      if (!$dbMap->hasTable(BaseProjectActivityPeer::TABLE_NAME)) {
        $dbMap->addTableObject(new ProjectActivityTableMap());
      }
    }

    /**
     * The class that the Peer will make instances of.
     *
     *
     * @return string ClassName
     */
    public static function getOMClass()
    {
        return ProjectActivityPeer::OM_CLASS;
    }

    /**
     * Performs an INSERT on the database, given a ProjectActivity or Criteria object.
     *
     * @param      mixed $values Criteria or ProjectActivity object containing data that is used to create the INSERT statement.
     * @param      PropelPDO $con the PropelPDO connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doInsert($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity
        } else {
            $criteria = $values->buildCriteria(); // build Criteria from ProjectActivity object
        }

        if ($criteria->containsKey(ProjectActivityPeer::ID) && $criteria->keyContainsValue(ProjectActivityPeer::ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.ProjectActivityPeer::ID.')');
        }


        // Set the correct dbName
        $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME);

        try {
            // use transaction because $criteria could contain info
            // for more than one table (I guess, conceivably)
            $con->beginTransaction();
            $pk = BasePeer::doInsert($criteria, $con);
            $con->commit();
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }

        return $pk;
    }

    /**
     * Performs an UPDATE on the database, given a ProjectActivity or Criteria object.
     *
     * @param      mixed $values Criteria or ProjectActivity object containing data that is used to create the UPDATE statement.
     * @param      PropelPDO $con The connection to use (specify PropelPDO connection object to exert more control over transactions).
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doUpdate($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $selectCriteria = new Criteria(ProjectActivityPeer::DATABASE_NAME);

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity

            $comparison = $criteria->getComparison(ProjectActivityPeer::ID);
            $value = $criteria->remove(ProjectActivityPeer::ID);
            if ($value) {
                $selectCriteria->add(ProjectActivityPeer::ID, $value, $comparison);
            } else {
                $selectCriteria->setPrimaryTableName(ProjectActivityPeer::TABLE_NAME);
            }

        } else { // $values is ProjectActivity object
            $criteria = $values->buildCriteria(); // gets full criteria
            $selectCriteria = $values->buildPkeyCriteria(); // gets criteria w/ primary key(s)
        }

        // set the correct dbName
        $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME);

        return BasePeer::doUpdate($selectCriteria, $criteria, $con);
    }

    /**
     * Deletes all rows from the projects_activity table.
     *
     * @param      PropelPDO $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException
     */
    public static function doForceDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $affectedRows = 0; // initialize var to track total num of affected rows
        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();
            $affectedRows += ProjectActivityPeer::doOnDeleteCascade(new Criteria(ProjectActivityPeer::DATABASE_NAME), $con);
            $affectedRows += BasePeer::doDeleteAll(ProjectActivityPeer::TABLE_NAME, $con, ProjectActivityPeer::DATABASE_NAME);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ProjectActivityPeer::clearInstancePool();
            ProjectActivityPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs a DELETE on the database, given a ProjectActivity or Criteria object OR a primary key value.
     *
     * @param      mixed $values Criteria or ProjectActivity object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param      PropelPDO $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *				if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
     public static function doForceDelete($values, PropelPDO $con = null)
     {
        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = clone $values;
        } elseif ($values instanceof ProjectActivity) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ProjectActivityPeer::DATABASE_NAME);
            $criteria->add(ProjectActivityPeer::ID, (array) $values, Criteria::IN);
        }

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityPeer::DATABASE_NAME);

        $affectedRows = 0; // initialize var to track total num of affected rows

        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();

            // cloning the Criteria in case it's modified by doSelect() or doSelectStmt()
            $c = clone $criteria;
            $affectedRows += ProjectActivityPeer::doOnDeleteCascade($c, $con);

            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            if ($values instanceof Criteria) {
                ProjectActivityPeer::clearInstancePool();
            } elseif ($values instanceof ProjectActivity) { // it's a model object
                ProjectActivityPeer::removeInstanceFromPool($values);
            } else { // it's a primary key, or an array of pks
                foreach ((array) $values as $singleval) {
                    ProjectActivityPeer::removeInstanceFromPool($singleval);
                }
            }

            $affectedRows += BasePeer::doDelete($criteria, $con);
            ProjectActivityPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * This is a method for emulating ON DELETE CASCADE for DBs that don't support this
     * feature (like MySQL or SQLite).
     *
     * This method is not very speedy because it must perform a query first to get
     * the implicated records and then perform the deletes by calling those Peer classes.
     *
     * This method should be used within a transaction if possible.
     *
     * @param      Criteria $criteria
     * @param      PropelPDO $con
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    protected static function doOnDeleteCascade(Criteria $criteria, PropelPDO $con)
    {
        // initialize var to track total num of affected rows
        $affectedRows = 0;

        // first find the objects that are implicated by the $criteria
        $objects = ProjectActivityPeer::doSelect($criteria, $con);
        foreach ($objects as $obj) {


            // delete related ActivityDocument objects
            $criteria = new Criteria(ActivityDocumentPeer::DATABASE_NAME);

            $criteria->add(ActivityDocumentPeer::ACTIVITY_ID, $obj->getId());
            $affectedRows += ActivityDocumentPeer::doDelete($criteria, $con);
        }

        return $affectedRows;
    }

    /**
     * Validates all modified columns of given ProjectActivity object.
     * If parameter $columns is either a single column name or an array of column names
     * than only those columns are validated.
     *
     * NOTICE: This does not apply to primary or foreign keys for now.
     *
     * @param      ProjectActivity $obj The object to validate.
     * @param      mixed $cols Column name or array of column names.
     *
     * @return mixed TRUE if all columns are valid or the error message of the first invalid column.
     */
    public static function doValidate($obj, $cols = null)
    {
        $columns = array();

        if ($cols) {
            $dbMap = Propel::getDatabaseMap(ProjectActivityPeer::DATABASE_NAME);
            $tableMap = $dbMap->getTable(ProjectActivityPeer::TABLE_NAME);

            if (! is_array($cols)) {
                $cols = array($cols);
            }

            foreach ($cols as $colName) {
                if ($tableMap->hasColumn($colName)) {
                    $get = 'get' . $tableMap->getColumn($colName)->getPhpName();
                    $columns[$colName] = $obj->$get();
                }
            }
        } else {

        }

        return BasePeer::doValidate(ProjectActivityPeer::DATABASE_NAME, ProjectActivityPeer::TABLE_NAME, $columns);
    }

    /**
     * Retrieve a single object by pkey.
     *
     * @param      int $pk the primary key.
     * @param      PropelPDO $con the connection to use
     * @return ProjectActivity
     */
    public static function retrieveByPK($pk, PropelPDO $con = null)
    {

        if (null !== ($obj = ProjectActivityPeer::getInstanceFromPool((string) $pk))) {
            return $obj;
        }

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria = new Criteria(ProjectActivityPeer::DATABASE_NAME);
        $criteria->add(ProjectActivityPeer::ID, $pk);

        $v = ProjectActivityPeer::doSelect($criteria, $con);

        return !empty($v) > 0 ? $v[0] : null;
    }

    /**
     * Retrieve multiple objects by pkey.
     *
     * @param      array $pks List of primary keys
     * @param      PropelPDO $con the connection to use
     * @return ProjectActivity[]
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function retrieveByPKs($pks, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $objs = null;
        if (empty($pks)) {
            $objs = array();
        } else {
            $criteria = new Criteria(ProjectActivityPeer::DATABASE_NAME);
            $criteria->add(ProjectActivityPeer::ID, $pks, Criteria::IN);
            $objs = ProjectActivityPeer::doSelect($criteria, $con);
        }

        return $objs;
    }

    // soft_delete behavior

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        ProjectActivityQuery::enableSoftDelete();
        // some soft_deleted objects may be in the instance pool
        ProjectActivityPeer::clearInstancePool();
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        ProjectActivityQuery::disableSoftDelete();
    }

    /**
     * Check the soft_delete behavior for this model
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return ProjectActivityQuery::isSoftDeleteEnabled();
    }

    /**
     * Soft delete records, given a ProjectActivity or Criteria object OR a primary key value.
     *
     * @param			 mixed $values Criteria or ProjectActivity object or primary key or array of primary keys
     *							which is used to create the DELETE statement
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doSoftDelete($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        if ($values instanceof Criteria) {
            // rename for clarity
            $selectCriteria = clone $values;
         } elseif ($values instanceof ProjectActivity) {
            // create criteria based on pk values
            $selectCriteria = $values->buildPkeyCriteria();
        } else {
            // it must be the primary key
            $selectCriteria = new Criteria(self::DATABASE_NAME);
             $selectCriteria->add(ProjectActivityPeer::ID, (array) $values, Criteria::IN);
        }
        // Set the correct dbName
        $selectCriteria->setDbName(ProjectActivityPeer::DATABASE_NAME);
        $updateCriteria = new Criteria(self::DATABASE_NAME);
        $updateCriteria->add(ProjectActivityPeer::DELETED_AT, time());

         return BasePeer::doUpdate($selectCriteria, $updateCriteria, $con);
    }

    /**
     * Delete or soft delete records, depending on ProjectActivityPeer::$softDelete
     *
     * @param			 mixed $values Criteria or ProjectActivity object or primary key or array of primary keys
     *							which is used to create the DELETE statement
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doDelete($values, PropelPDO $con = null)
    {
        if (ProjectActivityPeer::isSoftDeleteEnabled()) {
            return ProjectActivityPeer::doSoftDelete($values, $con);
        } else {
            return ProjectActivityPeer::doForceDelete($values, $con);
        }
    }
    /**
     * Method to soft delete all rows from the projects_activity table.
     *
     * @param			 PropelPDO $con the connection to use
     * @return		 int The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doSoftDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $selectCriteria = new Criteria();
        $selectCriteria->add(ProjectActivityPeer::DELETED_AT, null, Criteria::ISNULL);
        $selectCriteria->setDbName(ProjectActivityPeer::DATABASE_NAME);
        $modifyCriteria = new Criteria();
        $modifyCriteria->add(ProjectActivityPeer::DELETED_AT, time());

        return BasePeer::doUpdate($selectCriteria, $modifyCriteria, $con);
    }

    /**
     * Delete or soft delete all records, depending on ProjectActivityPeer::$softDelete
     *
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doDeleteAll(PropelPDO $con = null)
    {
        if (ProjectActivityPeer::isSoftDeleteEnabled()) {
            return ProjectActivityPeer::doSoftDeleteAll($con);
        } else {
            return ProjectActivityPeer::doForceDeleteAll($con);
        }
    }

} // BaseProjectActivityPeer

// This is the static code needed to register the TableMap for this table with the main Propel class.
//
BaseProjectActivityPeer::buildTableMap();

