<?php


/**
 * Base class that represents a row from the 'projects_activityLog' table.
 *
 * Activity Log
 *
 * @package    propel.generator.projects.classes.om
 */
abstract class BaseProjectActivityLog extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'ProjectActivityLogPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        ProjectActivityLogPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the activityid field.
     * @var        int
     */
    protected $activityid;

    /**
     * The value for the projectid field.
     * @var        int
     */
    protected $projectid;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the description field.
     * @var        string
     */
    protected $description;

    /**
     * The value for the date field.
     * @var        string
     */
    protected $date;

    /**
     * The value for the expirationdate field.
     * @var        string
     */
    protected $expirationdate;

    /**
     * The value for the completed field.
     * @var        boolean
     */
    protected $completed;

    /**
     * The value for the uniquegoalnumeric field.
     * @var        int
     */
    protected $uniquegoalnumeric;

    /**
     * The value for the goalprogress field.
     * @var        int
     */
    protected $goalprogress;

    /**
     * The value for the notes field.
     * @var        string
     */
    protected $notes;

    /**
     * The value for the userid field.
     * @var        int
     */
    protected $userid;

    /**
     * The value for the userbyaffiliatesid field.
     * @var        int
     */
    protected $userbyaffiliatesid;

    /**
     * The value for the updated field.
     * @var        string
     */
    protected $updated;

    /**
     * The value for the lastmodification field.
     * @var        string
     */
    protected $lastmodification;

    /**
     * The value for the changes field.
     * @var        int
     */
    protected $changes;

    /**
     * The value for the plannedstart field.
     * @var        string
     */
    protected $plannedstart;

    /**
     * The value for the plannedend field.
     * @var        string
     */
    protected $plannedend;

    /**
     * The value for the realstart field.
     * @var        string
     */
    protected $realstart;

    /**
     * The value for the realend field.
     * @var        string
     */
    protected $realend;

    /**
     * The value for the cancelled field.
     * @var        boolean
     */
    protected $cancelled;

    /**
     * The value for the startingyear field.
     * @var        int
     */
    protected $startingyear;

    /**
     * The value for the endingyear field.
     * @var        int
     */
    protected $endingyear;

    /**
     * The value for the press field.
     * @var        boolean
     */
    protected $press;

    /**
     * The value for the budget field.
     * @var        double
     */
    protected $budget;

    /**
     * The value for the responsiblecode field.
     * @var        int
     */
    protected $responsiblecode;

    /**
     * @var        Project
     */
    protected $aProject;

    /**
     * @var        ProjectActivity
     */
    protected $aProjectActivity;

    /**
     * @var        User
     */
    protected $aUser;

    /**
     * @var        Position
     */
    protected $aPosition;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * Get the [id] column value.
     * Activity Id
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [activityid] column value.
     * Activity Id
     * @return int
     */
    public function getActivityid()
    {
        return $this->activityid;
    }

    /**
     * Get the [projectid] column value.
     * Project Id
     * @return int
     */
    public function getProjectid()
    {
        return $this->projectid;
    }

    /**
     * Get the [name] column value.
     * Activity Name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [description] column value.
     * Activity Description
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the [optionally formatted] temporal [date] column value.
     * Activity Creation Date
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDate($format = '%Y/%m/%d')
    {
        if ($this->date === null) {
            return null;
        }

        if ($this->date === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->date);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->date, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [expirationdate] column value.
     * Activity Expiration Date
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getExpirationdate($format = '%Y/%m/%d')
    {
        if ($this->expirationdate === null) {
            return null;
        }

        if ($this->expirationdate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->expirationdate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->expirationdate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [completed] column value.
     * is Activity Completed?
     * @return boolean
     */
    public function getCompleted()
    {
        return $this->completed;
    }

    /**
     * Get the [uniquegoalnumeric] column value.
     * Project Unique Goal Numeric
     * @return int
     */
    public function getUniquegoalnumeric()
    {
        return $this->uniquegoalnumeric;
    }

    /**
     * Get the [goalprogress] column value.
     * Activity Goal Progress
     * @return int
     */
    public function getGoalprogress()
    {
        return $this->goalprogress;
    }

    /**
     * Get the [notes] column value.
     * Activity Notes
     * @return string
     */
    public function getNotes()
    {
        return $this->notes;
    }

    /**
     * Get the [userid] column value.
     * User Id
     * @return int
     */
    public function getUserid()
    {
        return $this->userid;
    }

    /**
     * Get the [userbyaffiliatesid] column value.
     * UserByAffiliates Id
     * @return int
     */
    public function getUserbyaffiliatesid()
    {
        return $this->userbyaffiliatesid;
    }

    /**
     * Get the [optionally formatted] temporal [updated] column value.
     * Updated
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getUpdated($format = 'Y-m-d H:i:s')
    {
        if ($this->updated === null) {
            return null;
        }

        if ($this->updated === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->updated);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->updated, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [lastmodification] column value.
     * Ultima modificacion Date
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getLastmodification($format = 'Y-m-d H:i:s')
    {
        if ($this->lastmodification === null) {
            return null;
        }

        if ($this->lastmodification === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->lastmodification);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->lastmodification, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [changes] column value.
     * Cantidad de modificaciones
     * @return int
     */
    public function getChanges()
    {
        return $this->changes;
    }

    /**
     * Get the [optionally formatted] temporal [plannedstart] column value.
     * Activity planned start
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getPlannedstart($format = '%Y/%m/%d')
    {
        if ($this->plannedstart === null) {
            return null;
        }

        if ($this->plannedstart === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->plannedstart);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->plannedstart, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [plannedend] column value.
     * Activity planned End
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getPlannedend($format = '%Y/%m/%d')
    {
        if ($this->plannedend === null) {
            return null;
        }

        if ($this->plannedend === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->plannedend);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->plannedend, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [realstart] column value.
     * Activity real start
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getRealstart($format = '%Y/%m/%d')
    {
        if ($this->realstart === null) {
            return null;
        }

        if ($this->realstart === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->realstart);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->realstart, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [realend] column value.
     * Activity real end
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getRealend($format = '%Y/%m/%d')
    {
        if ($this->realend === null) {
            return null;
        }

        if ($this->realend === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->realend);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->realend, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [cancelled] column value.
     * is activity cancelled?
     * @return boolean
     */
    public function getCancelled()
    {
        return $this->cancelled;
    }

    /**
     * Get the [startingyear] column value.
     * Starting year
     * @return int
     */
    public function getStartingyear()
    {
        return $this->startingyear;
    }

    /**
     * Get the [endingyear] column value.
     * Ending year
     * @return int
     */
    public function getEndingyear()
    {
        return $this->endingyear;
    }

    /**
     * Get the [press] column value.
     * Interes prensa?
     * @return boolean
     */
    public function getPress()
    {
        return $this->press;
    }

    /**
     * Get the [budget] column value.
     * Project Activity Budget (Presupuesto)
     * @return double
     */
    public function getBudget()
    {
        return $this->budget;
    }

    /**
     * Get the [responsiblecode] column value.
     * Codigo del responsable
     * @return int
     */
    public function getResponsiblecode()
    {
        return $this->responsiblecode;
    }

    /**
     * Set the value of [id] column.
     * Activity Id
     * @param int $v new value
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = ProjectActivityLogPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [activityid] column.
     * Activity Id
     * @param int $v new value
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setActivityid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->activityid !== $v) {
            $this->activityid = $v;
            $this->modifiedColumns[] = ProjectActivityLogPeer::ACTIVITYID;
        }

        if ($this->aProjectActivity !== null && $this->aProjectActivity->getId() !== $v) {
            $this->aProjectActivity = null;
        }


        return $this;
    } // setActivityid()

    /**
     * Set the value of [projectid] column.
     * Project Id
     * @param int $v new value
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setProjectid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->projectid !== $v) {
            $this->projectid = $v;
            $this->modifiedColumns[] = ProjectActivityLogPeer::PROJECTID;
        }

        if ($this->aProject !== null && $this->aProject->getId() !== $v) {
            $this->aProject = null;
        }


        return $this;
    } // setProjectid()

    /**
     * Set the value of [name] column.
     * Activity Name
     * @param string $v new value
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = ProjectActivityLogPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [description] column.
     * Activity Description
     * @param string $v new value
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->description !== $v) {
            $this->description = $v;
            $this->modifiedColumns[] = ProjectActivityLogPeer::DESCRIPTION;
        }


        return $this;
    } // setDescription()

    /**
     * Sets the value of [date] column to a normalized version of the date/time value specified.
     * Activity Creation Date
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setDate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->date !== null || $dt !== null) {
            $currentDateAsString = ($this->date !== null && $tmpDt = new DateTime($this->date)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->date = $newDateAsString;
                $this->modifiedColumns[] = ProjectActivityLogPeer::DATE;
            }
        } // if either are not null


        return $this;
    } // setDate()

    /**
     * Sets the value of [expirationdate] column to a normalized version of the date/time value specified.
     * Activity Expiration Date
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setExpirationdate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->expirationdate !== null || $dt !== null) {
            $currentDateAsString = ($this->expirationdate !== null && $tmpDt = new DateTime($this->expirationdate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->expirationdate = $newDateAsString;
                $this->modifiedColumns[] = ProjectActivityLogPeer::EXPIRATIONDATE;
            }
        } // if either are not null


        return $this;
    } // setExpirationdate()

    /**
     * Sets the value of the [completed] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * is Activity Completed?
     * @param boolean|integer|string $v The new value
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setCompleted($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->completed !== $v) {
            $this->completed = $v;
            $this->modifiedColumns[] = ProjectActivityLogPeer::COMPLETED;
        }


        return $this;
    } // setCompleted()

    /**
     * Set the value of [uniquegoalnumeric] column.
     * Project Unique Goal Numeric
     * @param int $v new value
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setUniquegoalnumeric($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->uniquegoalnumeric !== $v) {
            $this->uniquegoalnumeric = $v;
            $this->modifiedColumns[] = ProjectActivityLogPeer::UNIQUEGOALNUMERIC;
        }


        return $this;
    } // setUniquegoalnumeric()

    /**
     * Set the value of [goalprogress] column.
     * Activity Goal Progress
     * @param int $v new value
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setGoalprogress($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->goalprogress !== $v) {
            $this->goalprogress = $v;
            $this->modifiedColumns[] = ProjectActivityLogPeer::GOALPROGRESS;
        }


        return $this;
    } // setGoalprogress()

    /**
     * Set the value of [notes] column.
     * Activity Notes
     * @param string $v new value
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setNotes($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->notes !== $v) {
            $this->notes = $v;
            $this->modifiedColumns[] = ProjectActivityLogPeer::NOTES;
        }


        return $this;
    } // setNotes()

    /**
     * Set the value of [userid] column.
     * User Id
     * @param int $v new value
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setUserid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->userid !== $v) {
            $this->userid = $v;
            $this->modifiedColumns[] = ProjectActivityLogPeer::USERID;
        }

        if ($this->aUser !== null && $this->aUser->getId() !== $v) {
            $this->aUser = null;
        }


        return $this;
    } // setUserid()

    /**
     * Set the value of [userbyaffiliatesid] column.
     * UserByAffiliates Id
     * @param int $v new value
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setUserbyaffiliatesid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->userbyaffiliatesid !== $v) {
            $this->userbyaffiliatesid = $v;
            $this->modifiedColumns[] = ProjectActivityLogPeer::USERBYAFFILIATESID;
        }


        return $this;
    } // setUserbyaffiliatesid()

    /**
     * Sets the value of [updated] column to a normalized version of the date/time value specified.
     * Updated
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setUpdated($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->updated !== null || $dt !== null) {
            $currentDateAsString = ($this->updated !== null && $tmpDt = new DateTime($this->updated)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->updated = $newDateAsString;
                $this->modifiedColumns[] = ProjectActivityLogPeer::UPDATED;
            }
        } // if either are not null


        return $this;
    } // setUpdated()

    /**
     * Sets the value of [lastmodification] column to a normalized version of the date/time value specified.
     * Ultima modificacion Date
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setLastmodification($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->lastmodification !== null || $dt !== null) {
            $currentDateAsString = ($this->lastmodification !== null && $tmpDt = new DateTime($this->lastmodification)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->lastmodification = $newDateAsString;
                $this->modifiedColumns[] = ProjectActivityLogPeer::LASTMODIFICATION;
            }
        } // if either are not null


        return $this;
    } // setLastmodification()

    /**
     * Set the value of [changes] column.
     * Cantidad de modificaciones
     * @param int $v new value
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setChanges($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->changes !== $v) {
            $this->changes = $v;
            $this->modifiedColumns[] = ProjectActivityLogPeer::CHANGES;
        }


        return $this;
    } // setChanges()

    /**
     * Sets the value of [plannedstart] column to a normalized version of the date/time value specified.
     * Activity planned start
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setPlannedstart($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->plannedstart !== null || $dt !== null) {
            $currentDateAsString = ($this->plannedstart !== null && $tmpDt = new DateTime($this->plannedstart)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->plannedstart = $newDateAsString;
                $this->modifiedColumns[] = ProjectActivityLogPeer::PLANNEDSTART;
            }
        } // if either are not null


        return $this;
    } // setPlannedstart()

    /**
     * Sets the value of [plannedend] column to a normalized version of the date/time value specified.
     * Activity planned End
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setPlannedend($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->plannedend !== null || $dt !== null) {
            $currentDateAsString = ($this->plannedend !== null && $tmpDt = new DateTime($this->plannedend)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->plannedend = $newDateAsString;
                $this->modifiedColumns[] = ProjectActivityLogPeer::PLANNEDEND;
            }
        } // if either are not null


        return $this;
    } // setPlannedend()

    /**
     * Sets the value of [realstart] column to a normalized version of the date/time value specified.
     * Activity real start
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setRealstart($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->realstart !== null || $dt !== null) {
            $currentDateAsString = ($this->realstart !== null && $tmpDt = new DateTime($this->realstart)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->realstart = $newDateAsString;
                $this->modifiedColumns[] = ProjectActivityLogPeer::REALSTART;
            }
        } // if either are not null


        return $this;
    } // setRealstart()

    /**
     * Sets the value of [realend] column to a normalized version of the date/time value specified.
     * Activity real end
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setRealend($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->realend !== null || $dt !== null) {
            $currentDateAsString = ($this->realend !== null && $tmpDt = new DateTime($this->realend)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->realend = $newDateAsString;
                $this->modifiedColumns[] = ProjectActivityLogPeer::REALEND;
            }
        } // if either are not null


        return $this;
    } // setRealend()

    /**
     * Sets the value of the [cancelled] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * is activity cancelled?
     * @param boolean|integer|string $v The new value
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setCancelled($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->cancelled !== $v) {
            $this->cancelled = $v;
            $this->modifiedColumns[] = ProjectActivityLogPeer::CANCELLED;
        }


        return $this;
    } // setCancelled()

    /**
     * Set the value of [startingyear] column.
     * Starting year
     * @param int $v new value
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setStartingyear($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->startingyear !== $v) {
            $this->startingyear = $v;
            $this->modifiedColumns[] = ProjectActivityLogPeer::STARTINGYEAR;
        }


        return $this;
    } // setStartingyear()

    /**
     * Set the value of [endingyear] column.
     * Ending year
     * @param int $v new value
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setEndingyear($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->endingyear !== $v) {
            $this->endingyear = $v;
            $this->modifiedColumns[] = ProjectActivityLogPeer::ENDINGYEAR;
        }


        return $this;
    } // setEndingyear()

    /**
     * Sets the value of the [press] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Interes prensa?
     * @param boolean|integer|string $v The new value
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setPress($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->press !== $v) {
            $this->press = $v;
            $this->modifiedColumns[] = ProjectActivityLogPeer::PRESS;
        }


        return $this;
    } // setPress()

    /**
     * Set the value of [budget] column.
     * Project Activity Budget (Presupuesto)
     * @param double $v new value
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setBudget($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->budget !== $v) {
            $this->budget = $v;
            $this->modifiedColumns[] = ProjectActivityLogPeer::BUDGET;
        }


        return $this;
    } // setBudget()

    /**
     * Set the value of [responsiblecode] column.
     * Codigo del responsable
     * @param int $v new value
     * @return ProjectActivityLog The current object (for fluent API support)
     */
    public function setResponsiblecode($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->responsiblecode !== $v) {
            $this->responsiblecode = $v;
            $this->modifiedColumns[] = ProjectActivityLogPeer::RESPONSIBLECODE;
        }

        if ($this->aPosition !== null && $this->aPosition->getCode() !== $v) {
            $this->aPosition = null;
        }


        return $this;
    } // setResponsiblecode()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->activityid = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
            $this->projectid = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
            $this->name = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->description = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->date = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->expirationdate = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->completed = ($row[$startcol + 7] !== null) ? (boolean) $row[$startcol + 7] : null;
            $this->uniquegoalnumeric = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
            $this->goalprogress = ($row[$startcol + 9] !== null) ? (int) $row[$startcol + 9] : null;
            $this->notes = ($row[$startcol + 10] !== null) ? (string) $row[$startcol + 10] : null;
            $this->userid = ($row[$startcol + 11] !== null) ? (int) $row[$startcol + 11] : null;
            $this->userbyaffiliatesid = ($row[$startcol + 12] !== null) ? (int) $row[$startcol + 12] : null;
            $this->updated = ($row[$startcol + 13] !== null) ? (string) $row[$startcol + 13] : null;
            $this->lastmodification = ($row[$startcol + 14] !== null) ? (string) $row[$startcol + 14] : null;
            $this->changes = ($row[$startcol + 15] !== null) ? (int) $row[$startcol + 15] : null;
            $this->plannedstart = ($row[$startcol + 16] !== null) ? (string) $row[$startcol + 16] : null;
            $this->plannedend = ($row[$startcol + 17] !== null) ? (string) $row[$startcol + 17] : null;
            $this->realstart = ($row[$startcol + 18] !== null) ? (string) $row[$startcol + 18] : null;
            $this->realend = ($row[$startcol + 19] !== null) ? (string) $row[$startcol + 19] : null;
            $this->cancelled = ($row[$startcol + 20] !== null) ? (boolean) $row[$startcol + 20] : null;
            $this->startingyear = ($row[$startcol + 21] !== null) ? (int) $row[$startcol + 21] : null;
            $this->endingyear = ($row[$startcol + 22] !== null) ? (int) $row[$startcol + 22] : null;
            $this->press = ($row[$startcol + 23] !== null) ? (boolean) $row[$startcol + 23] : null;
            $this->budget = ($row[$startcol + 24] !== null) ? (double) $row[$startcol + 24] : null;
            $this->responsiblecode = ($row[$startcol + 25] !== null) ? (int) $row[$startcol + 25] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 26; // 26 = ProjectActivityLogPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating ProjectActivityLog object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aProjectActivity !== null && $this->activityid !== $this->aProjectActivity->getId()) {
            $this->aProjectActivity = null;
        }
        if ($this->aProject !== null && $this->projectid !== $this->aProject->getId()) {
            $this->aProject = null;
        }
        if ($this->aUser !== null && $this->userid !== $this->aUser->getId()) {
            $this->aUser = null;
        }
        if ($this->aPosition !== null && $this->responsiblecode !== $this->aPosition->getCode()) {
            $this->aPosition = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = ProjectActivityLogPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aProject = null;
            $this->aProjectActivity = null;
            $this->aUser = null;
            $this->aPosition = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = ProjectActivityLogQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                ProjectActivityLogPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aProject !== null) {
                if ($this->aProject->isModified() || $this->aProject->isNew()) {
                    $affectedRows += $this->aProject->save($con);
                }
                $this->setProject($this->aProject);
            }

            if ($this->aProjectActivity !== null) {
                if ($this->aProjectActivity->isModified() || $this->aProjectActivity->isNew()) {
                    $affectedRows += $this->aProjectActivity->save($con);
                }
                $this->setProjectActivity($this->aProjectActivity);
            }

            if ($this->aUser !== null) {
                if ($this->aUser->isModified() || $this->aUser->isNew()) {
                    $affectedRows += $this->aUser->save($con);
                }
                $this->setUser($this->aUser);
            }

            if ($this->aPosition !== null) {
                if ($this->aPosition->isModified() || $this->aPosition->isNew()) {
                    $affectedRows += $this->aPosition->save($con);
                }
                $this->setPosition($this->aPosition);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = ProjectActivityLogPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . ProjectActivityLogPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(ProjectActivityLogPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::ACTIVITYID)) {
            $modifiedColumns[':p' . $index++]  = '`ACTIVITYID`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::PROJECTID)) {
            $modifiedColumns[':p' . $index++]  = '`PROJECTID`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`DESCRIPTION`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::DATE)) {
            $modifiedColumns[':p' . $index++]  = '`DATE`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::EXPIRATIONDATE)) {
            $modifiedColumns[':p' . $index++]  = '`EXPIRATIONDATE`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::COMPLETED)) {
            $modifiedColumns[':p' . $index++]  = '`COMPLETED`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::UNIQUEGOALNUMERIC)) {
            $modifiedColumns[':p' . $index++]  = '`UNIQUEGOALNUMERIC`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::GOALPROGRESS)) {
            $modifiedColumns[':p' . $index++]  = '`GOALPROGRESS`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::NOTES)) {
            $modifiedColumns[':p' . $index++]  = '`NOTES`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::USERID)) {
            $modifiedColumns[':p' . $index++]  = '`USERID`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::USERBYAFFILIATESID)) {
            $modifiedColumns[':p' . $index++]  = '`USERBYAFFILIATESID`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::UPDATED)) {
            $modifiedColumns[':p' . $index++]  = '`UPDATED`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::LASTMODIFICATION)) {
            $modifiedColumns[':p' . $index++]  = '`LASTMODIFICATION`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::CHANGES)) {
            $modifiedColumns[':p' . $index++]  = '`CHANGES`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::PLANNEDSTART)) {
            $modifiedColumns[':p' . $index++]  = '`PLANNEDSTART`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::PLANNEDEND)) {
            $modifiedColumns[':p' . $index++]  = '`PLANNEDEND`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::REALSTART)) {
            $modifiedColumns[':p' . $index++]  = '`REALSTART`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::REALEND)) {
            $modifiedColumns[':p' . $index++]  = '`REALEND`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::CANCELLED)) {
            $modifiedColumns[':p' . $index++]  = '`CANCELLED`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::STARTINGYEAR)) {
            $modifiedColumns[':p' . $index++]  = '`STARTINGYEAR`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::ENDINGYEAR)) {
            $modifiedColumns[':p' . $index++]  = '`ENDINGYEAR`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::PRESS)) {
            $modifiedColumns[':p' . $index++]  = '`PRESS`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::BUDGET)) {
            $modifiedColumns[':p' . $index++]  = '`BUDGET`';
        }
        if ($this->isColumnModified(ProjectActivityLogPeer::RESPONSIBLECODE)) {
            $modifiedColumns[':p' . $index++]  = '`RESPONSIBLECODE`';
        }

        $sql = sprintf(
            'INSERT INTO `projects_activityLog` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`ACTIVITYID`':
                        $stmt->bindValue($identifier, $this->activityid, PDO::PARAM_INT);
                        break;
                    case '`PROJECTID`':
                        $stmt->bindValue($identifier, $this->projectid, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`DESCRIPTION`':
                        $stmt->bindValue($identifier, $this->description, PDO::PARAM_STR);
                        break;
                    case '`DATE`':
                        $stmt->bindValue($identifier, $this->date, PDO::PARAM_STR);
                        break;
                    case '`EXPIRATIONDATE`':
                        $stmt->bindValue($identifier, $this->expirationdate, PDO::PARAM_STR);
                        break;
                    case '`COMPLETED`':
                        $stmt->bindValue($identifier, (int) $this->completed, PDO::PARAM_INT);
                        break;
                    case '`UNIQUEGOALNUMERIC`':
                        $stmt->bindValue($identifier, $this->uniquegoalnumeric, PDO::PARAM_INT);
                        break;
                    case '`GOALPROGRESS`':
                        $stmt->bindValue($identifier, $this->goalprogress, PDO::PARAM_INT);
                        break;
                    case '`NOTES`':
                        $stmt->bindValue($identifier, $this->notes, PDO::PARAM_STR);
                        break;
                    case '`USERID`':
                        $stmt->bindValue($identifier, $this->userid, PDO::PARAM_INT);
                        break;
                    case '`USERBYAFFILIATESID`':
                        $stmt->bindValue($identifier, $this->userbyaffiliatesid, PDO::PARAM_INT);
                        break;
                    case '`UPDATED`':
                        $stmt->bindValue($identifier, $this->updated, PDO::PARAM_STR);
                        break;
                    case '`LASTMODIFICATION`':
                        $stmt->bindValue($identifier, $this->lastmodification, PDO::PARAM_STR);
                        break;
                    case '`CHANGES`':
                        $stmt->bindValue($identifier, $this->changes, PDO::PARAM_INT);
                        break;
                    case '`PLANNEDSTART`':
                        $stmt->bindValue($identifier, $this->plannedstart, PDO::PARAM_STR);
                        break;
                    case '`PLANNEDEND`':
                        $stmt->bindValue($identifier, $this->plannedend, PDO::PARAM_STR);
                        break;
                    case '`REALSTART`':
                        $stmt->bindValue($identifier, $this->realstart, PDO::PARAM_STR);
                        break;
                    case '`REALEND`':
                        $stmt->bindValue($identifier, $this->realend, PDO::PARAM_STR);
                        break;
                    case '`CANCELLED`':
                        $stmt->bindValue($identifier, (int) $this->cancelled, PDO::PARAM_INT);
                        break;
                    case '`STARTINGYEAR`':
                        $stmt->bindValue($identifier, $this->startingyear, PDO::PARAM_INT);
                        break;
                    case '`ENDINGYEAR`':
                        $stmt->bindValue($identifier, $this->endingyear, PDO::PARAM_INT);
                        break;
                    case '`PRESS`':
                        $stmt->bindValue($identifier, (int) $this->press, PDO::PARAM_INT);
                        break;
                    case '`BUDGET`':
                        $stmt->bindValue($identifier, $this->budget, PDO::PARAM_STR);
                        break;
                    case '`RESPONSIBLECODE`':
                        $stmt->bindValue($identifier, $this->responsiblecode, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aProject !== null) {
                if (!$this->aProject->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aProject->getValidationFailures());
                }
            }

            if ($this->aProjectActivity !== null) {
                if (!$this->aProjectActivity->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aProjectActivity->getValidationFailures());
                }
            }

            if ($this->aUser !== null) {
                if (!$this->aUser->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aUser->getValidationFailures());
                }
            }

            if ($this->aPosition !== null) {
                if (!$this->aPosition->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aPosition->getValidationFailures());
                }
            }


            if (($retval = ProjectActivityLogPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }



            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ProjectActivityLogPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getActivityid();
                break;
            case 2:
                return $this->getProjectid();
                break;
            case 3:
                return $this->getName();
                break;
            case 4:
                return $this->getDescription();
                break;
            case 5:
                return $this->getDate();
                break;
            case 6:
                return $this->getExpirationdate();
                break;
            case 7:
                return $this->getCompleted();
                break;
            case 8:
                return $this->getUniquegoalnumeric();
                break;
            case 9:
                return $this->getGoalprogress();
                break;
            case 10:
                return $this->getNotes();
                break;
            case 11:
                return $this->getUserid();
                break;
            case 12:
                return $this->getUserbyaffiliatesid();
                break;
            case 13:
                return $this->getUpdated();
                break;
            case 14:
                return $this->getLastmodification();
                break;
            case 15:
                return $this->getChanges();
                break;
            case 16:
                return $this->getPlannedstart();
                break;
            case 17:
                return $this->getPlannedend();
                break;
            case 18:
                return $this->getRealstart();
                break;
            case 19:
                return $this->getRealend();
                break;
            case 20:
                return $this->getCancelled();
                break;
            case 21:
                return $this->getStartingyear();
                break;
            case 22:
                return $this->getEndingyear();
                break;
            case 23:
                return $this->getPress();
                break;
            case 24:
                return $this->getBudget();
                break;
            case 25:
                return $this->getResponsiblecode();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['ProjectActivityLog'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['ProjectActivityLog'][$this->getPrimaryKey()] = true;
        $keys = ProjectActivityLogPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getActivityid(),
            $keys[2] => $this->getProjectid(),
            $keys[3] => $this->getName(),
            $keys[4] => $this->getDescription(),
            $keys[5] => $this->getDate(),
            $keys[6] => $this->getExpirationdate(),
            $keys[7] => $this->getCompleted(),
            $keys[8] => $this->getUniquegoalnumeric(),
            $keys[9] => $this->getGoalprogress(),
            $keys[10] => $this->getNotes(),
            $keys[11] => $this->getUserid(),
            $keys[12] => $this->getUserbyaffiliatesid(),
            $keys[13] => $this->getUpdated(),
            $keys[14] => $this->getLastmodification(),
            $keys[15] => $this->getChanges(),
            $keys[16] => $this->getPlannedstart(),
            $keys[17] => $this->getPlannedend(),
            $keys[18] => $this->getRealstart(),
            $keys[19] => $this->getRealend(),
            $keys[20] => $this->getCancelled(),
            $keys[21] => $this->getStartingyear(),
            $keys[22] => $this->getEndingyear(),
            $keys[23] => $this->getPress(),
            $keys[24] => $this->getBudget(),
            $keys[25] => $this->getResponsiblecode(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aProject) {
                $result['Project'] = $this->aProject->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aProjectActivity) {
                $result['ProjectActivity'] = $this->aProjectActivity->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aUser) {
                $result['User'] = $this->aUser->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aPosition) {
                $result['Position'] = $this->aPosition->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ProjectActivityLogPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setActivityid($value);
                break;
            case 2:
                $this->setProjectid($value);
                break;
            case 3:
                $this->setName($value);
                break;
            case 4:
                $this->setDescription($value);
                break;
            case 5:
                $this->setDate($value);
                break;
            case 6:
                $this->setExpirationdate($value);
                break;
            case 7:
                $this->setCompleted($value);
                break;
            case 8:
                $this->setUniquegoalnumeric($value);
                break;
            case 9:
                $this->setGoalprogress($value);
                break;
            case 10:
                $this->setNotes($value);
                break;
            case 11:
                $this->setUserid($value);
                break;
            case 12:
                $this->setUserbyaffiliatesid($value);
                break;
            case 13:
                $this->setUpdated($value);
                break;
            case 14:
                $this->setLastmodification($value);
                break;
            case 15:
                $this->setChanges($value);
                break;
            case 16:
                $this->setPlannedstart($value);
                break;
            case 17:
                $this->setPlannedend($value);
                break;
            case 18:
                $this->setRealstart($value);
                break;
            case 19:
                $this->setRealend($value);
                break;
            case 20:
                $this->setCancelled($value);
                break;
            case 21:
                $this->setStartingyear($value);
                break;
            case 22:
                $this->setEndingyear($value);
                break;
            case 23:
                $this->setPress($value);
                break;
            case 24:
                $this->setBudget($value);
                break;
            case 25:
                $this->setResponsiblecode($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = ProjectActivityLogPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setActivityid($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setProjectid($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setName($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setDescription($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setDate($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setExpirationdate($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setCompleted($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setUniquegoalnumeric($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setGoalprogress($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setNotes($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setUserid($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setUserbyaffiliatesid($arr[$keys[12]]);
        if (array_key_exists($keys[13], $arr)) $this->setUpdated($arr[$keys[13]]);
        if (array_key_exists($keys[14], $arr)) $this->setLastmodification($arr[$keys[14]]);
        if (array_key_exists($keys[15], $arr)) $this->setChanges($arr[$keys[15]]);
        if (array_key_exists($keys[16], $arr)) $this->setPlannedstart($arr[$keys[16]]);
        if (array_key_exists($keys[17], $arr)) $this->setPlannedend($arr[$keys[17]]);
        if (array_key_exists($keys[18], $arr)) $this->setRealstart($arr[$keys[18]]);
        if (array_key_exists($keys[19], $arr)) $this->setRealend($arr[$keys[19]]);
        if (array_key_exists($keys[20], $arr)) $this->setCancelled($arr[$keys[20]]);
        if (array_key_exists($keys[21], $arr)) $this->setStartingyear($arr[$keys[21]]);
        if (array_key_exists($keys[22], $arr)) $this->setEndingyear($arr[$keys[22]]);
        if (array_key_exists($keys[23], $arr)) $this->setPress($arr[$keys[23]]);
        if (array_key_exists($keys[24], $arr)) $this->setBudget($arr[$keys[24]]);
        if (array_key_exists($keys[25], $arr)) $this->setResponsiblecode($arr[$keys[25]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(ProjectActivityLogPeer::DATABASE_NAME);

        if ($this->isColumnModified(ProjectActivityLogPeer::ID)) $criteria->add(ProjectActivityLogPeer::ID, $this->id);
        if ($this->isColumnModified(ProjectActivityLogPeer::ACTIVITYID)) $criteria->add(ProjectActivityLogPeer::ACTIVITYID, $this->activityid);
        if ($this->isColumnModified(ProjectActivityLogPeer::PROJECTID)) $criteria->add(ProjectActivityLogPeer::PROJECTID, $this->projectid);
        if ($this->isColumnModified(ProjectActivityLogPeer::NAME)) $criteria->add(ProjectActivityLogPeer::NAME, $this->name);
        if ($this->isColumnModified(ProjectActivityLogPeer::DESCRIPTION)) $criteria->add(ProjectActivityLogPeer::DESCRIPTION, $this->description);
        if ($this->isColumnModified(ProjectActivityLogPeer::DATE)) $criteria->add(ProjectActivityLogPeer::DATE, $this->date);
        if ($this->isColumnModified(ProjectActivityLogPeer::EXPIRATIONDATE)) $criteria->add(ProjectActivityLogPeer::EXPIRATIONDATE, $this->expirationdate);
        if ($this->isColumnModified(ProjectActivityLogPeer::COMPLETED)) $criteria->add(ProjectActivityLogPeer::COMPLETED, $this->completed);
        if ($this->isColumnModified(ProjectActivityLogPeer::UNIQUEGOALNUMERIC)) $criteria->add(ProjectActivityLogPeer::UNIQUEGOALNUMERIC, $this->uniquegoalnumeric);
        if ($this->isColumnModified(ProjectActivityLogPeer::GOALPROGRESS)) $criteria->add(ProjectActivityLogPeer::GOALPROGRESS, $this->goalprogress);
        if ($this->isColumnModified(ProjectActivityLogPeer::NOTES)) $criteria->add(ProjectActivityLogPeer::NOTES, $this->notes);
        if ($this->isColumnModified(ProjectActivityLogPeer::USERID)) $criteria->add(ProjectActivityLogPeer::USERID, $this->userid);
        if ($this->isColumnModified(ProjectActivityLogPeer::USERBYAFFILIATESID)) $criteria->add(ProjectActivityLogPeer::USERBYAFFILIATESID, $this->userbyaffiliatesid);
        if ($this->isColumnModified(ProjectActivityLogPeer::UPDATED)) $criteria->add(ProjectActivityLogPeer::UPDATED, $this->updated);
        if ($this->isColumnModified(ProjectActivityLogPeer::LASTMODIFICATION)) $criteria->add(ProjectActivityLogPeer::LASTMODIFICATION, $this->lastmodification);
        if ($this->isColumnModified(ProjectActivityLogPeer::CHANGES)) $criteria->add(ProjectActivityLogPeer::CHANGES, $this->changes);
        if ($this->isColumnModified(ProjectActivityLogPeer::PLANNEDSTART)) $criteria->add(ProjectActivityLogPeer::PLANNEDSTART, $this->plannedstart);
        if ($this->isColumnModified(ProjectActivityLogPeer::PLANNEDEND)) $criteria->add(ProjectActivityLogPeer::PLANNEDEND, $this->plannedend);
        if ($this->isColumnModified(ProjectActivityLogPeer::REALSTART)) $criteria->add(ProjectActivityLogPeer::REALSTART, $this->realstart);
        if ($this->isColumnModified(ProjectActivityLogPeer::REALEND)) $criteria->add(ProjectActivityLogPeer::REALEND, $this->realend);
        if ($this->isColumnModified(ProjectActivityLogPeer::CANCELLED)) $criteria->add(ProjectActivityLogPeer::CANCELLED, $this->cancelled);
        if ($this->isColumnModified(ProjectActivityLogPeer::STARTINGYEAR)) $criteria->add(ProjectActivityLogPeer::STARTINGYEAR, $this->startingyear);
        if ($this->isColumnModified(ProjectActivityLogPeer::ENDINGYEAR)) $criteria->add(ProjectActivityLogPeer::ENDINGYEAR, $this->endingyear);
        if ($this->isColumnModified(ProjectActivityLogPeer::PRESS)) $criteria->add(ProjectActivityLogPeer::PRESS, $this->press);
        if ($this->isColumnModified(ProjectActivityLogPeer::BUDGET)) $criteria->add(ProjectActivityLogPeer::BUDGET, $this->budget);
        if ($this->isColumnModified(ProjectActivityLogPeer::RESPONSIBLECODE)) $criteria->add(ProjectActivityLogPeer::RESPONSIBLECODE, $this->responsiblecode);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(ProjectActivityLogPeer::DATABASE_NAME);
        $criteria->add(ProjectActivityLogPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of ProjectActivityLog (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setActivityid($this->getActivityid());
        $copyObj->setProjectid($this->getProjectid());
        $copyObj->setName($this->getName());
        $copyObj->setDescription($this->getDescription());
        $copyObj->setDate($this->getDate());
        $copyObj->setExpirationdate($this->getExpirationdate());
        $copyObj->setCompleted($this->getCompleted());
        $copyObj->setUniquegoalnumeric($this->getUniquegoalnumeric());
        $copyObj->setGoalprogress($this->getGoalprogress());
        $copyObj->setNotes($this->getNotes());
        $copyObj->setUserid($this->getUserid());
        $copyObj->setUserbyaffiliatesid($this->getUserbyaffiliatesid());
        $copyObj->setUpdated($this->getUpdated());
        $copyObj->setLastmodification($this->getLastmodification());
        $copyObj->setChanges($this->getChanges());
        $copyObj->setPlannedstart($this->getPlannedstart());
        $copyObj->setPlannedend($this->getPlannedend());
        $copyObj->setRealstart($this->getRealstart());
        $copyObj->setRealend($this->getRealend());
        $copyObj->setCancelled($this->getCancelled());
        $copyObj->setStartingyear($this->getStartingyear());
        $copyObj->setEndingyear($this->getEndingyear());
        $copyObj->setPress($this->getPress());
        $copyObj->setBudget($this->getBudget());
        $copyObj->setResponsiblecode($this->getResponsiblecode());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return ProjectActivityLog Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return ProjectActivityLogPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new ProjectActivityLogPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Project object.
     *
     * @param             Project $v
     * @return ProjectActivityLog The current object (for fluent API support)
     * @throws PropelException
     */
    public function setProject(Project $v = null)
    {
        if ($v === null) {
            $this->setProjectid(NULL);
        } else {
            $this->setProjectid($v->getId());
        }

        $this->aProject = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Project object, it will not be re-added.
        if ($v !== null) {
            $v->addProjectActivityLog($this);
        }


        return $this;
    }


    /**
     * Get the associated Project object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Project The associated Project object.
     * @throws PropelException
     */
    public function getProject(PropelPDO $con = null)
    {
        if ($this->aProject === null && ($this->projectid !== null)) {
            $this->aProject = ProjectQuery::create()->findPk($this->projectid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aProject->addProjectActivityLogs($this);
             */
        }

        return $this->aProject;
    }

    /**
     * Declares an association between this object and a ProjectActivity object.
     *
     * @param             ProjectActivity $v
     * @return ProjectActivityLog The current object (for fluent API support)
     * @throws PropelException
     */
    public function setProjectActivity(ProjectActivity $v = null)
    {
        if ($v === null) {
            $this->setActivityid(NULL);
        } else {
            $this->setActivityid($v->getId());
        }

        $this->aProjectActivity = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the ProjectActivity object, it will not be re-added.
        if ($v !== null) {
            $v->addProjectActivityLog($this);
        }


        return $this;
    }


    /**
     * Get the associated ProjectActivity object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return ProjectActivity The associated ProjectActivity object.
     * @throws PropelException
     */
    public function getProjectActivity(PropelPDO $con = null)
    {
        if ($this->aProjectActivity === null && ($this->activityid !== null)) {
            $this->aProjectActivity = ProjectActivityQuery::create()->findPk($this->activityid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aProjectActivity->addProjectActivityLogs($this);
             */
        }

        return $this->aProjectActivity;
    }

    /**
     * Declares an association between this object and a User object.
     *
     * @param             User $v
     * @return ProjectActivityLog The current object (for fluent API support)
     * @throws PropelException
     */
    public function setUser(User $v = null)
    {
        if ($v === null) {
            $this->setUserid(NULL);
        } else {
            $this->setUserid($v->getId());
        }

        $this->aUser = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the User object, it will not be re-added.
        if ($v !== null) {
            $v->addProjectActivityLog($this);
        }


        return $this;
    }


    /**
     * Get the associated User object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return User The associated User object.
     * @throws PropelException
     */
    public function getUser(PropelPDO $con = null)
    {
        if ($this->aUser === null && ($this->userid !== null)) {
            $this->aUser = UserQuery::create()->findPk($this->userid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aUser->addProjectActivityLogs($this);
             */
        }

        return $this->aUser;
    }

    /**
     * Declares an association between this object and a Position object.
     *
     * @param             Position $v
     * @return ProjectActivityLog The current object (for fluent API support)
     * @throws PropelException
     */
    public function setPosition(Position $v = null)
    {
        if ($v === null) {
            $this->setResponsiblecode(NULL);
        } else {
            $this->setResponsiblecode($v->getCode());
        }

        $this->aPosition = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Position object, it will not be re-added.
        if ($v !== null) {
            $v->addProjectActivityLog($this);
        }


        return $this;
    }


    /**
     * Get the associated Position object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Position The associated Position object.
     * @throws PropelException
     */
    public function getPosition(PropelPDO $con = null)
    {
        if ($this->aPosition === null && ($this->responsiblecode !== null)) {
            $this->aPosition = PositionQuery::create()
                ->filterByProjectActivityLog($this) // here
                ->findOne($con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aPosition->addProjectActivityLogs($this);
             */
        }

        return $this->aPosition;
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->activityid = null;
        $this->projectid = null;
        $this->name = null;
        $this->description = null;
        $this->date = null;
        $this->expirationdate = null;
        $this->completed = null;
        $this->uniquegoalnumeric = null;
        $this->goalprogress = null;
        $this->notes = null;
        $this->userid = null;
        $this->userbyaffiliatesid = null;
        $this->updated = null;
        $this->lastmodification = null;
        $this->changes = null;
        $this->plannedstart = null;
        $this->plannedend = null;
        $this->realstart = null;
        $this->realend = null;
        $this->cancelled = null;
        $this->startingyear = null;
        $this->endingyear = null;
        $this->press = null;
        $this->budget = null;
        $this->responsiblecode = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
        } // if ($deep)

        $this->aProject = null;
        $this->aProjectActivity = null;
        $this->aUser = null;
        $this->aPosition = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

}
