<?php
require_once('ExcelManagement.php');

class ProjectsDoExportAction extends BaseAction {

	function exec() {
		parent::exec();

		$project = ProjectQuery::create()->findOneById($_GET["filters"]["projectId"]);

		$excelMgmnt = new ExcelManagement;

		$excelMgmnt->removeSheet(0);
		$excelMgmnt->createSheet('Proyecto');
		$excelMgmnt->createSheet('Actividades del proyecto');
		$excelMgmnt->setActiveSheet(0);

		$tableHeaders = [
			'font' => [
				'size' => 19,
				'bold' => true
			],
			'alignment' => [
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
				'wrap' => true,
				'shrinkToFit' => true,
			],
		];

		$dataFormat = [
			'alignment' => [
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
				'wrap' => true,
				'shrinkToFit' => true,
			],
			'font' => [
				'size' => 14,
			],
		];

		$columnsWidth = [
			['B', 'B', 49],
			['C', 'C', 60]
		];

		$projectTitle = [
			'Datos al día',
			'',
			'Nombre del proyecto',
			'Responsable',
			'Objetivo',
			'Código/Expediente',
			'Descripción',
			'Obra',
			'Período de planificación desde 2017 hasta 2019',
			'Inicio planificado',
			'Final planificado',
			'Inicio real',
			'Final real',
			//'Estado',
			'',
			'Meta producto',
			'Meta numerica',
			'Prioridad',
			'Impacto',
			'Beneficiario',
			'Visibilidad',
			'Factores de riesgo',
			'',
			'Presupuesto',
			'Fuente de financiamiento',
			'Financiamiento propio',
			'Financiamiento provincial',
			'Financiamiento nacional',
			'Otro financiamiento',
			'Detalle de financiamiento',
			'Detalle del programa',
			'¿Este proyecto implica compra y/o contratación?',
			'Tipo de compra',
			'¿Este proyecto implica contratación extra de personal?',
			'Frecuencia',
			'Dirección/zona',
			'Terminado',
			'Interés prensa',
			'Progreso',
			'Comentarios adicionales'
		];

		$projectDataFormated = $this->prepareProjectData($project);

		$cantRows = count($data) + 3;

		$excelMgmnt->applyFormat('B1', 'B43', $dataFormat);
		$excelMgmnt->applyFormat('C1', 'C43', $dataFormat);
		$excelMgmnt->applyFormat('B2', 'B2', $tableHeaders);

		$excelMgmnt->setColumnInfoFromArray($columnsWidth);

		// cargo los datos al excel
		$excelMgmnt->setDataFromArray(['Ficha del Proyecto'], 'B2');

		foreach ($projectTitle as $key => $data) {
			$row = $key + 3;
			$excelMgmnt->addData('B'.$row, $data);
		}

		foreach ($projectDataFormated as $key => $data) {
			$row = $key + 3;
			$excelMgmnt->addData('C'.$row, $data);
		}

		// Actividades
		$activitiesData = [
			[
				'Nombre',
				'Responsable',
				'Inicio planificado',
				'Fin planificado',
				'Inicio real',
				'Fin real',
				'Terminado',
				'Estado'
			]
		];

		$activityHeader = [
			'font' => [
				'size' => 14,
				'bold' => true
			],
			'alignment' => [
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
				'wrap' => true,
				'shrinkToFit' => true,
			],
			'fill' => [
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => ['argb' => 'FF6ECEFC']
			],
		];

		$activityDataFormat = [
			'alignment' => [
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
				'wrap' => true,
				'shrinkToFit' => true,
			],
			'font' => [
				'size' => 14,
			],
		];

		$columnsWidth = [
			['B', 'B', 49],
			['C', 'C', 46],
			['D', 'G', 25],
			['H', 'I', 15]
		];

		$activities = $project->getProjectActivitys();
		$cantActivityRows = count($activities) + 5;
		$excelMgmnt->setActiveSheet(1);

		$excelMgmnt->applyFormat('B2', 'B2', $tableHeaders);
		$excelMgmnt->applyFormat('B4', 'I4', $activityHeader);
		$excelMgmnt->applyFormat('B5', "I$cantActivityRows", $activityDataFormat);
		$excelMgmnt->setRowHeight(4, 20);
		$excelMgmnt->setColumnInfoFromArray($columnsWidth);

		$excelMgmnt->setDataFromArray(['Actividades del Proyecto'], 'B2');
		$excelMgmnt->setDataFromArray($this->prepareAcitivitiesData($activities, $activitiesData), 'B4');

		// seteo la pagina de proyectos como principal
		$excelMgmnt->setActiveSheet(0);

		$fileName = 'Reporte de Proyectos_'.date('d-m-Y');

        $excelMgmnt->sendToBrowser($fileName.'.xlsx');
        die;
	}

	function prepareProjectData($project) {

		$purchaseTypes = Project::getPurchaseTypes();
		$construction = $project->getConstruction();
		$constructionName = !is_null($construction) ? $construction->getName() : 'No posee Obra';
		$projectData = [
			date('d-m-Y'),
			'',
			$project->getname(),
			$project->getResponsibleName(),
			$project->getObjectiveName(),
			$project->getCode(),
			$project->getdescription(),
			$constructionName,
			'2017 - 2019',
			(!is_null($project->getplannedStart()) ? date('d-m-Y', strtotime( $project->getplannedStart() )) : null),
			(!is_null($project->getplannedEnd()) ? date('d-m-Y', strtotime( $project->getplannedEnd() )) : null),
			(!is_null($project->getrealStart()) ? date('d-m-Y', strtotime( $project->getrealStart() )) : null),
			(!is_null($project->getrealEnd()) ? date('d-m-Y', strtotime( $project->getrealEnd() )) : null),
			//$colors[$project->statusColor()],
			'',
			$project->getGoal(),
			$project->getuniqueGoalNumeric(),
			$project->getPriority(),
			$project->getimpact(),
			$project->getBeneficiario(),
			$project->getVisibility(),
			$project->getRiskfactors(),
			'',
			$project->getBudgetPlanned(),
			'',
			$project->getOwnfinance(),
			$project->getProvincefinance(),
			$project->getNationfinance(),
			$project->getOtherfinance(),
			$project->getFinancedetail(),
			$project->getFinanceprogram(),
			$project->getRequirecontractor() ? 'Si' : 'No',
			$purchaseTypes[$project->getPurchasetype()],
			'',
			$project->getFrequency(),
			$project->getAddress(),
			$project->getFinished() ? 'Si' : 'No',
			$project->getpress() ? 'Si' : 'No',
			$project->getgoalProgress().'%',
			$project->getNotes()
		];

		return $projectData;
	}

	public function prepareAcitivitiesData($activities, $arr) {

		foreach ($activities as $activity) {
			$formated = [
				$activity->getName(),
				$activity->getResponsibleName(),
				(!is_null($activity->getplannedStart()) ? date('d-m-Y', strtotime( $activity->getplannedStart() )) : null),
				(!is_null($activity->getplannedEnd()) ? date('d-m-Y', strtotime( $activity->getplannedEnd() )) : null),
				(!is_null($activity->getrealStart()) ? date('d-m-Y', strtotime( $activity->getrealStart() )) : null),
				(!is_null($activity->getrealEnd()) ? date('d-m-Y', strtotime( $activity->getrealEnd() )) : null),
				$activity->getCompleted() ? 'Si' : 'No',
				$activity->getStatusName()
			];

			$arr[] = $formated;
		}

		return $arr;
	}

}
