<?php


/**
 * Base static class for performing query and update operations on the 'panel_resultFrameIndicator' table.
 *
 * Indicador del Marco de Resultados
 *
 * @package propel.generator.panel.classes.om
 */
abstract class BaseResultFrameIndicatorPeer
{

    /** the default database name for this class */
    const DATABASE_NAME = 'application';

    /** the table name for this class */
    const TABLE_NAME = 'panel_resultFrameIndicator';

    /** the related Propel class for this table */
    const OM_CLASS = 'ResultFrameIndicator';

    /** the related TableMap class for this table */
    const TM_CLASS = 'ResultFrameIndicatorTableMap';

    /** The total number of columns. */
    const NUM_COLUMNS = 17;

    /** The number of lazy-loaded columns. */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /** The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS) */
    const NUM_HYDRATE_COLUMNS = 17;

    /** the column name for the ID field */
    const ID = 'panel_resultFrameIndicator.ID';

    /** the column name for the NAME field */
    const NAME = 'panel_resultFrameIndicator.NAME';

    /** the column name for the TYPE field */
    const TYPE = 'panel_resultFrameIndicator.TYPE';

    /** the column name for the USEDATA field */
    const USEDATA = 'panel_resultFrameIndicator.USEDATA';

    /** the column name for the VALUETYPE field */
    const VALUETYPE = 'panel_resultFrameIndicator.VALUETYPE';

    /** the column name for the CONTENT field */
    const CONTENT = 'panel_resultFrameIndicator.CONTENT';

    /** the column name for the OBJECTTYPE field */
    const OBJECTTYPE = 'panel_resultFrameIndicator.OBJECTTYPE';

    /** the column name for the OBJECTID field */
    const OBJECTID = 'panel_resultFrameIndicator.OBJECTID';

    /** the column name for the FREQUENCY field */
    const FREQUENCY = 'panel_resultFrameIndicator.FREQUENCY';

    /** the column name for the BASEVALUE field */
    const BASEVALUE = 'panel_resultFrameIndicator.BASEVALUE';

    /** the column name for the DATARECOLECTIONINSTRUMENT field */
    const DATARECOLECTIONINSTRUMENT = 'panel_resultFrameIndicator.DATARECOLECTIONINSTRUMENT';

    /** the column name for the DATARECOLECTIONRESPONSIBLE field */
    const DATARECOLECTIONRESPONSIBLE = 'panel_resultFrameIndicator.DATARECOLECTIONRESPONSIBLE';

    /** the column name for the UPDATED field */
    const UPDATED = 'panel_resultFrameIndicator.UPDATED';

    /** the column name for the TREE_LEFT field */
    const TREE_LEFT = 'panel_resultFrameIndicator.TREE_LEFT';

    /** the column name for the TREE_RIGHT field */
    const TREE_RIGHT = 'panel_resultFrameIndicator.TREE_RIGHT';

    /** the column name for the TREE_LEVEL field */
    const TREE_LEVEL = 'panel_resultFrameIndicator.TREE_LEVEL';

    /** the column name for the DELETED_AT field */
    const DELETED_AT = 'panel_resultFrameIndicator.DELETED_AT';

    /** The default string format for model objects of the related table **/
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * An identiy map to hold any loaded instances of ResultFrameIndicator objects.
     * This must be public so that other peer classes can access this when hydrating from JOIN
     * queries.
     * @var        array ResultFrameIndicator[]
     */
    public static $instances = array();


    // nested_set behavior

    /**
     * Left column for the set
     */
    const LEFT_COL = 'panel_resultFrameIndicator.TREE_LEFT';

    /**
     * Right column for the set
     */
    const RIGHT_COL = 'panel_resultFrameIndicator.TREE_RIGHT';

    /**
     * Level column for the set
     */
    const LEVEL_COL = 'panel_resultFrameIndicator.TREE_LEVEL';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. ResultFrameIndicatorPeer::$fieldNames[ResultFrameIndicatorPeer::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        BasePeer::TYPE_PHPNAME => array ('Id', 'Name', 'Type', 'Usedata', 'Valuetype', 'Content', 'Objecttype', 'Objectid', 'Frequency', 'Basevalue', 'Datarecolectioninstrument', 'Datarecolectionresponsible', 'Updated', 'TreeLeft', 'TreeRight', 'TreeLevel', 'DeletedAt', ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id', 'name', 'type', 'usedata', 'valuetype', 'content', 'objecttype', 'objectid', 'frequency', 'basevalue', 'datarecolectioninstrument', 'datarecolectionresponsible', 'updated', 'treeLeft', 'treeRight', 'treeLevel', 'deletedAt', ),
        BasePeer::TYPE_COLNAME => array (ResultFrameIndicatorPeer::ID, ResultFrameIndicatorPeer::NAME, ResultFrameIndicatorPeer::TYPE, ResultFrameIndicatorPeer::USEDATA, ResultFrameIndicatorPeer::VALUETYPE, ResultFrameIndicatorPeer::CONTENT, ResultFrameIndicatorPeer::OBJECTTYPE, ResultFrameIndicatorPeer::OBJECTID, ResultFrameIndicatorPeer::FREQUENCY, ResultFrameIndicatorPeer::BASEVALUE, ResultFrameIndicatorPeer::DATARECOLECTIONINSTRUMENT, ResultFrameIndicatorPeer::DATARECOLECTIONRESPONSIBLE, ResultFrameIndicatorPeer::UPDATED, ResultFrameIndicatorPeer::TREE_LEFT, ResultFrameIndicatorPeer::TREE_RIGHT, ResultFrameIndicatorPeer::TREE_LEVEL, ResultFrameIndicatorPeer::DELETED_AT, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID', 'NAME', 'TYPE', 'USEDATA', 'VALUETYPE', 'CONTENT', 'OBJECTTYPE', 'OBJECTID', 'FREQUENCY', 'BASEVALUE', 'DATARECOLECTIONINSTRUMENT', 'DATARECOLECTIONRESPONSIBLE', 'UPDATED', 'TREE_LEFT', 'TREE_RIGHT', 'TREE_LEVEL', 'DELETED_AT', ),
        BasePeer::TYPE_FIELDNAME => array ('id', 'name', 'type', 'useData', 'valueType', 'content', 'objectType', 'objectId', 'frequency', 'baseValue', 'dataRecolectionInstrument', 'dataRecolectionResponsible', 'updated', 'tree_left', 'tree_right', 'tree_level', 'deleted_at', ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. ResultFrameIndicatorPeer::$fieldNames[BasePeer::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        BasePeer::TYPE_PHPNAME => array ('Id' => 0, 'Name' => 1, 'Type' => 2, 'Usedata' => 3, 'Valuetype' => 4, 'Content' => 5, 'Objecttype' => 6, 'Objectid' => 7, 'Frequency' => 8, 'Basevalue' => 9, 'Datarecolectioninstrument' => 10, 'Datarecolectionresponsible' => 11, 'Updated' => 12, 'TreeLeft' => 13, 'TreeRight' => 14, 'TreeLevel' => 15, 'DeletedAt' => 16, ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id' => 0, 'name' => 1, 'type' => 2, 'usedata' => 3, 'valuetype' => 4, 'content' => 5, 'objecttype' => 6, 'objectid' => 7, 'frequency' => 8, 'basevalue' => 9, 'datarecolectioninstrument' => 10, 'datarecolectionresponsible' => 11, 'updated' => 12, 'treeLeft' => 13, 'treeRight' => 14, 'treeLevel' => 15, 'deletedAt' => 16, ),
        BasePeer::TYPE_COLNAME => array (ResultFrameIndicatorPeer::ID => 0, ResultFrameIndicatorPeer::NAME => 1, ResultFrameIndicatorPeer::TYPE => 2, ResultFrameIndicatorPeer::USEDATA => 3, ResultFrameIndicatorPeer::VALUETYPE => 4, ResultFrameIndicatorPeer::CONTENT => 5, ResultFrameIndicatorPeer::OBJECTTYPE => 6, ResultFrameIndicatorPeer::OBJECTID => 7, ResultFrameIndicatorPeer::FREQUENCY => 8, ResultFrameIndicatorPeer::BASEVALUE => 9, ResultFrameIndicatorPeer::DATARECOLECTIONINSTRUMENT => 10, ResultFrameIndicatorPeer::DATARECOLECTIONRESPONSIBLE => 11, ResultFrameIndicatorPeer::UPDATED => 12, ResultFrameIndicatorPeer::TREE_LEFT => 13, ResultFrameIndicatorPeer::TREE_RIGHT => 14, ResultFrameIndicatorPeer::TREE_LEVEL => 15, ResultFrameIndicatorPeer::DELETED_AT => 16, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID' => 0, 'NAME' => 1, 'TYPE' => 2, 'USEDATA' => 3, 'VALUETYPE' => 4, 'CONTENT' => 5, 'OBJECTTYPE' => 6, 'OBJECTID' => 7, 'FREQUENCY' => 8, 'BASEVALUE' => 9, 'DATARECOLECTIONINSTRUMENT' => 10, 'DATARECOLECTIONRESPONSIBLE' => 11, 'UPDATED' => 12, 'TREE_LEFT' => 13, 'TREE_RIGHT' => 14, 'TREE_LEVEL' => 15, 'DELETED_AT' => 16, ),
        BasePeer::TYPE_FIELDNAME => array ('id' => 0, 'name' => 1, 'type' => 2, 'useData' => 3, 'valueType' => 4, 'content' => 5, 'objectType' => 6, 'objectId' => 7, 'frequency' => 8, 'baseValue' => 9, 'dataRecolectionInstrument' => 10, 'dataRecolectionResponsible' => 11, 'updated' => 12, 'tree_left' => 13, 'tree_right' => 14, 'tree_level' => 15, 'deleted_at' => 16, ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, )
    );

    /**
     * Translates a fieldname to another type
     *
     * @param      string $name field name
     * @param      string $fromType One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                         BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @param      string $toType   One of the class type constants
     * @return string          translated name of the field.
     * @throws PropelException - if the specified name could not be found in the fieldname mappings.
     */
    public static function translateFieldName($name, $fromType, $toType)
    {
        $toNames = ResultFrameIndicatorPeer::getFieldNames($toType);
        $key = isset(ResultFrameIndicatorPeer::$fieldKeys[$fromType][$name]) ? ResultFrameIndicatorPeer::$fieldKeys[$fromType][$name] : null;
        if ($key === null) {
            throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(ResultFrameIndicatorPeer::$fieldKeys[$fromType], true));
        }

        return $toNames[$key];
    }

    /**
     * Returns an array of field names.
     *
     * @param      string $type The type of fieldnames to return:
     *                      One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                      BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @return array           A list of field names
     * @throws PropelException - if the type is not valid.
     */
    public static function getFieldNames($type = BasePeer::TYPE_PHPNAME)
    {
        if (!array_key_exists($type, ResultFrameIndicatorPeer::$fieldNames)) {
            throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME, BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. ' . $type . ' was given.');
        }

        return ResultFrameIndicatorPeer::$fieldNames[$type];
    }

    /**
     * Convenience method which changes table.column to alias.column.
     *
     * Using this method you can maintain SQL abstraction while using column aliases.
     * <code>
     *		$c->addAlias("alias1", TablePeer::TABLE_NAME);
     *		$c->addJoin(TablePeer::alias("alias1", TablePeer::PRIMARY_KEY_COLUMN), TablePeer::PRIMARY_KEY_COLUMN);
     * </code>
     * @param      string $alias The alias for the current table.
     * @param      string $column The column name for current table. (i.e. ResultFrameIndicatorPeer::COLUMN_NAME).
     * @return string
     */
    public static function alias($alias, $column)
    {
        return str_replace(ResultFrameIndicatorPeer::TABLE_NAME.'.', $alias.'.', $column);
    }

    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param      Criteria $criteria object containing the columns to add.
     * @param      string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ResultFrameIndicatorPeer::ID);
            $criteria->addSelectColumn(ResultFrameIndicatorPeer::NAME);
            $criteria->addSelectColumn(ResultFrameIndicatorPeer::TYPE);
            $criteria->addSelectColumn(ResultFrameIndicatorPeer::USEDATA);
            $criteria->addSelectColumn(ResultFrameIndicatorPeer::VALUETYPE);
            $criteria->addSelectColumn(ResultFrameIndicatorPeer::CONTENT);
            $criteria->addSelectColumn(ResultFrameIndicatorPeer::OBJECTTYPE);
            $criteria->addSelectColumn(ResultFrameIndicatorPeer::OBJECTID);
            $criteria->addSelectColumn(ResultFrameIndicatorPeer::FREQUENCY);
            $criteria->addSelectColumn(ResultFrameIndicatorPeer::BASEVALUE);
            $criteria->addSelectColumn(ResultFrameIndicatorPeer::DATARECOLECTIONINSTRUMENT);
            $criteria->addSelectColumn(ResultFrameIndicatorPeer::DATARECOLECTIONRESPONSIBLE);
            $criteria->addSelectColumn(ResultFrameIndicatorPeer::UPDATED);
            $criteria->addSelectColumn(ResultFrameIndicatorPeer::TREE_LEFT);
            $criteria->addSelectColumn(ResultFrameIndicatorPeer::TREE_RIGHT);
            $criteria->addSelectColumn(ResultFrameIndicatorPeer::TREE_LEVEL);
            $criteria->addSelectColumn(ResultFrameIndicatorPeer::DELETED_AT);
        } else {
            $criteria->addSelectColumn($alias . '.ID');
            $criteria->addSelectColumn($alias . '.NAME');
            $criteria->addSelectColumn($alias . '.TYPE');
            $criteria->addSelectColumn($alias . '.USEDATA');
            $criteria->addSelectColumn($alias . '.VALUETYPE');
            $criteria->addSelectColumn($alias . '.CONTENT');
            $criteria->addSelectColumn($alias . '.OBJECTTYPE');
            $criteria->addSelectColumn($alias . '.OBJECTID');
            $criteria->addSelectColumn($alias . '.FREQUENCY');
            $criteria->addSelectColumn($alias . '.BASEVALUE');
            $criteria->addSelectColumn($alias . '.DATARECOLECTIONINSTRUMENT');
            $criteria->addSelectColumn($alias . '.DATARECOLECTIONRESPONSIBLE');
            $criteria->addSelectColumn($alias . '.UPDATED');
            $criteria->addSelectColumn($alias . '.TREE_LEFT');
            $criteria->addSelectColumn($alias . '.TREE_RIGHT');
            $criteria->addSelectColumn($alias . '.TREE_LEVEL');
            $criteria->addSelectColumn($alias . '.DELETED_AT');
        }
    }

    /**
     * Returns the number of rows matching criteria.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @return int Number of matching rows.
     */
    public static function doCount(Criteria $criteria, $distinct = false, PropelPDO $con = null)
    {
        // we may modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ResultFrameIndicatorPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ResultFrameIndicatorPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
        $criteria->setDbName(ResultFrameIndicatorPeer::DATABASE_NAME); // Set the correct dbName

        if ($con === null) {
            $con = Propel::getConnection(ResultFrameIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        // soft_delete behavior
        if (ResultFrameIndicatorQuery::isSoftDeleteEnabled()) {
            $criteria->add(ResultFrameIndicatorPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ResultFrameIndicatorPeer::enableSoftDelete();
        }
        // BasePeer returns a PDOStatement
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }
    /**
     * Selects one object from the DB.
     *
     * @param      Criteria $criteria object used to create the SELECT statement.
     * @param      PropelPDO $con
     * @return                 ResultFrameIndicator
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectOne(Criteria $criteria, PropelPDO $con = null)
    {
        $critcopy = clone $criteria;
        $critcopy->setLimit(1);
        $objects = ResultFrameIndicatorPeer::doSelect($critcopy, $con);
        if ($objects) {
            return $objects[0];
        }

        return null;
    }
    /**
     * Selects several row from the DB.
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con
     * @return array           Array of selected Objects
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelect(Criteria $criteria, PropelPDO $con = null)
    {
        return ResultFrameIndicatorPeer::populateObjects(ResultFrameIndicatorPeer::doSelectStmt($criteria, $con));
    }
    /**
     * Prepares the Criteria object and uses the parent doSelect() method to execute a PDOStatement.
     *
     * Use this method directly if you want to work with an executed statement durirectly (for example
     * to perform your own object hydration).
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con The connection to use
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return PDOStatement The executed PDOStatement object.
     * @see        BasePeer::doSelect()
     */
    public static function doSelectStmt(Criteria $criteria, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        if (!$criteria->hasSelectClause()) {
            $criteria = clone $criteria;
            ResultFrameIndicatorPeer::addSelectColumns($criteria);
        }

        // Set the correct dbName
        $criteria->setDbName(ResultFrameIndicatorPeer::DATABASE_NAME);
        // soft_delete behavior
        if (ResultFrameIndicatorQuery::isSoftDeleteEnabled()) {
            $criteria->add(ResultFrameIndicatorPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ResultFrameIndicatorPeer::enableSoftDelete();
        }

        // BasePeer returns a PDOStatement
        return BasePeer::doSelect($criteria, $con);
    }
    /**
     * Adds an object to the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doSelect*()
     * methods in your stub classes -- you may need to explicitly add objects
     * to the cache in order to ensure that the same objects are always returned by doSelect*()
     * and retrieveByPK*() calls.
     *
     * @param      ResultFrameIndicator $obj A ResultFrameIndicator object.
     * @param      string $key (optional) key to use for instance map (for performance boost if key was already calculated externally).
     */
    public static function addInstanceToPool($obj, $key = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if ($key === null) {
                $key = (string) $obj->getId();
            } // if key === null
            ResultFrameIndicatorPeer::$instances[$key] = $obj;
        }
    }

    /**
     * Removes an object from the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doDelete
     * methods in your stub classes -- you may need to explicitly remove objects
     * from the cache in order to prevent returning objects that no longer exist.
     *
     * @param      mixed $value A ResultFrameIndicator object or a primary key value.
     *
     * @return void
     * @throws PropelException - if the value is invalid.
     */
    public static function removeInstanceFromPool($value)
    {
        if (Propel::isInstancePoolingEnabled() && $value !== null) {
            if (is_object($value) && $value instanceof ResultFrameIndicator) {
                $key = (string) $value->getId();
            } elseif (is_scalar($value)) {
                // assume we've been passed a primary key
                $key = (string) $value;
            } else {
                $e = new PropelException("Invalid value passed to removeInstanceFromPool().  Expected primary key or ResultFrameIndicator object; got " . (is_object($value) ? get_class($value) . ' object.' : var_export($value,true)));
                throw $e;
            }

            unset(ResultFrameIndicatorPeer::$instances[$key]);
        }
    } // removeInstanceFromPool()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      string $key The key (@see getPrimaryKeyHash()) for this instance.
     * @return   ResultFrameIndicator Found object or null if 1) no instance exists for specified key or 2) instance pooling has been disabled.
     * @see        getPrimaryKeyHash()
     */
    public static function getInstanceFromPool($key)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if (isset(ResultFrameIndicatorPeer::$instances[$key])) {
                return ResultFrameIndicatorPeer::$instances[$key];
            }
        }

        return null; // just to be explicit
    }

    /**
     * Clear the instance pool.
     *
     * @return void
     */
    public static function clearInstancePool()
    {
        ResultFrameIndicatorPeer::$instances = array();
    }

    /**
     * Method to invalidate the instance pool of all tables related to panel_resultFrameIndicator
     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return string A string version of PK or null if the components of primary key in result array are all null.
     */
    public static function getPrimaryKeyHashFromRow($row, $startcol = 0)
    {
        // If the PK cannot be derived from the row, return null.
        if ($row[$startcol] === null) {
            return null;
        }

        return (string) $row[$startcol];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $startcol = 0)
    {

        return (int) $row[$startcol];
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function populateObjects(PDOStatement $stmt)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = ResultFrameIndicatorPeer::getOMClass();
        // populate the object(s)
        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key = ResultFrameIndicatorPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj = ResultFrameIndicatorPeer::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ResultFrameIndicatorPeer::addInstanceToPool($obj, $key);
            } // if key exists
        }
        $stmt->closeCursor();

        return $results;
    }
    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return array (ResultFrameIndicator object, last column rank)
     */
    public static function populateObject($row, $startcol = 0)
    {
        $key = ResultFrameIndicatorPeer::getPrimaryKeyHashFromRow($row, $startcol);
        if (null !== ($obj = ResultFrameIndicatorPeer::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $startcol, true); // rehydrate
            $col = $startcol + ResultFrameIndicatorPeer::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ResultFrameIndicatorPeer::OM_CLASS;
            $obj = new $cls();
            $col = $obj->hydrate($row, $startcol);
            ResultFrameIndicatorPeer::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * Returns the TableMap related to this peer.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getDatabaseMap(ResultFrameIndicatorPeer::DATABASE_NAME)->getTable(ResultFrameIndicatorPeer::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this peer class.
     */
    public static function buildTableMap()
    {
      $dbMap = Propel::getDatabaseMap(BaseResultFrameIndicatorPeer::DATABASE_NAME);
      if (!$dbMap->hasTable(BaseResultFrameIndicatorPeer::TABLE_NAME)) {
        $dbMap->addTableObject(new ResultFrameIndicatorTableMap());
      }
    }

    /**
     * The class that the Peer will make instances of.
     *
     *
     * @return string ClassName
     */
    public static function getOMClass()
    {
        return ResultFrameIndicatorPeer::OM_CLASS;
    }

    /**
     * Performs an INSERT on the database, given a ResultFrameIndicator or Criteria object.
     *
     * @param      mixed $values Criteria or ResultFrameIndicator object containing data that is used to create the INSERT statement.
     * @param      PropelPDO $con the PropelPDO connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doInsert($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity
        } else {
            $criteria = $values->buildCriteria(); // build Criteria from ResultFrameIndicator object
        }

        if ($criteria->containsKey(ResultFrameIndicatorPeer::ID) && $criteria->keyContainsValue(ResultFrameIndicatorPeer::ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.ResultFrameIndicatorPeer::ID.')');
        }


        // Set the correct dbName
        $criteria->setDbName(ResultFrameIndicatorPeer::DATABASE_NAME);

        try {
            // use transaction because $criteria could contain info
            // for more than one table (I guess, conceivably)
            $con->beginTransaction();
            $pk = BasePeer::doInsert($criteria, $con);
            $con->commit();
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }

        return $pk;
    }

    /**
     * Performs an UPDATE on the database, given a ResultFrameIndicator or Criteria object.
     *
     * @param      mixed $values Criteria or ResultFrameIndicator object containing data that is used to create the UPDATE statement.
     * @param      PropelPDO $con The connection to use (specify PropelPDO connection object to exert more control over transactions).
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doUpdate($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $selectCriteria = new Criteria(ResultFrameIndicatorPeer::DATABASE_NAME);

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity

            $comparison = $criteria->getComparison(ResultFrameIndicatorPeer::ID);
            $value = $criteria->remove(ResultFrameIndicatorPeer::ID);
            if ($value) {
                $selectCriteria->add(ResultFrameIndicatorPeer::ID, $value, $comparison);
            } else {
                $selectCriteria->setPrimaryTableName(ResultFrameIndicatorPeer::TABLE_NAME);
            }

        } else { // $values is ResultFrameIndicator object
            $criteria = $values->buildCriteria(); // gets full criteria
            $selectCriteria = $values->buildPkeyCriteria(); // gets criteria w/ primary key(s)
        }

        // set the correct dbName
        $criteria->setDbName(ResultFrameIndicatorPeer::DATABASE_NAME);

        return BasePeer::doUpdate($selectCriteria, $criteria, $con);
    }

    /**
     * Deletes all rows from the panel_resultFrameIndicator table.
     *
     * @param      PropelPDO $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException
     */
    public static function doForceDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $affectedRows = 0; // initialize var to track total num of affected rows
        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();
            $affectedRows += BasePeer::doDeleteAll(ResultFrameIndicatorPeer::TABLE_NAME, $con, ResultFrameIndicatorPeer::DATABASE_NAME);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ResultFrameIndicatorPeer::clearInstancePool();
            ResultFrameIndicatorPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs a DELETE on the database, given a ResultFrameIndicator or Criteria object OR a primary key value.
     *
     * @param      mixed $values Criteria or ResultFrameIndicator object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param      PropelPDO $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *				if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
     public static function doForceDelete($values, PropelPDO $con = null)
     {
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            // invalidate the cache for all objects of this type, since we have no
            // way of knowing (without running a query) what objects should be invalidated
            // from the cache based on this Criteria.
            ResultFrameIndicatorPeer::clearInstancePool();
            // rename for clarity
            $criteria = clone $values;
        } elseif ($values instanceof ResultFrameIndicator) { // it's a model object
            // invalidate the cache for this single object
            ResultFrameIndicatorPeer::removeInstanceFromPool($values);
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ResultFrameIndicatorPeer::DATABASE_NAME);
            $criteria->add(ResultFrameIndicatorPeer::ID, (array) $values, Criteria::IN);
            // invalidate the cache for this object(s)
            foreach ((array) $values as $singleval) {
                ResultFrameIndicatorPeer::removeInstanceFromPool($singleval);
            }
        }

        // Set the correct dbName
        $criteria->setDbName(ResultFrameIndicatorPeer::DATABASE_NAME);

        $affectedRows = 0; // initialize var to track total num of affected rows

        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();

            $affectedRows += BasePeer::doDelete($criteria, $con);
            ResultFrameIndicatorPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Validates all modified columns of given ResultFrameIndicator object.
     * If parameter $columns is either a single column name or an array of column names
     * than only those columns are validated.
     *
     * NOTICE: This does not apply to primary or foreign keys for now.
     *
     * @param      ResultFrameIndicator $obj The object to validate.
     * @param      mixed $cols Column name or array of column names.
     *
     * @return mixed TRUE if all columns are valid or the error message of the first invalid column.
     */
    public static function doValidate($obj, $cols = null)
    {
        $columns = array();

        if ($cols) {
            $dbMap = Propel::getDatabaseMap(ResultFrameIndicatorPeer::DATABASE_NAME);
            $tableMap = $dbMap->getTable(ResultFrameIndicatorPeer::TABLE_NAME);

            if (! is_array($cols)) {
                $cols = array($cols);
            }

            foreach ($cols as $colName) {
                if ($tableMap->hasColumn($colName)) {
                    $get = 'get' . $tableMap->getColumn($colName)->getPhpName();
                    $columns[$colName] = $obj->$get();
                }
            }
        } else {

        }

        return BasePeer::doValidate(ResultFrameIndicatorPeer::DATABASE_NAME, ResultFrameIndicatorPeer::TABLE_NAME, $columns);
    }

    /**
     * Retrieve a single object by pkey.
     *
     * @param      int $pk the primary key.
     * @param      PropelPDO $con the connection to use
     * @return ResultFrameIndicator
     */
    public static function retrieveByPK($pk, PropelPDO $con = null)
    {

        if (null !== ($obj = ResultFrameIndicatorPeer::getInstanceFromPool((string) $pk))) {
            return $obj;
        }

        if ($con === null) {
            $con = Propel::getConnection(ResultFrameIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria = new Criteria(ResultFrameIndicatorPeer::DATABASE_NAME);
        $criteria->add(ResultFrameIndicatorPeer::ID, $pk);

        $v = ResultFrameIndicatorPeer::doSelect($criteria, $con);

        return !empty($v) > 0 ? $v[0] : null;
    }

    /**
     * Retrieve multiple objects by pkey.
     *
     * @param      array $pks List of primary keys
     * @param      PropelPDO $con the connection to use
     * @return ResultFrameIndicator[]
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function retrieveByPKs($pks, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $objs = null;
        if (empty($pks)) {
            $objs = array();
        } else {
            $criteria = new Criteria(ResultFrameIndicatorPeer::DATABASE_NAME);
            $criteria->add(ResultFrameIndicatorPeer::ID, $pks, Criteria::IN);
            $objs = ResultFrameIndicatorPeer::doSelect($criteria, $con);
        }

        return $objs;
    }

    // nested_set behavior

    /**
     * Returns the root node for a given scope
     *
     * @param      PropelPDO $con	Connection to use.
     * @return     ResultFrameIndicator			Propel object for root node
     */
    public static function retrieveRoot(PropelPDO $con = null)
    {
        $c = new Criteria(ResultFrameIndicatorPeer::DATABASE_NAME);
        $c->add(ResultFrameIndicatorPeer::LEFT_COL, 1, Criteria::EQUAL);

        return ResultFrameIndicatorPeer::doSelectOne($c, $con);
    }

    /**
     * Returns the whole tree node for a given scope
     *
     * @param      Criteria $criteria	Optional Criteria to filter the query
     * @param      PropelPDO $con	Connection to use.
     * @return     ResultFrameIndicator			Propel object for root node
     */
    public static function retrieveTree(Criteria $criteria = null, PropelPDO $con = null)
    {
        if ($criteria === null) {
            $criteria = new Criteria(ResultFrameIndicatorPeer::DATABASE_NAME);
        }
        $criteria->addAscendingOrderByColumn(ResultFrameIndicatorPeer::LEFT_COL);

        return ResultFrameIndicatorPeer::doSelect($criteria, $con);
    }

    /**
     * Tests if node is valid
     *
     * @param      ResultFrameIndicator $node	Propel object for src node
     * @return     bool
     */
    public static function isValid(ResultFrameIndicator $node = null)
    {
        if (is_object($node) && $node->getRightValue() > $node->getLeftValue()) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Delete an entire tree
     *
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     int  The number of deleted nodes
     */
    public static function deleteTree(PropelPDO $con = null)
    {

        return ResultFrameIndicatorPeer::doDeleteAll($con);
    }

    /**
     * Adds $delta to all L and R values that are >= $first and <= $last.
     * '$delta' can also be negative.
     *
     * @param      int $delta		Value to be shifted by, can be negative
     * @param      int $first		First node to be shifted
     * @param      int $last			Last node to be shifted (optional)
     * @param      PropelPDO $con		Connection to use.
     */
    public static function shiftRLValues($delta, $first, $last = null, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        // Shift left column values
        $whereCriteria = new Criteria(ResultFrameIndicatorPeer::DATABASE_NAME);
        $criterion = $whereCriteria->getNewCriterion(ResultFrameIndicatorPeer::LEFT_COL, $first, Criteria::GREATER_EQUAL);
        if (null !== $last) {
            $criterion->addAnd($whereCriteria->getNewCriterion(ResultFrameIndicatorPeer::LEFT_COL, $last, Criteria::LESS_EQUAL));
        }
        $whereCriteria->add($criterion);

        $valuesCriteria = new Criteria(ResultFrameIndicatorPeer::DATABASE_NAME);
        $valuesCriteria->add(ResultFrameIndicatorPeer::LEFT_COL, array('raw' => ResultFrameIndicatorPeer::LEFT_COL . ' + ?', 'value' => $delta), Criteria::CUSTOM_EQUAL);

        BasePeer::doUpdate($whereCriteria, $valuesCriteria, $con);

        // Shift right column values
        $whereCriteria = new Criteria(ResultFrameIndicatorPeer::DATABASE_NAME);
        $criterion = $whereCriteria->getNewCriterion(ResultFrameIndicatorPeer::RIGHT_COL, $first, Criteria::GREATER_EQUAL);
        if (null !== $last) {
            $criterion->addAnd($whereCriteria->getNewCriterion(ResultFrameIndicatorPeer::RIGHT_COL, $last, Criteria::LESS_EQUAL));
        }
        $whereCriteria->add($criterion);

        $valuesCriteria = new Criteria(ResultFrameIndicatorPeer::DATABASE_NAME);
        $valuesCriteria->add(ResultFrameIndicatorPeer::RIGHT_COL, array('raw' => ResultFrameIndicatorPeer::RIGHT_COL . ' + ?', 'value' => $delta), Criteria::CUSTOM_EQUAL);

        BasePeer::doUpdate($whereCriteria, $valuesCriteria, $con);
    }

    /**
     * Adds $delta to level for nodes having left value >= $first and right value <= $last.
     * '$delta' can also be negative.
     *
     * @param      int $delta		Value to be shifted by, can be negative
     * @param      int $first		First node to be shifted
     * @param      int $last			Last node to be shifted
     * @param      PropelPDO $con		Connection to use.
     */
    public static function shiftLevel($delta, $first, $last, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $whereCriteria = new Criteria(ResultFrameIndicatorPeer::DATABASE_NAME);
        $whereCriteria->add(ResultFrameIndicatorPeer::LEFT_COL, $first, Criteria::GREATER_EQUAL);
        $whereCriteria->add(ResultFrameIndicatorPeer::RIGHT_COL, $last, Criteria::LESS_EQUAL);

        $valuesCriteria = new Criteria(ResultFrameIndicatorPeer::DATABASE_NAME);
        $valuesCriteria->add(ResultFrameIndicatorPeer::LEVEL_COL, array('raw' => ResultFrameIndicatorPeer::LEVEL_COL . ' + ?', 'value' => $delta), Criteria::CUSTOM_EQUAL);

        BasePeer::doUpdate($whereCriteria, $valuesCriteria, $con);
    }

    /**
     * Reload all already loaded nodes to sync them with updated db
     *
     * @param      ResultFrameIndicator $prune		Object to prune from the update
     * @param      PropelPDO $con		Connection to use.
     */
    public static function updateLoadedNodes($prune = null, PropelPDO $con = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            $keys = array();
            foreach (ResultFrameIndicatorPeer::$instances as $obj) {
                if (!$prune || !$prune->equals($obj)) {
                    $keys[] = $obj->getPrimaryKey();
                }
            }

            if (!empty($keys)) {
                // We don't need to alter the object instance pool; we're just modifying these ones
                // already in the pool.
                $criteria = new Criteria(ResultFrameIndicatorPeer::DATABASE_NAME);
                $criteria->add(ResultFrameIndicatorPeer::ID, $keys, Criteria::IN);
                $stmt = ResultFrameIndicatorPeer::doSelectStmt($criteria, $con);
                while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
                    $key = ResultFrameIndicatorPeer::getPrimaryKeyHashFromRow($row, 0);
                    if (null !== ($object = ResultFrameIndicatorPeer::getInstanceFromPool($key))) {
                        $object->setLeftValue($row[13]);
                        $object->setRightValue($row[14]);
                        $object->setLevel($row[15]);
                        $object->clearNestedSetChildren();
                    }
                }
                $stmt->closeCursor();
            }
        }
    }

    /**
     * Update the tree to allow insertion of a leaf at the specified position
     *
     * @param      int $left	left column value
     * @param      mixed $prune	Object to prune from the shift
     * @param      PropelPDO $con	Connection to use.
     */
    public static function makeRoomForLeaf($left, $prune = null, PropelPDO $con = null)
    {
        // Update database nodes
        ResultFrameIndicatorPeer::shiftRLValues(2, $left, null, $con);

        // Update all loaded nodes
        ResultFrameIndicatorPeer::updateLoadedNodes($prune, $con);
    }

    /**
     * Update the tree to allow insertion of a leaf at the specified position
     *
     * @param      PropelPDO $con	Connection to use.
     */
    public static function fixLevels(PropelPDO $con = null)
    {
        $c = new Criteria();
        $c->addAscendingOrderByColumn(ResultFrameIndicatorPeer::LEFT_COL);
        $stmt = ResultFrameIndicatorPeer::doSelectStmt($c, $con);

        // set the class once to avoid overhead in the loop
        $cls = ResultFrameIndicatorPeer::getOMClass(false);
        $level = null;
        // iterate over the statement
        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {

            // hydrate object
            $key = ResultFrameIndicatorPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null === ($obj = ResultFrameIndicatorPeer::getInstanceFromPool($key))) {
                $obj = new $cls();
                $obj->hydrate($row);
                ResultFrameIndicatorPeer::addInstanceToPool($obj, $key);
            }

            // compute level
            // Algorithm shamelessly stolen from sfPropelActAsNestedSetBehaviorPlugin
            // Probably authored by Tristan Rivoallan
            if ($level === null) {
                $level = 0;
                $i = 0;
                $prev = array($obj->getRightValue());
            } else {
                while ($obj->getRightValue() > $prev[$i]) {
                    $i--;
                }
                $level = ++$i;
                $prev[$i] = $obj->getRightValue();
            }

            // update level in node if necessary
            if ($obj->getLevel() !== $level) {
                $obj->setLevel($level);
                $obj->save($con);
            }
        }
        $stmt->closeCursor();
    }

    // soft_delete behavior

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        ResultFrameIndicatorQuery::enableSoftDelete();
        // some soft_deleted objects may be in the instance pool
        ResultFrameIndicatorPeer::clearInstancePool();
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        ResultFrameIndicatorQuery::disableSoftDelete();
    }

    /**
     * Check the soft_delete behavior for this model
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return ResultFrameIndicatorQuery::isSoftDeleteEnabled();
    }

    /**
     * Soft delete records, given a ResultFrameIndicator or Criteria object OR a primary key value.
     *
     * @param			 mixed $values Criteria or ResultFrameIndicator object or primary key or array of primary keys
     *							which is used to create the DELETE statement
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doSoftDelete($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        if ($values instanceof Criteria) {
            // rename for clarity
            $selectCriteria = clone $values;
         } elseif ($values instanceof ResultFrameIndicator) {
            // create criteria based on pk values
            $selectCriteria = $values->buildPkeyCriteria();
        } else {
            // it must be the primary key
            $selectCriteria = new Criteria(self::DATABASE_NAME);
             $selectCriteria->add(ResultFrameIndicatorPeer::ID, (array) $values, Criteria::IN);
        }
        // Set the correct dbName
        $selectCriteria->setDbName(ResultFrameIndicatorPeer::DATABASE_NAME);
        $updateCriteria = new Criteria(self::DATABASE_NAME);
        $updateCriteria->add(ResultFrameIndicatorPeer::DELETED_AT, time());

         return BasePeer::doUpdate($selectCriteria, $updateCriteria, $con);
    }

    /**
     * Delete or soft delete records, depending on ResultFrameIndicatorPeer::$softDelete
     *
     * @param			 mixed $values Criteria or ResultFrameIndicator object or primary key or array of primary keys
     *							which is used to create the DELETE statement
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doDelete($values, PropelPDO $con = null)
    {
        if (ResultFrameIndicatorPeer::isSoftDeleteEnabled()) {
            return ResultFrameIndicatorPeer::doSoftDelete($values, $con);
        } else {
            return ResultFrameIndicatorPeer::doForceDelete($values, $con);
        }
    }
    /**
     * Method to soft delete all rows from the panel_resultFrameIndicator table.
     *
     * @param			 PropelPDO $con the connection to use
     * @return		 int The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doSoftDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $selectCriteria = new Criteria();
        $selectCriteria->add(ResultFrameIndicatorPeer::DELETED_AT, null, Criteria::ISNULL);
        $selectCriteria->setDbName(ResultFrameIndicatorPeer::DATABASE_NAME);
        $modifyCriteria = new Criteria();
        $modifyCriteria->add(ResultFrameIndicatorPeer::DELETED_AT, time());

        return BasePeer::doUpdate($selectCriteria, $modifyCriteria, $con);
    }

    /**
     * Delete or soft delete all records, depending on ResultFrameIndicatorPeer::$softDelete
     *
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doDeleteAll(PropelPDO $con = null)
    {
        if (ResultFrameIndicatorPeer::isSoftDeleteEnabled()) {
            return ResultFrameIndicatorPeer::doSoftDeleteAll($con);
        } else {
            return ResultFrameIndicatorPeer::doForceDeleteAll($con);
        }
    }

} // BaseResultFrameIndicatorPeer

// This is the static code needed to register the TableMap for this table with the main Propel class.
//
BaseResultFrameIndicatorPeer::buildTableMap();

