<?php


/**
 * Base class that represents a query for the 'panel_alertDigest' table.
 *
 *
 *
 * @method AlertDigestQuery orderById($order = Criteria::ASC) Order by the id column
 * @method AlertDigestQuery orderByPositioncode($order = Criteria::ASC) Order by the positionCode column
 * @method AlertDigestQuery orderByEmails($order = Criteria::ASC) Order by the emails column
 *
 * @method AlertDigestQuery groupById() Group by the id column
 * @method AlertDigestQuery groupByPositioncode() Group by the positionCode column
 * @method AlertDigestQuery groupByEmails() Group by the emails column
 *
 * @method AlertDigestQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method AlertDigestQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method AlertDigestQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method AlertDigestQuery leftJoinPosition($relationAlias = null) Adds a LEFT JOIN clause to the query using the Position relation
 * @method AlertDigestQuery rightJoinPosition($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Position relation
 * @method AlertDigestQuery innerJoinPosition($relationAlias = null) Adds a INNER JOIN clause to the query using the Position relation
 *
 * @method AlertDigest findOne(PropelPDO $con = null) Return the first AlertDigest matching the query
 * @method AlertDigest findOneOrCreate(PropelPDO $con = null) Return the first AlertDigest matching the query, or a new AlertDigest object populated from the query conditions when no match is found
 *
 * @method AlertDigest findOneById(int $id) Return the first AlertDigest filtered by the id column
 * @method AlertDigest findOneByPositioncode(int $positionCode) Return the first AlertDigest filtered by the positionCode column
 * @method AlertDigest findOneByEmails(string $emails) Return the first AlertDigest filtered by the emails column
 *
 * @method array findById(int $id) Return AlertDigest objects filtered by the id column
 * @method array findByPositioncode(int $positionCode) Return AlertDigest objects filtered by the positionCode column
 * @method array findByEmails(string $emails) Return AlertDigest objects filtered by the emails column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseAlertDigestQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseAlertDigestQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'AlertDigest', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new AlertDigestQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     AlertDigestQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return AlertDigestQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof AlertDigestQuery) {
            return $criteria;
        }
        $query = new AlertDigestQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   AlertDigest|AlertDigest[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = AlertDigestPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(AlertDigestPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   AlertDigest A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `POSITIONCODE`, `EMAILS` FROM `panel_alertDigest` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new AlertDigest();
            $obj->hydrate($row);
            AlertDigestPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return AlertDigest|AlertDigest[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|AlertDigest[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return AlertDigestQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(AlertDigestPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return AlertDigestQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(AlertDigestPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return AlertDigestQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(AlertDigestPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the positionCode column
     *
     * Example usage:
     * <code>
     * $query->filterByPositioncode(1234); // WHERE positionCode = 1234
     * $query->filterByPositioncode(array(12, 34)); // WHERE positionCode IN (12, 34)
     * $query->filterByPositioncode(array('min' => 12)); // WHERE positionCode > 12
     * </code>
     *
     * @see       filterByPosition()
     *
     * @param     mixed $positioncode The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return AlertDigestQuery The current query, for fluid interface
     */
    public function filterByPositioncode($positioncode = null, $comparison = null)
    {
        if (is_array($positioncode)) {
            $useMinMax = false;
            if (isset($positioncode['min'])) {
                $this->addUsingAlias(AlertDigestPeer::POSITIONCODE, $positioncode['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($positioncode['max'])) {
                $this->addUsingAlias(AlertDigestPeer::POSITIONCODE, $positioncode['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(AlertDigestPeer::POSITIONCODE, $positioncode, $comparison);
    }

    /**
     * Filter the query on the emails column
     *
     * Example usage:
     * <code>
     * $query->filterByEmails('fooValue');   // WHERE emails = 'fooValue'
     * $query->filterByEmails('%fooValue%'); // WHERE emails LIKE '%fooValue%'
     * </code>
     *
     * @param     string $emails The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return AlertDigestQuery The current query, for fluid interface
     */
    public function filterByEmails($emails = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($emails)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $emails)) {
                $emails = str_replace('*', '%', $emails);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(AlertDigestPeer::EMAILS, $emails, $comparison);
    }

    /**
     * Filter the query by a related Position object
     *
     * @param   Position|PropelObjectCollection $position The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   AlertDigestQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPosition($position, $comparison = null)
    {
        if ($position instanceof Position) {
            return $this
                ->addUsingAlias(AlertDigestPeer::POSITIONCODE, $position->getCode(), $comparison);
        } elseif ($position instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(AlertDigestPeer::POSITIONCODE, $position->toKeyValue('PrimaryKey', 'Code'), $comparison);
        } else {
            throw new PropelException('filterByPosition() only accepts arguments of type Position or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Position relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return AlertDigestQuery The current query, for fluid interface
     */
    public function joinPosition($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Position');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Position');
        }

        return $this;
    }

    /**
     * Use the Position relation Position object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PositionQuery A secondary query class using the current class as primary query
     */
    public function usePositionQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinPosition($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Position', 'PositionQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   AlertDigest $alertDigest Object to remove from the list of results
     *
     * @return AlertDigestQuery The current query, for fluid interface
     */
    public function prune($alertDigest = null)
    {
        if ($alertDigest) {
            $this->addUsingAlias(AlertDigestPeer::ID, $alertDigest->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
