<?php

require_once 'EmailManagement.php';

class AlertMail {

	private $body;
	private $mailFrom;
	private $mailTo;
	private $responsible;
	private $subject;

	static function create($position, $responsible, $alertObjects) {
		$alertMail = new static();
		$alertMail->init($position, $responsible, $alertObjects);
		return $alertMail;
	}

	protected function getTemplateName() {
		return 'PanelAlertMail.tpl';
	}

	protected function createSubject($position) {
		return "Tablero de Gestión - Alerta de " . $position->getName(); //Common::getTranslation('Alert','panel') . " - " . $system['parameters']['siteDescription'];
	}

	protected function getNotificationType() {
		return NotificationPeer::ALERT;
	}

	protected function createTemplate($position, $responsible, $alertObjects) {

		$smarty = new SmartyML();

		$smarty->assign('responsible', $responsible);
		$smarty->assign('position', $position);
		$smarty->assign('alertObjects', $alertObjects);

		return $smarty->fetch($this->getTemplateName());
	}

	function init($position, $responsible, $alertObjects) {

		$this->responsible = $responsible;

		$system = Common::getModuleConfiguration("system");

		$this->mailFrom = $system["parameters"]["fromEmail"];
		$this->mailTo = $responsible->getMailAddress();
		$this->subject = $this->createSubject($position);

		$this->body = $this->createTemplate($position, $responsible, $alertObjects);
	}

	function getBody() {
		return $this->body;
	}

	function getMailFrom() {
		return $this->mailFrom;
	}

	function getMailTo() {
		return $this->mailTo;
	}

	function getSubject() {
		return $this->subject;
	}

	function send() {

		$manager = new EmailManagement();

		// Descomentar la siguiente linea si se desea redirigir los mails al debugMail.
		//$manager->setTestMode();

		$message = $manager->createHTMLMessage($this->subject, $this->body);
		$result = $manager->sendMessage($this->mailTo, $this->mailFrom, $message);

		// Se guarda en historico de envios las alertas entregadas
		$notification = $this->createNotification($result);
		$notification->save();

		return $result;
	}

	function createNotification($result) {

		$notification = new Notification();
		$notificationParams = [
			'objectType' => get_class($this->responsible),
			'objectId' => $this->responsible->getId(),
			'mailBody' => $this->body,
			'type' => $this->getNotificationType(),
			'result' => $result,
			'deliveredOn' => new DateTime()
		];
		Common::setObjectFromParams($notification, $notificationParams);

		return $notification;
	}
}
