<?php
/** 
 * PanelMapAction
 *
 * @package panel 
 */

class PanelMapAction extends BaseAction {

	function PanelMapAction() {
		;
	}

	function execute($mapping, $form, &$request, &$response) {

    BaseAction::execute($mapping, $form, $request, $response);

		$plugInKey = 'SMARTY_PLUGIN';
		$smarty =& $this->actionServer->getPlugIn($plugInKey);
		if($smarty == NULL) {
			echo 'No PlugIn found matching key: '.$plugInKey."<br>\n";
		}

		$version = PositionPeer::getLatestVersion();
		$types = array_keys(ConfigModule::get("proyects","positionsTypes"));
		$positions = PositionPeer::getAllResponsiblesByPositionType($types,$version);
		$smarty->assign("positions",$positions);

		$smarty->assign("policyGuidelines",PolicyGuidelineQuery::create()->find());
		
		if (!empty($_GET['filters']['policyGuidelineId'])) {
			$strategicObjectives = StrategicObjectiveQuery::create()
				->filterByPolicyguidelineid($_GET['filters']['policyGuidelineId'])
				->find();
			$smarty->assign("strategicObjectives", $strategicObjectives);
		}
		
		if (!empty($_GET['filters']['strategicObjectiveId'])) {
			$objectives = ObjectiveQuery::create()
				->filterByStrategicobjectiveid($_GET['filters']['strategicObjectiveId'])
				->find();
			$smarty->assign("objectives", $objectives);
		}

		$projectQuery = ProjectQuery::create()
			->useConstructionQuery()
				->filterByLatitude(0, Criteria::NOT_EQUAL)
				->filterByLongitude(0, Criteria::NOT_EQUAL)
			->endUse();
														
		if (!empty($_GET['filters']['searchString']))
			$projectQuery->searchString($_GET['filters']['searchString']);
		else {
			if (!empty($_GET['filters']['objectiveId']))
				$projectQuery->filterByObjectiveid($_GET['filters']['objectiveId']);
			elseif (!empty($_GET['filters']['strategicObjectiveId']))
				$projectQuery->filterByStrategicObjectiveId($_GET['filters']['strategicObjectiveId']);
			elseif (!empty($_GET['filters']['policyGuidelineId']))
				$projectQuery->filterByPolicyGuidelineId($_GET['filters']['policyGuidelineId']);
		}

		$smarty->assign('projects', $projectQuery->find());
		$smarty->assign("filters",$_GET['filters']);

		return $mapping->findForwardConfig('success');
	}

}
