<?php


/**
 * Base class that represents a query for the 'objectives_objectiveLog' table.
 *
 * Objective Log
 *
 * @method ObjectiveLogQuery orderById($order = Criteria::ASC) Order by the id column
 * @method ObjectiveLogQuery orderByObjectiveid($order = Criteria::ASC) Order by the objectiveId column
 * @method ObjectiveLogQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method ObjectiveLogQuery orderByPolicyguidelineid($order = Criteria::ASC) Order by the policyGuidelineId column
 * @method ObjectiveLogQuery orderByStrategicobjectiveid($order = Criteria::ASC) Order by the strategicObjectiveId column
 * @method ObjectiveLogQuery orderByAffiliateid($order = Criteria::ASC) Order by the affiliateId column
 * @method ObjectiveLogQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method ObjectiveLogQuery orderByDate($order = Criteria::ASC) Order by the date column
 * @method ObjectiveLogQuery orderByExpirationdate($order = Criteria::ASC) Order by the expirationDate column
 * @method ObjectiveLogQuery orderByAchieved($order = Criteria::ASC) Order by the achieved column
 * @method ObjectiveLogQuery orderByNotes($order = Criteria::ASC) Order by the notes column
 * @method ObjectiveLogQuery orderByResponsiblecode($order = Criteria::ASC) Order by the responsibleCode column
 * @method ObjectiveLogQuery orderByUserid($order = Criteria::ASC) Order by the userId column
 * @method ObjectiveLogQuery orderByUserbyaffiliatesid($order = Criteria::ASC) Order by the userByAffiliatesId column
 * @method ObjectiveLogQuery orderByUpdated($order = Criteria::ASC) Order by the updated column
 * @method ObjectiveLogQuery orderByChanges($order = Criteria::ASC) Order by the changes column
 * @method ObjectiveLogQuery orderByOldid($order = Criteria::ASC) Order by the oldId column
 * @method ObjectiveLogQuery orderByStartingyear($order = Criteria::ASC) Order by the startingYear column
 * @method ObjectiveLogQuery orderByEndingyear($order = Criteria::ASC) Order by the endingYear column
 *
 * @method ObjectiveLogQuery groupById() Group by the id column
 * @method ObjectiveLogQuery groupByObjectiveid() Group by the objectiveId column
 * @method ObjectiveLogQuery groupByName() Group by the name column
 * @method ObjectiveLogQuery groupByPolicyguidelineid() Group by the policyGuidelineId column
 * @method ObjectiveLogQuery groupByStrategicobjectiveid() Group by the strategicObjectiveId column
 * @method ObjectiveLogQuery groupByAffiliateid() Group by the affiliateId column
 * @method ObjectiveLogQuery groupByDescription() Group by the description column
 * @method ObjectiveLogQuery groupByDate() Group by the date column
 * @method ObjectiveLogQuery groupByExpirationdate() Group by the expirationDate column
 * @method ObjectiveLogQuery groupByAchieved() Group by the achieved column
 * @method ObjectiveLogQuery groupByNotes() Group by the notes column
 * @method ObjectiveLogQuery groupByResponsiblecode() Group by the responsibleCode column
 * @method ObjectiveLogQuery groupByUserid() Group by the userId column
 * @method ObjectiveLogQuery groupByUserbyaffiliatesid() Group by the userByAffiliatesId column
 * @method ObjectiveLogQuery groupByUpdated() Group by the updated column
 * @method ObjectiveLogQuery groupByChanges() Group by the changes column
 * @method ObjectiveLogQuery groupByOldid() Group by the oldId column
 * @method ObjectiveLogQuery groupByStartingyear() Group by the startingYear column
 * @method ObjectiveLogQuery groupByEndingyear() Group by the endingYear column
 *
 * @method ObjectiveLogQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ObjectiveLogQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ObjectiveLogQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ObjectiveLogQuery leftJoinStrategicObjective($relationAlias = null) Adds a LEFT JOIN clause to the query using the StrategicObjective relation
 * @method ObjectiveLogQuery rightJoinStrategicObjective($relationAlias = null) Adds a RIGHT JOIN clause to the query using the StrategicObjective relation
 * @method ObjectiveLogQuery innerJoinStrategicObjective($relationAlias = null) Adds a INNER JOIN clause to the query using the StrategicObjective relation
 *
 * @method ObjectiveLogQuery leftJoinObjective($relationAlias = null) Adds a LEFT JOIN clause to the query using the Objective relation
 * @method ObjectiveLogQuery rightJoinObjective($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Objective relation
 * @method ObjectiveLogQuery innerJoinObjective($relationAlias = null) Adds a INNER JOIN clause to the query using the Objective relation
 *
 * @method ObjectiveLogQuery leftJoinPolicyGuideline($relationAlias = null) Adds a LEFT JOIN clause to the query using the PolicyGuideline relation
 * @method ObjectiveLogQuery rightJoinPolicyGuideline($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PolicyGuideline relation
 * @method ObjectiveLogQuery innerJoinPolicyGuideline($relationAlias = null) Adds a INNER JOIN clause to the query using the PolicyGuideline relation
 *
 * @method ObjectiveLogQuery leftJoinUser($relationAlias = null) Adds a LEFT JOIN clause to the query using the User relation
 * @method ObjectiveLogQuery rightJoinUser($relationAlias = null) Adds a RIGHT JOIN clause to the query using the User relation
 * @method ObjectiveLogQuery innerJoinUser($relationAlias = null) Adds a INNER JOIN clause to the query using the User relation
 *
 * @method ObjectiveLogQuery leftJoinPosition($relationAlias = null) Adds a LEFT JOIN clause to the query using the Position relation
 * @method ObjectiveLogQuery rightJoinPosition($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Position relation
 * @method ObjectiveLogQuery innerJoinPosition($relationAlias = null) Adds a INNER JOIN clause to the query using the Position relation
 *
 * @method ObjectiveLog findOne(PropelPDO $con = null) Return the first ObjectiveLog matching the query
 * @method ObjectiveLog findOneOrCreate(PropelPDO $con = null) Return the first ObjectiveLog matching the query, or a new ObjectiveLog object populated from the query conditions when no match is found
 *
 * @method ObjectiveLog findOneById(int $id) Return the first ObjectiveLog filtered by the id column
 * @method ObjectiveLog findOneByObjectiveid(int $objectiveId) Return the first ObjectiveLog filtered by the objectiveId column
 * @method ObjectiveLog findOneByName(string $name) Return the first ObjectiveLog filtered by the name column
 * @method ObjectiveLog findOneByPolicyguidelineid(int $policyGuidelineId) Return the first ObjectiveLog filtered by the policyGuidelineId column
 * @method ObjectiveLog findOneByStrategicobjectiveid(int $strategicObjectiveId) Return the first ObjectiveLog filtered by the strategicObjectiveId column
 * @method ObjectiveLog findOneByAffiliateid(int $affiliateId) Return the first ObjectiveLog filtered by the affiliateId column
 * @method ObjectiveLog findOneByDescription(string $description) Return the first ObjectiveLog filtered by the description column
 * @method ObjectiveLog findOneByDate(string $date) Return the first ObjectiveLog filtered by the date column
 * @method ObjectiveLog findOneByExpirationdate(string $expirationDate) Return the first ObjectiveLog filtered by the expirationDate column
 * @method ObjectiveLog findOneByAchieved(boolean $achieved) Return the first ObjectiveLog filtered by the achieved column
 * @method ObjectiveLog findOneByNotes(string $notes) Return the first ObjectiveLog filtered by the notes column
 * @method ObjectiveLog findOneByResponsiblecode(int $responsibleCode) Return the first ObjectiveLog filtered by the responsibleCode column
 * @method ObjectiveLog findOneByUserid(int $userId) Return the first ObjectiveLog filtered by the userId column
 * @method ObjectiveLog findOneByUserbyaffiliatesid(int $userByAffiliatesId) Return the first ObjectiveLog filtered by the userByAffiliatesId column
 * @method ObjectiveLog findOneByUpdated(string $updated) Return the first ObjectiveLog filtered by the updated column
 * @method ObjectiveLog findOneByChanges(int $changes) Return the first ObjectiveLog filtered by the changes column
 * @method ObjectiveLog findOneByOldid(int $oldId) Return the first ObjectiveLog filtered by the oldId column
 * @method ObjectiveLog findOneByStartingyear(int $startingYear) Return the first ObjectiveLog filtered by the startingYear column
 * @method ObjectiveLog findOneByEndingyear(int $endingYear) Return the first ObjectiveLog filtered by the endingYear column
 *
 * @method array findById(int $id) Return ObjectiveLog objects filtered by the id column
 * @method array findByObjectiveid(int $objectiveId) Return ObjectiveLog objects filtered by the objectiveId column
 * @method array findByName(string $name) Return ObjectiveLog objects filtered by the name column
 * @method array findByPolicyguidelineid(int $policyGuidelineId) Return ObjectiveLog objects filtered by the policyGuidelineId column
 * @method array findByStrategicobjectiveid(int $strategicObjectiveId) Return ObjectiveLog objects filtered by the strategicObjectiveId column
 * @method array findByAffiliateid(int $affiliateId) Return ObjectiveLog objects filtered by the affiliateId column
 * @method array findByDescription(string $description) Return ObjectiveLog objects filtered by the description column
 * @method array findByDate(string $date) Return ObjectiveLog objects filtered by the date column
 * @method array findByExpirationdate(string $expirationDate) Return ObjectiveLog objects filtered by the expirationDate column
 * @method array findByAchieved(boolean $achieved) Return ObjectiveLog objects filtered by the achieved column
 * @method array findByNotes(string $notes) Return ObjectiveLog objects filtered by the notes column
 * @method array findByResponsiblecode(int $responsibleCode) Return ObjectiveLog objects filtered by the responsibleCode column
 * @method array findByUserid(int $userId) Return ObjectiveLog objects filtered by the userId column
 * @method array findByUserbyaffiliatesid(int $userByAffiliatesId) Return ObjectiveLog objects filtered by the userByAffiliatesId column
 * @method array findByUpdated(string $updated) Return ObjectiveLog objects filtered by the updated column
 * @method array findByChanges(int $changes) Return ObjectiveLog objects filtered by the changes column
 * @method array findByOldid(int $oldId) Return ObjectiveLog objects filtered by the oldId column
 * @method array findByStartingyear(int $startingYear) Return ObjectiveLog objects filtered by the startingYear column
 * @method array findByEndingyear(int $endingYear) Return ObjectiveLog objects filtered by the endingYear column
 *
 * @package    propel.generator.objectives.classes.om
 */
abstract class BaseObjectiveLogQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseObjectiveLogQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ObjectiveLog', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ObjectiveLogQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ObjectiveLogQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ObjectiveLogQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ObjectiveLogQuery) {
            return $criteria;
        }
        $query = new ObjectiveLogQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ObjectiveLog|ObjectiveLog[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ObjectiveLogPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ObjectiveLog A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `OBJECTIVEID`, `NAME`, `POLICYGUIDELINEID`, `STRATEGICOBJECTIVEID`, `AFFILIATEID`, `DESCRIPTION`, `DATE`, `EXPIRATIONDATE`, `ACHIEVED`, `NOTES`, `RESPONSIBLECODE`, `USERID`, `USERBYAFFILIATESID`, `UPDATED`, `CHANGES`, `OLDID`, `STARTINGYEAR`, `ENDINGYEAR` FROM `objectives_objectiveLog` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ObjectiveLog();
            $obj->hydrate($row);
            ObjectiveLogPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ObjectiveLog|ObjectiveLog[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ObjectiveLog[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ObjectiveLogPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ObjectiveLogPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ObjectiveLogPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the objectiveId column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectiveid(1234); // WHERE objectiveId = 1234
     * $query->filterByObjectiveid(array(12, 34)); // WHERE objectiveId IN (12, 34)
     * $query->filterByObjectiveid(array('min' => 12)); // WHERE objectiveId > 12
     * </code>
     *
     * @see       filterByObjective()
     *
     * @param     mixed $objectiveid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByObjectiveid($objectiveid = null, $comparison = null)
    {
        if (is_array($objectiveid)) {
            $useMinMax = false;
            if (isset($objectiveid['min'])) {
                $this->addUsingAlias(ObjectiveLogPeer::OBJECTIVEID, $objectiveid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($objectiveid['max'])) {
                $this->addUsingAlias(ObjectiveLogPeer::OBJECTIVEID, $objectiveid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectiveLogPeer::OBJECTIVEID, $objectiveid, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ObjectiveLogPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the policyGuidelineId column
     *
     * Example usage:
     * <code>
     * $query->filterByPolicyguidelineid(1234); // WHERE policyGuidelineId = 1234
     * $query->filterByPolicyguidelineid(array(12, 34)); // WHERE policyGuidelineId IN (12, 34)
     * $query->filterByPolicyguidelineid(array('min' => 12)); // WHERE policyGuidelineId > 12
     * </code>
     *
     * @see       filterByPolicyGuideline()
     *
     * @param     mixed $policyguidelineid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByPolicyguidelineid($policyguidelineid = null, $comparison = null)
    {
        if (is_array($policyguidelineid)) {
            $useMinMax = false;
            if (isset($policyguidelineid['min'])) {
                $this->addUsingAlias(ObjectiveLogPeer::POLICYGUIDELINEID, $policyguidelineid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($policyguidelineid['max'])) {
                $this->addUsingAlias(ObjectiveLogPeer::POLICYGUIDELINEID, $policyguidelineid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectiveLogPeer::POLICYGUIDELINEID, $policyguidelineid, $comparison);
    }

    /**
     * Filter the query on the strategicObjectiveId column
     *
     * Example usage:
     * <code>
     * $query->filterByStrategicobjectiveid(1234); // WHERE strategicObjectiveId = 1234
     * $query->filterByStrategicobjectiveid(array(12, 34)); // WHERE strategicObjectiveId IN (12, 34)
     * $query->filterByStrategicobjectiveid(array('min' => 12)); // WHERE strategicObjectiveId > 12
     * </code>
     *
     * @see       filterByStrategicObjective()
     *
     * @param     mixed $strategicobjectiveid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByStrategicobjectiveid($strategicobjectiveid = null, $comparison = null)
    {
        if (is_array($strategicobjectiveid)) {
            $useMinMax = false;
            if (isset($strategicobjectiveid['min'])) {
                $this->addUsingAlias(ObjectiveLogPeer::STRATEGICOBJECTIVEID, $strategicobjectiveid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($strategicobjectiveid['max'])) {
                $this->addUsingAlias(ObjectiveLogPeer::STRATEGICOBJECTIVEID, $strategicobjectiveid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectiveLogPeer::STRATEGICOBJECTIVEID, $strategicobjectiveid, $comparison);
    }

    /**
     * Filter the query on the affiliateId column
     *
     * Example usage:
     * <code>
     * $query->filterByAffiliateid(1234); // WHERE affiliateId = 1234
     * $query->filterByAffiliateid(array(12, 34)); // WHERE affiliateId IN (12, 34)
     * $query->filterByAffiliateid(array('min' => 12)); // WHERE affiliateId > 12
     * </code>
     *
     * @param     mixed $affiliateid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByAffiliateid($affiliateid = null, $comparison = null)
    {
        if (is_array($affiliateid)) {
            $useMinMax = false;
            if (isset($affiliateid['min'])) {
                $this->addUsingAlias(ObjectiveLogPeer::AFFILIATEID, $affiliateid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($affiliateid['max'])) {
                $this->addUsingAlias(ObjectiveLogPeer::AFFILIATEID, $affiliateid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectiveLogPeer::AFFILIATEID, $affiliateid, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ObjectiveLogPeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the date column
     *
     * Example usage:
     * <code>
     * $query->filterByDate('2011-03-14'); // WHERE date = '2011-03-14'
     * $query->filterByDate('now'); // WHERE date = '2011-03-14'
     * $query->filterByDate(array('max' => 'yesterday')); // WHERE date > '2011-03-13'
     * </code>
     *
     * @param     mixed $date The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByDate($date = null, $comparison = null)
    {
        if (is_array($date)) {
            $useMinMax = false;
            if (isset($date['min'])) {
                $this->addUsingAlias(ObjectiveLogPeer::DATE, $date['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($date['max'])) {
                $this->addUsingAlias(ObjectiveLogPeer::DATE, $date['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectiveLogPeer::DATE, $date, $comparison);
    }

    /**
     * Filter the query on the expirationDate column
     *
     * Example usage:
     * <code>
     * $query->filterByExpirationdate('2011-03-14'); // WHERE expirationDate = '2011-03-14'
     * $query->filterByExpirationdate('now'); // WHERE expirationDate = '2011-03-14'
     * $query->filterByExpirationdate(array('max' => 'yesterday')); // WHERE expirationDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $expirationdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByExpirationdate($expirationdate = null, $comparison = null)
    {
        if (is_array($expirationdate)) {
            $useMinMax = false;
            if (isset($expirationdate['min'])) {
                $this->addUsingAlias(ObjectiveLogPeer::EXPIRATIONDATE, $expirationdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($expirationdate['max'])) {
                $this->addUsingAlias(ObjectiveLogPeer::EXPIRATIONDATE, $expirationdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectiveLogPeer::EXPIRATIONDATE, $expirationdate, $comparison);
    }

    /**
     * Filter the query on the achieved column
     *
     * Example usage:
     * <code>
     * $query->filterByAchieved(true); // WHERE achieved = true
     * $query->filterByAchieved('yes'); // WHERE achieved = true
     * </code>
     *
     * @param     boolean|string $achieved The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByAchieved($achieved = null, $comparison = null)
    {
        if (is_string($achieved)) {
            $achieved = in_array(strtolower($achieved), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ObjectiveLogPeer::ACHIEVED, $achieved, $comparison);
    }

    /**
     * Filter the query on the notes column
     *
     * Example usage:
     * <code>
     * $query->filterByNotes('fooValue');   // WHERE notes = 'fooValue'
     * $query->filterByNotes('%fooValue%'); // WHERE notes LIKE '%fooValue%'
     * </code>
     *
     * @param     string $notes The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByNotes($notes = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($notes)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $notes)) {
                $notes = str_replace('*', '%', $notes);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ObjectiveLogPeer::NOTES, $notes, $comparison);
    }

    /**
     * Filter the query on the responsibleCode column
     *
     * Example usage:
     * <code>
     * $query->filterByResponsiblecode(1234); // WHERE responsibleCode = 1234
     * $query->filterByResponsiblecode(array(12, 34)); // WHERE responsibleCode IN (12, 34)
     * $query->filterByResponsiblecode(array('min' => 12)); // WHERE responsibleCode > 12
     * </code>
     *
     * @see       filterByPosition()
     *
     * @param     mixed $responsiblecode The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByResponsiblecode($responsiblecode = null, $comparison = null)
    {
        if (is_array($responsiblecode)) {
            $useMinMax = false;
            if (isset($responsiblecode['min'])) {
                $this->addUsingAlias(ObjectiveLogPeer::RESPONSIBLECODE, $responsiblecode['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($responsiblecode['max'])) {
                $this->addUsingAlias(ObjectiveLogPeer::RESPONSIBLECODE, $responsiblecode['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectiveLogPeer::RESPONSIBLECODE, $responsiblecode, $comparison);
    }

    /**
     * Filter the query on the userId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserid(1234); // WHERE userId = 1234
     * $query->filterByUserid(array(12, 34)); // WHERE userId IN (12, 34)
     * $query->filterByUserid(array('min' => 12)); // WHERE userId > 12
     * </code>
     *
     * @see       filterByUser()
     *
     * @param     mixed $userid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByUserid($userid = null, $comparison = null)
    {
        if (is_array($userid)) {
            $useMinMax = false;
            if (isset($userid['min'])) {
                $this->addUsingAlias(ObjectiveLogPeer::USERID, $userid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userid['max'])) {
                $this->addUsingAlias(ObjectiveLogPeer::USERID, $userid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectiveLogPeer::USERID, $userid, $comparison);
    }

    /**
     * Filter the query on the userByAffiliatesId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserbyaffiliatesid(1234); // WHERE userByAffiliatesId = 1234
     * $query->filterByUserbyaffiliatesid(array(12, 34)); // WHERE userByAffiliatesId IN (12, 34)
     * $query->filterByUserbyaffiliatesid(array('min' => 12)); // WHERE userByAffiliatesId > 12
     * </code>
     *
     * @param     mixed $userbyaffiliatesid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByUserbyaffiliatesid($userbyaffiliatesid = null, $comparison = null)
    {
        if (is_array($userbyaffiliatesid)) {
            $useMinMax = false;
            if (isset($userbyaffiliatesid['min'])) {
                $this->addUsingAlias(ObjectiveLogPeer::USERBYAFFILIATESID, $userbyaffiliatesid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userbyaffiliatesid['max'])) {
                $this->addUsingAlias(ObjectiveLogPeer::USERBYAFFILIATESID, $userbyaffiliatesid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectiveLogPeer::USERBYAFFILIATESID, $userbyaffiliatesid, $comparison);
    }

    /**
     * Filter the query on the updated column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdated('2011-03-14'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated('now'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated(array('max' => 'yesterday')); // WHERE updated > '2011-03-13'
     * </code>
     *
     * @param     mixed $updated The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByUpdated($updated = null, $comparison = null)
    {
        if (is_array($updated)) {
            $useMinMax = false;
            if (isset($updated['min'])) {
                $this->addUsingAlias(ObjectiveLogPeer::UPDATED, $updated['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updated['max'])) {
                $this->addUsingAlias(ObjectiveLogPeer::UPDATED, $updated['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectiveLogPeer::UPDATED, $updated, $comparison);
    }

    /**
     * Filter the query on the changes column
     *
     * Example usage:
     * <code>
     * $query->filterByChanges(1234); // WHERE changes = 1234
     * $query->filterByChanges(array(12, 34)); // WHERE changes IN (12, 34)
     * $query->filterByChanges(array('min' => 12)); // WHERE changes > 12
     * </code>
     *
     * @param     mixed $changes The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByChanges($changes = null, $comparison = null)
    {
        if (is_array($changes)) {
            $useMinMax = false;
            if (isset($changes['min'])) {
                $this->addUsingAlias(ObjectiveLogPeer::CHANGES, $changes['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($changes['max'])) {
                $this->addUsingAlias(ObjectiveLogPeer::CHANGES, $changes['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectiveLogPeer::CHANGES, $changes, $comparison);
    }

    /**
     * Filter the query on the oldId column
     *
     * Example usage:
     * <code>
     * $query->filterByOldid(1234); // WHERE oldId = 1234
     * $query->filterByOldid(array(12, 34)); // WHERE oldId IN (12, 34)
     * $query->filterByOldid(array('min' => 12)); // WHERE oldId > 12
     * </code>
     *
     * @param     mixed $oldid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByOldid($oldid = null, $comparison = null)
    {
        if (is_array($oldid)) {
            $useMinMax = false;
            if (isset($oldid['min'])) {
                $this->addUsingAlias(ObjectiveLogPeer::OLDID, $oldid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($oldid['max'])) {
                $this->addUsingAlias(ObjectiveLogPeer::OLDID, $oldid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectiveLogPeer::OLDID, $oldid, $comparison);
    }

    /**
     * Filter the query on the startingYear column
     *
     * Example usage:
     * <code>
     * $query->filterByStartingyear(1234); // WHERE startingYear = 1234
     * $query->filterByStartingyear(array(12, 34)); // WHERE startingYear IN (12, 34)
     * $query->filterByStartingyear(array('min' => 12)); // WHERE startingYear > 12
     * </code>
     *
     * @param     mixed $startingyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByStartingyear($startingyear = null, $comparison = null)
    {
        if (is_array($startingyear)) {
            $useMinMax = false;
            if (isset($startingyear['min'])) {
                $this->addUsingAlias(ObjectiveLogPeer::STARTINGYEAR, $startingyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($startingyear['max'])) {
                $this->addUsingAlias(ObjectiveLogPeer::STARTINGYEAR, $startingyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectiveLogPeer::STARTINGYEAR, $startingyear, $comparison);
    }

    /**
     * Filter the query on the endingYear column
     *
     * Example usage:
     * <code>
     * $query->filterByEndingyear(1234); // WHERE endingYear = 1234
     * $query->filterByEndingyear(array(12, 34)); // WHERE endingYear IN (12, 34)
     * $query->filterByEndingyear(array('min' => 12)); // WHERE endingYear > 12
     * </code>
     *
     * @param     mixed $endingyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByEndingyear($endingyear = null, $comparison = null)
    {
        if (is_array($endingyear)) {
            $useMinMax = false;
            if (isset($endingyear['min'])) {
                $this->addUsingAlias(ObjectiveLogPeer::ENDINGYEAR, $endingyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($endingyear['max'])) {
                $this->addUsingAlias(ObjectiveLogPeer::ENDINGYEAR, $endingyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectiveLogPeer::ENDINGYEAR, $endingyear, $comparison);
    }

    /**
     * Filter the query by a related StrategicObjective object
     *
     * @param   StrategicObjective|PropelObjectCollection $strategicObjective The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ObjectiveLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByStrategicObjective($strategicObjective, $comparison = null)
    {
        if ($strategicObjective instanceof StrategicObjective) {
            return $this
                ->addUsingAlias(ObjectiveLogPeer::STRATEGICOBJECTIVEID, $strategicObjective->getId(), $comparison);
        } elseif ($strategicObjective instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ObjectiveLogPeer::STRATEGICOBJECTIVEID, $strategicObjective->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByStrategicObjective() only accepts arguments of type StrategicObjective or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the StrategicObjective relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function joinStrategicObjective($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('StrategicObjective');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'StrategicObjective');
        }

        return $this;
    }

    /**
     * Use the StrategicObjective relation StrategicObjective object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   StrategicObjectiveQuery A secondary query class using the current class as primary query
     */
    public function useStrategicObjectiveQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinStrategicObjective($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'StrategicObjective', 'StrategicObjectiveQuery');
    }

    /**
     * Filter the query by a related Objective object
     *
     * @param   Objective|PropelObjectCollection $objective The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ObjectiveLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByObjective($objective, $comparison = null)
    {
        if ($objective instanceof Objective) {
            return $this
                ->addUsingAlias(ObjectiveLogPeer::OBJECTIVEID, $objective->getId(), $comparison);
        } elseif ($objective instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ObjectiveLogPeer::OBJECTIVEID, $objective->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByObjective() only accepts arguments of type Objective or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Objective relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function joinObjective($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Objective');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Objective');
        }

        return $this;
    }

    /**
     * Use the Objective relation Objective object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ObjectiveQuery A secondary query class using the current class as primary query
     */
    public function useObjectiveQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinObjective($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Objective', 'ObjectiveQuery');
    }

    /**
     * Filter the query by a related PolicyGuideline object
     *
     * @param   PolicyGuideline|PropelObjectCollection $policyGuideline The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ObjectiveLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPolicyGuideline($policyGuideline, $comparison = null)
    {
        if ($policyGuideline instanceof PolicyGuideline) {
            return $this
                ->addUsingAlias(ObjectiveLogPeer::POLICYGUIDELINEID, $policyGuideline->getId(), $comparison);
        } elseif ($policyGuideline instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ObjectiveLogPeer::POLICYGUIDELINEID, $policyGuideline->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByPolicyGuideline() only accepts arguments of type PolicyGuideline or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PolicyGuideline relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function joinPolicyGuideline($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PolicyGuideline');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PolicyGuideline');
        }

        return $this;
    }

    /**
     * Use the PolicyGuideline relation PolicyGuideline object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PolicyGuidelineQuery A secondary query class using the current class as primary query
     */
    public function usePolicyGuidelineQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinPolicyGuideline($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PolicyGuideline', 'PolicyGuidelineQuery');
    }

    /**
     * Filter the query by a related User object
     *
     * @param   User|PropelObjectCollection $user The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ObjectiveLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByUser($user, $comparison = null)
    {
        if ($user instanceof User) {
            return $this
                ->addUsingAlias(ObjectiveLogPeer::USERID, $user->getId(), $comparison);
        } elseif ($user instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ObjectiveLogPeer::USERID, $user->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByUser() only accepts arguments of type User or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the User relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function joinUser($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('User');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'User');
        }

        return $this;
    }

    /**
     * Use the User relation User object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   UserQuery A secondary query class using the current class as primary query
     */
    public function useUserQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinUser($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'User', 'UserQuery');
    }

    /**
     * Filter the query by a related Position object
     *
     * @param   Position|PropelObjectCollection $position The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ObjectiveLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPosition($position, $comparison = null)
    {
        if ($position instanceof Position) {
            return $this
                ->addUsingAlias(ObjectiveLogPeer::RESPONSIBLECODE, $position->getId(), $comparison);
        } elseif ($position instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ObjectiveLogPeer::RESPONSIBLECODE, $position->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByPosition() only accepts arguments of type Position or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Position relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function joinPosition($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Position');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Position');
        }

        return $this;
    }

    /**
     * Use the Position relation Position object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PositionQuery A secondary query class using the current class as primary query
     */
    public function usePositionQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinPosition($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Position', 'PositionQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ObjectiveLog $objectiveLog Object to remove from the list of results
     *
     * @return ObjectiveLogQuery The current query, for fluid interface
     */
    public function prune($objectiveLog = null)
    {
        if ($objectiveLog) {
            $this->addUsingAlias(ObjectiveLogPeer::ID, $objectiveLog->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
