<?php


/**
 * Base class that represents a row from the 'medias_media' table.
 *
 * Archivo de medios
 *
 * @package    propel.generator.medias.classes.om
 */
abstract class BaseMedia extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'MediaPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        MediaPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the address field.
     * @var        string
     */
    protected $address;

    /**
     * The value for the phone field.
     * @var        string
     */
    protected $phone;

    /**
     * The value for the url field.
     * @var        string
     */
    protected $url;

    /**
     * The value for the mediakiturl field.
     * @var        string
     */
    protected $mediakiturl;

    /**
     * The value for the fax field.
     * @var        string
     */
    protected $fax;

    /**
     * The value for the email field.
     * @var        string
     */
    protected $email;

    /**
     * The value for the receptionist field.
     * @var        string
     */
    protected $receptionist;

    /**
     * The value for the description field.
     * @var        string
     */
    protected $description;

    /**
     * The value for the typeid field.
     * @var        int
     */
    protected $typeid;

    /**
     * The value for the groupid field.
     * @var        int
     */
    protected $groupid;

    /**
     * The value for the importance field.
     * @var        int
     */
    protected $importance;

    /**
     * The value for the bias field.
     * @var        int
     */
    protected $bias;

    /**
     * The value for the aliasof field.
     * @var        int
     */
    protected $aliasof;

    /**
     * The value for the created_at field.
     * @var        string
     */
    protected $created_at;

    /**
     * The value for the updated_at field.
     * @var        string
     */
    protected $updated_at;

    /**
     * @var        MediaType
     */
    protected $aMediaType;

    /**
     * @var        Media
     */
    protected $aMediaRelatedByGroupid;

    /**
     * @var        Media
     */
    protected $aMediaRelatedByAliasof;

    /**
     * @var        PropelObjectCollection|Headline[] Collection to store aggregation of Headline objects.
     */
    protected $collHeadlines;
    protected $collHeadlinesPartial;

    /**
     * @var        PropelObjectCollection|Media[] Collection to store aggregation of Media objects.
     */
    protected $collMediasRelatedById0;
    protected $collMediasRelatedById0Partial;

    /**
     * @var        PropelObjectCollection|Media[] Collection to store aggregation of Media objects.
     */
    protected $collMediasRelatedById1;
    protected $collMediasRelatedById1Partial;

    /**
     * @var        PropelObjectCollection|MediaMarketRelation[] Collection to store aggregation of MediaMarketRelation objects.
     */
    protected $collMediaMarketRelations;
    protected $collMediaMarketRelationsPartial;

    /**
     * @var        PropelObjectCollection|MediaAudienceRelation[] Collection to store aggregation of MediaAudienceRelation objects.
     */
    protected $collMediaAudienceRelations;
    protected $collMediaAudienceRelationsPartial;

    /**
     * @var        PropelObjectCollection|MediaMarket[] Collection to store aggregation of MediaMarket objects.
     */
    protected $collMediaMarkets;

    /**
     * @var        PropelObjectCollection|MediaAudience[] Collection to store aggregation of MediaAudience objects.
     */
    protected $collMediaAudiences;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $mediaMarketsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $mediaAudiencesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $headlinesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $mediasRelatedById0ScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $mediasRelatedById1ScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $mediaMarketRelationsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $mediaAudienceRelationsScheduledForDeletion = null;

    /**
     * Get the [id] column value.
     * Id log
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     * Nombre del medio
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [address] column value.
     * Direccion
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * Get the [phone] column value.
     * Telefono
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * Get the [url] column value.
     * Direccion web
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * Get the [mediakiturl] column value.
     * Direccion del mediakit
     * @return string
     */
    public function getMediakiturl()
    {
        return $this->mediakiturl;
    }

    /**
     * Get the [fax] column value.
     * Fax
     * @return string
     */
    public function getFax()
    {
        return $this->fax;
    }

    /**
     * Get the [email] column value.
     * Direccion email
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Get the [receptionist] column value.
     * Recepcionista
     * @return string
     */
    public function getReceptionist()
    {
        return $this->receptionist;
    }

    /**
     * Get the [description] column value.
     * Descripcion del medio
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the [typeid] column value.
     * ID media destino
     * @return int
     */
    public function getTypeid()
    {
        return $this->typeid;
    }

    /**
     * Get the [groupid] column value.
     * ID media destino
     * @return int
     */
    public function getGroupid()
    {
        return $this->groupid;
    }

    /**
     * Get the [importance] column value.
     * Importancia del medio
     * @return int
     */
    public function getImportance()
    {
        return $this->importance;
    }

    /**
     * Get the [bias] column value.
     * Afinidad del medio
     * @return int
     */
    public function getBias()
    {
        return $this->bias;
    }

    /**
     * Get the [aliasof] column value.
     * ID media referenciado
     * @return int
     */
    public function getAliasof()
    {
        return $this->aliasof;
    }

    /**
     * Get the [optionally formatted] temporal [created_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getCreatedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->created_at === null) {
            return null;
        }

        if ($this->created_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->created_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->created_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [updated_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getUpdatedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->updated_at === null) {
            return null;
        }

        if ($this->updated_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->updated_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->updated_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Set the value of [id] column.
     * Id log
     * @param int $v new value
     * @return Media The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = MediaPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [name] column.
     * Nombre del medio
     * @param string $v new value
     * @return Media The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = MediaPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [address] column.
     * Direccion
     * @param string $v new value
     * @return Media The current object (for fluent API support)
     */
    public function setAddress($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->address !== $v) {
            $this->address = $v;
            $this->modifiedColumns[] = MediaPeer::ADDRESS;
        }


        return $this;
    } // setAddress()

    /**
     * Set the value of [phone] column.
     * Telefono
     * @param string $v new value
     * @return Media The current object (for fluent API support)
     */
    public function setPhone($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->phone !== $v) {
            $this->phone = $v;
            $this->modifiedColumns[] = MediaPeer::PHONE;
        }


        return $this;
    } // setPhone()

    /**
     * Set the value of [url] column.
     * Direccion web
     * @param string $v new value
     * @return Media The current object (for fluent API support)
     */
    public function setUrl($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->url !== $v) {
            $this->url = $v;
            $this->modifiedColumns[] = MediaPeer::URL;
        }


        return $this;
    } // setUrl()

    /**
     * Set the value of [mediakiturl] column.
     * Direccion del mediakit
     * @param string $v new value
     * @return Media The current object (for fluent API support)
     */
    public function setMediakiturl($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->mediakiturl !== $v) {
            $this->mediakiturl = $v;
            $this->modifiedColumns[] = MediaPeer::MEDIAKITURL;
        }


        return $this;
    } // setMediakiturl()

    /**
     * Set the value of [fax] column.
     * Fax
     * @param string $v new value
     * @return Media The current object (for fluent API support)
     */
    public function setFax($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->fax !== $v) {
            $this->fax = $v;
            $this->modifiedColumns[] = MediaPeer::FAX;
        }


        return $this;
    } // setFax()

    /**
     * Set the value of [email] column.
     * Direccion email
     * @param string $v new value
     * @return Media The current object (for fluent API support)
     */
    public function setEmail($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->email !== $v) {
            $this->email = $v;
            $this->modifiedColumns[] = MediaPeer::EMAIL;
        }


        return $this;
    } // setEmail()

    /**
     * Set the value of [receptionist] column.
     * Recepcionista
     * @param string $v new value
     * @return Media The current object (for fluent API support)
     */
    public function setReceptionist($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->receptionist !== $v) {
            $this->receptionist = $v;
            $this->modifiedColumns[] = MediaPeer::RECEPTIONIST;
        }


        return $this;
    } // setReceptionist()

    /**
     * Set the value of [description] column.
     * Descripcion del medio
     * @param string $v new value
     * @return Media The current object (for fluent API support)
     */
    public function setDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->description !== $v) {
            $this->description = $v;
            $this->modifiedColumns[] = MediaPeer::DESCRIPTION;
        }


        return $this;
    } // setDescription()

    /**
     * Set the value of [typeid] column.
     * ID media destino
     * @param int $v new value
     * @return Media The current object (for fluent API support)
     */
    public function setTypeid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->typeid !== $v) {
            $this->typeid = $v;
            $this->modifiedColumns[] = MediaPeer::TYPEID;
        }

        if ($this->aMediaType !== null && $this->aMediaType->getId() !== $v) {
            $this->aMediaType = null;
        }


        return $this;
    } // setTypeid()

    /**
     * Set the value of [groupid] column.
     * ID media destino
     * @param int $v new value
     * @return Media The current object (for fluent API support)
     */
    public function setGroupid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->groupid !== $v) {
            $this->groupid = $v;
            $this->modifiedColumns[] = MediaPeer::GROUPID;
        }

        if ($this->aMediaRelatedByGroupid !== null && $this->aMediaRelatedByGroupid->getId() !== $v) {
            $this->aMediaRelatedByGroupid = null;
        }


        return $this;
    } // setGroupid()

    /**
     * Set the value of [importance] column.
     * Importancia del medio
     * @param int $v new value
     * @return Media The current object (for fluent API support)
     */
    public function setImportance($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->importance !== $v) {
            $this->importance = $v;
            $this->modifiedColumns[] = MediaPeer::IMPORTANCE;
        }


        return $this;
    } // setImportance()

    /**
     * Set the value of [bias] column.
     * Afinidad del medio
     * @param int $v new value
     * @return Media The current object (for fluent API support)
     */
    public function setBias($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->bias !== $v) {
            $this->bias = $v;
            $this->modifiedColumns[] = MediaPeer::BIAS;
        }


        return $this;
    } // setBias()

    /**
     * Set the value of [aliasof] column.
     * ID media referenciado
     * @param int $v new value
     * @return Media The current object (for fluent API support)
     */
    public function setAliasof($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->aliasof !== $v) {
            $this->aliasof = $v;
            $this->modifiedColumns[] = MediaPeer::ALIASOF;
        }

        if ($this->aMediaRelatedByAliasof !== null && $this->aMediaRelatedByAliasof->getId() !== $v) {
            $this->aMediaRelatedByAliasof = null;
        }


        return $this;
    } // setAliasof()

    /**
     * Sets the value of [created_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Media The current object (for fluent API support)
     */
    public function setCreatedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->created_at !== null || $dt !== null) {
            $currentDateAsString = ($this->created_at !== null && $tmpDt = new DateTime($this->created_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->created_at = $newDateAsString;
                $this->modifiedColumns[] = MediaPeer::CREATED_AT;
            }
        } // if either are not null


        return $this;
    } // setCreatedAt()

    /**
     * Sets the value of [updated_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Media The current object (for fluent API support)
     */
    public function setUpdatedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->updated_at !== null || $dt !== null) {
            $currentDateAsString = ($this->updated_at !== null && $tmpDt = new DateTime($this->updated_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->updated_at = $newDateAsString;
                $this->modifiedColumns[] = MediaPeer::UPDATED_AT;
            }
        } // if either are not null


        return $this;
    } // setUpdatedAt()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->address = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->phone = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->url = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->mediakiturl = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->fax = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->email = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
            $this->receptionist = ($row[$startcol + 8] !== null) ? (string) $row[$startcol + 8] : null;
            $this->description = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
            $this->typeid = ($row[$startcol + 10] !== null) ? (int) $row[$startcol + 10] : null;
            $this->groupid = ($row[$startcol + 11] !== null) ? (int) $row[$startcol + 11] : null;
            $this->importance = ($row[$startcol + 12] !== null) ? (int) $row[$startcol + 12] : null;
            $this->bias = ($row[$startcol + 13] !== null) ? (int) $row[$startcol + 13] : null;
            $this->aliasof = ($row[$startcol + 14] !== null) ? (int) $row[$startcol + 14] : null;
            $this->created_at = ($row[$startcol + 15] !== null) ? (string) $row[$startcol + 15] : null;
            $this->updated_at = ($row[$startcol + 16] !== null) ? (string) $row[$startcol + 16] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 17; // 17 = MediaPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Media object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aMediaType !== null && $this->typeid !== $this->aMediaType->getId()) {
            $this->aMediaType = null;
        }
        if ($this->aMediaRelatedByGroupid !== null && $this->groupid !== $this->aMediaRelatedByGroupid->getId()) {
            $this->aMediaRelatedByGroupid = null;
        }
        if ($this->aMediaRelatedByAliasof !== null && $this->aliasof !== $this->aMediaRelatedByAliasof->getId()) {
            $this->aMediaRelatedByAliasof = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(MediaPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = MediaPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aMediaType = null;
            $this->aMediaRelatedByGroupid = null;
            $this->aMediaRelatedByAliasof = null;
            $this->collHeadlines = null;

            $this->collMediasRelatedById0 = null;

            $this->collMediasRelatedById1 = null;

            $this->collMediaMarketRelations = null;

            $this->collMediaAudienceRelations = null;

            $this->collMediaMarkets = null;
            $this->collMediaAudiences = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(MediaPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = MediaQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(MediaPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
                // timestampable behavior
                if (!$this->isColumnModified(MediaPeer::CREATED_AT)) {
                    $this->setCreatedAt(time());
                }
                if (!$this->isColumnModified(MediaPeer::UPDATED_AT)) {
                    $this->setUpdatedAt(time());
                }
            } else {
                $ret = $ret && $this->preUpdate($con);
                // timestampable behavior
                if ($this->isModified() && !$this->isColumnModified(MediaPeer::UPDATED_AT)) {
                    $this->setUpdatedAt(time());
                }
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                MediaPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aMediaType !== null) {
                if ($this->aMediaType->isModified() || $this->aMediaType->isNew()) {
                    $affectedRows += $this->aMediaType->save($con);
                }
                $this->setMediaType($this->aMediaType);
            }

            if ($this->aMediaRelatedByGroupid !== null) {
                if ($this->aMediaRelatedByGroupid->isModified() || $this->aMediaRelatedByGroupid->isNew()) {
                    $affectedRows += $this->aMediaRelatedByGroupid->save($con);
                }
                $this->setMediaRelatedByGroupid($this->aMediaRelatedByGroupid);
            }

            if ($this->aMediaRelatedByAliasof !== null) {
                if ($this->aMediaRelatedByAliasof->isModified() || $this->aMediaRelatedByAliasof->isNew()) {
                    $affectedRows += $this->aMediaRelatedByAliasof->save($con);
                }
                $this->setMediaRelatedByAliasof($this->aMediaRelatedByAliasof);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->mediaMarketsScheduledForDeletion !== null) {
                if (!$this->mediaMarketsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->mediaMarketsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    MediaMarketRelationQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->mediaMarketsScheduledForDeletion = null;
                }

                foreach ($this->getMediaMarkets() as $mediaMarket) {
                    if ($mediaMarket->isModified()) {
                        $mediaMarket->save($con);
                    }
                }
            }

            if ($this->mediaAudiencesScheduledForDeletion !== null) {
                if (!$this->mediaAudiencesScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->mediaAudiencesScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    MediaAudienceRelationQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->mediaAudiencesScheduledForDeletion = null;
                }

                foreach ($this->getMediaAudiences() as $mediaAudience) {
                    if ($mediaAudience->isModified()) {
                        $mediaAudience->save($con);
                    }
                }
            }

            if ($this->headlinesScheduledForDeletion !== null) {
                if (!$this->headlinesScheduledForDeletion->isEmpty()) {
                    foreach ($this->headlinesScheduledForDeletion as $headline) {
                        // need to save related object because we set the relation to null
                        $headline->save($con);
                    }
                    $this->headlinesScheduledForDeletion = null;
                }
            }

            if ($this->collHeadlines !== null) {
                foreach ($this->collHeadlines as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->mediasRelatedById0ScheduledForDeletion !== null) {
                if (!$this->mediasRelatedById0ScheduledForDeletion->isEmpty()) {
                    foreach ($this->mediasRelatedById0ScheduledForDeletion as $mediaRelatedById0) {
                        // need to save related object because we set the relation to null
                        $mediaRelatedById0->save($con);
                    }
                    $this->mediasRelatedById0ScheduledForDeletion = null;
                }
            }

            if ($this->collMediasRelatedById0 !== null) {
                foreach ($this->collMediasRelatedById0 as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->mediasRelatedById1ScheduledForDeletion !== null) {
                if (!$this->mediasRelatedById1ScheduledForDeletion->isEmpty()) {
                    foreach ($this->mediasRelatedById1ScheduledForDeletion as $mediaRelatedById1) {
                        // need to save related object because we set the relation to null
                        $mediaRelatedById1->save($con);
                    }
                    $this->mediasRelatedById1ScheduledForDeletion = null;
                }
            }

            if ($this->collMediasRelatedById1 !== null) {
                foreach ($this->collMediasRelatedById1 as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->mediaMarketRelationsScheduledForDeletion !== null) {
                if (!$this->mediaMarketRelationsScheduledForDeletion->isEmpty()) {
                    MediaMarketRelationQuery::create()
                        ->filterByPrimaryKeys($this->mediaMarketRelationsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->mediaMarketRelationsScheduledForDeletion = null;
                }
            }

            if ($this->collMediaMarketRelations !== null) {
                foreach ($this->collMediaMarketRelations as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->mediaAudienceRelationsScheduledForDeletion !== null) {
                if (!$this->mediaAudienceRelationsScheduledForDeletion->isEmpty()) {
                    MediaAudienceRelationQuery::create()
                        ->filterByPrimaryKeys($this->mediaAudienceRelationsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->mediaAudienceRelationsScheduledForDeletion = null;
                }
            }

            if ($this->collMediaAudienceRelations !== null) {
                foreach ($this->collMediaAudienceRelations as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = MediaPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . MediaPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(MediaPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(MediaPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(MediaPeer::ADDRESS)) {
            $modifiedColumns[':p' . $index++]  = '`ADDRESS`';
        }
        if ($this->isColumnModified(MediaPeer::PHONE)) {
            $modifiedColumns[':p' . $index++]  = '`PHONE`';
        }
        if ($this->isColumnModified(MediaPeer::URL)) {
            $modifiedColumns[':p' . $index++]  = '`URL`';
        }
        if ($this->isColumnModified(MediaPeer::MEDIAKITURL)) {
            $modifiedColumns[':p' . $index++]  = '`MEDIAKITURL`';
        }
        if ($this->isColumnModified(MediaPeer::FAX)) {
            $modifiedColumns[':p' . $index++]  = '`FAX`';
        }
        if ($this->isColumnModified(MediaPeer::EMAIL)) {
            $modifiedColumns[':p' . $index++]  = '`EMAIL`';
        }
        if ($this->isColumnModified(MediaPeer::RECEPTIONIST)) {
            $modifiedColumns[':p' . $index++]  = '`RECEPTIONIST`';
        }
        if ($this->isColumnModified(MediaPeer::DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`DESCRIPTION`';
        }
        if ($this->isColumnModified(MediaPeer::TYPEID)) {
            $modifiedColumns[':p' . $index++]  = '`TYPEID`';
        }
        if ($this->isColumnModified(MediaPeer::GROUPID)) {
            $modifiedColumns[':p' . $index++]  = '`GROUPID`';
        }
        if ($this->isColumnModified(MediaPeer::IMPORTANCE)) {
            $modifiedColumns[':p' . $index++]  = '`IMPORTANCE`';
        }
        if ($this->isColumnModified(MediaPeer::BIAS)) {
            $modifiedColumns[':p' . $index++]  = '`BIAS`';
        }
        if ($this->isColumnModified(MediaPeer::ALIASOF)) {
            $modifiedColumns[':p' . $index++]  = '`ALIASOF`';
        }
        if ($this->isColumnModified(MediaPeer::CREATED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`CREATED_AT`';
        }
        if ($this->isColumnModified(MediaPeer::UPDATED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`UPDATED_AT`';
        }

        $sql = sprintf(
            'INSERT INTO `medias_media` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`ADDRESS`':
                        $stmt->bindValue($identifier, $this->address, PDO::PARAM_STR);
                        break;
                    case '`PHONE`':
                        $stmt->bindValue($identifier, $this->phone, PDO::PARAM_STR);
                        break;
                    case '`URL`':
                        $stmt->bindValue($identifier, $this->url, PDO::PARAM_STR);
                        break;
                    case '`MEDIAKITURL`':
                        $stmt->bindValue($identifier, $this->mediakiturl, PDO::PARAM_STR);
                        break;
                    case '`FAX`':
                        $stmt->bindValue($identifier, $this->fax, PDO::PARAM_STR);
                        break;
                    case '`EMAIL`':
                        $stmt->bindValue($identifier, $this->email, PDO::PARAM_STR);
                        break;
                    case '`RECEPTIONIST`':
                        $stmt->bindValue($identifier, $this->receptionist, PDO::PARAM_STR);
                        break;
                    case '`DESCRIPTION`':
                        $stmt->bindValue($identifier, $this->description, PDO::PARAM_STR);
                        break;
                    case '`TYPEID`':
                        $stmt->bindValue($identifier, $this->typeid, PDO::PARAM_INT);
                        break;
                    case '`GROUPID`':
                        $stmt->bindValue($identifier, $this->groupid, PDO::PARAM_INT);
                        break;
                    case '`IMPORTANCE`':
                        $stmt->bindValue($identifier, $this->importance, PDO::PARAM_INT);
                        break;
                    case '`BIAS`':
                        $stmt->bindValue($identifier, $this->bias, PDO::PARAM_INT);
                        break;
                    case '`ALIASOF`':
                        $stmt->bindValue($identifier, $this->aliasof, PDO::PARAM_INT);
                        break;
                    case '`CREATED_AT`':
                        $stmt->bindValue($identifier, $this->created_at, PDO::PARAM_STR);
                        break;
                    case '`UPDATED_AT`':
                        $stmt->bindValue($identifier, $this->updated_at, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aMediaType !== null) {
                if (!$this->aMediaType->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aMediaType->getValidationFailures());
                }
            }

            if ($this->aMediaRelatedByGroupid !== null) {
                if (!$this->aMediaRelatedByGroupid->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aMediaRelatedByGroupid->getValidationFailures());
                }
            }

            if ($this->aMediaRelatedByAliasof !== null) {
                if (!$this->aMediaRelatedByAliasof->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aMediaRelatedByAliasof->getValidationFailures());
                }
            }


            if (($retval = MediaPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collHeadlines !== null) {
                    foreach ($this->collHeadlines as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collMediasRelatedById0 !== null) {
                    foreach ($this->collMediasRelatedById0 as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collMediasRelatedById1 !== null) {
                    foreach ($this->collMediasRelatedById1 as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collMediaMarketRelations !== null) {
                    foreach ($this->collMediaMarketRelations as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collMediaAudienceRelations !== null) {
                    foreach ($this->collMediaAudienceRelations as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = MediaPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getName();
                break;
            case 2:
                return $this->getAddress();
                break;
            case 3:
                return $this->getPhone();
                break;
            case 4:
                return $this->getUrl();
                break;
            case 5:
                return $this->getMediakiturl();
                break;
            case 6:
                return $this->getFax();
                break;
            case 7:
                return $this->getEmail();
                break;
            case 8:
                return $this->getReceptionist();
                break;
            case 9:
                return $this->getDescription();
                break;
            case 10:
                return $this->getTypeid();
                break;
            case 11:
                return $this->getGroupid();
                break;
            case 12:
                return $this->getImportance();
                break;
            case 13:
                return $this->getBias();
                break;
            case 14:
                return $this->getAliasof();
                break;
            case 15:
                return $this->getCreatedAt();
                break;
            case 16:
                return $this->getUpdatedAt();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['Media'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Media'][$this->getPrimaryKey()] = true;
        $keys = MediaPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getAddress(),
            $keys[3] => $this->getPhone(),
            $keys[4] => $this->getUrl(),
            $keys[5] => $this->getMediakiturl(),
            $keys[6] => $this->getFax(),
            $keys[7] => $this->getEmail(),
            $keys[8] => $this->getReceptionist(),
            $keys[9] => $this->getDescription(),
            $keys[10] => $this->getTypeid(),
            $keys[11] => $this->getGroupid(),
            $keys[12] => $this->getImportance(),
            $keys[13] => $this->getBias(),
            $keys[14] => $this->getAliasof(),
            $keys[15] => $this->getCreatedAt(),
            $keys[16] => $this->getUpdatedAt(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aMediaType) {
                $result['MediaType'] = $this->aMediaType->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aMediaRelatedByGroupid) {
                $result['MediaRelatedByGroupid'] = $this->aMediaRelatedByGroupid->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aMediaRelatedByAliasof) {
                $result['MediaRelatedByAliasof'] = $this->aMediaRelatedByAliasof->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collHeadlines) {
                $result['Headlines'] = $this->collHeadlines->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collMediasRelatedById0) {
                $result['MediasRelatedById0'] = $this->collMediasRelatedById0->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collMediasRelatedById1) {
                $result['MediasRelatedById1'] = $this->collMediasRelatedById1->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collMediaMarketRelations) {
                $result['MediaMarketRelations'] = $this->collMediaMarketRelations->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collMediaAudienceRelations) {
                $result['MediaAudienceRelations'] = $this->collMediaAudienceRelations->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = MediaPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setAddress($value);
                break;
            case 3:
                $this->setPhone($value);
                break;
            case 4:
                $this->setUrl($value);
                break;
            case 5:
                $this->setMediakiturl($value);
                break;
            case 6:
                $this->setFax($value);
                break;
            case 7:
                $this->setEmail($value);
                break;
            case 8:
                $this->setReceptionist($value);
                break;
            case 9:
                $this->setDescription($value);
                break;
            case 10:
                $this->setTypeid($value);
                break;
            case 11:
                $this->setGroupid($value);
                break;
            case 12:
                $this->setImportance($value);
                break;
            case 13:
                $this->setBias($value);
                break;
            case 14:
                $this->setAliasof($value);
                break;
            case 15:
                $this->setCreatedAt($value);
                break;
            case 16:
                $this->setUpdatedAt($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = MediaPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setName($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setAddress($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setPhone($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setUrl($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setMediakiturl($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setFax($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setEmail($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setReceptionist($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setDescription($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setTypeid($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setGroupid($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setImportance($arr[$keys[12]]);
        if (array_key_exists($keys[13], $arr)) $this->setBias($arr[$keys[13]]);
        if (array_key_exists($keys[14], $arr)) $this->setAliasof($arr[$keys[14]]);
        if (array_key_exists($keys[15], $arr)) $this->setCreatedAt($arr[$keys[15]]);
        if (array_key_exists($keys[16], $arr)) $this->setUpdatedAt($arr[$keys[16]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(MediaPeer::DATABASE_NAME);

        if ($this->isColumnModified(MediaPeer::ID)) $criteria->add(MediaPeer::ID, $this->id);
        if ($this->isColumnModified(MediaPeer::NAME)) $criteria->add(MediaPeer::NAME, $this->name);
        if ($this->isColumnModified(MediaPeer::ADDRESS)) $criteria->add(MediaPeer::ADDRESS, $this->address);
        if ($this->isColumnModified(MediaPeer::PHONE)) $criteria->add(MediaPeer::PHONE, $this->phone);
        if ($this->isColumnModified(MediaPeer::URL)) $criteria->add(MediaPeer::URL, $this->url);
        if ($this->isColumnModified(MediaPeer::MEDIAKITURL)) $criteria->add(MediaPeer::MEDIAKITURL, $this->mediakiturl);
        if ($this->isColumnModified(MediaPeer::FAX)) $criteria->add(MediaPeer::FAX, $this->fax);
        if ($this->isColumnModified(MediaPeer::EMAIL)) $criteria->add(MediaPeer::EMAIL, $this->email);
        if ($this->isColumnModified(MediaPeer::RECEPTIONIST)) $criteria->add(MediaPeer::RECEPTIONIST, $this->receptionist);
        if ($this->isColumnModified(MediaPeer::DESCRIPTION)) $criteria->add(MediaPeer::DESCRIPTION, $this->description);
        if ($this->isColumnModified(MediaPeer::TYPEID)) $criteria->add(MediaPeer::TYPEID, $this->typeid);
        if ($this->isColumnModified(MediaPeer::GROUPID)) $criteria->add(MediaPeer::GROUPID, $this->groupid);
        if ($this->isColumnModified(MediaPeer::IMPORTANCE)) $criteria->add(MediaPeer::IMPORTANCE, $this->importance);
        if ($this->isColumnModified(MediaPeer::BIAS)) $criteria->add(MediaPeer::BIAS, $this->bias);
        if ($this->isColumnModified(MediaPeer::ALIASOF)) $criteria->add(MediaPeer::ALIASOF, $this->aliasof);
        if ($this->isColumnModified(MediaPeer::CREATED_AT)) $criteria->add(MediaPeer::CREATED_AT, $this->created_at);
        if ($this->isColumnModified(MediaPeer::UPDATED_AT)) $criteria->add(MediaPeer::UPDATED_AT, $this->updated_at);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(MediaPeer::DATABASE_NAME);
        $criteria->add(MediaPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Media (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setName($this->getName());
        $copyObj->setAddress($this->getAddress());
        $copyObj->setPhone($this->getPhone());
        $copyObj->setUrl($this->getUrl());
        $copyObj->setMediakiturl($this->getMediakiturl());
        $copyObj->setFax($this->getFax());
        $copyObj->setEmail($this->getEmail());
        $copyObj->setReceptionist($this->getReceptionist());
        $copyObj->setDescription($this->getDescription());
        $copyObj->setTypeid($this->getTypeid());
        $copyObj->setGroupid($this->getGroupid());
        $copyObj->setImportance($this->getImportance());
        $copyObj->setBias($this->getBias());
        $copyObj->setAliasof($this->getAliasof());
        $copyObj->setCreatedAt($this->getCreatedAt());
        $copyObj->setUpdatedAt($this->getUpdatedAt());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getHeadlines() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addHeadline($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getMediasRelatedById0() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addMediaRelatedById0($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getMediasRelatedById1() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addMediaRelatedById1($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getMediaMarketRelations() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addMediaMarketRelation($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getMediaAudienceRelations() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addMediaAudienceRelation($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Media Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return MediaPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new MediaPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a MediaType object.
     *
     * @param             MediaType $v
     * @return Media The current object (for fluent API support)
     * @throws PropelException
     */
    public function setMediaType(MediaType $v = null)
    {
        if ($v === null) {
            $this->setTypeid(NULL);
        } else {
            $this->setTypeid($v->getId());
        }

        $this->aMediaType = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the MediaType object, it will not be re-added.
        if ($v !== null) {
            $v->addMedia($this);
        }


        return $this;
    }


    /**
     * Get the associated MediaType object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return MediaType The associated MediaType object.
     * @throws PropelException
     */
    public function getMediaType(PropelPDO $con = null)
    {
        if ($this->aMediaType === null && ($this->typeid !== null)) {
            $this->aMediaType = MediaTypeQuery::create()->findPk($this->typeid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aMediaType->addMedias($this);
             */
        }

        return $this->aMediaType;
    }

    /**
     * Declares an association between this object and a Media object.
     *
     * @param             Media $v
     * @return Media The current object (for fluent API support)
     * @throws PropelException
     */
    public function setMediaRelatedByGroupid(Media $v = null)
    {
        if ($v === null) {
            $this->setGroupid(NULL);
        } else {
            $this->setGroupid($v->getId());
        }

        $this->aMediaRelatedByGroupid = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Media object, it will not be re-added.
        if ($v !== null) {
            $v->addMediaRelatedById0($this);
        }


        return $this;
    }


    /**
     * Get the associated Media object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Media The associated Media object.
     * @throws PropelException
     */
    public function getMediaRelatedByGroupid(PropelPDO $con = null)
    {
        if ($this->aMediaRelatedByGroupid === null && ($this->groupid !== null)) {
            $this->aMediaRelatedByGroupid = MediaQuery::create()->findPk($this->groupid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aMediaRelatedByGroupid->addMediasRelatedById0($this);
             */
        }

        return $this->aMediaRelatedByGroupid;
    }

    /**
     * Declares an association between this object and a Media object.
     *
     * @param             Media $v
     * @return Media The current object (for fluent API support)
     * @throws PropelException
     */
    public function setMediaRelatedByAliasof(Media $v = null)
    {
        if ($v === null) {
            $this->setAliasof(NULL);
        } else {
            $this->setAliasof($v->getId());
        }

        $this->aMediaRelatedByAliasof = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Media object, it will not be re-added.
        if ($v !== null) {
            $v->addMediaRelatedById1($this);
        }


        return $this;
    }


    /**
     * Get the associated Media object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Media The associated Media object.
     * @throws PropelException
     */
    public function getMediaRelatedByAliasof(PropelPDO $con = null)
    {
        if ($this->aMediaRelatedByAliasof === null && ($this->aliasof !== null)) {
            $this->aMediaRelatedByAliasof = MediaQuery::create()->findPk($this->aliasof, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aMediaRelatedByAliasof->addMediasRelatedById1($this);
             */
        }

        return $this->aMediaRelatedByAliasof;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('Headline' == $relationName) {
            $this->initHeadlines();
        }
        if ('MediaRelatedById0' == $relationName) {
            $this->initMediasRelatedById0();
        }
        if ('MediaRelatedById1' == $relationName) {
            $this->initMediasRelatedById1();
        }
        if ('MediaMarketRelation' == $relationName) {
            $this->initMediaMarketRelations();
        }
        if ('MediaAudienceRelation' == $relationName) {
            $this->initMediaAudienceRelations();
        }
    }

    /**
     * Clears out the collHeadlines collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addHeadlines()
     */
    public function clearHeadlines()
    {
        $this->collHeadlines = null; // important to set this to null since that means it is uninitialized
        $this->collHeadlinesPartial = null;
    }

    /**
     * reset is the collHeadlines collection loaded partially
     *
     * @return void
     */
    public function resetPartialHeadlines($v = true)
    {
        $this->collHeadlinesPartial = $v;
    }

    /**
     * Initializes the collHeadlines collection.
     *
     * By default this just sets the collHeadlines collection to an empty array (like clearcollHeadlines());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initHeadlines($overrideExisting = true)
    {
        if (null !== $this->collHeadlines && !$overrideExisting) {
            return;
        }
        $this->collHeadlines = new PropelObjectCollection();
        $this->collHeadlines->setModel('Headline');
    }

    /**
     * Gets an array of Headline objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Media is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Headline[] List of Headline objects
     * @throws PropelException
     */
    public function getHeadlines($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collHeadlinesPartial && !$this->isNew();
        if (null === $this->collHeadlines || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collHeadlines) {
                // return empty collection
                $this->initHeadlines();
            } else {
                $collHeadlines = HeadlineQuery::create(null, $criteria)
                    ->filterByMedia($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collHeadlinesPartial && count($collHeadlines)) {
                      $this->initHeadlines(false);

                      foreach($collHeadlines as $obj) {
                        if (false == $this->collHeadlines->contains($obj)) {
                          $this->collHeadlines->append($obj);
                        }
                      }

                      $this->collHeadlinesPartial = true;
                    }

                    return $collHeadlines;
                }

                if($partial && $this->collHeadlines) {
                    foreach($this->collHeadlines as $obj) {
                        if($obj->isNew()) {
                            $collHeadlines[] = $obj;
                        }
                    }
                }

                $this->collHeadlines = $collHeadlines;
                $this->collHeadlinesPartial = false;
            }
        }

        return $this->collHeadlines;
    }

    /**
     * Sets a collection of Headline objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $headlines A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setHeadlines(PropelCollection $headlines, PropelPDO $con = null)
    {
        $this->headlinesScheduledForDeletion = $this->getHeadlines(new Criteria(), $con)->diff($headlines);

        foreach ($this->headlinesScheduledForDeletion as $headlineRemoved) {
            $headlineRemoved->setMedia(null);
        }

        $this->collHeadlines = null;
        foreach ($headlines as $headline) {
            $this->addHeadline($headline);
        }

        $this->collHeadlines = $headlines;
        $this->collHeadlinesPartial = false;
    }

    /**
     * Returns the number of related Headline objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Headline objects.
     * @throws PropelException
     */
    public function countHeadlines(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collHeadlinesPartial && !$this->isNew();
        if (null === $this->collHeadlines || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collHeadlines) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getHeadlines());
                }
                $query = HeadlineQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByMedia($this)
                    ->count($con);
            }
        } else {
            return count($this->collHeadlines);
        }
    }

    /**
     * Method called to associate a BaseHeadline object to this object
     * through the BaseHeadline foreign key attribute.
     *
     * @param    BaseHeadline $l BaseHeadline
     * @return Media The current object (for fluent API support)
     */
    public function addHeadline(BaseHeadline $l)
    {
        if ($this->collHeadlines === null) {
            $this->initHeadlines();
            $this->collHeadlinesPartial = true;
        }
        if (!$this->collHeadlines->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddHeadline($l);
        }

        return $this;
    }

    /**
     * @param	Headline $headline The headline object to add.
     */
    protected function doAddHeadline($headline)
    {
        $this->collHeadlines[]= $headline;
        $headline->setMedia($this);
    }

    /**
     * @param	Headline $headline The headline object to remove.
     */
    public function removeHeadline($headline)
    {
        if ($this->getHeadlines()->contains($headline)) {
            $this->collHeadlines->remove($this->collHeadlines->search($headline));
            if (null === $this->headlinesScheduledForDeletion) {
                $this->headlinesScheduledForDeletion = clone $this->collHeadlines;
                $this->headlinesScheduledForDeletion->clear();
            }
            $this->headlinesScheduledForDeletion[]= $headline;
            $headline->setMedia(null);
        }
    }

    /**
     * Clears out the collMediasRelatedById0 collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addMediasRelatedById0()
     */
    public function clearMediasRelatedById0()
    {
        $this->collMediasRelatedById0 = null; // important to set this to null since that means it is uninitialized
        $this->collMediasRelatedById0Partial = null;
    }

    /**
     * reset is the collMediasRelatedById0 collection loaded partially
     *
     * @return void
     */
    public function resetPartialMediasRelatedById0($v = true)
    {
        $this->collMediasRelatedById0Partial = $v;
    }

    /**
     * Initializes the collMediasRelatedById0 collection.
     *
     * By default this just sets the collMediasRelatedById0 collection to an empty array (like clearcollMediasRelatedById0());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initMediasRelatedById0($overrideExisting = true)
    {
        if (null !== $this->collMediasRelatedById0 && !$overrideExisting) {
            return;
        }
        $this->collMediasRelatedById0 = new PropelObjectCollection();
        $this->collMediasRelatedById0->setModel('Media');
    }

    /**
     * Gets an array of Media objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Media is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Media[] List of Media objects
     * @throws PropelException
     */
    public function getMediasRelatedById0($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collMediasRelatedById0Partial && !$this->isNew();
        if (null === $this->collMediasRelatedById0 || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collMediasRelatedById0) {
                // return empty collection
                $this->initMediasRelatedById0();
            } else {
                $collMediasRelatedById0 = MediaQuery::create(null, $criteria)
                    ->filterByMediaRelatedByGroupid($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collMediasRelatedById0Partial && count($collMediasRelatedById0)) {
                      $this->initMediasRelatedById0(false);

                      foreach($collMediasRelatedById0 as $obj) {
                        if (false == $this->collMediasRelatedById0->contains($obj)) {
                          $this->collMediasRelatedById0->append($obj);
                        }
                      }

                      $this->collMediasRelatedById0Partial = true;
                    }

                    return $collMediasRelatedById0;
                }

                if($partial && $this->collMediasRelatedById0) {
                    foreach($this->collMediasRelatedById0 as $obj) {
                        if($obj->isNew()) {
                            $collMediasRelatedById0[] = $obj;
                        }
                    }
                }

                $this->collMediasRelatedById0 = $collMediasRelatedById0;
                $this->collMediasRelatedById0Partial = false;
            }
        }

        return $this->collMediasRelatedById0;
    }

    /**
     * Sets a collection of MediaRelatedById0 objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $mediasRelatedById0 A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setMediasRelatedById0(PropelCollection $mediasRelatedById0, PropelPDO $con = null)
    {
        $this->mediasRelatedById0ScheduledForDeletion = $this->getMediasRelatedById0(new Criteria(), $con)->diff($mediasRelatedById0);

        foreach ($this->mediasRelatedById0ScheduledForDeletion as $mediaRelatedById0Removed) {
            $mediaRelatedById0Removed->setMediaRelatedByGroupid(null);
        }

        $this->collMediasRelatedById0 = null;
        foreach ($mediasRelatedById0 as $mediaRelatedById0) {
            $this->addMediaRelatedById0($mediaRelatedById0);
        }

        $this->collMediasRelatedById0 = $mediasRelatedById0;
        $this->collMediasRelatedById0Partial = false;
    }

    /**
     * Returns the number of related Media objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Media objects.
     * @throws PropelException
     */
    public function countMediasRelatedById0(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collMediasRelatedById0Partial && !$this->isNew();
        if (null === $this->collMediasRelatedById0 || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collMediasRelatedById0) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getMediasRelatedById0());
                }
                $query = MediaQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByMediaRelatedByGroupid($this)
                    ->count($con);
            }
        } else {
            return count($this->collMediasRelatedById0);
        }
    }

    /**
     * Method called to associate a Media object to this object
     * through the Media foreign key attribute.
     *
     * @param    Media $l Media
     * @return Media The current object (for fluent API support)
     */
    public function addMediaRelatedById0(Media $l)
    {
        if ($this->collMediasRelatedById0 === null) {
            $this->initMediasRelatedById0();
            $this->collMediasRelatedById0Partial = true;
        }
        if (!$this->collMediasRelatedById0->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddMediaRelatedById0($l);
        }

        return $this;
    }

    /**
     * @param	MediaRelatedById0 $mediaRelatedById0 The mediaRelatedById0 object to add.
     */
    protected function doAddMediaRelatedById0($mediaRelatedById0)
    {
        $this->collMediasRelatedById0[]= $mediaRelatedById0;
        $mediaRelatedById0->setMediaRelatedByGroupid($this);
    }

    /**
     * @param	MediaRelatedById0 $mediaRelatedById0 The mediaRelatedById0 object to remove.
     */
    public function removeMediaRelatedById0($mediaRelatedById0)
    {
        if ($this->getMediasRelatedById0()->contains($mediaRelatedById0)) {
            $this->collMediasRelatedById0->remove($this->collMediasRelatedById0->search($mediaRelatedById0));
            if (null === $this->mediasRelatedById0ScheduledForDeletion) {
                $this->mediasRelatedById0ScheduledForDeletion = clone $this->collMediasRelatedById0;
                $this->mediasRelatedById0ScheduledForDeletion->clear();
            }
            $this->mediasRelatedById0ScheduledForDeletion[]= $mediaRelatedById0;
            $mediaRelatedById0->setMediaRelatedByGroupid(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Media is new, it will return
     * an empty collection; or if this Media has previously
     * been saved, it will retrieve related MediasRelatedById0 from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Media.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Media[] List of Media objects
     */
    public function getMediasRelatedById0JoinMediaType($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = MediaQuery::create(null, $criteria);
        $query->joinWith('MediaType', $join_behavior);

        return $this->getMediasRelatedById0($query, $con);
    }

    /**
     * Clears out the collMediasRelatedById1 collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addMediasRelatedById1()
     */
    public function clearMediasRelatedById1()
    {
        $this->collMediasRelatedById1 = null; // important to set this to null since that means it is uninitialized
        $this->collMediasRelatedById1Partial = null;
    }

    /**
     * reset is the collMediasRelatedById1 collection loaded partially
     *
     * @return void
     */
    public function resetPartialMediasRelatedById1($v = true)
    {
        $this->collMediasRelatedById1Partial = $v;
    }

    /**
     * Initializes the collMediasRelatedById1 collection.
     *
     * By default this just sets the collMediasRelatedById1 collection to an empty array (like clearcollMediasRelatedById1());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initMediasRelatedById1($overrideExisting = true)
    {
        if (null !== $this->collMediasRelatedById1 && !$overrideExisting) {
            return;
        }
        $this->collMediasRelatedById1 = new PropelObjectCollection();
        $this->collMediasRelatedById1->setModel('Media');
    }

    /**
     * Gets an array of Media objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Media is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Media[] List of Media objects
     * @throws PropelException
     */
    public function getMediasRelatedById1($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collMediasRelatedById1Partial && !$this->isNew();
        if (null === $this->collMediasRelatedById1 || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collMediasRelatedById1) {
                // return empty collection
                $this->initMediasRelatedById1();
            } else {
                $collMediasRelatedById1 = MediaQuery::create(null, $criteria)
                    ->filterByMediaRelatedByAliasof($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collMediasRelatedById1Partial && count($collMediasRelatedById1)) {
                      $this->initMediasRelatedById1(false);

                      foreach($collMediasRelatedById1 as $obj) {
                        if (false == $this->collMediasRelatedById1->contains($obj)) {
                          $this->collMediasRelatedById1->append($obj);
                        }
                      }

                      $this->collMediasRelatedById1Partial = true;
                    }

                    return $collMediasRelatedById1;
                }

                if($partial && $this->collMediasRelatedById1) {
                    foreach($this->collMediasRelatedById1 as $obj) {
                        if($obj->isNew()) {
                            $collMediasRelatedById1[] = $obj;
                        }
                    }
                }

                $this->collMediasRelatedById1 = $collMediasRelatedById1;
                $this->collMediasRelatedById1Partial = false;
            }
        }

        return $this->collMediasRelatedById1;
    }

    /**
     * Sets a collection of MediaRelatedById1 objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $mediasRelatedById1 A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setMediasRelatedById1(PropelCollection $mediasRelatedById1, PropelPDO $con = null)
    {
        $this->mediasRelatedById1ScheduledForDeletion = $this->getMediasRelatedById1(new Criteria(), $con)->diff($mediasRelatedById1);

        foreach ($this->mediasRelatedById1ScheduledForDeletion as $mediaRelatedById1Removed) {
            $mediaRelatedById1Removed->setMediaRelatedByAliasof(null);
        }

        $this->collMediasRelatedById1 = null;
        foreach ($mediasRelatedById1 as $mediaRelatedById1) {
            $this->addMediaRelatedById1($mediaRelatedById1);
        }

        $this->collMediasRelatedById1 = $mediasRelatedById1;
        $this->collMediasRelatedById1Partial = false;
    }

    /**
     * Returns the number of related Media objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Media objects.
     * @throws PropelException
     */
    public function countMediasRelatedById1(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collMediasRelatedById1Partial && !$this->isNew();
        if (null === $this->collMediasRelatedById1 || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collMediasRelatedById1) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getMediasRelatedById1());
                }
                $query = MediaQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByMediaRelatedByAliasof($this)
                    ->count($con);
            }
        } else {
            return count($this->collMediasRelatedById1);
        }
    }

    /**
     * Method called to associate a Media object to this object
     * through the Media foreign key attribute.
     *
     * @param    Media $l Media
     * @return Media The current object (for fluent API support)
     */
    public function addMediaRelatedById1(Media $l)
    {
        if ($this->collMediasRelatedById1 === null) {
            $this->initMediasRelatedById1();
            $this->collMediasRelatedById1Partial = true;
        }
        if (!$this->collMediasRelatedById1->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddMediaRelatedById1($l);
        }

        return $this;
    }

    /**
     * @param	MediaRelatedById1 $mediaRelatedById1 The mediaRelatedById1 object to add.
     */
    protected function doAddMediaRelatedById1($mediaRelatedById1)
    {
        $this->collMediasRelatedById1[]= $mediaRelatedById1;
        $mediaRelatedById1->setMediaRelatedByAliasof($this);
    }

    /**
     * @param	MediaRelatedById1 $mediaRelatedById1 The mediaRelatedById1 object to remove.
     */
    public function removeMediaRelatedById1($mediaRelatedById1)
    {
        if ($this->getMediasRelatedById1()->contains($mediaRelatedById1)) {
            $this->collMediasRelatedById1->remove($this->collMediasRelatedById1->search($mediaRelatedById1));
            if (null === $this->mediasRelatedById1ScheduledForDeletion) {
                $this->mediasRelatedById1ScheduledForDeletion = clone $this->collMediasRelatedById1;
                $this->mediasRelatedById1ScheduledForDeletion->clear();
            }
            $this->mediasRelatedById1ScheduledForDeletion[]= $mediaRelatedById1;
            $mediaRelatedById1->setMediaRelatedByAliasof(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Media is new, it will return
     * an empty collection; or if this Media has previously
     * been saved, it will retrieve related MediasRelatedById1 from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Media.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Media[] List of Media objects
     */
    public function getMediasRelatedById1JoinMediaType($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = MediaQuery::create(null, $criteria);
        $query->joinWith('MediaType', $join_behavior);

        return $this->getMediasRelatedById1($query, $con);
    }

    /**
     * Clears out the collMediaMarketRelations collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addMediaMarketRelations()
     */
    public function clearMediaMarketRelations()
    {
        $this->collMediaMarketRelations = null; // important to set this to null since that means it is uninitialized
        $this->collMediaMarketRelationsPartial = null;
    }

    /**
     * reset is the collMediaMarketRelations collection loaded partially
     *
     * @return void
     */
    public function resetPartialMediaMarketRelations($v = true)
    {
        $this->collMediaMarketRelationsPartial = $v;
    }

    /**
     * Initializes the collMediaMarketRelations collection.
     *
     * By default this just sets the collMediaMarketRelations collection to an empty array (like clearcollMediaMarketRelations());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initMediaMarketRelations($overrideExisting = true)
    {
        if (null !== $this->collMediaMarketRelations && !$overrideExisting) {
            return;
        }
        $this->collMediaMarketRelations = new PropelObjectCollection();
        $this->collMediaMarketRelations->setModel('MediaMarketRelation');
    }

    /**
     * Gets an array of MediaMarketRelation objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Media is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|MediaMarketRelation[] List of MediaMarketRelation objects
     * @throws PropelException
     */
    public function getMediaMarketRelations($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collMediaMarketRelationsPartial && !$this->isNew();
        if (null === $this->collMediaMarketRelations || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collMediaMarketRelations) {
                // return empty collection
                $this->initMediaMarketRelations();
            } else {
                $collMediaMarketRelations = MediaMarketRelationQuery::create(null, $criteria)
                    ->filterByMedia($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collMediaMarketRelationsPartial && count($collMediaMarketRelations)) {
                      $this->initMediaMarketRelations(false);

                      foreach($collMediaMarketRelations as $obj) {
                        if (false == $this->collMediaMarketRelations->contains($obj)) {
                          $this->collMediaMarketRelations->append($obj);
                        }
                      }

                      $this->collMediaMarketRelationsPartial = true;
                    }

                    return $collMediaMarketRelations;
                }

                if($partial && $this->collMediaMarketRelations) {
                    foreach($this->collMediaMarketRelations as $obj) {
                        if($obj->isNew()) {
                            $collMediaMarketRelations[] = $obj;
                        }
                    }
                }

                $this->collMediaMarketRelations = $collMediaMarketRelations;
                $this->collMediaMarketRelationsPartial = false;
            }
        }

        return $this->collMediaMarketRelations;
    }

    /**
     * Sets a collection of MediaMarketRelation objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $mediaMarketRelations A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setMediaMarketRelations(PropelCollection $mediaMarketRelations, PropelPDO $con = null)
    {
        $this->mediaMarketRelationsScheduledForDeletion = $this->getMediaMarketRelations(new Criteria(), $con)->diff($mediaMarketRelations);

        foreach ($this->mediaMarketRelationsScheduledForDeletion as $mediaMarketRelationRemoved) {
            $mediaMarketRelationRemoved->setMedia(null);
        }

        $this->collMediaMarketRelations = null;
        foreach ($mediaMarketRelations as $mediaMarketRelation) {
            $this->addMediaMarketRelation($mediaMarketRelation);
        }

        $this->collMediaMarketRelations = $mediaMarketRelations;
        $this->collMediaMarketRelationsPartial = false;
    }

    /**
     * Returns the number of related MediaMarketRelation objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related MediaMarketRelation objects.
     * @throws PropelException
     */
    public function countMediaMarketRelations(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collMediaMarketRelationsPartial && !$this->isNew();
        if (null === $this->collMediaMarketRelations || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collMediaMarketRelations) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getMediaMarketRelations());
                }
                $query = MediaMarketRelationQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByMedia($this)
                    ->count($con);
            }
        } else {
            return count($this->collMediaMarketRelations);
        }
    }

    /**
     * Method called to associate a MediaMarketRelation object to this object
     * through the MediaMarketRelation foreign key attribute.
     *
     * @param    MediaMarketRelation $l MediaMarketRelation
     * @return Media The current object (for fluent API support)
     */
    public function addMediaMarketRelation(MediaMarketRelation $l)
    {
        if ($this->collMediaMarketRelations === null) {
            $this->initMediaMarketRelations();
            $this->collMediaMarketRelationsPartial = true;
        }
        if (!$this->collMediaMarketRelations->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddMediaMarketRelation($l);
        }

        return $this;
    }

    /**
     * @param	MediaMarketRelation $mediaMarketRelation The mediaMarketRelation object to add.
     */
    protected function doAddMediaMarketRelation($mediaMarketRelation)
    {
        $this->collMediaMarketRelations[]= $mediaMarketRelation;
        $mediaMarketRelation->setMedia($this);
    }

    /**
     * @param	MediaMarketRelation $mediaMarketRelation The mediaMarketRelation object to remove.
     */
    public function removeMediaMarketRelation($mediaMarketRelation)
    {
        if ($this->getMediaMarketRelations()->contains($mediaMarketRelation)) {
            $this->collMediaMarketRelations->remove($this->collMediaMarketRelations->search($mediaMarketRelation));
            if (null === $this->mediaMarketRelationsScheduledForDeletion) {
                $this->mediaMarketRelationsScheduledForDeletion = clone $this->collMediaMarketRelations;
                $this->mediaMarketRelationsScheduledForDeletion->clear();
            }
            $this->mediaMarketRelationsScheduledForDeletion[]= $mediaMarketRelation;
            $mediaMarketRelation->setMedia(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Media is new, it will return
     * an empty collection; or if this Media has previously
     * been saved, it will retrieve related MediaMarketRelations from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Media.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|MediaMarketRelation[] List of MediaMarketRelation objects
     */
    public function getMediaMarketRelationsJoinMediaMarket($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = MediaMarketRelationQuery::create(null, $criteria);
        $query->joinWith('MediaMarket', $join_behavior);

        return $this->getMediaMarketRelations($query, $con);
    }

    /**
     * Clears out the collMediaAudienceRelations collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addMediaAudienceRelations()
     */
    public function clearMediaAudienceRelations()
    {
        $this->collMediaAudienceRelations = null; // important to set this to null since that means it is uninitialized
        $this->collMediaAudienceRelationsPartial = null;
    }

    /**
     * reset is the collMediaAudienceRelations collection loaded partially
     *
     * @return void
     */
    public function resetPartialMediaAudienceRelations($v = true)
    {
        $this->collMediaAudienceRelationsPartial = $v;
    }

    /**
     * Initializes the collMediaAudienceRelations collection.
     *
     * By default this just sets the collMediaAudienceRelations collection to an empty array (like clearcollMediaAudienceRelations());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initMediaAudienceRelations($overrideExisting = true)
    {
        if (null !== $this->collMediaAudienceRelations && !$overrideExisting) {
            return;
        }
        $this->collMediaAudienceRelations = new PropelObjectCollection();
        $this->collMediaAudienceRelations->setModel('MediaAudienceRelation');
    }

    /**
     * Gets an array of MediaAudienceRelation objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Media is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|MediaAudienceRelation[] List of MediaAudienceRelation objects
     * @throws PropelException
     */
    public function getMediaAudienceRelations($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collMediaAudienceRelationsPartial && !$this->isNew();
        if (null === $this->collMediaAudienceRelations || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collMediaAudienceRelations) {
                // return empty collection
                $this->initMediaAudienceRelations();
            } else {
                $collMediaAudienceRelations = MediaAudienceRelationQuery::create(null, $criteria)
                    ->filterByMedia($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collMediaAudienceRelationsPartial && count($collMediaAudienceRelations)) {
                      $this->initMediaAudienceRelations(false);

                      foreach($collMediaAudienceRelations as $obj) {
                        if (false == $this->collMediaAudienceRelations->contains($obj)) {
                          $this->collMediaAudienceRelations->append($obj);
                        }
                      }

                      $this->collMediaAudienceRelationsPartial = true;
                    }

                    return $collMediaAudienceRelations;
                }

                if($partial && $this->collMediaAudienceRelations) {
                    foreach($this->collMediaAudienceRelations as $obj) {
                        if($obj->isNew()) {
                            $collMediaAudienceRelations[] = $obj;
                        }
                    }
                }

                $this->collMediaAudienceRelations = $collMediaAudienceRelations;
                $this->collMediaAudienceRelationsPartial = false;
            }
        }

        return $this->collMediaAudienceRelations;
    }

    /**
     * Sets a collection of MediaAudienceRelation objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $mediaAudienceRelations A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setMediaAudienceRelations(PropelCollection $mediaAudienceRelations, PropelPDO $con = null)
    {
        $this->mediaAudienceRelationsScheduledForDeletion = $this->getMediaAudienceRelations(new Criteria(), $con)->diff($mediaAudienceRelations);

        foreach ($this->mediaAudienceRelationsScheduledForDeletion as $mediaAudienceRelationRemoved) {
            $mediaAudienceRelationRemoved->setMedia(null);
        }

        $this->collMediaAudienceRelations = null;
        foreach ($mediaAudienceRelations as $mediaAudienceRelation) {
            $this->addMediaAudienceRelation($mediaAudienceRelation);
        }

        $this->collMediaAudienceRelations = $mediaAudienceRelations;
        $this->collMediaAudienceRelationsPartial = false;
    }

    /**
     * Returns the number of related MediaAudienceRelation objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related MediaAudienceRelation objects.
     * @throws PropelException
     */
    public function countMediaAudienceRelations(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collMediaAudienceRelationsPartial && !$this->isNew();
        if (null === $this->collMediaAudienceRelations || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collMediaAudienceRelations) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getMediaAudienceRelations());
                }
                $query = MediaAudienceRelationQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByMedia($this)
                    ->count($con);
            }
        } else {
            return count($this->collMediaAudienceRelations);
        }
    }

    /**
     * Method called to associate a MediaAudienceRelation object to this object
     * through the MediaAudienceRelation foreign key attribute.
     *
     * @param    MediaAudienceRelation $l MediaAudienceRelation
     * @return Media The current object (for fluent API support)
     */
    public function addMediaAudienceRelation(MediaAudienceRelation $l)
    {
        if ($this->collMediaAudienceRelations === null) {
            $this->initMediaAudienceRelations();
            $this->collMediaAudienceRelationsPartial = true;
        }
        if (!$this->collMediaAudienceRelations->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddMediaAudienceRelation($l);
        }

        return $this;
    }

    /**
     * @param	MediaAudienceRelation $mediaAudienceRelation The mediaAudienceRelation object to add.
     */
    protected function doAddMediaAudienceRelation($mediaAudienceRelation)
    {
        $this->collMediaAudienceRelations[]= $mediaAudienceRelation;
        $mediaAudienceRelation->setMedia($this);
    }

    /**
     * @param	MediaAudienceRelation $mediaAudienceRelation The mediaAudienceRelation object to remove.
     */
    public function removeMediaAudienceRelation($mediaAudienceRelation)
    {
        if ($this->getMediaAudienceRelations()->contains($mediaAudienceRelation)) {
            $this->collMediaAudienceRelations->remove($this->collMediaAudienceRelations->search($mediaAudienceRelation));
            if (null === $this->mediaAudienceRelationsScheduledForDeletion) {
                $this->mediaAudienceRelationsScheduledForDeletion = clone $this->collMediaAudienceRelations;
                $this->mediaAudienceRelationsScheduledForDeletion->clear();
            }
            $this->mediaAudienceRelationsScheduledForDeletion[]= $mediaAudienceRelation;
            $mediaAudienceRelation->setMedia(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Media is new, it will return
     * an empty collection; or if this Media has previously
     * been saved, it will retrieve related MediaAudienceRelations from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Media.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|MediaAudienceRelation[] List of MediaAudienceRelation objects
     */
    public function getMediaAudienceRelationsJoinMediaAudience($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = MediaAudienceRelationQuery::create(null, $criteria);
        $query->joinWith('MediaAudience', $join_behavior);

        return $this->getMediaAudienceRelations($query, $con);
    }

    /**
     * Clears out the collMediaMarkets collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addMediaMarkets()
     */
    public function clearMediaMarkets()
    {
        $this->collMediaMarkets = null; // important to set this to null since that means it is uninitialized
        $this->collMediaMarketsPartial = null;
    }

    /**
     * Initializes the collMediaMarkets collection.
     *
     * By default this just sets the collMediaMarkets collection to an empty collection (like clearMediaMarkets());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initMediaMarkets()
    {
        $this->collMediaMarkets = new PropelObjectCollection();
        $this->collMediaMarkets->setModel('MediaMarket');
    }

    /**
     * Gets a collection of MediaMarket objects related by a many-to-many relationship
     * to the current object by way of the medias_marketRelation cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Media is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|MediaMarket[] List of MediaMarket objects
     */
    public function getMediaMarkets($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collMediaMarkets || null !== $criteria) {
            if ($this->isNew() && null === $this->collMediaMarkets) {
                // return empty collection
                $this->initMediaMarkets();
            } else {
                $collMediaMarkets = MediaMarketQuery::create(null, $criteria)
                    ->filterByMedia($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collMediaMarkets;
                }
                $this->collMediaMarkets = $collMediaMarkets;
            }
        }

        return $this->collMediaMarkets;
    }

    /**
     * Sets a collection of MediaMarket objects related by a many-to-many relationship
     * to the current object by way of the medias_marketRelation cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $mediaMarkets A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setMediaMarkets(PropelCollection $mediaMarkets, PropelPDO $con = null)
    {
        $this->clearMediaMarkets();
        $currentMediaMarkets = $this->getMediaMarkets();

        $this->mediaMarketsScheduledForDeletion = $currentMediaMarkets->diff($mediaMarkets);

        foreach ($mediaMarkets as $mediaMarket) {
            if (!$currentMediaMarkets->contains($mediaMarket)) {
                $this->doAddMediaMarket($mediaMarket);
            }
        }

        $this->collMediaMarkets = $mediaMarkets;
    }

    /**
     * Gets the number of MediaMarket objects related by a many-to-many relationship
     * to the current object by way of the medias_marketRelation cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related MediaMarket objects
     */
    public function countMediaMarkets($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collMediaMarkets || null !== $criteria) {
            if ($this->isNew() && null === $this->collMediaMarkets) {
                return 0;
            } else {
                $query = MediaMarketQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByMedia($this)
                    ->count($con);
            }
        } else {
            return count($this->collMediaMarkets);
        }
    }

    /**
     * Associate a MediaMarket object to this object
     * through the medias_marketRelation cross reference table.
     *
     * @param  MediaMarket $mediaMarket The MediaMarketRelation object to relate
     * @return void
     */
    public function addMediaMarket(MediaMarket $mediaMarket)
    {
        if ($this->collMediaMarkets === null) {
            $this->initMediaMarkets();
        }
        if (!$this->collMediaMarkets->contains($mediaMarket)) { // only add it if the **same** object is not already associated
            $this->doAddMediaMarket($mediaMarket);

            $this->collMediaMarkets[]= $mediaMarket;
        }
    }

    /**
     * @param	MediaMarket $mediaMarket The mediaMarket object to add.
     */
    protected function doAddMediaMarket($mediaMarket)
    {
        $mediaMarketRelation = new MediaMarketRelation();
        $mediaMarketRelation->setMediaMarket($mediaMarket);
        $this->addMediaMarketRelation($mediaMarketRelation);
    }

    /**
     * Remove a MediaMarket object to this object
     * through the medias_marketRelation cross reference table.
     *
     * @param MediaMarket $mediaMarket The MediaMarketRelation object to relate
     * @return void
     */
    public function removeMediaMarket(MediaMarket $mediaMarket)
    {
        if ($this->getMediaMarkets()->contains($mediaMarket)) {
            $this->collMediaMarkets->remove($this->collMediaMarkets->search($mediaMarket));
            if (null === $this->mediaMarketsScheduledForDeletion) {
                $this->mediaMarketsScheduledForDeletion = clone $this->collMediaMarkets;
                $this->mediaMarketsScheduledForDeletion->clear();
            }
            $this->mediaMarketsScheduledForDeletion[]= $mediaMarket;
        }
    }

    /**
     * Clears out the collMediaAudiences collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addMediaAudiences()
     */
    public function clearMediaAudiences()
    {
        $this->collMediaAudiences = null; // important to set this to null since that means it is uninitialized
        $this->collMediaAudiencesPartial = null;
    }

    /**
     * Initializes the collMediaAudiences collection.
     *
     * By default this just sets the collMediaAudiences collection to an empty collection (like clearMediaAudiences());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initMediaAudiences()
    {
        $this->collMediaAudiences = new PropelObjectCollection();
        $this->collMediaAudiences->setModel('MediaAudience');
    }

    /**
     * Gets a collection of MediaAudience objects related by a many-to-many relationship
     * to the current object by way of the medias_audienceRelation cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Media is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|MediaAudience[] List of MediaAudience objects
     */
    public function getMediaAudiences($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collMediaAudiences || null !== $criteria) {
            if ($this->isNew() && null === $this->collMediaAudiences) {
                // return empty collection
                $this->initMediaAudiences();
            } else {
                $collMediaAudiences = MediaAudienceQuery::create(null, $criteria)
                    ->filterByMedia($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collMediaAudiences;
                }
                $this->collMediaAudiences = $collMediaAudiences;
            }
        }

        return $this->collMediaAudiences;
    }

    /**
     * Sets a collection of MediaAudience objects related by a many-to-many relationship
     * to the current object by way of the medias_audienceRelation cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $mediaAudiences A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setMediaAudiences(PropelCollection $mediaAudiences, PropelPDO $con = null)
    {
        $this->clearMediaAudiences();
        $currentMediaAudiences = $this->getMediaAudiences();

        $this->mediaAudiencesScheduledForDeletion = $currentMediaAudiences->diff($mediaAudiences);

        foreach ($mediaAudiences as $mediaAudience) {
            if (!$currentMediaAudiences->contains($mediaAudience)) {
                $this->doAddMediaAudience($mediaAudience);
            }
        }

        $this->collMediaAudiences = $mediaAudiences;
    }

    /**
     * Gets the number of MediaAudience objects related by a many-to-many relationship
     * to the current object by way of the medias_audienceRelation cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related MediaAudience objects
     */
    public function countMediaAudiences($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collMediaAudiences || null !== $criteria) {
            if ($this->isNew() && null === $this->collMediaAudiences) {
                return 0;
            } else {
                $query = MediaAudienceQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByMedia($this)
                    ->count($con);
            }
        } else {
            return count($this->collMediaAudiences);
        }
    }

    /**
     * Associate a MediaAudience object to this object
     * through the medias_audienceRelation cross reference table.
     *
     * @param  MediaAudience $mediaAudience The MediaAudienceRelation object to relate
     * @return void
     */
    public function addMediaAudience(MediaAudience $mediaAudience)
    {
        if ($this->collMediaAudiences === null) {
            $this->initMediaAudiences();
        }
        if (!$this->collMediaAudiences->contains($mediaAudience)) { // only add it if the **same** object is not already associated
            $this->doAddMediaAudience($mediaAudience);

            $this->collMediaAudiences[]= $mediaAudience;
        }
    }

    /**
     * @param	MediaAudience $mediaAudience The mediaAudience object to add.
     */
    protected function doAddMediaAudience($mediaAudience)
    {
        $mediaAudienceRelation = new MediaAudienceRelation();
        $mediaAudienceRelation->setMediaAudience($mediaAudience);
        $this->addMediaAudienceRelation($mediaAudienceRelation);
    }

    /**
     * Remove a MediaAudience object to this object
     * through the medias_audienceRelation cross reference table.
     *
     * @param MediaAudience $mediaAudience The MediaAudienceRelation object to relate
     * @return void
     */
    public function removeMediaAudience(MediaAudience $mediaAudience)
    {
        if ($this->getMediaAudiences()->contains($mediaAudience)) {
            $this->collMediaAudiences->remove($this->collMediaAudiences->search($mediaAudience));
            if (null === $this->mediaAudiencesScheduledForDeletion) {
                $this->mediaAudiencesScheduledForDeletion = clone $this->collMediaAudiences;
                $this->mediaAudiencesScheduledForDeletion->clear();
            }
            $this->mediaAudiencesScheduledForDeletion[]= $mediaAudience;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->address = null;
        $this->phone = null;
        $this->url = null;
        $this->mediakiturl = null;
        $this->fax = null;
        $this->email = null;
        $this->receptionist = null;
        $this->description = null;
        $this->typeid = null;
        $this->groupid = null;
        $this->importance = null;
        $this->bias = null;
        $this->aliasof = null;
        $this->created_at = null;
        $this->updated_at = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collHeadlines) {
                foreach ($this->collHeadlines as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collMediasRelatedById0) {
                foreach ($this->collMediasRelatedById0 as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collMediasRelatedById1) {
                foreach ($this->collMediasRelatedById1 as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collMediaMarketRelations) {
                foreach ($this->collMediaMarketRelations as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collMediaAudienceRelations) {
                foreach ($this->collMediaAudienceRelations as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collMediaMarkets) {
                foreach ($this->collMediaMarkets as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collMediaAudiences) {
                foreach ($this->collMediaAudiences as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collHeadlines instanceof PropelCollection) {
            $this->collHeadlines->clearIterator();
        }
        $this->collHeadlines = null;
        if ($this->collMediasRelatedById0 instanceof PropelCollection) {
            $this->collMediasRelatedById0->clearIterator();
        }
        $this->collMediasRelatedById0 = null;
        if ($this->collMediasRelatedById1 instanceof PropelCollection) {
            $this->collMediasRelatedById1->clearIterator();
        }
        $this->collMediasRelatedById1 = null;
        if ($this->collMediaMarketRelations instanceof PropelCollection) {
            $this->collMediaMarketRelations->clearIterator();
        }
        $this->collMediaMarketRelations = null;
        if ($this->collMediaAudienceRelations instanceof PropelCollection) {
            $this->collMediaAudienceRelations->clearIterator();
        }
        $this->collMediaAudienceRelations = null;
        if ($this->collMediaMarkets instanceof PropelCollection) {
            $this->collMediaMarkets->clearIterator();
        }
        $this->collMediaMarkets = null;
        if ($this->collMediaAudiences instanceof PropelCollection) {
            $this->collMediaAudiences->clearIterator();
        }
        $this->collMediaAudiences = null;
        $this->aMediaType = null;
        $this->aMediaRelatedByGroupid = null;
        $this->aMediaRelatedByAliasof = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // timestampable behavior

    /**
     * Mark the current object so that the update date doesn't get updated during next save
     *
     * @return     Media The current object (for fluent API support)
     */
    public function keepUpdateDateUnchanged()
    {
        $this->modifiedColumns[] = MediaPeer::UPDATED_AT;

        return $this;
    }

}
