<?php

/**
 * MediasAudienceDoEditXAction
 * Edita audiencias de medio extendiendo BaseDoEditAction
 *
 * @package    medias
 */

class MediasAudienceDoEditXAction extends BaseDoEditAction {

	function __construct() {
		parent::__construct('MediaAudience');
	}

 /**
	* Acciones a tomar antes de guardar el objeto
	*/
	function preSave(){
		parent::preSave();

		$exist = MediaAudienceQuery::create()->filterByName($this->entityParams['name'])->count();
		if ($exist) {
			$this->smarty->assign("errorTagId", "messageEdit");
			$this->smarty->assign("message", "Nombre existente, No se pudo guardar");
			return false;
		}

		$action = $this->entity->isNew() ? 'create' : 'edit';
		$this->smarty->assign('action',$action);
	}

 /**
	* Acciones a tomar despues de guardar el objeto
	*/
	function postSave(){
		parent::postSave();
		$this->smarty->assign('mediaAudience',$this->entity);
	}

}