<link rel="stylesheet" href="scripts/nvd3/nv.d3.css"/>
<script src="scripts/d3.v3.min.js"></script>
<script src="scripts/nvd3/nv.d3.js"></script>
|-block "header"-|
|-if isset($numericIndicator)-|
	|-assign var=entity value=$numericIndicator scope=parent-|
|-/if-|
<h2>##panel,1,Tablero de Gestión##</h2>
<h1>##indicators,2, Administración de Indicadores##</h1>
<p>##indicators,12, A continuación se muestra el formulario para crear/editar un indicador.##</p>
|-/block-|
|-block "legend"-||-/block-|
|-block "formIntro"-||-/block-|
|-if isset($notValidId)-|
	<div class="errorMessage">##common,124,ID inválido##</div>
	<input type="button" value="##common,102,Ir al listado##" onclick="window.location = '|-'Indicator'|routeTo:'list'-|';" />

|-else-|
<fieldset>
<legend>##indicators,13, Formulario de Indicadores##</legend>
<p>##indicators,14, Complete la información solicitada y haga click en "Guardar" para grabar los cambios o "Ir al listado" para descartarlos.##</p>
<br />
	<form method="POST" action="Main.php">
		|-include "IndicatorsFields.tpl" indicator=$numericIndicator-|
		<br />
		<p>
			<input type="submit" value="##common,101,Guardar##" />
			<input type="button" value="##common,102,Ir al listado##" onclick="window.location = 'Main.php?do=indicatorsNumericList|-include file="FiltersRedirectUrlInclude.tpl" filters=$filters-|';" />
			|-*if !$numericIndicator->isNew()-|<input type="button" value="##indicators,16, Editar Valores##" onclick="window.location = 'Main.php?do=indicatorsNumericValuesEdit&id=|-$numericIndicator->getId()-|';">|-/if*-|
			|-*include "components/ArchivateButton.tpl"*-|
		</p>
	</form>

	|-if !$numericIndicator->isNew()-|
		<h3>##indicators,17,Gráfico##</h3>
		<div>|-include "IndicatorsNumericValuesGraph.tpl"-|</div>
	|-/if-|


	|-* ************************************************************************** *-|
	|-* ********************* start indicator values edition ********************* *-|
	|-* ************************************************************************** *-|
	<style>
		table {
			margin-top: 20px;
			margin-bottom: 20px;
		}

		table input {
			text-align: right;
		}
	</style>

	|-assign var="expectedValues" value=$numericIndicator->getExpectedIndicatorValues()->toJSON(false)-|

	|-function name="indicatorValuesTable" type=null-|
		<table class="tableTdBorders">
			<thead>
				<tr>
					<th width="45%">##indicators,36,Fecha##</th>
					<th width="40%">Valor</th>
					<th width="15%">&nbsp;</th>
				</tr>
				<tr>
					<th><input class="datepicker |-$type-|" type="text" ng-model="newIndicatorValues.|-$type-|.Date"></th>
					<th><input type="text" ng-model="newIndicatorValues.|-$type-|.Value"></th>
					<th>
						<button type="button" class="icon iconAdd" ng-click="editIndicatorValue(newIndicatorValues.|-$type-|, null, '|-$type-|');" title="##common,125,Add item##">##common,125,Add item##</button>
						<span id="indicatorValueStatus-|-$type-|-new"></span>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr ng-repeat="indicatorValue in indicatorValues.|-$type-| | orderBy: 'Date'">
					<td align="center"><input class="datepicker |-$type-|" type="text" ng-model="indicatorValue.Date"></td>
					<td align="center"><input type="text" ng-model="indicatorValue.Value"></td>
					<td nowrap="nowrap" align="center">
						<button type="button" class="icon iconSave" ng-click="editIndicatorValue(indicatorValue, $index, '|-$type-|');" title="##common,101,Guardar##">##common,101,Guardar##</button>
						<button type="button" class="icon iconDelete" ng-click="deleteIndicatorValue(indicatorValue, '|-$type-|');" title="##common,2,Eliminar##">##common,2,Eliminar##</button>
						<span id="indicatorValueStatus-|-$type-|-{{indicatorValue.Id}}"></span>
					</td>
				</tr>
			</tbody>
		</table>
	|-/function-|

	<div ng-controller="NumericValuesEditController">
		|-*if json_decode($expectedValues)|count eq 0-|
			<div id="expectedValuesAssitant">
				<h4>##indicators,64,Asistente para generar valores esperados##</h4>
				<p>##indicators,65,A continuación podrá cargar los valores esperados iniciales y finales, las fechas correspondientes y el intervalo de medición.<br />El asistente generará automáticamente los valores esperados para el indicador.##</p>
				<p>
					<label>##indicators,62,Fecha Inicial##</label>
					<input type="text" class="datepicker expected" ng-model="autocreationData.startDate">
				</p>
				<p>
					<label>##indicators,63,Fecha Final##</label>
					<input type="text" class="datepicker expected" ng-model="autocreationData.endDate">
				</p>
				<p>
					<label>##indicators,60,Valor Inicial##</label>
					<input type="text" ng-model="autocreationData.startValue">
				</p>
				<p>
					<label>##indicators,61,Valor Final##</label>
					<input type="text" ng-model="autocreationData.endValue">
				</p>
				<p>
					<label>##indicators,59,Intervalo##</label>
					<select ng-model="autocreationData.interval">
						<option value="daily">##indicators,57,Diario##</option>
						<option value="weekly">##indicators,56,Semanal##</option>
						<option value="monthly">##indicators,55,Mensual##</option>
						<option value="quarterly">##indicators,54,Trimestral##</option>
						<option value="semiannual">##indicators,53,Semestral##</option>
						<option value="yearly">##indicators,52,Anual##</option>
					</select>
				</p>
				<p>
					<button type="button" ng-click="autocreateExpectedIndicatorValues(autocreationData)">##indicators,58,Generar valores esperados##</button>
					<span id="autocreation-status"></span>
				</p>
			</div>
		|-/if*-|
	|-if !$numericIndicator->isNew()-|
		|-indicatorValuesTable type="expected"-|
	|-/if-|
	</div>

	<script>
		egytcaApp.controller('NumericValuesEditController', ['$scope', '$http',
			'ExpectedIndicatorValue',
			function($scope, $http, ExpectedIndicatorValue) {

				$scope.indicatorValues = {
					|-*expected: |-json_encode($numericIndicator->getExpectedIndicatorValues()->toArray())-|*-|
					expected: |-$expectedValues-|
				};

				$scope.editIndicatorValue = function(indicatorValueData, index, type) {

					if (indicatorValueData === undefined)
						return;

					if (indicatorValueData.Numericindicatorid === undefined)
						indicatorValueData.Numericindicatorid = |-$numericIndicator->getId()-|;

					var indicatorValue = createIndicatorValueObject(indicatorValueData, type);

					var statusContainer = getStatusContainer(indicatorValueData, type);
					setOpStatus(statusContainer, 'working');

					indicatorValue.$save(function(entity) {
						replaceOrPushEntity(entity, $scope.indicatorValues[type]);
						setTimeout(function() {setOpStatus(statusContainer, 'success');}, 200); // arreglar
						$scope.newIndicatorValues = '';
					}, function() {
						setOpStatus(statusContainer, 'failure');
					});
				};

				$scope.deleteIndicatorValue = function(indicatorValueData, type) {
					if (confirm('##indicators,69,¿Está seguro de que desea eliminar el valor?##')) {

						if (indicatorValueData === undefined)
							return;

						var indicatorValue = createIndicatorValueObject(indicatorValueData, type);

						var statusContainer = getStatusContainer(indicatorValueData, type);
						setOpStatus(statusContainer, 'working');

						indicatorValue.$delete(function(entity) {
							setOpStatus(statusContainer, 'success');
							var values = $scope.indicatorValues[type];
							values.splice(values.indexOf(indicatorValueData), 1);
						}, function() {
							setOpStatus(statusContainer, 'failure');
						});
					}
				};

				var createIndicatorValueObject = function(indicatorValueData, type) {
					return type == 'expected' ? (new ExpectedIndicatorValue(indicatorValueData))
						: (new RealIndicatorValue(indicatorValueData));
				};

				var getStatusContainer = function(indicatorValueData, type) {
					var id = 'indicatorValueStatus-' + type + '-' + (indicatorValueData.Id || 'new');
					return document.getElementById(id);
				};

				$scope.autocreationData = { interval: 'monthly' };

				$scope.autocreateExpectedIndicatorValues = function(autocreationData) {

					var statusContainer = document.getElementById('autocreation-status');

					// mover request a indicator.$autocreateExpectedValues()
					$http({
						method: 'POST',
						url: 'Main.php',
						headers: { 'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8' },
						data: param({
							'do': 'indicatorsValuesAutoCreate',
							'startDate': autocreationData.startDate,
							'endDate': autocreationData.endDate,
							'startValue': autocreationData.startValue,
							'endValue': autocreationData.endValue,
							'interval': autocreationData.interval,
							'numericIndicatorId': '|-$numericIndicator->getId()-|'
						})
					}).success(function(data, status) {
						setOpStatus(statusContainer, 'success');
						$('#expectedValuesAssitant').empty();
						$('#expectedValuesAssitant').append('<div class="resultSuccess">##indicators,70,Valores esperados agregados correctamente##</div>');
						$scope.indicatorValues.expected = $scope.indicatorValues.expected.concat(data.entities);
					}).error(function() {
						setOpStatus(statusContainer, 'failure');
					});
				};
			}
		]);

		$(function() {
			$.datepicker.setDefaults($.datepicker.regional['es']);
			$('.datepicker.expected').datepicker({
				dateFormat:"dd-mm-yy"
			});
			$('.datepicker.real').datepicker({
				dateFormat:"dd-mm-yy", maxDate:"+0"
			});
		});
	</script>

	|-* ************************************************************************** *-|
	|-* ********************** end indicator values edition ********************** *-|
	|-* ************************************************************************** *-|

</fieldset>
|-/if-|