<?php


/**
 * Base class that represents a row from the 'indicators_graph' table.
 *
 * Indicators graph
 *
 * @package    propel.generator.indicators.classes.om
 */
abstract class BaseIndicatorGraph extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'IndicatorGraphPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        IndicatorGraphPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the graphtype field.
     * @var        int
     */
    protected $graphtype;

    /**
     * The value for the decimals field.
     * @var        int
     */
    protected $decimals;

    /**
     * The value for the valuetype field.
     * @var        int
     */
    protected $valuetype;

    /**
     * The value for the showvalue field.
     * @var        int
     */
    protected $showvalue;

    /**
     * The value for the minx field.
     * @var        int
     */
    protected $minx;

    /**
     * The value for the maxx field.
     * @var        int
     */
    protected $maxx;

    /**
     * The value for the miny field.
     * @var        int
     */
    protected $miny;

    /**
     * The value for the maxy field.
     * @var        int
     */
    protected $maxy;

    /**
     * The value for the description field.
     * @var        string
     */
    protected $description;

    /**
     * The value for the mindate field.
     * @var        string
     */
    protected $mindate;

    /**
     * The value for the maxdate field.
     * @var        string
     */
    protected $maxdate;

    /**
     * @var        PropelObjectCollection|IndicatorGraphSerie[] Collection to store aggregation of IndicatorGraphSerie objects.
     */
    protected $collIndicatorGraphSeries;
    protected $collIndicatorGraphSeriesPartial;

    /**
     * @var        PropelObjectCollection|IndicatorGraphComment[] Collection to store aggregation of IndicatorGraphComment objects.
     */
    protected $collIndicatorGraphComments;
    protected $collIndicatorGraphCommentsPartial;

    /**
     * @var        PropelObjectCollection|Indicator[] Collection to store aggregation of Indicator objects.
     */
    protected $collIndicators;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $indicatorsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $indicatorGraphSeriesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $indicatorGraphCommentsScheduledForDeletion = null;

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     * Name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [graphtype] column value.
     * Tipo de Grafico
     * @return int
     */
    public function getGraphtype()
    {
        return $this->graphtype;
    }

    /**
     * Get the [decimals] column value.
     * Numero de decimales
     * @return int
     */
    public function getDecimals()
    {
        return $this->decimals;
    }

    /**
     * Get the [valuetype] column value.
     * Tipo de valor
     * @return int
     */
    public function getValuetype()
    {
        return $this->valuetype;
    }

    /**
     * Get the [showvalue] column value.
     * Tipo de valor
     * @return int
     */
    public function getShowvalue()
    {
        return $this->showvalue;
    }

    /**
     * Get the [minx] column value.
     * Menor valor X
     * @return int
     */
    public function getMinx()
    {
        return $this->minx;
    }

    /**
     * Get the [maxx] column value.
     * Maximo valor X
     * @return int
     */
    public function getMaxx()
    {
        return $this->maxx;
    }

    /**
     * Get the [miny] column value.
     * Menor valor Y
     * @return int
     */
    public function getMiny()
    {
        return $this->miny;
    }

    /**
     * Get the [maxy] column value.
     * Maximo valor Y
     * @return int
     */
    public function getMaxy()
    {
        return $this->maxy;
    }

    /**
     * Get the [description] column value.
     * Descripcion
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the [optionally formatted] temporal [mindate] column value.
     * Menor valor de fecha
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getMindate($format = 'Y-m-d H:i:s')
    {
        if ($this->mindate === null) {
            return null;
        }

        if ($this->mindate === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->mindate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->mindate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [maxdate] column value.
     * Maximo valor de fecha
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getMaxdate($format = 'Y-m-d H:i:s')
    {
        if ($this->maxdate === null) {
            return null;
        }

        if ($this->maxdate === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->maxdate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->maxdate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v new value
     * @return IndicatorGraph The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = IndicatorGraphPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [name] column.
     * Name
     * @param string $v new value
     * @return IndicatorGraph The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = IndicatorGraphPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [graphtype] column.
     * Tipo de Grafico
     * @param int $v new value
     * @return IndicatorGraph The current object (for fluent API support)
     */
    public function setGraphtype($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->graphtype !== $v) {
            $this->graphtype = $v;
            $this->modifiedColumns[] = IndicatorGraphPeer::GRAPHTYPE;
        }


        return $this;
    } // setGraphtype()

    /**
     * Set the value of [decimals] column.
     * Numero de decimales
     * @param int $v new value
     * @return IndicatorGraph The current object (for fluent API support)
     */
    public function setDecimals($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->decimals !== $v) {
            $this->decimals = $v;
            $this->modifiedColumns[] = IndicatorGraphPeer::DECIMALS;
        }


        return $this;
    } // setDecimals()

    /**
     * Set the value of [valuetype] column.
     * Tipo de valor
     * @param int $v new value
     * @return IndicatorGraph The current object (for fluent API support)
     */
    public function setValuetype($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->valuetype !== $v) {
            $this->valuetype = $v;
            $this->modifiedColumns[] = IndicatorGraphPeer::VALUETYPE;
        }


        return $this;
    } // setValuetype()

    /**
     * Set the value of [showvalue] column.
     * Tipo de valor
     * @param int $v new value
     * @return IndicatorGraph The current object (for fluent API support)
     */
    public function setShowvalue($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->showvalue !== $v) {
            $this->showvalue = $v;
            $this->modifiedColumns[] = IndicatorGraphPeer::SHOWVALUE;
        }


        return $this;
    } // setShowvalue()

    /**
     * Set the value of [minx] column.
     * Menor valor X
     * @param int $v new value
     * @return IndicatorGraph The current object (for fluent API support)
     */
    public function setMinx($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->minx !== $v) {
            $this->minx = $v;
            $this->modifiedColumns[] = IndicatorGraphPeer::MINX;
        }


        return $this;
    } // setMinx()

    /**
     * Set the value of [maxx] column.
     * Maximo valor X
     * @param int $v new value
     * @return IndicatorGraph The current object (for fluent API support)
     */
    public function setMaxx($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->maxx !== $v) {
            $this->maxx = $v;
            $this->modifiedColumns[] = IndicatorGraphPeer::MAXX;
        }


        return $this;
    } // setMaxx()

    /**
     * Set the value of [miny] column.
     * Menor valor Y
     * @param int $v new value
     * @return IndicatorGraph The current object (for fluent API support)
     */
    public function setMiny($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->miny !== $v) {
            $this->miny = $v;
            $this->modifiedColumns[] = IndicatorGraphPeer::MINY;
        }


        return $this;
    } // setMiny()

    /**
     * Set the value of [maxy] column.
     * Maximo valor Y
     * @param int $v new value
     * @return IndicatorGraph The current object (for fluent API support)
     */
    public function setMaxy($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->maxy !== $v) {
            $this->maxy = $v;
            $this->modifiedColumns[] = IndicatorGraphPeer::MAXY;
        }


        return $this;
    } // setMaxy()

    /**
     * Set the value of [description] column.
     * Descripcion
     * @param string $v new value
     * @return IndicatorGraph The current object (for fluent API support)
     */
    public function setDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->description !== $v) {
            $this->description = $v;
            $this->modifiedColumns[] = IndicatorGraphPeer::DESCRIPTION;
        }


        return $this;
    } // setDescription()

    /**
     * Sets the value of [mindate] column to a normalized version of the date/time value specified.
     * Menor valor de fecha
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return IndicatorGraph The current object (for fluent API support)
     */
    public function setMindate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->mindate !== null || $dt !== null) {
            $currentDateAsString = ($this->mindate !== null && $tmpDt = new DateTime($this->mindate)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->mindate = $newDateAsString;
                $this->modifiedColumns[] = IndicatorGraphPeer::MINDATE;
            }
        } // if either are not null


        return $this;
    } // setMindate()

    /**
     * Sets the value of [maxdate] column to a normalized version of the date/time value specified.
     * Maximo valor de fecha
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return IndicatorGraph The current object (for fluent API support)
     */
    public function setMaxdate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->maxdate !== null || $dt !== null) {
            $currentDateAsString = ($this->maxdate !== null && $tmpDt = new DateTime($this->maxdate)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->maxdate = $newDateAsString;
                $this->modifiedColumns[] = IndicatorGraphPeer::MAXDATE;
            }
        } // if either are not null


        return $this;
    } // setMaxdate()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->graphtype = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
            $this->decimals = ($row[$startcol + 3] !== null) ? (int) $row[$startcol + 3] : null;
            $this->valuetype = ($row[$startcol + 4] !== null) ? (int) $row[$startcol + 4] : null;
            $this->showvalue = ($row[$startcol + 5] !== null) ? (int) $row[$startcol + 5] : null;
            $this->minx = ($row[$startcol + 6] !== null) ? (int) $row[$startcol + 6] : null;
            $this->maxx = ($row[$startcol + 7] !== null) ? (int) $row[$startcol + 7] : null;
            $this->miny = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
            $this->maxy = ($row[$startcol + 9] !== null) ? (int) $row[$startcol + 9] : null;
            $this->description = ($row[$startcol + 10] !== null) ? (string) $row[$startcol + 10] : null;
            $this->mindate = ($row[$startcol + 11] !== null) ? (string) $row[$startcol + 11] : null;
            $this->maxdate = ($row[$startcol + 12] !== null) ? (string) $row[$startcol + 12] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 13; // 13 = IndicatorGraphPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating IndicatorGraph object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(IndicatorGraphPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = IndicatorGraphPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->collIndicatorGraphSeries = null;

            $this->collIndicatorGraphComments = null;

            $this->collIndicators = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(IndicatorGraphPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = IndicatorGraphQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(IndicatorGraphPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                IndicatorGraphPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->indicatorsScheduledForDeletion !== null) {
                if (!$this->indicatorsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->indicatorsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    IndicatorGraphSerieQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->indicatorsScheduledForDeletion = null;
                }

                foreach ($this->getIndicators() as $indicator) {
                    if ($indicator->isModified()) {
                        $indicator->save($con);
                    }
                }
            }

            if ($this->indicatorGraphSeriesScheduledForDeletion !== null) {
                if (!$this->indicatorGraphSeriesScheduledForDeletion->isEmpty()) {
                    IndicatorGraphSerieQuery::create()
                        ->filterByPrimaryKeys($this->indicatorGraphSeriesScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->indicatorGraphSeriesScheduledForDeletion = null;
                }
            }

            if ($this->collIndicatorGraphSeries !== null) {
                foreach ($this->collIndicatorGraphSeries as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->indicatorGraphCommentsScheduledForDeletion !== null) {
                if (!$this->indicatorGraphCommentsScheduledForDeletion->isEmpty()) {
                    IndicatorGraphCommentQuery::create()
                        ->filterByPrimaryKeys($this->indicatorGraphCommentsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->indicatorGraphCommentsScheduledForDeletion = null;
                }
            }

            if ($this->collIndicatorGraphComments !== null) {
                foreach ($this->collIndicatorGraphComments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = IndicatorGraphPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . IndicatorGraphPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(IndicatorGraphPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(IndicatorGraphPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(IndicatorGraphPeer::GRAPHTYPE)) {
            $modifiedColumns[':p' . $index++]  = '`GRAPHTYPE`';
        }
        if ($this->isColumnModified(IndicatorGraphPeer::DECIMALS)) {
            $modifiedColumns[':p' . $index++]  = '`DECIMALS`';
        }
        if ($this->isColumnModified(IndicatorGraphPeer::VALUETYPE)) {
            $modifiedColumns[':p' . $index++]  = '`VALUETYPE`';
        }
        if ($this->isColumnModified(IndicatorGraphPeer::SHOWVALUE)) {
            $modifiedColumns[':p' . $index++]  = '`SHOWVALUE`';
        }
        if ($this->isColumnModified(IndicatorGraphPeer::MINX)) {
            $modifiedColumns[':p' . $index++]  = '`MINX`';
        }
        if ($this->isColumnModified(IndicatorGraphPeer::MAXX)) {
            $modifiedColumns[':p' . $index++]  = '`MAXX`';
        }
        if ($this->isColumnModified(IndicatorGraphPeer::MINY)) {
            $modifiedColumns[':p' . $index++]  = '`MINY`';
        }
        if ($this->isColumnModified(IndicatorGraphPeer::MAXY)) {
            $modifiedColumns[':p' . $index++]  = '`MAXY`';
        }
        if ($this->isColumnModified(IndicatorGraphPeer::DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`DESCRIPTION`';
        }
        if ($this->isColumnModified(IndicatorGraphPeer::MINDATE)) {
            $modifiedColumns[':p' . $index++]  = '`MINDATE`';
        }
        if ($this->isColumnModified(IndicatorGraphPeer::MAXDATE)) {
            $modifiedColumns[':p' . $index++]  = '`MAXDATE`';
        }

        $sql = sprintf(
            'INSERT INTO `indicators_graph` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`GRAPHTYPE`':
                        $stmt->bindValue($identifier, $this->graphtype, PDO::PARAM_INT);
                        break;
                    case '`DECIMALS`':
                        $stmt->bindValue($identifier, $this->decimals, PDO::PARAM_INT);
                        break;
                    case '`VALUETYPE`':
                        $stmt->bindValue($identifier, $this->valuetype, PDO::PARAM_INT);
                        break;
                    case '`SHOWVALUE`':
                        $stmt->bindValue($identifier, $this->showvalue, PDO::PARAM_INT);
                        break;
                    case '`MINX`':
                        $stmt->bindValue($identifier, $this->minx, PDO::PARAM_INT);
                        break;
                    case '`MAXX`':
                        $stmt->bindValue($identifier, $this->maxx, PDO::PARAM_INT);
                        break;
                    case '`MINY`':
                        $stmt->bindValue($identifier, $this->miny, PDO::PARAM_INT);
                        break;
                    case '`MAXY`':
                        $stmt->bindValue($identifier, $this->maxy, PDO::PARAM_INT);
                        break;
                    case '`DESCRIPTION`':
                        $stmt->bindValue($identifier, $this->description, PDO::PARAM_STR);
                        break;
                    case '`MINDATE`':
                        $stmt->bindValue($identifier, $this->mindate, PDO::PARAM_STR);
                        break;
                    case '`MAXDATE`':
                        $stmt->bindValue($identifier, $this->maxdate, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            if (($retval = IndicatorGraphPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collIndicatorGraphSeries !== null) {
                    foreach ($this->collIndicatorGraphSeries as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collIndicatorGraphComments !== null) {
                    foreach ($this->collIndicatorGraphComments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = IndicatorGraphPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getName();
                break;
            case 2:
                return $this->getGraphtype();
                break;
            case 3:
                return $this->getDecimals();
                break;
            case 4:
                return $this->getValuetype();
                break;
            case 5:
                return $this->getShowvalue();
                break;
            case 6:
                return $this->getMinx();
                break;
            case 7:
                return $this->getMaxx();
                break;
            case 8:
                return $this->getMiny();
                break;
            case 9:
                return $this->getMaxy();
                break;
            case 10:
                return $this->getDescription();
                break;
            case 11:
                return $this->getMindate();
                break;
            case 12:
                return $this->getMaxdate();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['IndicatorGraph'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['IndicatorGraph'][$this->getPrimaryKey()] = true;
        $keys = IndicatorGraphPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getGraphtype(),
            $keys[3] => $this->getDecimals(),
            $keys[4] => $this->getValuetype(),
            $keys[5] => $this->getShowvalue(),
            $keys[6] => $this->getMinx(),
            $keys[7] => $this->getMaxx(),
            $keys[8] => $this->getMiny(),
            $keys[9] => $this->getMaxy(),
            $keys[10] => $this->getDescription(),
            $keys[11] => $this->getMindate(),
            $keys[12] => $this->getMaxdate(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->collIndicatorGraphSeries) {
                $result['IndicatorGraphSeries'] = $this->collIndicatorGraphSeries->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collIndicatorGraphComments) {
                $result['IndicatorGraphComments'] = $this->collIndicatorGraphComments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = IndicatorGraphPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setGraphtype($value);
                break;
            case 3:
                $this->setDecimals($value);
                break;
            case 4:
                $this->setValuetype($value);
                break;
            case 5:
                $this->setShowvalue($value);
                break;
            case 6:
                $this->setMinx($value);
                break;
            case 7:
                $this->setMaxx($value);
                break;
            case 8:
                $this->setMiny($value);
                break;
            case 9:
                $this->setMaxy($value);
                break;
            case 10:
                $this->setDescription($value);
                break;
            case 11:
                $this->setMindate($value);
                break;
            case 12:
                $this->setMaxdate($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = IndicatorGraphPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setName($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setGraphtype($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setDecimals($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setValuetype($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setShowvalue($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setMinx($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setMaxx($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setMiny($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setMaxy($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setDescription($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setMindate($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setMaxdate($arr[$keys[12]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(IndicatorGraphPeer::DATABASE_NAME);

        if ($this->isColumnModified(IndicatorGraphPeer::ID)) $criteria->add(IndicatorGraphPeer::ID, $this->id);
        if ($this->isColumnModified(IndicatorGraphPeer::NAME)) $criteria->add(IndicatorGraphPeer::NAME, $this->name);
        if ($this->isColumnModified(IndicatorGraphPeer::GRAPHTYPE)) $criteria->add(IndicatorGraphPeer::GRAPHTYPE, $this->graphtype);
        if ($this->isColumnModified(IndicatorGraphPeer::DECIMALS)) $criteria->add(IndicatorGraphPeer::DECIMALS, $this->decimals);
        if ($this->isColumnModified(IndicatorGraphPeer::VALUETYPE)) $criteria->add(IndicatorGraphPeer::VALUETYPE, $this->valuetype);
        if ($this->isColumnModified(IndicatorGraphPeer::SHOWVALUE)) $criteria->add(IndicatorGraphPeer::SHOWVALUE, $this->showvalue);
        if ($this->isColumnModified(IndicatorGraphPeer::MINX)) $criteria->add(IndicatorGraphPeer::MINX, $this->minx);
        if ($this->isColumnModified(IndicatorGraphPeer::MAXX)) $criteria->add(IndicatorGraphPeer::MAXX, $this->maxx);
        if ($this->isColumnModified(IndicatorGraphPeer::MINY)) $criteria->add(IndicatorGraphPeer::MINY, $this->miny);
        if ($this->isColumnModified(IndicatorGraphPeer::MAXY)) $criteria->add(IndicatorGraphPeer::MAXY, $this->maxy);
        if ($this->isColumnModified(IndicatorGraphPeer::DESCRIPTION)) $criteria->add(IndicatorGraphPeer::DESCRIPTION, $this->description);
        if ($this->isColumnModified(IndicatorGraphPeer::MINDATE)) $criteria->add(IndicatorGraphPeer::MINDATE, $this->mindate);
        if ($this->isColumnModified(IndicatorGraphPeer::MAXDATE)) $criteria->add(IndicatorGraphPeer::MAXDATE, $this->maxdate);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(IndicatorGraphPeer::DATABASE_NAME);
        $criteria->add(IndicatorGraphPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of IndicatorGraph (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setName($this->getName());
        $copyObj->setGraphtype($this->getGraphtype());
        $copyObj->setDecimals($this->getDecimals());
        $copyObj->setValuetype($this->getValuetype());
        $copyObj->setShowvalue($this->getShowvalue());
        $copyObj->setMinx($this->getMinx());
        $copyObj->setMaxx($this->getMaxx());
        $copyObj->setMiny($this->getMiny());
        $copyObj->setMaxy($this->getMaxy());
        $copyObj->setDescription($this->getDescription());
        $copyObj->setMindate($this->getMindate());
        $copyObj->setMaxdate($this->getMaxdate());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getIndicatorGraphSeries() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addIndicatorGraphSerie($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getIndicatorGraphComments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addIndicatorGraphComment($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return IndicatorGraph Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return IndicatorGraphPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new IndicatorGraphPeer();
        }

        return self::$peer;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('IndicatorGraphSerie' == $relationName) {
            $this->initIndicatorGraphSeries();
        }
        if ('IndicatorGraphComment' == $relationName) {
            $this->initIndicatorGraphComments();
        }
    }

    /**
     * Clears out the collIndicatorGraphSeries collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addIndicatorGraphSeries()
     */
    public function clearIndicatorGraphSeries()
    {
        $this->collIndicatorGraphSeries = null; // important to set this to null since that means it is uninitialized
        $this->collIndicatorGraphSeriesPartial = null;
    }

    /**
     * reset is the collIndicatorGraphSeries collection loaded partially
     *
     * @return void
     */
    public function resetPartialIndicatorGraphSeries($v = true)
    {
        $this->collIndicatorGraphSeriesPartial = $v;
    }

    /**
     * Initializes the collIndicatorGraphSeries collection.
     *
     * By default this just sets the collIndicatorGraphSeries collection to an empty array (like clearcollIndicatorGraphSeries());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initIndicatorGraphSeries($overrideExisting = true)
    {
        if (null !== $this->collIndicatorGraphSeries && !$overrideExisting) {
            return;
        }
        $this->collIndicatorGraphSeries = new PropelObjectCollection();
        $this->collIndicatorGraphSeries->setModel('IndicatorGraphSerie');
    }

    /**
     * Gets an array of IndicatorGraphSerie objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this IndicatorGraph is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|IndicatorGraphSerie[] List of IndicatorGraphSerie objects
     * @throws PropelException
     */
    public function getIndicatorGraphSeries($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collIndicatorGraphSeriesPartial && !$this->isNew();
        if (null === $this->collIndicatorGraphSeries || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collIndicatorGraphSeries) {
                // return empty collection
                $this->initIndicatorGraphSeries();
            } else {
                $collIndicatorGraphSeries = IndicatorGraphSerieQuery::create(null, $criteria)
                    ->filterByIndicatorGraph($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collIndicatorGraphSeriesPartial && count($collIndicatorGraphSeries)) {
                      $this->initIndicatorGraphSeries(false);

                      foreach($collIndicatorGraphSeries as $obj) {
                        if (false == $this->collIndicatorGraphSeries->contains($obj)) {
                          $this->collIndicatorGraphSeries->append($obj);
                        }
                      }

                      $this->collIndicatorGraphSeriesPartial = true;
                    }

                    return $collIndicatorGraphSeries;
                }

                if($partial && $this->collIndicatorGraphSeries) {
                    foreach($this->collIndicatorGraphSeries as $obj) {
                        if($obj->isNew()) {
                            $collIndicatorGraphSeries[] = $obj;
                        }
                    }
                }

                $this->collIndicatorGraphSeries = $collIndicatorGraphSeries;
                $this->collIndicatorGraphSeriesPartial = false;
            }
        }

        return $this->collIndicatorGraphSeries;
    }

    /**
     * Sets a collection of IndicatorGraphSerie objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $indicatorGraphSeries A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setIndicatorGraphSeries(PropelCollection $indicatorGraphSeries, PropelPDO $con = null)
    {
        $this->indicatorGraphSeriesScheduledForDeletion = $this->getIndicatorGraphSeries(new Criteria(), $con)->diff($indicatorGraphSeries);

        foreach ($this->indicatorGraphSeriesScheduledForDeletion as $indicatorGraphSerieRemoved) {
            $indicatorGraphSerieRemoved->setIndicatorGraph(null);
        }

        $this->collIndicatorGraphSeries = null;
        foreach ($indicatorGraphSeries as $indicatorGraphSerie) {
            $this->addIndicatorGraphSerie($indicatorGraphSerie);
        }

        $this->collIndicatorGraphSeries = $indicatorGraphSeries;
        $this->collIndicatorGraphSeriesPartial = false;
    }

    /**
     * Returns the number of related IndicatorGraphSerie objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related IndicatorGraphSerie objects.
     * @throws PropelException
     */
    public function countIndicatorGraphSeries(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collIndicatorGraphSeriesPartial && !$this->isNew();
        if (null === $this->collIndicatorGraphSeries || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collIndicatorGraphSeries) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getIndicatorGraphSeries());
                }
                $query = IndicatorGraphSerieQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByIndicatorGraph($this)
                    ->count($con);
            }
        } else {
            return count($this->collIndicatorGraphSeries);
        }
    }

    /**
     * Method called to associate a IndicatorGraphSerie object to this object
     * through the IndicatorGraphSerie foreign key attribute.
     *
     * @param    IndicatorGraphSerie $l IndicatorGraphSerie
     * @return IndicatorGraph The current object (for fluent API support)
     */
    public function addIndicatorGraphSerie(IndicatorGraphSerie $l)
    {
        if ($this->collIndicatorGraphSeries === null) {
            $this->initIndicatorGraphSeries();
            $this->collIndicatorGraphSeriesPartial = true;
        }
        if (!$this->collIndicatorGraphSeries->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddIndicatorGraphSerie($l);
        }

        return $this;
    }

    /**
     * @param	IndicatorGraphSerie $indicatorGraphSerie The indicatorGraphSerie object to add.
     */
    protected function doAddIndicatorGraphSerie($indicatorGraphSerie)
    {
        $this->collIndicatorGraphSeries[]= $indicatorGraphSerie;
        $indicatorGraphSerie->setIndicatorGraph($this);
    }

    /**
     * @param	IndicatorGraphSerie $indicatorGraphSerie The indicatorGraphSerie object to remove.
     */
    public function removeIndicatorGraphSerie($indicatorGraphSerie)
    {
        if ($this->getIndicatorGraphSeries()->contains($indicatorGraphSerie)) {
            $this->collIndicatorGraphSeries->remove($this->collIndicatorGraphSeries->search($indicatorGraphSerie));
            if (null === $this->indicatorGraphSeriesScheduledForDeletion) {
                $this->indicatorGraphSeriesScheduledForDeletion = clone $this->collIndicatorGraphSeries;
                $this->indicatorGraphSeriesScheduledForDeletion->clear();
            }
            $this->indicatorGraphSeriesScheduledForDeletion[]= $indicatorGraphSerie;
            $indicatorGraphSerie->setIndicatorGraph(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this IndicatorGraph is new, it will return
     * an empty collection; or if this IndicatorGraph has previously
     * been saved, it will retrieve related IndicatorGraphSeries from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in IndicatorGraph.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|IndicatorGraphSerie[] List of IndicatorGraphSerie objects
     */
    public function getIndicatorGraphSeriesJoinIndicator($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = IndicatorGraphSerieQuery::create(null, $criteria);
        $query->joinWith('Indicator', $join_behavior);

        return $this->getIndicatorGraphSeries($query, $con);
    }

    /**
     * Clears out the collIndicatorGraphComments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addIndicatorGraphComments()
     */
    public function clearIndicatorGraphComments()
    {
        $this->collIndicatorGraphComments = null; // important to set this to null since that means it is uninitialized
        $this->collIndicatorGraphCommentsPartial = null;
    }

    /**
     * reset is the collIndicatorGraphComments collection loaded partially
     *
     * @return void
     */
    public function resetPartialIndicatorGraphComments($v = true)
    {
        $this->collIndicatorGraphCommentsPartial = $v;
    }

    /**
     * Initializes the collIndicatorGraphComments collection.
     *
     * By default this just sets the collIndicatorGraphComments collection to an empty array (like clearcollIndicatorGraphComments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initIndicatorGraphComments($overrideExisting = true)
    {
        if (null !== $this->collIndicatorGraphComments && !$overrideExisting) {
            return;
        }
        $this->collIndicatorGraphComments = new PropelObjectCollection();
        $this->collIndicatorGraphComments->setModel('IndicatorGraphComment');
    }

    /**
     * Gets an array of IndicatorGraphComment objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this IndicatorGraph is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|IndicatorGraphComment[] List of IndicatorGraphComment objects
     * @throws PropelException
     */
    public function getIndicatorGraphComments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collIndicatorGraphCommentsPartial && !$this->isNew();
        if (null === $this->collIndicatorGraphComments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collIndicatorGraphComments) {
                // return empty collection
                $this->initIndicatorGraphComments();
            } else {
                $collIndicatorGraphComments = IndicatorGraphCommentQuery::create(null, $criteria)
                    ->filterByIndicatorGraph($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collIndicatorGraphCommentsPartial && count($collIndicatorGraphComments)) {
                      $this->initIndicatorGraphComments(false);

                      foreach($collIndicatorGraphComments as $obj) {
                        if (false == $this->collIndicatorGraphComments->contains($obj)) {
                          $this->collIndicatorGraphComments->append($obj);
                        }
                      }

                      $this->collIndicatorGraphCommentsPartial = true;
                    }

                    return $collIndicatorGraphComments;
                }

                if($partial && $this->collIndicatorGraphComments) {
                    foreach($this->collIndicatorGraphComments as $obj) {
                        if($obj->isNew()) {
                            $collIndicatorGraphComments[] = $obj;
                        }
                    }
                }

                $this->collIndicatorGraphComments = $collIndicatorGraphComments;
                $this->collIndicatorGraphCommentsPartial = false;
            }
        }

        return $this->collIndicatorGraphComments;
    }

    /**
     * Sets a collection of IndicatorGraphComment objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $indicatorGraphComments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setIndicatorGraphComments(PropelCollection $indicatorGraphComments, PropelPDO $con = null)
    {
        $this->indicatorGraphCommentsScheduledForDeletion = $this->getIndicatorGraphComments(new Criteria(), $con)->diff($indicatorGraphComments);

        foreach ($this->indicatorGraphCommentsScheduledForDeletion as $indicatorGraphCommentRemoved) {
            $indicatorGraphCommentRemoved->setIndicatorGraph(null);
        }

        $this->collIndicatorGraphComments = null;
        foreach ($indicatorGraphComments as $indicatorGraphComment) {
            $this->addIndicatorGraphComment($indicatorGraphComment);
        }

        $this->collIndicatorGraphComments = $indicatorGraphComments;
        $this->collIndicatorGraphCommentsPartial = false;
    }

    /**
     * Returns the number of related IndicatorGraphComment objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related IndicatorGraphComment objects.
     * @throws PropelException
     */
    public function countIndicatorGraphComments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collIndicatorGraphCommentsPartial && !$this->isNew();
        if (null === $this->collIndicatorGraphComments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collIndicatorGraphComments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getIndicatorGraphComments());
                }
                $query = IndicatorGraphCommentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByIndicatorGraph($this)
                    ->count($con);
            }
        } else {
            return count($this->collIndicatorGraphComments);
        }
    }

    /**
     * Method called to associate a IndicatorGraphComment object to this object
     * through the IndicatorGraphComment foreign key attribute.
     *
     * @param    IndicatorGraphComment $l IndicatorGraphComment
     * @return IndicatorGraph The current object (for fluent API support)
     */
    public function addIndicatorGraphComment(IndicatorGraphComment $l)
    {
        if ($this->collIndicatorGraphComments === null) {
            $this->initIndicatorGraphComments();
            $this->collIndicatorGraphCommentsPartial = true;
        }
        if (!$this->collIndicatorGraphComments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddIndicatorGraphComment($l);
        }

        return $this;
    }

    /**
     * @param	IndicatorGraphComment $indicatorGraphComment The indicatorGraphComment object to add.
     */
    protected function doAddIndicatorGraphComment($indicatorGraphComment)
    {
        $this->collIndicatorGraphComments[]= $indicatorGraphComment;
        $indicatorGraphComment->setIndicatorGraph($this);
    }

    /**
     * @param	IndicatorGraphComment $indicatorGraphComment The indicatorGraphComment object to remove.
     */
    public function removeIndicatorGraphComment($indicatorGraphComment)
    {
        if ($this->getIndicatorGraphComments()->contains($indicatorGraphComment)) {
            $this->collIndicatorGraphComments->remove($this->collIndicatorGraphComments->search($indicatorGraphComment));
            if (null === $this->indicatorGraphCommentsScheduledForDeletion) {
                $this->indicatorGraphCommentsScheduledForDeletion = clone $this->collIndicatorGraphComments;
                $this->indicatorGraphCommentsScheduledForDeletion->clear();
            }
            $this->indicatorGraphCommentsScheduledForDeletion[]= $indicatorGraphComment;
            $indicatorGraphComment->setIndicatorGraph(null);
        }
    }

    /**
     * Clears out the collIndicators collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addIndicators()
     */
    public function clearIndicators()
    {
        $this->collIndicators = null; // important to set this to null since that means it is uninitialized
        $this->collIndicatorsPartial = null;
    }

    /**
     * Initializes the collIndicators collection.
     *
     * By default this just sets the collIndicators collection to an empty collection (like clearIndicators());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initIndicators()
    {
        $this->collIndicators = new PropelObjectCollection();
        $this->collIndicators->setModel('Indicator');
    }

    /**
     * Gets a collection of Indicator objects related by a many-to-many relationship
     * to the current object by way of the indicators_graphSerie cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this IndicatorGraph is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Indicator[] List of Indicator objects
     */
    public function getIndicators($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collIndicators || null !== $criteria) {
            if ($this->isNew() && null === $this->collIndicators) {
                // return empty collection
                $this->initIndicators();
            } else {
                $collIndicators = IndicatorQuery::create(null, $criteria)
                    ->filterByIndicatorGraph($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collIndicators;
                }
                $this->collIndicators = $collIndicators;
            }
        }

        return $this->collIndicators;
    }

    /**
     * Sets a collection of Indicator objects related by a many-to-many relationship
     * to the current object by way of the indicators_graphSerie cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $indicators A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setIndicators(PropelCollection $indicators, PropelPDO $con = null)
    {
        $this->clearIndicators();
        $currentIndicators = $this->getIndicators();

        $this->indicatorsScheduledForDeletion = $currentIndicators->diff($indicators);

        foreach ($indicators as $indicator) {
            if (!$currentIndicators->contains($indicator)) {
                $this->doAddIndicator($indicator);
            }
        }

        $this->collIndicators = $indicators;
    }

    /**
     * Gets the number of Indicator objects related by a many-to-many relationship
     * to the current object by way of the indicators_graphSerie cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Indicator objects
     */
    public function countIndicators($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collIndicators || null !== $criteria) {
            if ($this->isNew() && null === $this->collIndicators) {
                return 0;
            } else {
                $query = IndicatorQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByIndicatorGraph($this)
                    ->count($con);
            }
        } else {
            return count($this->collIndicators);
        }
    }

    /**
     * Associate a Indicator object to this object
     * through the indicators_graphSerie cross reference table.
     *
     * @param  Indicator $indicator The IndicatorGraphSerie object to relate
     * @return void
     */
    public function addIndicator(Indicator $indicator)
    {
        if ($this->collIndicators === null) {
            $this->initIndicators();
        }
        if (!$this->collIndicators->contains($indicator)) { // only add it if the **same** object is not already associated
            $this->doAddIndicator($indicator);

            $this->collIndicators[]= $indicator;
        }
    }

    /**
     * @param	Indicator $indicator The indicator object to add.
     */
    protected function doAddIndicator($indicator)
    {
        $indicatorGraphSerie = new IndicatorGraphSerie();
        $indicatorGraphSerie->setIndicator($indicator);
        $this->addIndicatorGraphSerie($indicatorGraphSerie);
    }

    /**
     * Remove a Indicator object to this object
     * through the indicators_graphSerie cross reference table.
     *
     * @param Indicator $indicator The IndicatorGraphSerie object to relate
     * @return void
     */
    public function removeIndicator(Indicator $indicator)
    {
        if ($this->getIndicators()->contains($indicator)) {
            $this->collIndicators->remove($this->collIndicators->search($indicator));
            if (null === $this->indicatorsScheduledForDeletion) {
                $this->indicatorsScheduledForDeletion = clone $this->collIndicators;
                $this->indicatorsScheduledForDeletion->clear();
            }
            $this->indicatorsScheduledForDeletion[]= $indicator;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->graphtype = null;
        $this->decimals = null;
        $this->valuetype = null;
        $this->showvalue = null;
        $this->minx = null;
        $this->maxx = null;
        $this->miny = null;
        $this->maxy = null;
        $this->description = null;
        $this->mindate = null;
        $this->maxdate = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collIndicatorGraphSeries) {
                foreach ($this->collIndicatorGraphSeries as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collIndicatorGraphComments) {
                foreach ($this->collIndicatorGraphComments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collIndicators) {
                foreach ($this->collIndicators as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collIndicatorGraphSeries instanceof PropelCollection) {
            $this->collIndicatorGraphSeries->clearIterator();
        }
        $this->collIndicatorGraphSeries = null;
        if ($this->collIndicatorGraphComments instanceof PropelCollection) {
            $this->collIndicatorGraphComments->clearIterator();
        }
        $this->collIndicatorGraphComments = null;
        if ($this->collIndicators instanceof PropelCollection) {
            $this->collIndicators->clearIterator();
        }
        $this->collIndicators = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(IndicatorGraphPeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

}
