<?php


/**
 * Base class that represents a row from the 'headlines_tag' table.
 *
 * Etiquetas de titulares
 *
 * @package    propel.generator.headlines.classes.om
 */
abstract class BaseHeadlineTag extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'HeadlineTagPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        HeadlineTagPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the created_at field.
     * @var        string
     */
    protected $created_at;

    /**
     * The value for the updated_at field.
     * @var        string
     */
    protected $updated_at;

    /**
     * @var        PropelObjectCollection|HeadlineTagRelation[] Collection to store aggregation of HeadlineTagRelation objects.
     */
    protected $collHeadlineTagRelations;
    protected $collHeadlineTagRelationsPartial;

    /**
     * @var        PropelObjectCollection|Headline[] Collection to store aggregation of Headline objects.
     */
    protected $collHeadlines;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $headlinesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $headlineTagRelationsScheduledForDeletion = null;

    /**
     * Get the [id] column value.
     * Tag Id
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     * Etiquetas de Headline
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [optionally formatted] temporal [created_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getCreatedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->created_at === null) {
            return null;
        }

        if ($this->created_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->created_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->created_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [updated_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getUpdatedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->updated_at === null) {
            return null;
        }

        if ($this->updated_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->updated_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->updated_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Set the value of [id] column.
     * Tag Id
     * @param int $v new value
     * @return HeadlineTag The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = HeadlineTagPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [name] column.
     * Etiquetas de Headline
     * @param string $v new value
     * @return HeadlineTag The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = HeadlineTagPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Sets the value of [created_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return HeadlineTag The current object (for fluent API support)
     */
    public function setCreatedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->created_at !== null || $dt !== null) {
            $currentDateAsString = ($this->created_at !== null && $tmpDt = new DateTime($this->created_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->created_at = $newDateAsString;
                $this->modifiedColumns[] = HeadlineTagPeer::CREATED_AT;
            }
        } // if either are not null


        return $this;
    } // setCreatedAt()

    /**
     * Sets the value of [updated_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return HeadlineTag The current object (for fluent API support)
     */
    public function setUpdatedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->updated_at !== null || $dt !== null) {
            $currentDateAsString = ($this->updated_at !== null && $tmpDt = new DateTime($this->updated_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->updated_at = $newDateAsString;
                $this->modifiedColumns[] = HeadlineTagPeer::UPDATED_AT;
            }
        } // if either are not null


        return $this;
    } // setUpdatedAt()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->created_at = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->updated_at = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 4; // 4 = HeadlineTagPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating HeadlineTag object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(HeadlineTagPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = HeadlineTagPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->collHeadlineTagRelations = null;

            $this->collHeadlines = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(HeadlineTagPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = HeadlineTagQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(HeadlineTagPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
                // timestampable behavior
                if (!$this->isColumnModified(HeadlineTagPeer::CREATED_AT)) {
                    $this->setCreatedAt(time());
                }
                if (!$this->isColumnModified(HeadlineTagPeer::UPDATED_AT)) {
                    $this->setUpdatedAt(time());
                }
            } else {
                $ret = $ret && $this->preUpdate($con);
                // timestampable behavior
                if ($this->isModified() && !$this->isColumnModified(HeadlineTagPeer::UPDATED_AT)) {
                    $this->setUpdatedAt(time());
                }
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                HeadlineTagPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->headlinesScheduledForDeletion !== null) {
                if (!$this->headlinesScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->headlinesScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    HeadlineTagRelationQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->headlinesScheduledForDeletion = null;
                }

                foreach ($this->getHeadlines() as $headline) {
                    if ($headline->isModified()) {
                        $headline->save($con);
                    }
                }
            }

            if ($this->headlineTagRelationsScheduledForDeletion !== null) {
                if (!$this->headlineTagRelationsScheduledForDeletion->isEmpty()) {
                    HeadlineTagRelationQuery::create()
                        ->filterByPrimaryKeys($this->headlineTagRelationsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->headlineTagRelationsScheduledForDeletion = null;
                }
            }

            if ($this->collHeadlineTagRelations !== null) {
                foreach ($this->collHeadlineTagRelations as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = HeadlineTagPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . HeadlineTagPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(HeadlineTagPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(HeadlineTagPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(HeadlineTagPeer::CREATED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`CREATED_AT`';
        }
        if ($this->isColumnModified(HeadlineTagPeer::UPDATED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`UPDATED_AT`';
        }

        $sql = sprintf(
            'INSERT INTO `headlines_tag` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`CREATED_AT`':
                        $stmt->bindValue($identifier, $this->created_at, PDO::PARAM_STR);
                        break;
                    case '`UPDATED_AT`':
                        $stmt->bindValue($identifier, $this->updated_at, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            if (($retval = HeadlineTagPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collHeadlineTagRelations !== null) {
                    foreach ($this->collHeadlineTagRelations as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = HeadlineTagPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getName();
                break;
            case 2:
                return $this->getCreatedAt();
                break;
            case 3:
                return $this->getUpdatedAt();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['HeadlineTag'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['HeadlineTag'][$this->getPrimaryKey()] = true;
        $keys = HeadlineTagPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getCreatedAt(),
            $keys[3] => $this->getUpdatedAt(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->collHeadlineTagRelations) {
                $result['HeadlineTagRelations'] = $this->collHeadlineTagRelations->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = HeadlineTagPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setCreatedAt($value);
                break;
            case 3:
                $this->setUpdatedAt($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = HeadlineTagPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setName($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setCreatedAt($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setUpdatedAt($arr[$keys[3]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(HeadlineTagPeer::DATABASE_NAME);

        if ($this->isColumnModified(HeadlineTagPeer::ID)) $criteria->add(HeadlineTagPeer::ID, $this->id);
        if ($this->isColumnModified(HeadlineTagPeer::NAME)) $criteria->add(HeadlineTagPeer::NAME, $this->name);
        if ($this->isColumnModified(HeadlineTagPeer::CREATED_AT)) $criteria->add(HeadlineTagPeer::CREATED_AT, $this->created_at);
        if ($this->isColumnModified(HeadlineTagPeer::UPDATED_AT)) $criteria->add(HeadlineTagPeer::UPDATED_AT, $this->updated_at);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(HeadlineTagPeer::DATABASE_NAME);
        $criteria->add(HeadlineTagPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of HeadlineTag (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setName($this->getName());
        $copyObj->setCreatedAt($this->getCreatedAt());
        $copyObj->setUpdatedAt($this->getUpdatedAt());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getHeadlineTagRelations() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addHeadlineTagRelation($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return HeadlineTag Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return HeadlineTagPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new HeadlineTagPeer();
        }

        return self::$peer;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('HeadlineTagRelation' == $relationName) {
            $this->initHeadlineTagRelations();
        }
    }

    /**
     * Clears out the collHeadlineTagRelations collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addHeadlineTagRelations()
     */
    public function clearHeadlineTagRelations()
    {
        $this->collHeadlineTagRelations = null; // important to set this to null since that means it is uninitialized
        $this->collHeadlineTagRelationsPartial = null;
    }

    /**
     * reset is the collHeadlineTagRelations collection loaded partially
     *
     * @return void
     */
    public function resetPartialHeadlineTagRelations($v = true)
    {
        $this->collHeadlineTagRelationsPartial = $v;
    }

    /**
     * Initializes the collHeadlineTagRelations collection.
     *
     * By default this just sets the collHeadlineTagRelations collection to an empty array (like clearcollHeadlineTagRelations());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initHeadlineTagRelations($overrideExisting = true)
    {
        if (null !== $this->collHeadlineTagRelations && !$overrideExisting) {
            return;
        }
        $this->collHeadlineTagRelations = new PropelObjectCollection();
        $this->collHeadlineTagRelations->setModel('HeadlineTagRelation');
    }

    /**
     * Gets an array of HeadlineTagRelation objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this HeadlineTag is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|HeadlineTagRelation[] List of HeadlineTagRelation objects
     * @throws PropelException
     */
    public function getHeadlineTagRelations($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collHeadlineTagRelationsPartial && !$this->isNew();
        if (null === $this->collHeadlineTagRelations || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collHeadlineTagRelations) {
                // return empty collection
                $this->initHeadlineTagRelations();
            } else {
                $collHeadlineTagRelations = HeadlineTagRelationQuery::create(null, $criteria)
                    ->filterByHeadlineTag($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collHeadlineTagRelationsPartial && count($collHeadlineTagRelations)) {
                      $this->initHeadlineTagRelations(false);

                      foreach($collHeadlineTagRelations as $obj) {
                        if (false == $this->collHeadlineTagRelations->contains($obj)) {
                          $this->collHeadlineTagRelations->append($obj);
                        }
                      }

                      $this->collHeadlineTagRelationsPartial = true;
                    }

                    return $collHeadlineTagRelations;
                }

                if($partial && $this->collHeadlineTagRelations) {
                    foreach($this->collHeadlineTagRelations as $obj) {
                        if($obj->isNew()) {
                            $collHeadlineTagRelations[] = $obj;
                        }
                    }
                }

                $this->collHeadlineTagRelations = $collHeadlineTagRelations;
                $this->collHeadlineTagRelationsPartial = false;
            }
        }

        return $this->collHeadlineTagRelations;
    }

    /**
     * Sets a collection of HeadlineTagRelation objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $headlineTagRelations A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setHeadlineTagRelations(PropelCollection $headlineTagRelations, PropelPDO $con = null)
    {
        $this->headlineTagRelationsScheduledForDeletion = $this->getHeadlineTagRelations(new Criteria(), $con)->diff($headlineTagRelations);

        foreach ($this->headlineTagRelationsScheduledForDeletion as $headlineTagRelationRemoved) {
            $headlineTagRelationRemoved->setHeadlineTag(null);
        }

        $this->collHeadlineTagRelations = null;
        foreach ($headlineTagRelations as $headlineTagRelation) {
            $this->addHeadlineTagRelation($headlineTagRelation);
        }

        $this->collHeadlineTagRelations = $headlineTagRelations;
        $this->collHeadlineTagRelationsPartial = false;
    }

    /**
     * Returns the number of related HeadlineTagRelation objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related HeadlineTagRelation objects.
     * @throws PropelException
     */
    public function countHeadlineTagRelations(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collHeadlineTagRelationsPartial && !$this->isNew();
        if (null === $this->collHeadlineTagRelations || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collHeadlineTagRelations) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getHeadlineTagRelations());
                }
                $query = HeadlineTagRelationQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByHeadlineTag($this)
                    ->count($con);
            }
        } else {
            return count($this->collHeadlineTagRelations);
        }
    }

    /**
     * Method called to associate a HeadlineTagRelation object to this object
     * through the HeadlineTagRelation foreign key attribute.
     *
     * @param    HeadlineTagRelation $l HeadlineTagRelation
     * @return HeadlineTag The current object (for fluent API support)
     */
    public function addHeadlineTagRelation(HeadlineTagRelation $l)
    {
        if ($this->collHeadlineTagRelations === null) {
            $this->initHeadlineTagRelations();
            $this->collHeadlineTagRelationsPartial = true;
        }
        if (!$this->collHeadlineTagRelations->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddHeadlineTagRelation($l);
        }

        return $this;
    }

    /**
     * @param	HeadlineTagRelation $headlineTagRelation The headlineTagRelation object to add.
     */
    protected function doAddHeadlineTagRelation($headlineTagRelation)
    {
        $this->collHeadlineTagRelations[]= $headlineTagRelation;
        $headlineTagRelation->setHeadlineTag($this);
    }

    /**
     * @param	HeadlineTagRelation $headlineTagRelation The headlineTagRelation object to remove.
     */
    public function removeHeadlineTagRelation($headlineTagRelation)
    {
        if ($this->getHeadlineTagRelations()->contains($headlineTagRelation)) {
            $this->collHeadlineTagRelations->remove($this->collHeadlineTagRelations->search($headlineTagRelation));
            if (null === $this->headlineTagRelationsScheduledForDeletion) {
                $this->headlineTagRelationsScheduledForDeletion = clone $this->collHeadlineTagRelations;
                $this->headlineTagRelationsScheduledForDeletion->clear();
            }
            $this->headlineTagRelationsScheduledForDeletion[]= $headlineTagRelation;
            $headlineTagRelation->setHeadlineTag(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this HeadlineTag is new, it will return
     * an empty collection; or if this HeadlineTag has previously
     * been saved, it will retrieve related HeadlineTagRelations from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in HeadlineTag.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|HeadlineTagRelation[] List of HeadlineTagRelation objects
     */
    public function getHeadlineTagRelationsJoinHeadline($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = HeadlineTagRelationQuery::create(null, $criteria);
        $query->joinWith('Headline', $join_behavior);

        return $this->getHeadlineTagRelations($query, $con);
    }

    /**
     * Clears out the collHeadlines collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addHeadlines()
     */
    public function clearHeadlines()
    {
        $this->collHeadlines = null; // important to set this to null since that means it is uninitialized
        $this->collHeadlinesPartial = null;
    }

    /**
     * Initializes the collHeadlines collection.
     *
     * By default this just sets the collHeadlines collection to an empty collection (like clearHeadlines());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initHeadlines()
    {
        $this->collHeadlines = new PropelObjectCollection();
        $this->collHeadlines->setModel('Headline');
    }

    /**
     * Gets a collection of Headline objects related by a many-to-many relationship
     * to the current object by way of the headlines_headlineTags cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this HeadlineTag is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Headline[] List of Headline objects
     */
    public function getHeadlines($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collHeadlines || null !== $criteria) {
            if ($this->isNew() && null === $this->collHeadlines) {
                // return empty collection
                $this->initHeadlines();
            } else {
                $collHeadlines = HeadlineQuery::create(null, $criteria)
                    ->filterByHeadlineTag($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collHeadlines;
                }
                $this->collHeadlines = $collHeadlines;
            }
        }

        return $this->collHeadlines;
    }

    /**
     * Sets a collection of Headline objects related by a many-to-many relationship
     * to the current object by way of the headlines_headlineTags cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $headlines A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setHeadlines(PropelCollection $headlines, PropelPDO $con = null)
    {
        $this->clearHeadlines();
        $currentHeadlines = $this->getHeadlines();

        $this->headlinesScheduledForDeletion = $currentHeadlines->diff($headlines);

        foreach ($headlines as $headline) {
            if (!$currentHeadlines->contains($headline)) {
                $this->doAddHeadline($headline);
            }
        }

        $this->collHeadlines = $headlines;
    }

    /**
     * Gets the number of Headline objects related by a many-to-many relationship
     * to the current object by way of the headlines_headlineTags cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Headline objects
     */
    public function countHeadlines($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collHeadlines || null !== $criteria) {
            if ($this->isNew() && null === $this->collHeadlines) {
                return 0;
            } else {
                $query = HeadlineQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByHeadlineTag($this)
                    ->count($con);
            }
        } else {
            return count($this->collHeadlines);
        }
    }

    /**
     * Associate a Headline object to this object
     * through the headlines_headlineTags cross reference table.
     *
     * @param  Headline $headline The HeadlineTagRelation object to relate
     * @return void
     */
    public function addHeadline(Headline $headline)
    {
        if ($this->collHeadlines === null) {
            $this->initHeadlines();
        }
        if (!$this->collHeadlines->contains($headline)) { // only add it if the **same** object is not already associated
            $this->doAddHeadline($headline);

            $this->collHeadlines[]= $headline;
        }
    }

    /**
     * @param	Headline $headline The headline object to add.
     */
    protected function doAddHeadline($headline)
    {
        $headlineTagRelation = new HeadlineTagRelation();
        $headlineTagRelation->setHeadline($headline);
        $this->addHeadlineTagRelation($headlineTagRelation);
    }

    /**
     * Remove a Headline object to this object
     * through the headlines_headlineTags cross reference table.
     *
     * @param Headline $headline The HeadlineTagRelation object to relate
     * @return void
     */
    public function removeHeadline(Headline $headline)
    {
        if ($this->getHeadlines()->contains($headline)) {
            $this->collHeadlines->remove($this->collHeadlines->search($headline));
            if (null === $this->headlinesScheduledForDeletion) {
                $this->headlinesScheduledForDeletion = clone $this->collHeadlines;
                $this->headlinesScheduledForDeletion->clear();
            }
            $this->headlinesScheduledForDeletion[]= $headline;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->created_at = null;
        $this->updated_at = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collHeadlineTagRelations) {
                foreach ($this->collHeadlineTagRelations as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collHeadlines) {
                foreach ($this->collHeadlines as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collHeadlineTagRelations instanceof PropelCollection) {
            $this->collHeadlineTagRelations->clearIterator();
        }
        $this->collHeadlineTagRelations = null;
        if ($this->collHeadlines instanceof PropelCollection) {
            $this->collHeadlines->clearIterator();
        }
        $this->collHeadlines = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // timestampable behavior

    /**
     * Mark the current object so that the update date doesn't get updated during next save
     *
     * @return     HeadlineTag The current object (for fluent API support)
     */
    public function keepUpdateDateUnchanged()
    {
        $this->modifiedColumns[] = HeadlineTagPeer::UPDATED_AT;

        return $this;
    }

}
