<?php


/**
 * Base class that represents a query for the 'headlines_issue' table.
 *
 * Headlines / Issues
 *
 * @method HeadlineIssueQuery orderByHeadlineid($order = Criteria::ASC) Order by the headlineId column
 * @method HeadlineIssueQuery orderByIssueid($order = Criteria::ASC) Order by the issueId column
 *
 * @method HeadlineIssueQuery groupByHeadlineid() Group by the headlineId column
 * @method HeadlineIssueQuery groupByIssueid() Group by the issueId column
 *
 * @method HeadlineIssueQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method HeadlineIssueQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method HeadlineIssueQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method HeadlineIssueQuery leftJoinHeadline($relationAlias = null) Adds a LEFT JOIN clause to the query using the Headline relation
 * @method HeadlineIssueQuery rightJoinHeadline($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Headline relation
 * @method HeadlineIssueQuery innerJoinHeadline($relationAlias = null) Adds a INNER JOIN clause to the query using the Headline relation
 *
 * @method HeadlineIssueQuery leftJoinIssue($relationAlias = null) Adds a LEFT JOIN clause to the query using the Issue relation
 * @method HeadlineIssueQuery rightJoinIssue($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Issue relation
 * @method HeadlineIssueQuery innerJoinIssue($relationAlias = null) Adds a INNER JOIN clause to the query using the Issue relation
 *
 * @method HeadlineIssue findOne(PropelPDO $con = null) Return the first HeadlineIssue matching the query
 * @method HeadlineIssue findOneOrCreate(PropelPDO $con = null) Return the first HeadlineIssue matching the query, or a new HeadlineIssue object populated from the query conditions when no match is found
 *
 * @method HeadlineIssue findOneByHeadlineid(int $headlineId) Return the first HeadlineIssue filtered by the headlineId column
 * @method HeadlineIssue findOneByIssueid(int $issueId) Return the first HeadlineIssue filtered by the issueId column
 *
 * @method array findByHeadlineid(int $headlineId) Return HeadlineIssue objects filtered by the headlineId column
 * @method array findByIssueid(int $issueId) Return HeadlineIssue objects filtered by the issueId column
 *
 * @package    propel.generator.headlines.classes.om
 */
abstract class BaseHeadlineIssueQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseHeadlineIssueQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'HeadlineIssue', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new HeadlineIssueQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     HeadlineIssueQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return HeadlineIssueQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof HeadlineIssueQuery) {
            return $criteria;
        }
        $query = new HeadlineIssueQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$headlineId, $issueId]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   HeadlineIssue|HeadlineIssue[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = HeadlineIssuePeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(HeadlineIssuePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   HeadlineIssue A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `HEADLINEID`, `ISSUEID` FROM `headlines_issue` WHERE `HEADLINEID` = :p0 AND `ISSUEID` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new HeadlineIssue();
            $obj->hydrate($row);
            HeadlineIssuePeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return HeadlineIssue|HeadlineIssue[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|HeadlineIssue[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return HeadlineIssueQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(HeadlineIssuePeer::HEADLINEID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(HeadlineIssuePeer::ISSUEID, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return HeadlineIssueQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(HeadlineIssuePeer::HEADLINEID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(HeadlineIssuePeer::ISSUEID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the headlineId column
     *
     * Example usage:
     * <code>
     * $query->filterByHeadlineid(1234); // WHERE headlineId = 1234
     * $query->filterByHeadlineid(array(12, 34)); // WHERE headlineId IN (12, 34)
     * $query->filterByHeadlineid(array('min' => 12)); // WHERE headlineId > 12
     * </code>
     *
     * @see       filterByHeadline()
     *
     * @param     mixed $headlineid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineIssueQuery The current query, for fluid interface
     */
    public function filterByHeadlineid($headlineid = null, $comparison = null)
    {
        if (is_array($headlineid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(HeadlineIssuePeer::HEADLINEID, $headlineid, $comparison);
    }

    /**
     * Filter the query on the issueId column
     *
     * Example usage:
     * <code>
     * $query->filterByIssueid(1234); // WHERE issueId = 1234
     * $query->filterByIssueid(array(12, 34)); // WHERE issueId IN (12, 34)
     * $query->filterByIssueid(array('min' => 12)); // WHERE issueId > 12
     * </code>
     *
     * @see       filterByIssue()
     *
     * @param     mixed $issueid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineIssueQuery The current query, for fluid interface
     */
    public function filterByIssueid($issueid = null, $comparison = null)
    {
        if (is_array($issueid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(HeadlineIssuePeer::ISSUEID, $issueid, $comparison);
    }

    /**
     * Filter the query by a related Headline object
     *
     * @param   Headline|PropelObjectCollection $headline The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   HeadlineIssueQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByHeadline($headline, $comparison = null)
    {
        if ($headline instanceof Headline) {
            return $this
                ->addUsingAlias(HeadlineIssuePeer::HEADLINEID, $headline->getId(), $comparison);
        } elseif ($headline instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(HeadlineIssuePeer::HEADLINEID, $headline->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByHeadline() only accepts arguments of type Headline or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Headline relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return HeadlineIssueQuery The current query, for fluid interface
     */
    public function joinHeadline($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Headline');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Headline');
        }

        return $this;
    }

    /**
     * Use the Headline relation Headline object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   HeadlineQuery A secondary query class using the current class as primary query
     */
    public function useHeadlineQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinHeadline($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Headline', 'HeadlineQuery');
    }

    /**
     * Filter the query by a related Issue object
     *
     * @param   Issue|PropelObjectCollection $issue The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   HeadlineIssueQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIssue($issue, $comparison = null)
    {
        if ($issue instanceof Issue) {
            return $this
                ->addUsingAlias(HeadlineIssuePeer::ISSUEID, $issue->getId(), $comparison);
        } elseif ($issue instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(HeadlineIssuePeer::ISSUEID, $issue->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByIssue() only accepts arguments of type Issue or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Issue relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return HeadlineIssueQuery The current query, for fluid interface
     */
    public function joinIssue($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Issue');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Issue');
        }

        return $this;
    }

    /**
     * Use the Issue relation Issue object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IssueQuery A secondary query class using the current class as primary query
     */
    public function useIssueQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinIssue($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Issue', 'IssueQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   HeadlineIssue $headlineIssue Object to remove from the list of results
     *
     * @return HeadlineIssueQuery The current query, for fluid interface
     */
    public function prune($headlineIssue = null)
    {
        if ($headlineIssue) {
            $this->addCond('pruneCond0', $this->getAliasedColName(HeadlineIssuePeer::HEADLINEID), $headlineIssue->getHeadlineid(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(HeadlineIssuePeer::ISSUEID), $headlineIssue->getIssueid(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // aggregate_column_relation behavior
        $this->findRelatedHeadlines($con);

        return $this->preDelete($con);
    }

    /**
     * Code to execute after every DELETE statement
     *
     * @param     int $affectedRows the number of deleted rows
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePostDelete($affectedRows, PropelPDO $con)
    {
        // aggregate_column_relation behavior
        $this->updateRelatedHeadlines($con);

        return $this->postDelete($affectedRows, $con);
    }

    /**
     * Code to execute before every UPDATE statement
     *
     * @param     array $values The associatiove array of columns and values for the update
     * @param     PropelPDO $con The connection object used by the query
     * @param     boolean $forceIndividualSaves If false (default), the resulting call is a BasePeer::doUpdate(), ortherwise it is a series of save() calls on all the found objects
     */
    protected function basePreUpdate(&$values, PropelPDO $con, $forceIndividualSaves = false)
    {
        // aggregate_column_relation behavior
        $this->findRelatedHeadlines($con);

        return $this->preUpdate($values, $con, $forceIndividualSaves);
    }

    /**
     * Code to execute after every UPDATE statement
     *
     * @param     int $affectedRows the number of udated rows
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePostUpdate($affectedRows, PropelPDO $con)
    {
        // aggregate_column_relation behavior
        $this->updateRelatedHeadlines($con);

        return $this->postUpdate($affectedRows, $con);
    }

    // aggregate_column_relation behavior

    /**
     * Finds the related Headline objects and keep them for later
     *
     * @param PropelPDO $con A connection object
     */
    protected function findRelatedHeadlines($con)
    {
        $criteria = clone $this;
        if ($this->useAliasInSQL) {
            $alias = $this->getModelAlias();
            $criteria->removeAlias($alias);
        } else {
            $alias = '';
        }
        $this->headlines = HeadlineQuery::create()
            ->joinHeadlineIssue($alias)
            ->mergeWith($criteria)
            ->find($con);
    }

    protected function updateRelatedHeadlines($con)
    {
        foreach ($this->headlines as $headline) {
            $headline->updateIssuescount($con);
        }
        $this->headlines = array();
    }

}
