<?php


/**
 * Base class that represents a query for the 'headlines_actor' table.
 *
 * Headlines / Actors
 *
 * @method HeadlineActorQuery orderByHeadlineid($order = Criteria::ASC) Order by the headlineId column
 * @method HeadlineActorQuery orderByActorid($order = Criteria::ASC) Order by the actorId column
 * @method HeadlineActorQuery orderByActortype($order = Criteria::ASC) Order by the actorType column
 * @method HeadlineActorQuery orderByRole($order = Criteria::ASC) Order by the role column
 *
 * @method HeadlineActorQuery groupByHeadlineid() Group by the headlineId column
 * @method HeadlineActorQuery groupByActorid() Group by the actorId column
 * @method HeadlineActorQuery groupByActortype() Group by the actorType column
 * @method HeadlineActorQuery groupByRole() Group by the role column
 *
 * @method HeadlineActorQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method HeadlineActorQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method HeadlineActorQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method HeadlineActorQuery leftJoinHeadline($relationAlias = null) Adds a LEFT JOIN clause to the query using the Headline relation
 * @method HeadlineActorQuery rightJoinHeadline($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Headline relation
 * @method HeadlineActorQuery innerJoinHeadline($relationAlias = null) Adds a INNER JOIN clause to the query using the Headline relation
 *
 * @method HeadlineActorQuery leftJoinActor($relationAlias = null) Adds a LEFT JOIN clause to the query using the Actor relation
 * @method HeadlineActorQuery rightJoinActor($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Actor relation
 * @method HeadlineActorQuery innerJoinActor($relationAlias = null) Adds a INNER JOIN clause to the query using the Actor relation
 *
 * @method HeadlineActor findOne(PropelPDO $con = null) Return the first HeadlineActor matching the query
 * @method HeadlineActor findOneOrCreate(PropelPDO $con = null) Return the first HeadlineActor matching the query, or a new HeadlineActor object populated from the query conditions when no match is found
 *
 * @method HeadlineActor findOneByHeadlineid(int $headlineId) Return the first HeadlineActor filtered by the headlineId column
 * @method HeadlineActor findOneByActorid(int $actorId) Return the first HeadlineActor filtered by the actorId column
 * @method HeadlineActor findOneByActortype(int $actorType) Return the first HeadlineActor filtered by the actorType column
 * @method HeadlineActor findOneByRole(int $role) Return the first HeadlineActor filtered by the role column
 *
 * @method array findByHeadlineid(int $headlineId) Return HeadlineActor objects filtered by the headlineId column
 * @method array findByActorid(int $actorId) Return HeadlineActor objects filtered by the actorId column
 * @method array findByActortype(int $actorType) Return HeadlineActor objects filtered by the actorType column
 * @method array findByRole(int $role) Return HeadlineActor objects filtered by the role column
 *
 * @package    propel.generator.headlines.classes.om
 */
abstract class BaseHeadlineActorQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseHeadlineActorQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'HeadlineActor', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new HeadlineActorQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     HeadlineActorQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return HeadlineActorQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof HeadlineActorQuery) {
            return $criteria;
        }
        $query = new HeadlineActorQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34, 56), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$headlineId, $actorId, $actorType]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   HeadlineActor|HeadlineActor[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = HeadlineActorPeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1], (string) $key[2]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(HeadlineActorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   HeadlineActor A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `HEADLINEID`, `ACTORID`, `ACTORTYPE`, `ROLE` FROM `headlines_actor` WHERE `HEADLINEID` = :p0 AND `ACTORID` = :p1 AND `ACTORTYPE` = :p2';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->bindValue(':p2', $key[2], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new HeadlineActor();
            $obj->hydrate($row);
            HeadlineActorPeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1], (string) $key[2])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return HeadlineActor|HeadlineActor[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|HeadlineActor[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return HeadlineActorQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(HeadlineActorPeer::HEADLINEID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(HeadlineActorPeer::ACTORID, $key[1], Criteria::EQUAL);
        $this->addUsingAlias(HeadlineActorPeer::ACTORTYPE, $key[2], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return HeadlineActorQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(HeadlineActorPeer::HEADLINEID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(HeadlineActorPeer::ACTORID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $cton2 = $this->getNewCriterion(HeadlineActorPeer::ACTORTYPE, $key[2], Criteria::EQUAL);
            $cton0->addAnd($cton2);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the headlineId column
     *
     * Example usage:
     * <code>
     * $query->filterByHeadlineid(1234); // WHERE headlineId = 1234
     * $query->filterByHeadlineid(array(12, 34)); // WHERE headlineId IN (12, 34)
     * $query->filterByHeadlineid(array('min' => 12)); // WHERE headlineId > 12
     * </code>
     *
     * @see       filterByHeadline()
     *
     * @param     mixed $headlineid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineActorQuery The current query, for fluid interface
     */
    public function filterByHeadlineid($headlineid = null, $comparison = null)
    {
        if (is_array($headlineid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(HeadlineActorPeer::HEADLINEID, $headlineid, $comparison);
    }

    /**
     * Filter the query on the actorId column
     *
     * Example usage:
     * <code>
     * $query->filterByActorid(1234); // WHERE actorId = 1234
     * $query->filterByActorid(array(12, 34)); // WHERE actorId IN (12, 34)
     * $query->filterByActorid(array('min' => 12)); // WHERE actorId > 12
     * </code>
     *
     * @see       filterByActor()
     *
     * @param     mixed $actorid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineActorQuery The current query, for fluid interface
     */
    public function filterByActorid($actorid = null, $comparison = null)
    {
        if (is_array($actorid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(HeadlineActorPeer::ACTORID, $actorid, $comparison);
    }

    /**
     * Filter the query on the actorType column
     *
     * Example usage:
     * <code>
     * $query->filterByActortype(1234); // WHERE actorType = 1234
     * $query->filterByActortype(array(12, 34)); // WHERE actorType IN (12, 34)
     * $query->filterByActortype(array('min' => 12)); // WHERE actorType > 12
     * </code>
     *
     * @param     mixed $actortype The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineActorQuery The current query, for fluid interface
     */
    public function filterByActortype($actortype = null, $comparison = null)
    {
        if (is_array($actortype) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(HeadlineActorPeer::ACTORTYPE, $actortype, $comparison);
    }

    /**
     * Filter the query on the role column
     *
     * Example usage:
     * <code>
     * $query->filterByRole(1234); // WHERE role = 1234
     * $query->filterByRole(array(12, 34)); // WHERE role IN (12, 34)
     * $query->filterByRole(array('min' => 12)); // WHERE role > 12
     * </code>
     *
     * @param     mixed $role The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineActorQuery The current query, for fluid interface
     */
    public function filterByRole($role = null, $comparison = null)
    {
        if (is_array($role)) {
            $useMinMax = false;
            if (isset($role['min'])) {
                $this->addUsingAlias(HeadlineActorPeer::ROLE, $role['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($role['max'])) {
                $this->addUsingAlias(HeadlineActorPeer::ROLE, $role['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlineActorPeer::ROLE, $role, $comparison);
    }

    /**
     * Filter the query by a related Headline object
     *
     * @param   Headline|PropelObjectCollection $headline The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   HeadlineActorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByHeadline($headline, $comparison = null)
    {
        if ($headline instanceof Headline) {
            return $this
                ->addUsingAlias(HeadlineActorPeer::HEADLINEID, $headline->getId(), $comparison);
        } elseif ($headline instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(HeadlineActorPeer::HEADLINEID, $headline->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByHeadline() only accepts arguments of type Headline or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Headline relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return HeadlineActorQuery The current query, for fluid interface
     */
    public function joinHeadline($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Headline');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Headline');
        }

        return $this;
    }

    /**
     * Use the Headline relation Headline object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   HeadlineQuery A secondary query class using the current class as primary query
     */
    public function useHeadlineQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinHeadline($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Headline', 'HeadlineQuery');
    }

    /**
     * Filter the query by a related Actor object
     *
     * @param   Actor|PropelObjectCollection $actor The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   HeadlineActorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByActor($actor, $comparison = null)
    {
        if ($actor instanceof Actor) {
            return $this
                ->addUsingAlias(HeadlineActorPeer::ACTORID, $actor->getId(), $comparison);
        } elseif ($actor instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(HeadlineActorPeer::ACTORID, $actor->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByActor() only accepts arguments of type Actor or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Actor relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return HeadlineActorQuery The current query, for fluid interface
     */
    public function joinActor($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Actor');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Actor');
        }

        return $this;
    }

    /**
     * Use the Actor relation Actor object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ActorQuery A secondary query class using the current class as primary query
     */
    public function useActorQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinActor($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Actor', 'ActorQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   HeadlineActor $headlineActor Object to remove from the list of results
     *
     * @return HeadlineActorQuery The current query, for fluid interface
     */
    public function prune($headlineActor = null)
    {
        if ($headlineActor) {
            $this->addCond('pruneCond0', $this->getAliasedColName(HeadlineActorPeer::HEADLINEID), $headlineActor->getHeadlineid(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(HeadlineActorPeer::ACTORID), $headlineActor->getActorid(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond2', $this->getAliasedColName(HeadlineActorPeer::ACTORTYPE), $headlineActor->getActortype(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1', 'pruneCond2'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

}
