<?php

class HeadlinesCampaignsReportViewAction extends BaseSelectAction {
	
	function __construct() {
		parent::__construct('Campaign');
	}
	
	protected function postSelect() {
		parent::postSelect();

		if(is_object($this->entity)){
			$headlinesFilters['campaignId'] = $this->entity->getId();

			// obtengo el total de tweets para avisale al usuario en caso de que con los filtros no se obtengan datos
			$campaignHeadlinesCount = HeadlineQuery::create()->filterByCampaignId($headlinesFilters['campaignId'])->count();

			// si en la campaign hay tweets opero normalmente
			if($campaignHeadlinesCount > 0){
				// por defecto busco entre los limites de la campaign
				$headlinesFilters['from'] = Common::getDatetimeOnGMT(date('Y-m-d H:i:s',strtotime($this->entity->getStartdate())));
				$headlinesFilters['to'] = Common::getDatetimeOnGMT(date('Y-m-d H:i:s',strtotime($this->entity->getFinishdate())));
				
				// cuento cantidad de tweets en rango
				$tweetsInRange = TwitterTweetQuery::create()
					->filterByCampaignId($headlinesFilters['campaignId'])
					->filterByCreatedat(array('min' => $headlinesFilters['from'],'max' => $headlinesFilters['to']))
					->count();

				// si en el rango por defecto no hay tweets el rango sera del primer tweet a hoy
				if($tweetsInRange == 0){
					$firstTweet = TwitterTweetQuery::create()
					->filterByCampaignId($headlinesFilters['campaignId'])
					->orderByCreatedat('asc')
					->findOne();

					if(is_object($firstTweet)){
						$headlinesFilters['from'] = Common::getDatetimeOnGMT(date('Y-m-d H:i:s',strtotime($firstTweet->getCreatedat())));
						$headlinesFilters['to'] = Common::getDatetimeOnGMT(date('Y-m-d H:i:s'));		
					}
				}
				// FIN FILTERS SET

				// obtengo titulares por valor y relevancia
				$byValue = Headline::getAllByValue($headlinesFilters);
				foreach($byValue as $date) {
					unset($date['date']);
					$byValueTotal += array_sum($date);
				}

				$byRelevance = Headline::getAllByRelevance($headlinesFilters);
				foreach($byRelevance as $date) {
					unset($date['date']);
					$byRelevanceTotal += array_sum($date);
				}
		
				$this->smarty->assign('byValue', $byValue);
				$this->smarty->assign('byValueTotal', $byValueTotal);
				$this->smarty->assign('byRelevance', $byRelevance);
				$this->smarty->assign('byRelevanceTotal', $byRelevanceTotal);

				if($byValueTotal > 0 || $byRelevanceTotal > 0){
					
					$byGender = TwitterTweetQuery::getAllByGender($headlinesFilters);
					$this->smarty->assign('byGender', $byGender);

					// obtengo los usuarios que mas tweets crearon
					$topUsers = TwitterUserQuery::getTopUsers($headlinesFilters, 5);
					$influentialUsers = TwitterUserQuery::getInfluentialUsers($headlinesFilters);
					
					$vennData = TwitterTweetQuery::getVennData($headlinesFilters);
					$tweetsAmount = TwitterTweetQuery::getCombinations($headlinesFilters);

					$this->smarty->assign('topUsers', $topUsers);
					$this->smarty->assign('influentialUsers', $influentialUsers);
					$this->smarty->assign('vennData', $vennData);
					$this->smarty->assign('tweetsAmount', $tweetsAmount);
					$this->smarty->assign('treemapAmount', TwitterTweetQuery::getCombinationsTreemap($headlinesFilters));
					
					/* Tendencias personalizadas */
					$treemapInfo = array();
					$personalTrends = TwitterTweet::getPersonalTrends($headlinesFilters, $treemapInfo);
					$this->smarty->assign('personalTrends',$personalTrends);
					$dailyPersonalTrends = TwitterTweet::dailyPersonalTrends($headlinesFilters, $personalTrends);
					$this->smarty->assign('dailyPersonalTrends',json_encode($dailyPersonalTrends));
					$dailyTweets = TwitterTweet::dailyTweets($headlinesFilters);
					$this->smarty->assign('dailyTweets',json_encode($dailyTweets));
					$this->smarty->assign('treemapPersonalTrends',json_encode($treemapInfo));
					
					$this->smarty->assign('headlinesCount',$campaignHeadlinesCount);

				}// FIN HAY VAL O REL
				else{
					// si no se obtuvieron tweets con los filtros
					if($campaignHeadlinesCount > 0){
						$this->smarty->assign('availableTweets',true);
						$this->smarty->assign('totalTweets', $campaignHeadlinesCount);
					}
				}
			}// FIN HAY T
			else
				$this->smarty->assign('availableTweets',false);

			// posibles valores y relevancias para los filtros
			$this->smarty->assign("tweetValues",TwitterTweet::getValues());
			$this->smarty->assign("tweetRelevances",TwitterTweet::getRelevances());
			$this->smarty->assign("from",$headlinesFilters['from']);
			$this->smarty->assign("to",$headlinesFilters['to']);

			$this->smarty->assign("headlinesFilters", $headlinesFilters);

		}// FIN OBJ
		$moduleConfig = Common::getModuleConfiguration($this->module);
	}
	
}