<?php


/**
 * Base class that represents a query for the 'documents_keyWord' table.
 *
 * Palabras clave de documentos
 *
 * @method DocumentKeyWordQuery orderById($order = Criteria::ASC) Order by the id column
 * @method DocumentKeyWordQuery orderByKeyword($order = Criteria::ASC) Order by the keyWord column
 *
 * @method DocumentKeyWordQuery groupById() Group by the id column
 * @method DocumentKeyWordQuery groupByKeyword() Group by the keyWord column
 *
 * @method DocumentKeyWordQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method DocumentKeyWordQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method DocumentKeyWordQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method DocumentKeyWord findOne(PropelPDO $con = null) Return the first DocumentKeyWord matching the query
 * @method DocumentKeyWord findOneOrCreate(PropelPDO $con = null) Return the first DocumentKeyWord matching the query, or a new DocumentKeyWord object populated from the query conditions when no match is found
 *
 * @method DocumentKeyWord findOneById(int $id) Return the first DocumentKeyWord filtered by the id column
 * @method DocumentKeyWord findOneByKeyword(string $keyWord) Return the first DocumentKeyWord filtered by the keyWord column
 *
 * @method array findById(int $id) Return DocumentKeyWord objects filtered by the id column
 * @method array findByKeyword(string $keyWord) Return DocumentKeyWord objects filtered by the keyWord column
 *
 * @package    propel.generator.documents.classes.om
 */
abstract class BaseDocumentKeyWordQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseDocumentKeyWordQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'DocumentKeyWord', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new DocumentKeyWordQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     DocumentKeyWordQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return DocumentKeyWordQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof DocumentKeyWordQuery) {
            return $criteria;
        }
        $query = new DocumentKeyWordQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   DocumentKeyWord|DocumentKeyWord[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = DocumentKeyWordPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(DocumentKeyWordPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   DocumentKeyWord A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `KEYWORD` FROM `documents_keyWord` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new DocumentKeyWord();
            $obj->hydrate($row);
            DocumentKeyWordPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return DocumentKeyWord|DocumentKeyWord[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|DocumentKeyWord[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return DocumentKeyWordQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(DocumentKeyWordPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return DocumentKeyWordQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(DocumentKeyWordPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return DocumentKeyWordQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(DocumentKeyWordPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the keyWord column
     *
     * Example usage:
     * <code>
     * $query->filterByKeyword('fooValue');   // WHERE keyWord = 'fooValue'
     * $query->filterByKeyword('%fooValue%'); // WHERE keyWord LIKE '%fooValue%'
     * </code>
     *
     * @param     string $keyword The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return DocumentKeyWordQuery The current query, for fluid interface
     */
    public function filterByKeyword($keyword = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($keyword)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $keyword)) {
                $keyword = str_replace('*', '%', $keyword);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(DocumentKeyWordPeer::KEYWORD, $keyword, $comparison);
    }

    /**
     * Exclude object from result
     *
     * @param   DocumentKeyWord $documentKeyWord Object to remove from the list of results
     *
     * @return DocumentKeyWordQuery The current query, for fluid interface
     */
    public function prune($documentKeyWord = null)
    {
        if ($documentKeyWord) {
            $this->addUsingAlias(DocumentKeyWordPeer::ID, $documentKeyWord->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
