|-$yearPickerMin = 2000-|
|-$yearPickerMax = 2050-|
|-$monthPickerMin = 1-|
|-$monthPickerMax = 12-|

<style>
	.exceeded {
		color: red;
	}

	tfoot td {
		text-align: right;
	}
</style>

<div id="progressRecordMsgField"></div>
|-if !$show && !$showLog-|
	<script language="JavaScript" type="text/JavaScript">
		function addProgressRecord(a) {
			var div = $$("#progressRecordEdit div:first")[0];
			$(a).insert({
				before: "<div>"+div.innerHTML+"</div>"
			});
			return false;
		}

		function addProgressRecordRow() {

			var lastTr = $('#progressRecordsTbody tr:last');
			if (lastTr.length > 0) {

				var lastTrMonthStr = lastTr.find('[name$="[month]"]').val();
				var lastTrYearStr = lastTr.find('[name$="[year]"]').val();

				if (lastTrMonthStr != '' && lastTrYearStr != '') {

					var lastTrMonth = parseInt(lastTrMonthStr);
					var lastTrYear = parseInt(lastTrYearStr);
					var newTrMonth = lastTrMonth == 12 ? 1 : (lastTrMonth + 1);
					var newTrYear = newTrMonth == 1 ? (lastTrYear + 1) : lastTrYear;

				} else {
					var newTrMonth = '';
					var newTrYear = '';
				}

			} else {
				var newTrMonth = '';
				var newTrYear = '';
			}

			var createSelectOptions = function(start, end, selected) {
				var html = '';
				for (var value = start; value <= end; value++) {
					html += '<option value="' + value + '"'
					if (value == selected) html += ' selected="selected"';
					html += '>' + value + '</option>';
				}
				return html;
			}

			var createSelectYears = function() {
				return createSelectOptions(|-$yearPickerMin-|, |-$yearPickerMax-|, newTrYear);
			}

			var createSelectMonths = function() {
				return createSelectOptions(|-$monthPickerMin-|, |-$monthPickerMax-|, newTrMonth);
			}

			var ms = new Date().getTime();
			var row = document.createElement('tr');
			html = '<tr>'
					+ '<td></td>'
					+ '<td>'
						+ '<select name="progressRecord[' + ms + '][year]" title="año">'
							+ createSelectYears()
						+ '</select>'
					+ '</td>'
					+ '<td>'
						+ '<select name="progressRecord[' + ms + '][month]" title="año">'
							+ createSelectMonths()
						+ '</select>'
					+ '</td>'
					+ '<td><input data-physical-progress onkeyup="updateTotalProgress(\'physical-progress\')" onchange="updateTotalProgress(\'physical-progress\')" name="progressRecord[' + ms + '][physicalProgress]"  id="params_physicalProgress[]" type="text" value="" style="width: 4em !Important;" class="right" title="Avance Físico en Porcentaje"> % </td>'
					+ '<td> $ <input data-financial-progress onkeyup="updateTotalProgress(\'financial-progress\')" onchange="updateTotalProgress(\'financial-progress\')" name="progressRecord[' + ms + '][financialProgress]"  id="params_financialProgress[]" type="text" value="" style="width: 8em !Important;" class="right" title="Avance Finaciero en Pesos"></td>'
					+ '<td><input data-real-physical-progress onkeyup="updateTotalProgress(\'real-physical-progress\')" onchange="updateTotalProgress(\'real-physical-progress\')" name="progressRecord[' + ms + '][realPhysicalProgress]"  id="params_physicalProgress[]" type="text" value="" style="width: 4em !Important;" class="right" title="Avance Físico real en Porcentaje"> % </td>'
					+ '<td> $ <input data-real-financial-progress onkeyup="updateTotalProgress(\'real-financial-progress\')" onchange="updateTotalProgress(\'real-financial-progress\')" name="progressRecord[' + ms + '][realFinancialProgress]"  id="params_financialProgress[]" type="text" value="" style="width: 8em !Important;" class="right" title="Avance Finaciero real en Pesos"></td>'
					+ '<td>&nbsp;</td><td>&nbsp;</td>'
					+ '<td><input name="progressRecord[' + ms + '][eol]" type="hidden" value="1"><input type="button" class="icon iconDelete disable" title="Eliminar registro" onclick="deleteProgressRow(this.parentNode.parentNode.rowIndex)" /></td>'
				+ '</tr>';
			row.innerHTML= html;
			document.getElementById("progressRecordsTbody").appendChild(row);
			return false;

		}

		function removeRecordFromConstruction(id) {

			if (!confirm('¿Desea eliminar el registro?')) return;

			$('#progressRecordMsgField').html('<span class="inProgress">Eliminando registro de avance</span>');
			$.post(
				'Main.php?do=constructionsProgressRecordDoRemoveX',
				{ id: id },
				function(data) {
					$('body').append(data);
					var row = document.getElementById('progressRecordId_'+id);
					var parent = row.parentNode;
					row.remove();
					if (parent.children.length <= 0) {
						$('#view-progress-chart-button').remove();
					}
				}
			);
			return true;
		}
	</script>
|-/if-|
<div>
	<table class="tableTdBorders" id="progressRecordsTable" cellpadding="4" cellspacing="0" style="display:block;" width="100%">
		<thead>
			|-if !$show && !$showLog-|
				<tr>
					<th colspan="10">
						|-if $showGraphButton|default:true && $progressRecords|count > 0-|
							<input type='button' id="view-progress-chart-button" onClick='location.href="Main.php?do=constructionsProgressCharts&id=|-$construction->getId()-||-include file="FiltersRedirectUrlInclude.tpl" filters=$filters-||-if isset($page)-|&page=|-$page-||-/if-|"' value='Ver gráficos de avance' title="Ver gráficos de avance" />
						|-/if-|
						<div class="rightLink">
							<a href="#" onclick="return addProgressRecordRow()" class="addLink" title="Agregar nuevo Monto">Agregar Nuevo Registro</a>
						</div>
					</th>
				</tr>
			|-/if-|
			<tr>
				<th width="15%">Nro. Certificado</th>
				<th width="8%">Año</th>
				<th width="3%">Mes</th>
				<th width="12%">Avance Físico</th>
				<th width="20%">Avance Financiero</th>
				<th width="12%">Avance Físico Real</th>
				<th width="20%">Avance Financiero Real</th>
				<th width="5%">Desvío Físico</th>
				<th width="5%">Desvío Financiero</th>
				<th width="2%">&nbsp;</th>
			</tr>
		</thead>
		<tbody id="progressRecordsTbody">
			|-foreach from=$progressRecords item=progressRecord name=for_contractProgressRecords-|
				<tr id="progressRecordId_|-$progressRecord->getId()-|">
					<td align="center">
						<span title="Nro. Certificado" style="width: 8em !Important;">|-$progressRecord->getCertificateNumber()-|</span>
					</td>
					<td>
						<input type="hidden" name="progressRecord[|-$progressRecord->getId()-|][id]" value="|-$progressRecord->getId()-|" class="right" |-$readonly|readonly-|/>
						|-if !$show && !$showLog-|
							<select name="progressRecord[|-$progressRecord->getId()-|][year]" id="params_year[]" title="Año">
								|-for $year=$yearPickerMin to $yearPickerMax-|
									<option value="|-$year-|" |-$year|selected:$progressRecord->getYear()-|>|-$year-|</option>
								|-/for-|
							</select>
						|-else-|
							<input name="progressRecord[|-$progressRecord->getId()-|][year]"  id="params_year[]" type="text" value="|-$progressRecord->getYear()-|" style="width: 3em !Important;" title="Año (yyyy)" class="right" |-$readonly|readonly-|>
						|-/if-|
					</td>
					<td>
						|-if !$show && !$showLog-|
							<select name="progressRecord[|-$progressRecord->getId()-|][month]" id="params_month[]" title="Mes">
								|-for $month=$monthPickerMin to $monthPickerMax-|
									<option value="|-$month-|" |-$month|selected:$progressRecord->getMonth()-|>|-$month-|</option>
								|-/for-|
							</select>
						|-else-|
							<input name="progressRecord[|-$progressRecord->getId()-|][month]"  id="params_month[]" type="text" value="|-$progressRecord->getMonth()-|" style="width: 3em !Important;" title="Mes (mm)" class="right" |-$readonly|readonly-|>
						|-/if-|
					</td>
					<td>
						<input data-physical-progress onkeyup="setZeroIfEmpty(this); updateTotalProgress('physical-progress')" onchange="setZeroIfEmpty(this); updateTotalProgress('physical-progress')" name="progressRecord[|-$progressRecord->getId()-|][physicalProgress]"  id="params_physicalProgress[]" type="text" value="|-$progressRecord->getPhysicalProgress()|default:'0'|system_numeric_format-|" style="width: 4em !Important;" title="Avance Físico en Porcentaje" class="right" |-$readonly|readonly-|> %
					</td>
					<td>
						$ <input data-financial-progress onkeyup="setZeroIfEmpty(this); updateTotalProgress('financial-progress')" onchange="setZeroIfEmpty(this); updateTotalProgress('financial-progress')" name="progressRecord[|-$progressRecord->getId()-|][financialProgress]"  id="params_financialProgress[]" type="text" value="|-$progressRecord->getFinancialProgress()|default:'0'|system_numeric_format-|" style="width: 8em !Important;" title="Avance Financiero en Pesos" class="right" |-$readonly|readonly-|>
					</td>
					<td>
						<input data-real-physical-progress onkeyup="setZeroIfEmpty(this); updateTotalProgress('real-physical-progress')" onchange="setZeroIfEmpty(this); updateTotalProgress('real-physical-progress')" name="progressRecord[|-$progressRecord->getId()-|][realPhysicalProgress]"  id="params_realPhysicalProgress[]" type="text" value="|-$progressRecord->getRealPhysicalProgress()|default:'0'|system_numeric_format-|" style="width: 4em !Important;" title="Avance Físico en Porcentaje" class="right" |-$readonly|readonly-|> %
					</td>
					<td>
						$ <input data-real-financial-progress onkeyup="setZeroIfEmpty(this); updateTotalProgress('real-financial-progress')" onchange="setZeroIfEmpty(this); updateTotalProgress('real-financial-progress')" name="progressRecord[|-$progressRecord->getId()-|][realFinancialProgress]"  id="params_realFinancialProgress[]" type="text" value="|-$progressRecord->getRealFinancialProgress()|default:'0'|system_numeric_format-|" style="width: 6em !Important;" title="Avance Financiero en Pesos" class="right" |-$readonly|readonly-|>
					</td>
					<td align="right">
						<span data-physical-delta>
							|-$progressRecord->getPhysicalDelta()|system_numeric_format-|
						</span>
						%
					</td>
					<td align="right">
						$
						<span data-financial-delta>
							|-$progressRecord->getFinancialDelta()|system_numeric_format-|
						</span>
					</td>
					<td>
						|-if !$show && !$showLog && $progressRecord->isDeletable()-|
							<input name="progressRecord[|-$progressRecord->getId()-|][eol]" type="hidden" value="1"><input type="button" class="icon iconDelete" title="Eliminar partida" value="Eliminar partida" onClick="removeRecordFromConstruction('|-$progressRecord->getId()-|')" />
						|-else-|
							<img src="images/clear.png" class="disabled icon iconDelete" />
						|-/if-|
					</td>
				</tr>
			|-foreachelse-|
				<tr>
					<td colspan="10">No hay registros de evolución</td>
				</tr>
			|-/foreach-|
			<!-- <tr>
				<th colspan="5">Ejecución Finaciera acumulada según SIGAF (Actualizada: dd-mm-yyy)</th>
				<th align="right"> #.###,00 &nbsp;&nbsp;&nbsp;</th>
				<th colspan="3">&nbsp;</th>
			</tr> -->
		</tbody>
		<tfoot>
			<tr>
				<td colspan="3">Total</td>
				<td>
					<span data-total-physical-progress></span> %
				</td>
				<td>
					$ <span data-total-financial-progress></span>
				</td>
				<td>
					<span data-total-real-physical-progress></span> %
				</td>
				<td>
					$ <span data-total-real-financial-progress></span>
				</td>
				<td>
					<span data-total-physical-delta></span> %
				</td>
				<td>
					$ <span data-total-financial-delta></span>
				</td>
				<td></td>
			</tr>
		</tfoot>
	</table>
</div>
<script type="text/javascript">
	function setZeroIfEmpty(input) {
		if (input.value.trim() === '') input.value = '0';
	}

	function deleteProgressRow(i){
		document.getElementById('progressRecordsTable').deleteRow(i)
	}

	function stringToNumber(string) {
		return parseFloat(string.replace(/\./g, '').replace(/,/g, '.').replace(/^$/, '0'));
	}

	function numberToString(number) {
		return number.toString().replace(/\./g, ',');
	}

	function getBoxes(type) {
		return $('[data-' + type + ']');
	}

	function getTotalBox(type) {
		return $('[data-total-' + type + ']');
	}

	function updateTotalProgress(type, valueGetter) {

		var resolvedValueGetter = null;

		if (valueGetter === undefined) valueGetter = 'value';
		if (typeof valueGetter === 'string') {
			resolvedValueGetter = function(elem) { return elem[valueGetter] };
		} else if (typeof valueGetter === 'function') {
			resolvedValueGetter = valueGetter;
		} else {
			throw Error('invalid value getter');
		}

		var total = 0;
		$('[data-' + type + ']').each(function() {
			var addend = stringToNumber(resolvedValueGetter(this));
			total += addend;
		});

		var totalBox = getTotalBox(type);

		if (isTypePercentage(type)) {
			var exceededClass = 'exceeded';
			if (total > 100) totalBox.addClass(exceededClass);
			else totalBox.removeClass(exceededClass);
		}

		var displayTotal = numberToString(total);
		totalBox.html(displayTotal);
	}

	var percentageTypes = [
		'physical-progress',
		'real-physical-progress',
		'physical-delta'
	];

	function isTypePercentage(type) {
		return percentageTypes.indexOf(type) >= 0;
	}

	function isPercentageExceeded(type) {
		return stringToNumber(getTotalBox(type).html()) > 100;
	}

	function isAnyTotalPercentageExceeded() {

		for (var key in percentageTypes) {
			var type = percentageTypes[key];
			if (isPercentageExceeded(type))
				return true;
		}

		return false;
	}

	function checkNegative(stringValue) {
		return stringToNumber(stringValue) < 0
	};

	function isValueNegative(type) {

		var negative = false;
		getBoxes(type).each(function() {
			if (checkNegative(this.value)) negative = true;
		});

		return negative || checkNegative(getTotalBox(type).val());
	}

	function isAnyFinancialValueNegative() {

		var checkTypes = [
			'financial-progress',
			'real-financial-progress'
		];

		for (var key in checkTypes) {
			var type = checkTypes[key];
			if (isValueNegative(type))
				return true;
		}

		return false;
	}

	$(function() {
		updateTotalProgress('physical-progress');
		updateTotalProgress('financial-progress');
		updateTotalProgress('real-physical-progress');
		updateTotalProgress('real-financial-progress');
		updateTotalProgress('physical-delta', 'innerHTML');
		updateTotalProgress('financial-delta', 'innerHTML');
	});
</script>
