<?php

// use Egytca\ConfigXmlManagement as ConfigXmlManagement;
// TODO Se usa requiere por no estar disponible el autoload
require_once('classes/includes/Egytca/ConfigXmlManagement.php');

/**
 * CommonConfigDoSetAction
 *
 * @package config
 */

class CommonConfigDoSetAction extends BaseAction
{

    protected function exec()
    {
        parent::exec();

        $xmlManager = new ConfigXmlManagement();

        global $system;
        if (empty($_POST["module"]))
            $system["config"] = $this->encodeRecursive($_POST["config"]);
        else
            $system["config"][$_POST["module"]] = $this->encodeRecursive($_POST["config"][$_POST["module"]]);

        // esto cambiaria por el array que viene en el POST del formulario de edicion de CommonConfig
        $localConfigArray = $system['config'];

        // cargo la configuracion del archivo config.xml
        $baseConfigArray = $xmlManager->getBaseConfigXmlArray();

        $diff = $xmlManager->diff($localConfigArray, $baseConfigArray);

        $newXml = new SimpleXMLElement('<?xml version="1.0" encoding="UTF-8"?> <config/>', null, false);
        $xmlManager->toXml($newXml, $diff);

        $domxml = new DOMDocument('1.0');
        $domxml->formatOutput = true;
        $domxml->loadXML($newXml->asXML());
        $domxml->save('config/config.local.xml');

    }

    /**
     * Encodeo el config que viene desde la request, para escapear cualquier caracter especial
     *
     * @param Array $config
     * @return Array
     */
    public function encodeRecursive($config)
    {
        array_walk_recursive($config, function (&$value) {
            $value = htmlspecialchars($value);
        });

        return $config;
    }

}
