<?php


/**
 * Base class that represents a row from the 'campaigns_campaignParticipant' table.
 *
 * Base de participantes en campaignes
 *
 * @package    propel.generator.campaigns.classes.om
 */
abstract class BaseCampaignParticipant extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'CampaignParticipantPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        CampaignParticipantPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the campaignid field.
     * @var        int
     */
    protected $campaignid;

    /**
     * The value for the objecttype field.
     * @var        string
     */
    protected $objecttype;

    /**
     * The value for the objectid field.
     * @var        int
     */
    protected $objectid;

    /**
     * @var        Campaign
     */
    protected $aCampaign;

    /**
     * @var        PropelObjectCollection|CampaignCommitment[] Collection to store aggregation of CampaignCommitment objects.
     */
    protected $collCampaignCommitments;
    protected $collCampaignCommitmentsPartial;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $campaignCommitmentsScheduledForDeletion = null;

    /**
     * Get the [id] column value.
     * Identificacion del Participante de la Campaign
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [campaignid] column value.
     * Id de la campaign
     * @return int
     */
    public function getCampaignid()
    {
        return $this->campaignid;
    }

    /**
     * Get the [objecttype] column value.
     * Tipo de participante
     * @return string
     */
    public function getObjecttype()
    {
        return $this->objecttype;
    }

    /**
     * Get the [objectid] column value.
     * Id del participante
     * @return int
     */
    public function getObjectid()
    {
        return $this->objectid;
    }

    /**
     * Set the value of [id] column.
     * Identificacion del Participante de la Campaign
     * @param int $v new value
     * @return CampaignParticipant The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = CampaignParticipantPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [campaignid] column.
     * Id de la campaign
     * @param int $v new value
     * @return CampaignParticipant The current object (for fluent API support)
     */
    public function setCampaignid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->campaignid !== $v) {
            $this->campaignid = $v;
            $this->modifiedColumns[] = CampaignParticipantPeer::CAMPAIGNID;
        }

        if ($this->aCampaign !== null && $this->aCampaign->getId() !== $v) {
            $this->aCampaign = null;
        }


        return $this;
    } // setCampaignid()

    /**
     * Set the value of [objecttype] column.
     * Tipo de participante
     * @param string $v new value
     * @return CampaignParticipant The current object (for fluent API support)
     */
    public function setObjecttype($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->objecttype !== $v) {
            $this->objecttype = $v;
            $this->modifiedColumns[] = CampaignParticipantPeer::OBJECTTYPE;
        }


        return $this;
    } // setObjecttype()

    /**
     * Set the value of [objectid] column.
     * Id del participante
     * @param int $v new value
     * @return CampaignParticipant The current object (for fluent API support)
     */
    public function setObjectid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->objectid !== $v) {
            $this->objectid = $v;
            $this->modifiedColumns[] = CampaignParticipantPeer::OBJECTID;
        }


        return $this;
    } // setObjectid()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->campaignid = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
            $this->objecttype = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->objectid = ($row[$startcol + 3] !== null) ? (int) $row[$startcol + 3] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 4; // 4 = CampaignParticipantPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating CampaignParticipant object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aCampaign !== null && $this->campaignid !== $this->aCampaign->getId()) {
            $this->aCampaign = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(CampaignParticipantPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = CampaignParticipantPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aCampaign = null;
            $this->collCampaignCommitments = null;

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(CampaignParticipantPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = CampaignParticipantQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(CampaignParticipantPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                CampaignParticipantPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aCampaign !== null) {
                if ($this->aCampaign->isModified() || $this->aCampaign->isNew()) {
                    $affectedRows += $this->aCampaign->save($con);
                }
                $this->setCampaign($this->aCampaign);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->campaignCommitmentsScheduledForDeletion !== null) {
                if (!$this->campaignCommitmentsScheduledForDeletion->isEmpty()) {
                    foreach ($this->campaignCommitmentsScheduledForDeletion as $campaignCommitment) {
                        // need to save related object because we set the relation to null
                        $campaignCommitment->save($con);
                    }
                    $this->campaignCommitmentsScheduledForDeletion = null;
                }
            }

            if ($this->collCampaignCommitments !== null) {
                foreach ($this->collCampaignCommitments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = CampaignParticipantPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . CampaignParticipantPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(CampaignParticipantPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(CampaignParticipantPeer::CAMPAIGNID)) {
            $modifiedColumns[':p' . $index++]  = '`CAMPAIGNID`';
        }
        if ($this->isColumnModified(CampaignParticipantPeer::OBJECTTYPE)) {
            $modifiedColumns[':p' . $index++]  = '`OBJECTTYPE`';
        }
        if ($this->isColumnModified(CampaignParticipantPeer::OBJECTID)) {
            $modifiedColumns[':p' . $index++]  = '`OBJECTID`';
        }

        $sql = sprintf(
            'INSERT INTO `campaigns_campaignParticipant` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`CAMPAIGNID`':
                        $stmt->bindValue($identifier, $this->campaignid, PDO::PARAM_INT);
                        break;
                    case '`OBJECTTYPE`':
                        $stmt->bindValue($identifier, $this->objecttype, PDO::PARAM_STR);
                        break;
                    case '`OBJECTID`':
                        $stmt->bindValue($identifier, $this->objectid, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aCampaign !== null) {
                if (!$this->aCampaign->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aCampaign->getValidationFailures());
                }
            }


            if (($retval = CampaignParticipantPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collCampaignCommitments !== null) {
                    foreach ($this->collCampaignCommitments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = CampaignParticipantPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getCampaignid();
                break;
            case 2:
                return $this->getObjecttype();
                break;
            case 3:
                return $this->getObjectid();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['CampaignParticipant'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['CampaignParticipant'][$this->getPrimaryKey()] = true;
        $keys = CampaignParticipantPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getCampaignid(),
            $keys[2] => $this->getObjecttype(),
            $keys[3] => $this->getObjectid(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aCampaign) {
                $result['Campaign'] = $this->aCampaign->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collCampaignCommitments) {
                $result['CampaignCommitments'] = $this->collCampaignCommitments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = CampaignParticipantPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setCampaignid($value);
                break;
            case 2:
                $this->setObjecttype($value);
                break;
            case 3:
                $this->setObjectid($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = CampaignParticipantPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setCampaignid($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setObjecttype($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setObjectid($arr[$keys[3]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(CampaignParticipantPeer::DATABASE_NAME);

        if ($this->isColumnModified(CampaignParticipantPeer::ID)) $criteria->add(CampaignParticipantPeer::ID, $this->id);
        if ($this->isColumnModified(CampaignParticipantPeer::CAMPAIGNID)) $criteria->add(CampaignParticipantPeer::CAMPAIGNID, $this->campaignid);
        if ($this->isColumnModified(CampaignParticipantPeer::OBJECTTYPE)) $criteria->add(CampaignParticipantPeer::OBJECTTYPE, $this->objecttype);
        if ($this->isColumnModified(CampaignParticipantPeer::OBJECTID)) $criteria->add(CampaignParticipantPeer::OBJECTID, $this->objectid);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(CampaignParticipantPeer::DATABASE_NAME);
        $criteria->add(CampaignParticipantPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of CampaignParticipant (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setCampaignid($this->getCampaignid());
        $copyObj->setObjecttype($this->getObjecttype());
        $copyObj->setObjectid($this->getObjectid());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getCampaignCommitments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addCampaignCommitment($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return CampaignParticipant Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return CampaignParticipantPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new CampaignParticipantPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Campaign object.
     *
     * @param             Campaign $v
     * @return CampaignParticipant The current object (for fluent API support)
     * @throws PropelException
     */
    public function setCampaign(Campaign $v = null)
    {
        if ($v === null) {
            $this->setCampaignid(NULL);
        } else {
            $this->setCampaignid($v->getId());
        }

        $this->aCampaign = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Campaign object, it will not be re-added.
        if ($v !== null) {
            $v->addCampaignParticipant($this);
        }


        return $this;
    }


    /**
     * Get the associated Campaign object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Campaign The associated Campaign object.
     * @throws PropelException
     */
    public function getCampaign(PropelPDO $con = null)
    {
        if ($this->aCampaign === null && ($this->campaignid !== null)) {
            $this->aCampaign = CampaignQuery::create()->findPk($this->campaignid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aCampaign->addCampaignParticipants($this);
             */
        }

        return $this->aCampaign;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('CampaignCommitment' == $relationName) {
            $this->initCampaignCommitments();
        }
    }

    /**
     * Clears out the collCampaignCommitments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addCampaignCommitments()
     */
    public function clearCampaignCommitments()
    {
        $this->collCampaignCommitments = null; // important to set this to null since that means it is uninitialized
        $this->collCampaignCommitmentsPartial = null;
    }

    /**
     * reset is the collCampaignCommitments collection loaded partially
     *
     * @return void
     */
    public function resetPartialCampaignCommitments($v = true)
    {
        $this->collCampaignCommitmentsPartial = $v;
    }

    /**
     * Initializes the collCampaignCommitments collection.
     *
     * By default this just sets the collCampaignCommitments collection to an empty array (like clearcollCampaignCommitments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initCampaignCommitments($overrideExisting = true)
    {
        if (null !== $this->collCampaignCommitments && !$overrideExisting) {
            return;
        }
        $this->collCampaignCommitments = new PropelObjectCollection();
        $this->collCampaignCommitments->setModel('CampaignCommitment');
    }

    /**
     * Gets an array of CampaignCommitment objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this CampaignParticipant is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|CampaignCommitment[] List of CampaignCommitment objects
     * @throws PropelException
     */
    public function getCampaignCommitments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collCampaignCommitmentsPartial && !$this->isNew();
        if (null === $this->collCampaignCommitments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collCampaignCommitments) {
                // return empty collection
                $this->initCampaignCommitments();
            } else {
                $collCampaignCommitments = CampaignCommitmentQuery::create(null, $criteria)
                    ->filterByCampaignParticipant($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collCampaignCommitmentsPartial && count($collCampaignCommitments)) {
                      $this->initCampaignCommitments(false);

                      foreach($collCampaignCommitments as $obj) {
                        if (false == $this->collCampaignCommitments->contains($obj)) {
                          $this->collCampaignCommitments->append($obj);
                        }
                      }

                      $this->collCampaignCommitmentsPartial = true;
                    }

                    return $collCampaignCommitments;
                }

                if($partial && $this->collCampaignCommitments) {
                    foreach($this->collCampaignCommitments as $obj) {
                        if($obj->isNew()) {
                            $collCampaignCommitments[] = $obj;
                        }
                    }
                }

                $this->collCampaignCommitments = $collCampaignCommitments;
                $this->collCampaignCommitmentsPartial = false;
            }
        }

        return $this->collCampaignCommitments;
    }

    /**
     * Sets a collection of CampaignCommitment objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $campaignCommitments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setCampaignCommitments(PropelCollection $campaignCommitments, PropelPDO $con = null)
    {
        $this->campaignCommitmentsScheduledForDeletion = $this->getCampaignCommitments(new Criteria(), $con)->diff($campaignCommitments);

        foreach ($this->campaignCommitmentsScheduledForDeletion as $campaignCommitmentRemoved) {
            $campaignCommitmentRemoved->setCampaignParticipant(null);
        }

        $this->collCampaignCommitments = null;
        foreach ($campaignCommitments as $campaignCommitment) {
            $this->addCampaignCommitment($campaignCommitment);
        }

        $this->collCampaignCommitments = $campaignCommitments;
        $this->collCampaignCommitmentsPartial = false;
    }

    /**
     * Returns the number of related CampaignCommitment objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related CampaignCommitment objects.
     * @throws PropelException
     */
    public function countCampaignCommitments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collCampaignCommitmentsPartial && !$this->isNew();
        if (null === $this->collCampaignCommitments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collCampaignCommitments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getCampaignCommitments());
                }
                $query = CampaignCommitmentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByCampaignParticipant($this)
                    ->count($con);
            }
        } else {
            return count($this->collCampaignCommitments);
        }
    }

    /**
     * Method called to associate a CampaignCommitment object to this object
     * through the CampaignCommitment foreign key attribute.
     *
     * @param    CampaignCommitment $l CampaignCommitment
     * @return CampaignParticipant The current object (for fluent API support)
     */
    public function addCampaignCommitment(CampaignCommitment $l)
    {
        if ($this->collCampaignCommitments === null) {
            $this->initCampaignCommitments();
            $this->collCampaignCommitmentsPartial = true;
        }
        if (!$this->collCampaignCommitments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddCampaignCommitment($l);
        }

        return $this;
    }

    /**
     * @param	CampaignCommitment $campaignCommitment The campaignCommitment object to add.
     */
    protected function doAddCampaignCommitment($campaignCommitment)
    {
        $this->collCampaignCommitments[]= $campaignCommitment;
        $campaignCommitment->setCampaignParticipant($this);
    }

    /**
     * @param	CampaignCommitment $campaignCommitment The campaignCommitment object to remove.
     */
    public function removeCampaignCommitment($campaignCommitment)
    {
        if ($this->getCampaignCommitments()->contains($campaignCommitment)) {
            $this->collCampaignCommitments->remove($this->collCampaignCommitments->search($campaignCommitment));
            if (null === $this->campaignCommitmentsScheduledForDeletion) {
                $this->campaignCommitmentsScheduledForDeletion = clone $this->collCampaignCommitments;
                $this->campaignCommitmentsScheduledForDeletion->clear();
            }
            $this->campaignCommitmentsScheduledForDeletion[]= $campaignCommitment;
            $campaignCommitment->setCampaignParticipant(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this CampaignParticipant is new, it will return
     * an empty collection; or if this CampaignParticipant has previously
     * been saved, it will retrieve related CampaignCommitments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in CampaignParticipant.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|CampaignCommitment[] List of CampaignCommitment objects
     */
    public function getCampaignCommitmentsJoinCampaign($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = CampaignCommitmentQuery::create(null, $criteria);
        $query->joinWith('Campaign', $join_behavior);

        return $this->getCampaignCommitments($query, $con);
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->campaignid = null;
        $this->objecttype = null;
        $this->objectid = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collCampaignCommitments) {
                foreach ($this->collCampaignCommitments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collCampaignCommitments instanceof PropelCollection) {
            $this->collCampaignCommitments->clearIterator();
        }
        $this->collCampaignCommitments = null;
        $this->aCampaign = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(CampaignParticipantPeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

}
