<?php

/**
 * BackupRestoreAction
 *
 * Restaurar un respaldo extendiendo BaseAction
 *
 * @package backup
 */

class BackupRestoreAction extends BaseAction {

	/**
	 * Acciones a ejecutar antes de generar el display
	 */
	protected function exec() {
		parent::exec();

		require_once('Backup.php');
		$backup = new Backup();

		if (!empty($_FILES['backup'])) {
			$filename = $_FILES["backup"]['tmp_name'];
			$originalFileName = $_FILES["backup"]['name'];
		}
		else if (!empty($_POST['filename'])) {
			$filename = 'WEB-INF/../backups/' . $_POST['filename'];
			$originalFileName = $filename;
		}
		else {
			Common::doLog('failure', 'filename: ' . $_POST['filename']);
			return false;
		}
		
		if ($backup->restoreBackup($filename, $originalFileName)) {
			Common::doLog('success', 'filename: ' . $filename);
			return true;
		}
		else {
			Common::doLog('failure', 'filename: ' . $filename);
			return false;
		}
	} // End exec

}
