<?php

namespace Egytca\ParamChecker;

use Egytca\ParamChecker\Conditions\ConditionFactory;
use Exception;

class ParamChecker {

	private $conditions;

	private $defaults = [
		'method' => 'GET',
		'required' => false,
		'nonEmpty' => false,
		'conditions' => []
	];

	function __construct($defaultOptions) {
		if ($defaultOptions) {
			$this->defaults = array_merge($this->defaults, $defaultOptions);
		}
	}

	function check($paramDescriptors) {
		$result = new Result();
		foreach ($paramDescriptors as $desc) {
			$this->checkOne($desc, $result);
		}
		return $result;
	}

	private function checkOne($desc, $result) {

		$desc = $this->normalize($desc);
		$reqParams = $this->getRequestParams();
		$reqParam = $reqParams[$desc['method']][$desc['name']];

		$isSet = ConditionFactory::create('isSet');
		if ($isSet->test($reqParam)) {

			$nonEmpty = ConditionFactory::create('nonEmpty');
			if ($nonEmpty->test($reqParam)) {

				foreach ($desc['conditions'] as $conditionDesc) {
					$condition = ConditionFactory::create($conditionDesc);
					if (!$condition->test($reqParam)) {
						$result->addError($condition->getFailureMessage($desc));
						return; // condition failed. no param assigned.
					}
				}

				$result->addParam($desc['name'], $reqParam); // all conditions passed. assign param.

			} else { // empty
				if ($desc['nonEmpty'])
					$result->addError($nonEmpty->getFailureMessage($desc));
				else
					$result->addParam($desc['name'], null); // param can be empty. add it.
			}

		} else { // not set
			if ($desc['required'])
				$result->addError($isSet->getFailureMessage($desc));
			// param not set. do not add it.
		}
	}

	private function normalize($paramDescriptor) {
		if (!$paramDescriptor['name'])
			throw new Exception('bad parameter description: "name" required');
		$paramDescriptor = array_merge($this->defaults, $paramDescriptor);
		$paramDescriptor['method'] = strtoupper($paramDescriptor['method']);
		return $paramDescriptor;
	}

	private function getRequestParams() {
		return [
			'GET' => $_GET,
			'POST' => $_POST,
			'REQUEST' => $_REQUEST
		];
	}
}