<?php

namespace Egytca\ParamChecker\Conditions;

abstract class Condition {

	protected $failureMessage = 'condition not met';

	abstract function test($value);

	function getFailureMessage($paramDescriptor) {
		return $this->failureMessage
			.' ( name: '.$paramDescriptor['name']
			.', method: '.$paramDescriptor['method'].' )'
			.' - '.get_class($this);
	}
}