<?php

require_once('PHPExcel/PHPExcel.php');
require_once('PHPExcel/PHPExcel/IOFactory.php');

/**
* Wrapper de la funcionalidades basicas de PHPExcel.
*
* Encapsulamiento de los aspectos basicos de generación de xls.
*/
class ExcelManagement
{
	private $objPHPExcel;
	private $useTemplate = false;
	private $headerFormat;
	private $tableHeaderFormat;
	const SAVE_TO_FILE = 1;
	const SEND_TO_BROWSER = 2;

	/*
		Se crea el objeto objPHPExcel que contendrá en memoría toda la planilla Excel
		y se asigna como nombre a la hoja predeterminada Export
	*/
	public function __construct() {
		$this->objPHPExcel = new PHPExcel();
		$this->objPHPExcel->getActiveSheet()->setTitle('Export');
	}

	/*
		Test de la función Load
		TODO: Completar implementación para el uso de templates

		* @param string $filename con la nombre del archivo del template.
		* @return void
	*/
	public function loadTemplate($filename = 'template.xlsx'){
		$this->objPHPExcel = PHPExcel_IOFactory::load($filename);
		$this->useTemplate = true;
	}

	/*
		Función básica para el agregado de datos.

		* @param string $cell celda donde se escribe el dato en el formato Excel (Columna en letras, fila en numeros Ej. "A1")
		* @param string $data texto que se escribe en la celda

		* @return void
	*/
	public function addData($cell, $data){
		$this->objPHPExcel->getActiveSheet()
						->setCellValue($cell, $data);
	}

	/*
		DEPRECATED usar setColumnInfoFromArray

		Define el ancho de un grupo de columnas

		* @param integer $firstcol indice de la columna inicial
		* @param integer $lastcol indice de la columna final
		* @param mixed $width ancho de la celda. Acepta Integer para el ancho en numeros y String "auto" para ancho automatico

		* @return void
	*/
	public function setColumnInfo($firstcol, $lastcol, $width){
		foreach(range($firstcol,$lastcol) as $columnID) {
			//Recorre el rango de valores de columna y define si el ancho es un numero o si es automatico
			if (!(is_numeric($width)) && strtolower($width)=='auto'){
				$this->objPHPExcel->getActiveSheet()->getColumnDimension(PHPExcel_Cell::stringFromColumnIndex($columnID))
				->setAutoSize(true);
			}else{
				$this->objPHPExcel->getActiveSheet()->getColumnDimension(PHPExcel_Cell::stringFromColumnIndex($columnID))
				->setWidth($width);
			}
		}
	}

	/*
		Define el ancho de un grupo de columnas descriptas en un array

		* @param array $array Matriz de arrays con el rango de columnas y los anchos según:
			indice 0: string primera columna en formato Excel (Ej. "A")
			indice 1: string última columna en formato Excel (Ej. "A")
			indice 2: mixed valor de ancho; acepta Integer para ancho fijo o string "auto" para ancho automatico.
		* @return void
	*/
	public function setColumnInfoFromArray($array) {
	  for( $line=0; $line < count($array); $line++ ) {
		foreach( $this->excelColumnRange( $array[$line][0], $array[$line][1] ) as $columnID) {
			//Recorre el rango de valores de columna y define si el ancho es un numero o si es automatico
			if (!( is_numeric( $array[$line][2] ) ) && strtolower( $array[$line][2] ) == 'auto' ) {
				$this->objPHPExcel->getActiveSheet()->getColumnDimension($columnID)
													->setAutoSize(true);
			} else {
				$this->objPHPExcel->getActiveSheet()->getColumnDimension($columnID)
													->setWidth($array[$line][2]);
			}
		}
	  }
	}

	/**
	 * Metodo para calcular el rango entre columnas dobles de un excel (AA-AB)
	 * @param  string $lower
	 * @param  string $upper
	 * @return rango
	 */
	function excelColumnRange($lower, $upper) {
	    ++$upper;
	    for ($i = $lower; $i !== $upper; ++$i) {
	        yield $i;
	    }
	}

	/*

		Guarda un archivo xlsx en el servidor conteniendo la información almacenada en el objeto objPHPExcel

		* @param string $filename nombre del archivo a guardar (acepta el nombre sin extensión y le agrega xlsx)

		* @return void
	*/
	public function saveToFile($filename = 'export.xlsx'){
		$objWriter = PHPExcel_IOFactory::createWriter($this->objPHPExcel, 'Excel2007');
		$file_parts = pathinfo($filename);
		if (!(isset($file_parts['extension'])) || $file_parts['extension'] == ''){
			$filename = $file_parts['filename'].'.xlsx';
		}
		if (ConfigModule::get('global', 'excelRepositoryDir')){
			$filename == ConfigModule::get('global', 'excelRepositoryDir').$filename;
		}
		$objWriter->save($filename);
	}

	/*

		Genera un archivo xlsx conteniendo la información almacenada en el objeto objPHPExcel y lo descarga como un ContentType
		sin guardarlo en el servidor

		* @param string $filename nombre del archivo a guardar (acepta el nombre sin extensión y le agrega xlsx)

		* @return void
	*/
	public function sendToBrowser($filename = 'export.xlsx'){
		$objWriter = PHPExcel_IOFactory::createWriter($this->objPHPExcel, 'Excel2007');
		$file_parts = pathinfo($filename);
		if (!(isset($file_parts['extension'])) || $file_parts['extension'] == ''){
			$filename = $file_parts['filename'].'.xlsx';
		}
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="'.$filename.'"');
		header('Cache-Control: max-age=0');

		$objWriter->save('php://output');
	}

	/*

		Define el estilo de un grupo de celdas

		* @param string $fromCell celda incial en el formato Excel (Columna en letras, fila en numeros Ej. "A1")
		* @param string $toCell celda final en el formato Excel (Columna en letras, fila en numeros Ej. "A1")
		* @param array $style array en el formato PHPExcel_Style

		* @return void
	*/
	public function applyFormat($fromCell,$toCell,$style){
		$this->objPHPExcel->getActiveSheet()->getStyle($fromCell.':'.$toCell)->applyFromArray($style);;
	}

	/*

		Define el estilo del header. Si no recibe un estilo define el estilo por defecto.

		* @param array $arrayFormat array en el formato PHPExcel_Style

		* @return void
	*/
	public function setheaderFormat($arrayFormat=[]){
		if(count($arrayFormat)==0){
			//Array de formato por defecto
			$arrayFormat = array(
						   'font' => array(
								'name' =>'Helvetica',
								'bold' => (true),
								'size' => 16,
								'color' => array('argb' => 'FF000080')
							),
							'borders' => array(
								'bottom' => array(
									'style' => PHPExcel_Style_Border::BORDER_MEDIUM,
									'color' => array('argb' => 'FF000080')
								)
							)
						);
		}

		$this->headerFormat = $arrayFormat;
	}

	/*

		Define el estilo del header de las tablas. Si no recibe un estilo define el estilo por defecto.

		* @param array $arrayFormat array en el formato PHPExcel_Style

		* @return void
	*/
	public function setTableHeaders($arrayFormat=[]){
		if(count($arrayFormat)==0){
			//Array de formato por defecto
			$arrayFormat = array(
						   'font' => array(
								'name' =>'Helvetica',
								'bold' => (true),
								'size' => 11,
								'color' => array('argb' => 'FF000080')
							),
							'borders' => array(
								'bottom' => array(
									'style' => PHPExcel_Style_Border::BORDER_THIN,
									'color' => array('argb' => 'FF000080')
								)
							)
						);
		}

		$this->tableHeaderFormat = $arrayFormat;
	}

	/*
		Agrega un array de datos en la posición definida como fistcell

		* @param array $dataArray Matriz de datos a agregar
		* @param string $fistcell celda inicial a partir de donde se escribiran los datos.

		* @return void
	*/
	public function setDataFromArray($dataArray,$fistcell="A1"){
		$this->objPHPExcel->getActiveSheet()->fromArray($dataArray, NULL, $fistcell);
	}

	/*
		Inicio agregado de funciones de carga y lectura de archivos
		TODO: Documentar metodos
	*/

	public function loadFile($filename = 'template.xlsx'){
		$this->objPHPExcel = PHPExcel_IOFactory::load($filename);
	}

	public function setArrayFromData($calculateformulas = true){
		return $this->objPHPExcel->getActiveSheet()->toArray(null,$calculateformulas,false,false);
	}

	/*
		Fin de agregado de funciones de carga y lectura de archivos

	*/
	/*
		Inicio agregado de funciones de manejo de templates
		TODO: Documentar metodos
	*/
	public function setActiveSheet($sheetnumber=1){
		$this->objPHPExcel->setActiveSheetIndex($sheetnumber);
	}

	public function removeSheet($sheetnumber=0){
		$this->objPHPExcel->removeSheetByIndex($sheetnumber);
	}

	public function setSheetTitle($sheettitle){
		$this->objPHPExcel->getActiveSheet()->setTitle($sheettitle);
	}

	public function createSheet($sheettitle = ""){
		$worksheet = $this->objPHPExcel->createSheet();
		$this->objPHPExcel->setActiveSheetIndex($this->objPHPExcel->getIndex($worksheet));
		if ($sheettitle != ""){
			$this->objPHPExcel->getActiveSheet()->setTitle($sheettitle);
		}
	}

	public function mergeCells($from,$to){
		$this->objPHPExcel->getActiveSheet()->mergeCells($from.":".$to);
		$this->objPHPExcel->getActiveSheet()->getStyle($from)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
		$this->objPHPExcel->getActiveSheet()->getStyle($from)->getAlignment()->setWrapText(true);
	}

	public function getCellbyCoords($row,$col){
		return PHPExcel_Cell::stringFromColumnIndex($col).$row;
	}

	public function setRowHeight($row,$height = -1){
		$this->objPHPExcel->getActiveSheet()->getRowDimension($row)->setRowHeight($height);
	}

	public function setTextDirection($row, $direction = 90){
		$this->objPHPExcel->getActiveSheet()->getStyle($row)->getAlignment()->setTextRotation($direction);
		$this->objPHPExcel->getActiveSheet()->getStyle($row)->getAlignment()->setWrapText(true);
	}

	public function fetchCellTag($tag){
		$cellPos = "";
		foreach ($this->objPHPExcel->getActiveSheet()->getRowIterator() as $row) {
			$cellIterator = $row->getCellIterator();
			$cellIterator->setIterateOnlyExistingCells(true);
			foreach ($cellIterator as $cell) {
				if ($cell->getValue() == $tag) {
					$cellPos = $cell->getCoordinate();
				}
			}
		}
		return $cellPos;
	}
	public function fetchRowTag($tag){
		$rowPos = 0;
		foreach ($this->objPHPExcel->getActiveSheet()->getRowIterator() as $row) {
			$cellIterator = $row->getCellIterator();
			$cellIterator->setIterateOnlyExistingCells(true);
			foreach ($cellIterator as $cell) {
				if ($cell->getValue() == $tag) {
					$rowPos = $row->getRowIndex();
				}
			}
		}
		return $rowPos;
	}

	public function setColumnFormatNumber($col, $format = '#'){
		$this->objPHPExcel->getActiveSheet()->getStyle($col."1:".$col.$this->objPHPExcel->getActiveSheet()->getHighestRow())->getNumberFormat()->setFormatCode($format);
	}

	public function convertPHPDatetoExcelDate($year,$month,$day){
		return PHPExcel_Shared_Date::FormattedPHPToExcel($year, $month, $day);
	}

	public function setWorksheetPassword($password = 'Egytca'){
		$this->objPHPExcel->getActiveSheet()->getProtection()->setSheet(true);
		$this->objPHPExcel->getActiveSheet()->getProtection()->setSort(true);
		$this->objPHPExcel->getActiveSheet()->getProtection()->setInsertRows(true);
		$this->objPHPExcel->getActiveSheet()->getProtection()->setFormatCells(true);
		$this->objPHPExcel->getActiveSheet()->getProtection()->setPassword($password);
	}
	/*
		Fin de agregado de funciones de manejo de templates

	*/

	public function insertImage($imagePath, $cell){
		$objDrawing = new PHPExcel_Worksheet_Drawing();
		$objDrawing->setPath($imagePath);
		$objDrawing->setCoordinates($cell);
		$objDrawing->setWorksheet($this->objPHPExcel->getActiveSheet());
	}

	public function hideSheet($sheetnumber){
		$this->objPHPExcel->getSheet($sheetnumber)
			->setSheetState(PHPExcel_Worksheet::SHEETSTATE_HIDDEN);
	}

	public function setDataValidationCell($cell, $list){
		$objValidation = $this->objPHPExcel->getActiveSheet()->getCell($cell)->getDataValidation();
		$objValidation->setType( PHPExcel_Cell_DataValidation::TYPE_LIST );
		$objValidation->setShowDropDown(true);
		$objValidation->setAllowBlank(false);
		$objValidation->setFormula1($list);
	}

	public function cloneDataValidationCell($origin, $destination){
		$objValidation = $this->objPHPExcel->getActiveSheet()->getCell($origin)->getDataValidation();
		$this->objPHPExcel->getActiveSheet()->getCell($destination)->setDataValidation(clone $objValidation);
	}

	/*

		Genera un archivo xlsx desde un xml.

		* @param string $xml Árbol XML
		* @param string $filename Nombre del archivo a generar o guardar
		* @param integer $saveMode flag que define si se generará un archivo en el servidor o si se generará un ContentType

		* @return void
	*/
	public function sendXlsFromXml($xml, $filename='export.xlsx', $saveMode=ExcelManagement::SEND_TO_BROWSER) {

		//Utilizó la función nativa SimpleXML de PHP que convierte el arból XML en un objeto
		$objXml=simplexml_load_string($xml);

		$currRow = 1;

		//Si no definió el formato del header se utiliza el default
		if ($this->headerFormat == ''){
			$this->setheaderFormat();
		}

		$headersElement = $objXml->{'headers'}->{'header'};

		foreach ($headersElement as $header){
			$this->objPHPExcel->getActiveSheet()->setCellValue('A'.$currRow, $header);
			if ($header!='' && $header!=' '){
				//Para cada header, si no están en blanco, se le aplica el formato almacenado
				$this->applyFormat('A'.$currRow,'A'.$currRow,$this->headerFormat);
			}
			$currRow++;
		}

		//Si no definió el formato del header de las tablas se utiliza el default
		if ($this->tableHeaderFormat == ''){
			$this->setTableHeaders();
		}

		$tableHeadersElement = $objXml->{'tableHeaders'}->{'header'};

		$currCol = 0;
		foreach ($tableHeadersElement as $header){
			//Se agregan los heades de la tabla uno en cada columna
			$this->objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($currCol,$currRow,$header);
			if (count($header->attributes())!=0){
				//nuevo formato
				//usando atributo "size" en el tag tableHeaders -> header
				//TODO: Agregar otros atributos (ojo con el applyFormat)

				$this->setColumnInfoFromArray([
											  [PHPExcel_Cell::stringFromColumnIndex($currCol),PHPExcel_Cell::stringFromColumnIndex($currCol),$header->attributes()['size']]
											  ]);
			}
			$currCol++;
		}

		$this->applyFormat('A'.$currRow,PHPExcel_Cell::stringFromColumnIndex($currCol-1).$currRow,$this->tableHeaderFormat);


		$dataElements = $objXml->{'tableValues'}->{'row'};

		foreach ($dataElements as $dataElement) {
			$currCol = 0;
			$currRow++;
			foreach ($dataElement as $cell){
				$this->objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($currCol,$currRow,$cell);
				$currCol++;
			}

		}

		//Se valida el flag saveMode para realizar la acción de cierre correspondiente
		if ($saveMode == ExcelManagement::SAVE_TO_FILE){
			$this->saveToFile($filename);
		}else if($saveMode == ExcelManagement::SEND_TO_BROWSER){
			$this->sendToBrowser($filename);
		}

	}

	/*
		DEPRECATED usar sendXlsFromXml

		Genera un archivo xlsx desde un xml.

		* @param string $xml Árbol XML
		* @param string $filename Nombre del archivo a guardar

		* @return void
	*/
	public function sendXlsFromXmlOld($xml, $filename='export.xlsx') {

		require_once('xml2ary.php');

		$xml2ary = new Xml2ary();

		$array = $xml2ary->getArray($xml);

		$currRow = 1;

		if ($this->headerFormat == ''){
			$this->setheaderFormat();
		}

		$headersElement = $array['xls']['_c']['headers']['_c']['header'];

		$headers = array();
		foreach ($headersElement as $header){
			$this->objPHPExcel->getActiveSheet()->setCellValue('A'.$currRow, $header['_v']);
			if ($header['_v']!='' && $header['_v']!=' '){
				$this->applyFormat('A'.$currRow,'A'.$currRow,$this->headerFormat);
			}
			$currRow++;
		}

		if ($this->tableHeaderFormat == ''){
			$this->setTableHeaders();
		}

		$tableHeadersElement = $array['xls']['_c']['tableHeaders']['_c']['header'];

		$tableHeaders = array();
		$currCol = 0;
		foreach ($tableHeadersElement as $header){
				$this->objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($currCol,$currRow,$header['_v']);
				$currCol++;
		}

		$this->applyFormat('A'.$currRow,PHPExcel_Cell::stringFromColumnIndex($currCol-1).$currRow,$this->tableHeaderFormat);


		$dataElements = $array['xls']['_c']['tableValues']['_c']['row'];
		$data = array();

		foreach ($dataElements as $dataElement) {
			$itemData = array();
			$currCol = 0;
			$currRow++;
			foreach ($dataElement['_c'] as $cell){
				$this->objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($currCol,$currRow,$cell['_v']);
				$currCol++;
			}

		}


		$this->saveToFile($filename);

	}

}


